/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractCaptialGatherUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CaptialGatherUI
extends AbstractCaptialGatherUI {
    private static final Logger logger = CoreUIObject.getLogger(CaptialGatherUI.class);
    private Map mapCompany = new HashMap(32);
    private Date startDate = DateTimeUtils.addMonth((Date)new Date(), (int)-2);
    private Date endDate = new Date();
    private static final String NUMBER_FORMATE = "#,###0.00";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.mapCompany.clear();
        this.getQueryResult();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.startDate = (Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.endDate = (Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u8d44\u91d1\u5f52\u96c6\u60c5\u51b5\u8868");
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.tblMain.getColumn(0).setWidth(180);
        for (int i = 1; i < 6; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
            this.tblMain.getColumn(i).setWidth(120);
        }
        this.getQueryResult();
    }

    private int getColIndex(int bankType) {
        int index = 1;
        switch (bankType) {
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
                break;
            }
            case 4: {
                index = 3;
                break;
            }
            default: {
                index = 4;
            }
        }
        return index;
    }

    private String getQuerySql() {
        String dateSql = ReportClientUtil.getQueryDateCondition("biztime", this.startDate, this.endDate);
        return "select company_number,company_name,bankinterfacetype,sum(creditamount) as transvalue from v_be_transdetail where " + dateSql + " group by company_number,company_name,bankinterfacetype order by company_number";
    }

    private void getQueryResult() throws Exception {
        this.fillDataToTable();
        this.sum();
    }

    private void fillDataToTable() throws Exception {
        int rowIndex = 0;
        int currRowIndex = 0;
        int colIndex = 0;
        IRow row = null;
        String companyId = null;
        String sql = this.getQuerySql();
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            companyId = rs.getString("company_number");
            if (this.mapCompany.containsKey(companyId)) {
                rowIndex = (Integer)this.mapCompany.get(companyId);
                row = this.tblMain.getRow(rowIndex);
            } else {
                row = this.tblMain.addRow();
                this.mapCompany.put(companyId, new Integer(currRowIndex++));
            }
            row.getCell(0).setValue((Object)rs.getString("company_name"));
            int bankType = rs.getInt("bankinterfacetype");
            colIndex = this.getColIndex(bankType);
            row.getCell(colIndex).setValue((Object)new Double(rs.getDouble("transvalue")));
        }
    }

    private void sum() {
        int rows = this.tblMain.getRowCount();
        int cols = this.tblMain.getColumnCount() - 1;
        double value = 0.0;
        for (int i = 0; i < rows; ++i) {
            value = 0.0;
            for (int j = 1; j < cols; ++j) {
                value += this.getValueFromCell(i, j);
            }
            this.tblMain.getCell(i, 5).setValue((Object)new Double(value));
        }
    }

    private double getValueFromCell(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }
}

