/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractCaptialTransferUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class CaptialTransferUI
extends AbstractCaptialTransferUI {
    private static final Logger logger = CoreUIObject.getLogger(CaptialTransferUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private Date startDate = DateTimeUtils.addMonth((Date)new Date(), (int)-2);
    private Date endDate = new Date();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.startDate = (Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.endDate = (Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.getQueryResult();
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u8d44\u91d1\u62e8\u4ed8\u60c5\u51b5\u8868");
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.tblMain.getColumn(0).setWidth(180);
        for (int i = 1; i < 4; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
            this.tblMain.getColumn(i).setWidth(120);
        }
        this.getQueryResult();
    }

    private String getQuerySql() {
        String dateSql = ReportClientUtil.getQueryDateCondition("biztime", this.startDate, this.endDate);
        return "select company_number,company_name,transcode,sum(creditamount) as transvalue from v_be_transdetail where " + dateSql + " group by company_number,company_name,transcode order by company_number";
    }

    private void fillDataToTable() throws Exception {
        IRow row = null;
        String companyId = null;
        String lastCompanyId = null;
        String sql = this.getQuerySql();
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            companyId = rs.getString("company_number");
            if (!companyId.equalsIgnoreCase(lastCompanyId)) {
                row = this.tblMain.addRow();
                lastCompanyId = companyId;
            }
            if (row == null) continue;
            String transType = rs.getString("transcode");
            row.getCell(0).setValue((Object)rs.getString("company_name"));
            int colIndex = this.getColIndex(transType);
            row.getCell(colIndex).setValue((Object)new Double(rs.getDouble("transvalue")));
        }
    }

    private int getColIndex(String transType) {
        if ("E02".equalsIgnoreCase(transType)) {
            return 1;
        }
        if ("E02".equalsIgnoreCase(transType)) {
            return 2;
        }
        return 1;
    }

    private void sum() {
        int rows = this.tblMain.getRowCount();
        int cols = this.tblMain.getColumnCount() - 1;
        double value = 0.0;
        for (int i = 0; i < rows; ++i) {
            value = 0.0;
            for (int j = 1; j < cols; ++j) {
                value += this.getValueFromCell(i, j);
            }
            this.tblMain.getCell(i, 3).setValue((Object)new Double(value));
        }
    }

    private void getQueryResult() throws Exception {
        this.fillDataToTable();
        this.sum();
    }

    private double getValueFromCell(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }
}

