/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractFDCaptialReportUI;
import com.kingdee.eas.custom.gpgc.client.FDReportChartHelper;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FDCaptialReportUI
extends AbstractFDCaptialReportUI {
    private static final Logger logger = CoreUIObject.getLogger(FDCaptialReportUI.class);
    private List lstHeaderName = new ArrayList(16);
    private HashMap mapBankInterface = new HashMap();
    private java.util.Date endDate = new java.util.Date();
    private java.util.Date startDate = DateTimeUtils.addMonth((java.util.Date)this.endDate, (int)-1);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private HashMap mapPosIndex = new HashMap(128);
    private final int CLOUMNCOUNT = 8;
    private final int ACCOUNT_TYPE = 1;
    private final int ORG = 2;
    private final int BANK = 3;
    private int SEP_ORG_IDX = 0;
    private int SEP_BANK_IDX = 0;
    private HashMap mapDblClickRow = new HashMap(32);
    private HashMap mapFirstColKey = new HashMap(128);
    private List lstDblClickRow = new ArrayList(32);
    private List lstNotHideRow = new ArrayList();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.startDate = (java.util.Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.endDate = (java.util.Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.lstDblClickRow.clear();
        this.mapDblClickRow.clear();
        this.mapPosIndex.clear();
        this.lstNotHideRow.clear();
        this.mapFirstColKey.clear();
        this.fillDataToTable();
        this.displayPieChart();
    }

    private void displayPieChart() throws BOSException, SQLException {
        FDReportChartHelper helper = new FDReportChartHelper(this.endDate);
        helper.displayPieChart(this);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int count = e.getClickCount();
        if (count != 2) {
            return;
        }
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (this.mapDblClickRow.containsKey(new Integer(rowIndex))) {
            HidePosition pos = (HidePosition)this.mapDblClickRow.get(new Integer(rowIndex));
            if (pos.display) {
                pos.display = false;
                this.hideRow(pos.startIndex, pos.endIndex);
            } else {
                pos.display = true;
                this.displayRow(pos.startIndex, pos.endIndex);
            }
        }
    }

    private void displayRow(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.tblMain.getRow(i).getStyleAttributes().setHided(false);
        }
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.btnRefresh.setEnabled(true);
        this.btnFilter.setEnabled(true);
        this.setUITitle("\u4f5b\u7535\u8d44\u91d1\u62a5\u8868");
        this.initHeaderName();
        this.initBankInterfaceMap();
        this.fillDataToTable();
        this.displayPieChart();
    }

    private void initTable() {
        int i;
        IRow row = this.tblMain.addRow();
        for (i = 0; i < 8; ++i) {
            row.getCell(i).setValue(this.lstHeaderName.get(i));
        }
        row.getStyleAttributes().setBackground(Color.YELLOW);
        row.getStyleAttributes().setBold(true);
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5408\u8ba1");
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        for (i = 4; i < 8; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
            this.tblMain.getColumn(i).setWidth(120);
        }
    }

    private void initHeaderName() {
        this.lstHeaderName.add("\u5e10\u6237\u7c7b\u578b");
        this.lstHeaderName.add("\u7ec4\u7ec7");
        this.lstHeaderName.add("\u94f6\u884c");
        this.lstHeaderName.add("\u5e10\u6237");
        this.lstHeaderName.add("\u671f\u521d\u4f59\u989d");
        this.lstHeaderName.add("\u672c\u671f\u6d41\u5165");
        this.lstHeaderName.add("\u672c\u671f\u6d41\u51fa");
        this.lstHeaderName.add("\u671f\u672b\u4f59\u989d");
    }

    private void sum(IRow row, int start, int end) {
        double sumCol = 0.0;
        for (int i = 4; i < 8; ++i) {
            sumCol = 0.0;
            for (int j = start; j <= end; ++j) {
                sumCol += this.getCellValue(j, i);
            }
            row.getCell(i).setValue((Object)new Double(sumCol));
        }
    }

    private double getCellValue(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    public void fillDataToTable() throws SQLException, BOSException {
        this.initTable();
        this.fillTableByAccountType();
        this.fillTableByOrg();
        this.fillTableByBank();
        this.reGroup(this.mapDblClickRow);
        this.sum();
        this.hideDetailRow();
    }

    private void sum() {
        Integer key = null;
        int size = this.lstDblClickRow.size();
        for (int i = 0; i < size; ++i) {
            key = (Integer)this.lstDblClickRow.get(i);
            HidePosition pos = (HidePosition)this.mapDblClickRow.get(key);
            IRow row = this.tblMain.getRow(key.intValue());
            this.sum(row, pos.startIndex, pos.endIndex);
        }
    }

    private void hideDetailRow() {
        Integer key = null;
        int size = this.lstDblClickRow.size();
        for (int i = 0; i < size; ++i) {
            key = (Integer)this.lstDblClickRow.get(i);
            HidePosition pos = (HidePosition)this.mapDblClickRow.get(key);
            this.hideRow(pos.startIndex, pos.endIndex);
        }
    }

    private void hideRow(int startIndex, int endIndex) {
        for (int j = startIndex; j <= endIndex; ++j) {
            if (this.lstNotHideRow.indexOf(new Integer(j)) != -1) continue;
            IRow row = this.tblMain.getRow(j);
            row.getStyleAttributes().setHided(true);
        }
    }

    private void fillTableByAccountType() throws SQLException, BOSException {
        this.fillBalanceByAccountType();
        this.fillTransDetailByAccountType();
        IRow row = this.tblMain.getRow(1);
        this.sum(row, 1, this.tblMain.getRowCount() - 1);
    }

    private void fillBalanceByAccountType() throws BOSException, SQLException {
        IRowSet rs = this.getRsBalanceByAccountType();
        this.fillBalanceColumn(rs, 1);
    }

    private void fillTransDetailByAccountType() throws BOSException, SQLException {
        IRowSet rs = this.getRsDetailByAccountType();
        this.fillTransDetailColumn(rs, 1);
    }

    private void fillTableByOrg() throws BOSException, SQLException {
        this.fillBalanceByOrg();
        this.fillTransDetailByOrg();
    }

    private void fillBalanceByOrg() throws BOSException, SQLException {
        IRow row = this.tblMain.addRow();
        int count = this.tblMain.getRowCount();
        this.lstNotHideRow.add(new Integer(count - 1));
        this.SEP_ORG_IDX = count - 1;
        this.setHeaderNameByOrg(row);
        IRowSet rs = this.getRsBalanceByOrg();
        this.fillBalanceColumn(rs, 2);
    }

    private void fillTransDetailByOrg() throws SQLException, BOSException {
        IRowSet rs = this.getRsDetailByOrg();
        this.fillTransDetailColumn(rs, 2);
    }

    private void fillTableByBank() throws BOSException, SQLException {
        this.fillBalanceByBank();
        this.fillTransDetailByBank();
    }

    private void fillBalanceByBank() throws BOSException, SQLException {
        IRow row = this.tblMain.addRow();
        this.setHeaderNameByBank(row);
        int count = this.tblMain.getRowCount();
        this.lstNotHideRow.add(new Integer(count - 1));
        this.SEP_BANK_IDX = count - 1;
        IRowSet rs = this.getRsBalanceByBank();
        this.fillBalanceColumn(rs, 3);
    }

    private void fillTransDetailByBank() throws BOSException, SQLException {
        IRowSet rs = this.getRsDetailByBank();
        this.fillTransDetailColumn(rs, 3);
    }

    private Integer getHashcode(IRowSet rs, int catalogType) throws SQLException {
        String rowKey = "";
        switch (catalogType) {
            case 1: {
                rowKey = rs.getInt("accounttype") + "_" + rs.getString("companyid") + "_" + rs.getInt("bankinterfacetype") + "_" + rs.getString("bankaccountnumber");
                break;
            }
            case 2: {
                rowKey = rs.getString("companyid") + "_" + rs.getInt("accounttype") + "_" + rs.getInt("bankinterfacetype") + "_" + rs.getString("bankaccountnumber");
                break;
            }
            case 3: {
                rowKey = rs.getInt("bankinterfacetype") + "_" + rs.getInt("accounttype") + "_" + rs.getString("companyid") + "_" + rs.getString("bankaccountnumber");
            }
        }
        return new Integer(rowKey.hashCode());
    }

    private String getRowKey(IRowSet rs, int catalogType) throws SQLException {
        String rowKey = "";
        switch (catalogType) {
            case 1: {
                rowKey = rs.getInt("accounttype") + "_" + rs.getString("company_name") + "_" + rs.getInt("bankinterfacetype") + "_" + rs.getString("bankaccountnumber");
                break;
            }
            case 2: {
                rowKey = rs.getString("company_name") + "_" + rs.getInt("accounttype") + "_" + rs.getInt("bankinterfacetype") + "_" + rs.getString("bankaccountnumber");
                break;
            }
            case 3: {
                rowKey = rs.getInt("bankinterfacetype") + "_" + rs.getInt("accounttype") + "_" + rs.getString("company_name") + "_" + rs.getString("bankaccountnumber");
            }
        }
        return rowKey;
    }

    private boolean setCatalogColumn(int catalogType, int index, IRowSet rs) throws SQLException {
        int bankInterfaceType = rs.getInt("bankinterfacetype");
        String accountType = null;
        String companyName = null;
        String companyId = null;
        String bankName = null;
        accountType = FDCaptialReportUI.getAccountTypeName(rs.getInt("accounttype"));
        companyName = rs.getString("company_name");
        companyId = rs.getString("companyid");
        bankName = this.getBankName(bankInterfaceType);
        IRow row = null;
        boolean addNewRow = false;
        switch (catalogType) {
            case 1: {
                if (!this.mapFirstColKey.containsKey(accountType)) {
                    row = this.tblMain.addRow();
                    this.mapFirstColKey.put(accountType, new Integer(index));
                    row.getCell(0).setValue((Object)accountType);
                    this.recordDblClickPosition(index);
                    addNewRow = true;
                }
                row = this.tblMain.addRow();
                row.getCell(1).setValue((Object)companyName);
                row.getCell(2).setValue((Object)bankName);
                break;
            }
            case 2: {
                if (!this.mapFirstColKey.containsKey(companyId)) {
                    row = this.tblMain.addRow();
                    this.mapFirstColKey.put(companyId, new Integer(index));
                    row.getCell(0).setValue((Object)companyName);
                    this.recordDblClickPosition(index);
                    addNewRow = true;
                }
                row = this.tblMain.addRow();
                row.getCell(1).setValue((Object)accountType);
                row.getCell(2).setValue((Object)bankName);
                break;
            }
            case 3: {
                if (!this.mapFirstColKey.containsKey(new Integer(bankInterfaceType))) {
                    row = this.tblMain.addRow();
                    this.mapFirstColKey.put(new Integer(bankInterfaceType), new Integer(index));
                    row.getCell(0).setValue((Object)bankName);
                    this.recordDblClickPosition(index);
                    addNewRow = true;
                }
                row = this.tblMain.addRow();
                row.getCell(1).setValue((Object)accountType);
                row.getCell(2).setValue((Object)companyName);
            }
        }
        return addNewRow;
    }

    private void recordDblClickPosition(int index) {
        this.lstDblClickRow.add(new Integer(index));
        HidePosition pos = new HidePosition();
        this.mapDblClickRow.put(new Integer(index), pos);
        pos.startIndex = index + 1;
    }

    private void fillTransDetailColumn(IRowSet rs, int catalogType) throws SQLException {
        IRow row = null;
        Integer rowKey = null;
        while (rs.next()) {
            if (this.mapPosIndex.size() == 0) continue;
            rowKey = this.getHashcode(rs, catalogType);
            int index = this.getRowIndex(rowKey);
            if (this.mapPosIndex.size() > 0 && index == -1) continue;
            row = this.tblMain.getRow(index);
            row.getCell(3).setValue((Object)rs.getString("bankaccountnumber"));
            row.getCell(6).setValue((Object)rs.getBigDecimal("debitamount"));
            row.getCell(5).setValue((Object)rs.getBigDecimal("creditamount"));
        }
    }

    private void fillBalanceColumn(IRowSet rs, int catalogType) throws SQLException {
        IRow row = null;
        Integer rowKey = null;
        int index = this.tblMain.getRowCount();
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        while (rs.next()) {
            rowKey = this.getHashcode(rs, catalogType);
            if (map.containsKey(rowKey)) continue;
            map.put(rowKey, "");
            index = this.setCatalogColumn(catalogType, index, rs) ? (index += 2) : ++index;
            Date date = rs.getDate("biztime");
            row = this.tblMain.getRow(index - 1);
            row.getCell(3).setValue((Object)rs.getString("bankaccountnumber"));
            if (this.isDateEqual(date, this.startDate)) {
                row.getCell(4).setValue((Object)rs.getBigDecimal("balance"));
            } else if (this.isDateEqual(date, this.endDate)) {
                row.getCell(7).setValue((Object)rs.getBigDecimal("balance"));
            } else {
                row.getCell(4).setValue((Object)"9.99");
            }
            this.mapPosIndex.put(rowKey, new Integer(index - 1));
        }
    }

    private boolean isDateEqual(java.util.Date date1, java.util.Date date2) {
        int year1 = 0;
        int month1 = 0;
        int day1 = 0;
        int year2 = 0;
        int month2 = 0;
        int day2 = 0;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        year1 = cal.get(1);
        month1 = cal.get(2);
        day1 = cal.get(5);
        cal.setTime(date2);
        year2 = cal.get(1);
        month2 = cal.get(2);
        day2 = cal.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    private int getRowIndex(Integer key) {
        if (!this.mapPosIndex.containsKey(key)) {
            return -1;
        }
        return (Integer)this.mapPosIndex.get(key);
    }

    private void setHeaderNameByOrg(IRow row) {
        row.getStyleAttributes().setBackground(Color.YELLOW);
        row.getStyleAttributes().setBold(true);
        ICell cell = row.getCell(0);
        cell.setValue(this.lstHeaderName.get(1));
        cell = row.getCell(1);
        cell.setValue(this.lstHeaderName.get(0));
        for (int i = 2; i < 8; ++i) {
            cell = row.getCell(i);
            cell.setValue(this.lstHeaderName.get(i));
        }
    }

    private void setHeaderNameByBank(IRow row) {
        row.getStyleAttributes().setBackground(Color.YELLOW);
        row.getStyleAttributes().setBold(true);
        ICell cell = row.getCell(0);
        cell.setValue(this.lstHeaderName.get(2));
        cell = row.getCell(1);
        cell.setValue(this.lstHeaderName.get(1));
        cell = row.getCell(1);
        cell.setValue(this.lstHeaderName.get(0));
        for (int i = 3; i < 8; ++i) {
            cell = row.getCell(i);
            cell.setValue(this.lstHeaderName.get(i));
        }
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    private void initBankInterfaceMap() {
        this.mapBankInterface.put(new Integer(1), "\u4e2d\u56fd\u94f6\u884c");
        this.mapBankInterface.put(new Integer(2), "\u5de5\u5546\u94f6\u884c");
        this.mapBankInterface.put(new Integer(3), "\u519c\u4e1a\u94f6\u884c");
        this.mapBankInterface.put(new Integer(4), "\u5efa\u8bbe\u94f6\u884c");
    }

    private String getBankName(int type) {
        Integer key = new Integer(type);
        if (!this.mapBankInterface.containsKey(key)) {
            return new Integer(type).toString();
        }
        return (String)this.mapBankInterface.get(key);
    }

    public static String getAccountTypeName(int accountType) {
        if (accountType == 0) {
            return "\u6536\u5165\u6237";
        }
        if (accountType == 1) {
            return "\u652f\u51fa\u6237";
        }
        return "\u6536\u652f\u6237";
    }

    private String getDateSql() {
        return this.getPeriodDateSql();
    }

    private IRowSet getRsBalanceByAccountType() throws BOSException {
        String sql = "select accounttype,companyid,company_name,bankinterfacetype,bankaccountnumber,biztime,balance from v_be_fdbankbalance where " + this.getEqualDateSql() + " order by biztime,accounttype,companyid,company_name,bankinterfacetype,bankaccountnumber";
        return this.getRowSet(sql);
    }

    private IRowSet getRsBalanceByOrg() throws BOSException {
        String sql = "select companyid,company_name,accounttype,bankinterfacetype,bankaccountnumber,biztime,balance from v_be_fdbankbalance where " + this.getEqualDateSql() + " order by biztime,companyid,company_name,accounttype,bankinterfacetype,bankaccountnumber";
        return this.getRowSet(sql);
    }

    private IRowSet getRsBalanceByBank() throws BOSException {
        String sql = "select bankinterfacetype,companyid,company_name,accounttype,bankaccountnumber,biztime,balance from v_be_fdbankbalance where " + this.getEqualDateSql() + " order by biztime,bankinterfacetype,companyid,company_name,accounttype,bankaccountnumber";
        return this.getRowSet(sql);
    }

    private IRowSet getRsDetailByAccountType() throws BOSException {
        String sql = "select accounttype,companyid,company_name,bankinterfacetype,bankaccountnumber,sum(debitamount) as debitamount,sum(creditamount) as creditamount from v_be_fdtransdetail where " + this.getDateSql() + " group by accounttype,companyid,company_name,bankinterfacetype,bankaccountnumber order by accounttype,companyid,company_name,bankinterfacetype,bankaccountnumber";
        return this.getRowSet(sql);
    }

    private IRowSet getRsDetailByOrg() throws BOSException {
        String sql = "select companyid,company_name,accounttype,bankinterfacetype,bankaccountnumber,sum(debitamount) as debitamount,sum(creditamount) as creditamount from v_be_fdtransdetail where " + this.getDateSql() + " group by companyid,company_name,accounttype,bankinterfacetype,bankaccountnumber order by companyid,company_name,accounttype,bankinterfacetype,bankaccountnumber";
        return this.getRowSet(sql);
    }

    private IRowSet getRsDetailByBank() throws BOSException {
        String sql = "select bankinterfacetype,companyid,company_name,accounttype,bankaccountnumber,sum(debitamount) as debitamount,sum(creditamount) as creditamount from v_be_fdtransdetail where " + this.getDateSql() + " group by bankinterfacetype,companyid,company_name,accounttype,bankaccountnumber order by bankinterfacetype,companyid,company_name,accounttype,bankaccountnumber";
        return this.getRowSet(sql);
    }

    private String getEqualDateSql() {
        String strDatePre = ReportClientUtil.getFixedDataStr(this.startDate);
        String strDateNext = ReportClientUtil.getFixedDataStr(this.endDate);
        return " biztime = {ts'" + strDatePre + "'} or biztime = {ts'" + strDateNext + "'} ";
    }

    private String getPeriodDateSql() {
        String strDatePre = ReportClientUtil.getFixedDataStr(this.startDate);
        String strDateNext = ReportClientUtil.getFixedDataStr(this.endDate);
        return " biztime >= {ts'" + strDatePre + "'} and biztime <= {ts'" + strDateNext + "'} ";
    }

    private void reGroup(HashMap map) {
        Integer key;
        if (this.lstDblClickRow.size() == 0) {
            return;
        }
        Integer lastKey = key = (Integer)this.lstDblClickRow.get(0);
        int value = 0;
        int size = this.lstDblClickRow.size();
        for (int i = 1; i < size; ++i) {
            key = (Integer)this.lstDblClickRow.get(i);
            HidePosition pos = (HidePosition)this.mapDblClickRow.get(lastKey);
            value = key - 1;
            pos.endIndex = value == this.SEP_BANK_IDX || value == this.SEP_ORG_IDX ? value - 1 : value;
            lastKey = key;
        }
        HidePosition pos = (HidePosition)this.mapDblClickRow.get(key);
        pos.endIndex = this.tblMain.getRowCount() - 1;
    }

    class HidePosition {
        public int startIndex = 0;
        public int endIndex = 0;
        public boolean display = false;

        HidePosition() {
        }

        public String toString() {
            return "[" + this.startIndex + "," + this.endIndex + "]";
        }
    }
}

