/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.custom.gpgc.client.FDCaptialChartUI;
import com.kingdee.eas.custom.gpgc.client.FDCaptialReportUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;

public class FDReportChartHelper {
    private HashMap mapBankInterface = new HashMap();
    private Date endDate = null;

    public FDReportChartHelper(Date end) {
        this.endDate = end;
        this.initBankInterfaceMap();
    }

    public void displayPieChart(CoreUI ui) throws BOSException, SQLException {
        KDChart accountChart = this.getChartByAccountType();
        KDChart orgChart = this.getChartByOrg();
        KDChart bankChart = this.getChartByBank();
        FDCaptialReportUI reportUI = (FDCaptialReportUI)ui;
        reportUI.pnlLeft.removeAll();
        reportUI.pnlMid.removeAll();
        reportUI.pnlRight.removeAll();
        reportUI.pnlLeft.add((Component)accountChart);
        reportUI.pnlMid.add((Component)orgChart);
        reportUI.pnlRight.add((Component)bankChart);
    }

    public void displayOnePieChart(CoreUI ui) throws BOSException, SQLException {
        KDChart orgChart = this.getChartByOrg();
        FDCaptialChartUI reportUI = (FDCaptialChartUI)ui;
        orgChart.setSize(600, 600);
        reportUI.add((Component)orgChart);
    }

    private String getEqualDateSql() {
        String strDateNext = ReportClientUtil.getFixedDataStr(this.endDate);
        return " biztime = {ts'" + strDateNext + "'} ";
    }

    private KDChart getChartByAccountType() throws BOSException, SQLException {
        String sql = "select accounttype,sum(balance) from v_be_fdbankbalance  where " + this.getEqualDateSql() + " group by accounttype order by accounttype";
        IRowSet rs = this.getRowSet(sql);
        int size = rs.size();
        String[] lstTitles = new String[size];
        double[] lstDatas = new double[size];
        int i = 0;
        while (rs.next()) {
            lstTitles[i] = this.getAccountTypeName(rs.getInt(1));
            lstDatas[i++] = rs.getDouble(2);
        }
        return this.fillChart("\u6309\u8d26\u6237\u7c7b\u578b\u663e\u793a", lstTitles, lstDatas, 250);
    }

    public KDChart getChartByOrg() throws BOSException, SQLException {
        String sql = "select companyid,company_name,sum(balance) from v_be_fdbankbalance  where " + this.getEqualDateSql() + " group by companyid,company_name order by companyid";
        IRowSet rs = this.getRowSet(sql);
        int size = rs.size();
        String[] lstTitles = new String[size];
        double[] lstDatas = new double[size];
        int i = 0;
        while (rs.next()) {
            lstTitles[i] = rs.getString(2);
            lstDatas[i++] = rs.getDouble(3);
        }
        return this.fillChart("\u6309\u7ec4\u7ec7\u663e\u793a", lstTitles, lstDatas, 400);
    }

    private KDChart getChartByBank() throws BOSException, SQLException {
        String sql = "select bankinterfacetype,sum(balance) from v_be_fdbankbalance  where " + this.getEqualDateSql() + " group by bankinterfacetype order by bankinterfacetype";
        IRowSet rs = this.getRowSet(sql);
        int size = rs.size();
        String[] lstTitles = new String[size];
        double[] lstDatas = new double[size];
        int i = 0;
        while (rs.next()) {
            lstTitles[i] = this.getBankName(rs.getInt(1));
            lstDatas[i++] = rs.getDouble(2);
        }
        this.printDoubleArray(lstDatas);
        return this.fillChart("\u6309\u94f6\u884c\u663e\u793a", lstTitles, lstDatas, 250);
    }

    private KDChart fillChart(String chartTitle, String[] titles, double[] datas, int width) {
        KDChart chart = new KDChart();
        chart.setChartType(ChartType.CT_PIE);
        chart.getChartTitle().setText(chartTitle);
        PieChartData pieChartData = ChartDataUtil.createPieChartData((String[])titles, (double[])datas);
        chart.addChartData((IChartData)pieChartData);
        chart.setSize(width, 250);
        return chart;
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    private void initBankInterfaceMap() {
        this.mapBankInterface.put(new Integer(1), "\u4e2d\u56fd\u94f6\u884c");
        this.mapBankInterface.put(new Integer(2), "\u5de5\u5546\u94f6\u884c");
        this.mapBankInterface.put(new Integer(3), "\u519c\u4e1a\u94f6\u884c");
        this.mapBankInterface.put(new Integer(4), "\u5efa\u8bbe\u94f6\u884c");
    }

    private String getBankName(int type) {
        Integer key = new Integer(type);
        if (!this.mapBankInterface.containsKey(key)) {
            return new Integer(type).toString();
        }
        return (String)this.mapBankInterface.get(key);
    }

    private String getAccountTypeName(int type) {
        return FDCaptialReportUI.getAccountTypeName(type);
    }

    private void printDoubleArray(double[] arrs) {
        String str = "(";
        for (int i = 0; i < arrs.length; ++i) {
            str = str + arrs[i] + ",";
        }
        System.out.println(str + ")");
    }
}

