/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GDJConstrantHelper {
    public static final int APPLY = 1;
    public static final int PLAN = 2;
    private KDTable tblMain = null;
    private int type = 0;
    private Map mapCompany = new HashMap(32);
    private Date queryDate = new Date();
    private static final String JINYING = "A08";
    private static final String NUMBER_FORMATE = "#,###0.00";

    public GDJConstrantHelper(KDTable tblMain, int type) {
        this.tblMain = tblMain;
        this.type = type;
    }

    public void setQueryDate(Date date) {
        this.queryDate = date;
    }

    private String getQuerySql() {
        return "select company_number,company_name,sum(creditamount) as creditamt,transcode from v_be_transdetail ";
    }

    private void fillDataToTable(IRowSet rs, int colIndex) throws Exception {
        int rowIndex = 0;
        int currRowIndex = 0;
        boolean isDebit = false;
        String companyId = null;
        String transcode = null;
        IRow row = null;
        while (rs.next()) {
            companyId = rs.getString("company_number");
            if (this.mapCompany.containsKey(companyId)) {
                rowIndex = (Integer)this.mapCompany.get(companyId);
                row = this.tblMain.getRow(rowIndex);
            } else {
                row = this.tblMain.addRow();
                this.mapCompany.put(companyId, new Integer(currRowIndex++));
            }
            row.getCell(0).setValue((Object)rs.getString("company_name"));
            transcode = rs.getString("transcode");
            if (JINYING.equalsIgnoreCase(transcode)) {
                row.getCell(colIndex).setValue((Object)new Double(rs.getDouble("creditamt")));
                continue;
            }
            row.getCell(colIndex + 4).setValue((Object)new Double(rs.getDouble("creditamt")));
        }
    }

    private String getPeriodQuerySql() {
        Date end;
        Date start;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.queryDate);
        int day = cal.get(5);
        int month = cal.get(2);
        if (day < 11) {
            cal.set(5, 1);
            start = cal.getTime();
            cal.set(5, 11);
            end = cal.getTime();
        } else if (day < 21) {
            cal.set(5, 11);
            start = cal.getTime();
            cal.set(5, 21);
            end = cal.getTime();
        } else {
            cal.set(5, 21);
            start = cal.getTime();
            cal.set(2, month + 1);
            cal.set(5, 1);
            end = cal.getTime();
        }
        String sql = this.getQuerySql();
        String dateSql = ReportClientUtil.getQueryDateCondition("biztime", start, end);
        return sql + " where " + dateSql + " group by company_number,company_name,transcode order by company_number";
    }

    private String getMonthQuerySql() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.queryDate);
        int month = cal.get(2);
        cal.set(5, 1);
        Date start = cal.getTime();
        cal.set(2, month + 1);
        Date end = cal.getTime();
        String sql = this.getQuerySql();
        String dateSql = ReportClientUtil.getQueryDateCondition("biztime", start, end);
        return sql + " where " + dateSql + " group by company_number,company_name,transcode order by company_number";
    }

    private void fillPeriodData() throws Exception {
        String sql = this.getPeriodQuerySql();
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        this.fillDataToTable(rs, 1);
    }

    private void fillMonthData() throws Exception {
        String sql = this.getMonthQuerySql();
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        this.fillDataToTable(rs, 2);
    }

    public void getQueryResult() throws Exception {
        this.fillPeriodData();
        this.fillMonthData();
        this.sumRow();
    }

    private void sumRow() {
        int rows = this.tblMain.getRowCount();
        if (rows == 0) {
            return;
        }
        int cols = this.tblMain.getColumnCount();
        double value = 0.0;
        for (int i = 1; i < cols; ++i) {
            value = 0.0;
            for (int j = 0; j < rows; ++j) {
                value += this.getCellValue(j, i);
            }
            this.tblMain.getCell(rows - 1, i).setValue((Object)new Double(value));
        }
    }

    private double getCellValue(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    public void refresh() throws Exception {
        this.tblMain.removeRows();
        this.mapCompany.clear();
        this.getQueryResult();
    }

    public void setTableNumberFormat() {
        int size = this.tblMain.getColumnCount();
        for (int i = 1; i < size; ++i) {
            if (i == 4 || i == 8) continue;
            this.tblMain.getColumn(i).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        }
    }
}

