/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.custom.gpgc.client.AbstractGDJDailyBalanceUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class GDJDailyBalanceUI
extends AbstractGDJDailyBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(GDJDailyBalanceUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private Date dateQuery = new Date();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnFilter.setEnabled(true);
        this.setUITitle("\u4f9b\u7535\u5c40\u8d26\u6237\u4f59\u989d\u8868");
        this.initTable();
        this.getQueryResult();
    }

    private String getQuerySql() {
        String dateSql = ReportClientUtil.getDatePeriodString("bizdate", this.dateQuery);
        return "select sum(balance),company_number,company_name,bankinterfacetype from v_be_accountbalance where " + dateSql + " group by company_number,company_name,bankinterfacetype order by company_number";
    }

    private void fillDataToTable() throws Exception {
        String sql = this.getQuerySql();
        System.out.println(sql);
        String company = null;
        String lastCompany = null;
        IRow row = null;
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            int type = rs.getInt(4);
            company = rs.getString(2);
            if (!company.equalsIgnoreCase(lastCompany)) {
                row = this.tblMain.addRow();
                lastCompany = company;
                row.getCell(0).setValue((Object)rs.getString(3));
            }
            if (row == null) continue;
            ICell cell = row.getCell(type);
            cell.setValue((Object)rs.getBigDecimal(1));
        }
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(0).setWidth(250);
        this.tblMain.getColumn(1).setWidth(150);
        this.tblMain.getColumn(2).setWidth(150);
        this.tblMain.getColumn(3).setWidth(150);
        this.tblMain.getColumn(4).setWidth(150);
        this.tblMain.getColumn(5).setWidth(150);
        this.setNumericEditor();
    }

    private void setNumericEditor() {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setDataVerifierType(12);
        kft.setPrecision(6);
        for (int i = 1; i < 6; ++i) {
            this.tblMain.getColumn(i).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
            this.tblMain.getColumn(i).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        }
    }

    private void sumCol() {
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            double v1 = ReportClientUtil.getValueFromCell(this.tblMain, i, 2);
            double v2 = ReportClientUtil.getValueFromCell(this.tblMain, i, 3);
            double v3 = ReportClientUtil.getValueFromCell(this.tblMain, i, 4);
            double v4 = ReportClientUtil.getValueFromCell(this.tblMain, i, 5);
            double v5 = v1 + v2 + v3 + v4;
            this.tblMain.getCell(i, 1).setValue((Object)new Double(v5));
        }
    }

    private void getQueryResult() throws Exception {
        this.fillDataToTable();
        this.sumCol();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.custom.gpgc.client.DateFilterUI", (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
        Map map = this.getUIContext();
        if (map.containsKey("QueryDate")) {
            this.dateQuery = (Date)map.get("QueryDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.getQueryResult();
    }
}

