/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractGDJFluxUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class GDJFluxUI
extends AbstractGDJFluxUI {
    private static final Logger logger = CoreUIObject.getLogger(GDJFluxUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private HashMap mapPosition = new HashMap(48);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.clearTable();
        this.getQueryResult();
    }

    public void clearTable() {
        int rows = this.tblMain.getRowCount();
        int cols = this.tblMain.getColumnCount();
        for (int i = 1; i < rows; ++i) {
            for (int j = 2; j < cols; ++j) {
                this.tblMain.getCell(i, j).setValue(null);
            }
        }
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u4f9b\u7535\u5c40\u73b0\u91d1\u6d41\u91cf\u7b80\u8868");
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.initPositionMap();
        this.setReportTitle();
        this.initTableItems();
        this.getQueryResult();
    }

    private void setReportTitle() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        this.lblDate.setText("\u7f16\u5236\u65e5\u671f\uff1a" + sf.format(new Date()));
        this.lblUnit.setText("\u5355\u4f4d\uff1a\u4e07\u5143");
    }

    private void setNumericEditor() {
        this.tblMain.getColumn(2).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(3).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initTableItems() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(0).setWidth(200);
        this.tblMain.getColumn(1).setWidth(40);
        this.tblMain.getColumn(2).setWidth(200);
        this.tblMain.getColumn(3).setWidth(200);
        this.setNumericEditor();
        for (int i = 0; i < 33; ++i) {
            IRow row = this.tblMain.addRow();
            row.getCell(1).setValue((Object)(i + 1 + ""));
        }
        int index = 0;
        this.tblMain.getRow(index).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u8d27\u5e01\u8d44\u91d1\u7684\u671f\u521d\u4f59\u989d");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u5f53\u6708\u73b0\u91d1\u6d41\u5165\uff1a");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u4e00\u3001\u5916\u90e8\u73b0\u91d1\u6d41\u5165");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e00\uff09\u7535\u8d39");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e8c\uff09\u63d0\u4f9b\u52b3\u52a1\u6536\u652f\u7684\u73b0\u91d1");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e09\uff09\u5176\u4ed6");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u4e8c\u3001\u5185\u90e8\u73b0\u91d1\u6d41\u5165");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e00\uff09\u7ecf\u8425\u6027\u8d44\u91d1");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e8c\uff09\u8d44\u672c\u6027\u8d44\u91d1");
        this.tblMain.getRow(index).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u73b0\u91d1\u6d41\u5165\u5408\u8ba1");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u5f53\u6708\u73b0\u91d1\u6d41\u51fa\uff1a");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u4e09\u3001\u5916\u90e8\u73b0\u91d1\u6d41\u51fa");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e00\uff09\u7ecf\u8425\u6027\u6d41\u51fa");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"1\u3001\u652f\u4ed8\u5730\u65b9\u7535\u8d39");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"2\u3001\u652f\u4ed8\u8d2d\u4e70\u6750\u6599\u6b3e");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"3\u3001\u652f\u4ed8\u7a0e\u6b3e");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"4\u3001\u652f\u4ed8\u519c\u7535\u670d\u52a1\u8d39");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"5\u3001\u652f\u4ed8\u5de5\u8d44\u798f\u5229");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"6\u3001\u652f\u4ed8\u4fee\u7406\u8d39");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"7\u3001\u57ce\u5efa\u9644\u52a0\u8d39");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"8\u3001\u5176\u4ed6");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e8c\uff09\u8d44\u672c\u6027\u6d41\u51fa");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"1\u3001\u7535\u7f51\u5efa\u8bbe\u9879\u76ee");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"2\u3001\u5c0f\u578b\u57fa\u5efa\u9879\u76ee");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"3\u3001\u6280\u6539\u9879\u76ee");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"4\u3001\u79d1\u6280\u9879\u76ee");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"5\u3001IT\u89c4\u5212\u9879\u76ee");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"6\u3001\u5176\u4ed6\u8d44\u672c\u6027\u9879\u76ee");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u56db\u3001\u5185\u90e8\u73b0\u91d1\u6d41\u51fa");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e00\uff09\u5f52\u96c6\u8d44\u91d1");
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\uff08\u4e8c\uff09\u5176\u4ed6");
        this.tblMain.getRow(index).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u73b0\u91d1\u6d41\u51fa\u5408\u8ba1");
        this.tblMain.getRow(index).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.tblMain.getRow(index++).getCell(0).setValue((Object)"\u8d27\u5e01\u8d44\u91d1\u7684\u671f\u672b\u4f59\u989d");
    }

    private void initPositionMap() {
        this.mapPosition.put("Z01", new Integer(3));
        this.mapPosition.put("E02", new Integer(4));
        this.mapPosition.put("Z02", new Integer(5));
        this.mapPosition.put("E02", new Integer(7));
        this.mapPosition.put("E03", new Integer(8));
        int index = 13;
        this.mapPosition.put("A01", new Integer(index++));
        this.mapPosition.put("A02", new Integer(index++));
        this.mapPosition.put("A06", new Integer(index++));
        this.mapPosition.put("A04", new Integer(index++));
        this.mapPosition.put("A05", new Integer(index));
        this.mapPosition.put("D1", new Integer(index));
        this.mapPosition.put("D2", new Integer(index++));
        this.mapPosition.put("A03", new Integer(index++));
        this.mapPosition.put("A07", new Integer(index++));
        this.mapPosition.put("A09", new Integer(index));
        this.mapPosition.put("A10", new Integer(index));
        this.mapPosition.put("A11", new Integer(index));
        this.mapPosition.put("C01", new Integer(index));
        this.mapPosition.put("C03", new Integer(index));
        this.mapPosition.put("D03", new Integer(index));
        this.mapPosition.put("D04", new Integer(index++));
        int n = ++index;
        this.mapPosition.put("B01", new Integer(n));
        this.mapPosition.put("B01", new Integer(++index));
        this.mapPosition.put("D05", new Integer(index));
        this.mapPosition.put("D06", new Integer(index++));
        this.mapPosition.put("B03", new Integer(index++));
        this.mapPosition.put("B04", new Integer(index++));
        this.mapPosition.put("B05", new Integer(index++));
        this.mapPosition.put("B06", new Integer(index));
        this.mapPosition.put("B05", new Integer(index++));
        int n2 = ++index;
        this.mapPosition.put("E04", new Integer(n2));
        this.mapPosition.put("E05", new Integer(++index));
        this.mapPosition.put("E06", new Integer(index));
        this.mapPosition.put("E07", new Integer(index));
    }

    private void getQueryResult() throws Exception {
        this.fillDateToTable();
        this.sumItems();
    }

    private void fillDateToTable() throws Exception {
        IRowSet rsMonth = this.getRowSetByMonth();
        IRowSet rsYear = this.getRowSetByYear();
        this.fillRowSetToTable(rsMonth, 2);
        this.fillRowSetToTable(rsYear, 3);
    }

    private void fillRowSetToTable(IRowSet rs, int col) throws SQLException {
        String type = null;
        int isdebit = 0;
        while (rs.next()) {
            type = rs.getString("ftype");
            if (!this.mapPosition.containsKey(type)) continue;
            int row = (Integer)this.mapPosition.get(type);
            double value = this.getCellValue(row, col);
            isdebit = rs.getInt(4);
            value = isdebit == 0 ? (value += rs.getDouble(1)) : (value += rs.getDouble(2));
            this.tblMain.getCell(row, col).setValue((Object)new Double(value));
        }
    }

    private IRowSet getRowSetByMonth() throws BOSException {
        String dateCond = this.getConditionByMonth();
        String sql = this.getQueryPrefixSql() + " and transcode is not null and " + dateCond + " group by transcode,fisdebit";
        System.out.println("month:" + sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    private IRowSet getRowSetByYear() throws BOSException {
        String dateCond = this.getConditionByYear();
        String sql = this.getQueryPrefixSql() + " and transcode is not null and " + dateCond + " group by transcode,fisdebit";
        System.out.println("year:" + sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    private String getQueryPrefixSql() {
        return "select sum(debitamount),sum(creditamount),transcode as ftype,fisdebit from v_be_transdetail where company_number not like '00.%' ";
    }

    private String getConditionByMonth() {
        return ReportClientUtil.getConditionByMonth();
    }

    private String getConditionByYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        Date start = cal.getTime();
        return ReportClientUtil.getQueryDateCondition(start, new Date());
    }

    private double getCellValue(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    private void sumItems() {
        int i;
        double total1 = 0.0;
        double total2 = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (i = 13; i < 21; ++i) {
            total1 += this.getCellValue(i, 2);
            total2 += this.getCellValue(i, 3);
        }
        this.tblMain.getCell(12, 2).setValue((Object)new Double(total1));
        this.tblMain.getCell(12, 3).setValue((Object)new Double(total2));
        sum1 += total1;
        sum2 += total2;
        total1 = 0.0;
        total2 = 0.0;
        for (i = 22; i < 28; ++i) {
            total1 += this.getCellValue(i, 2);
            total2 += this.getCellValue(i, 3);
        }
        this.tblMain.getCell(21, 2).setValue((Object)new Double(total1));
        this.tblMain.getCell(21, 3).setValue((Object)new Double(total2));
        this.tblMain.getCell(11, 2).setValue((Object)new Double(sum1));
        this.tblMain.getCell(11, 3).setValue((Object)new Double(sum2));
        sum1 += total1;
        sum2 += total2;
        total1 = 0.0;
        total2 = 0.0;
        for (i = 29; i < 31; ++i) {
            total1 += this.getCellValue(i, 2);
            total2 += this.getCellValue(i, 3);
        }
        this.tblMain.getCell(28, 2).setValue((Object)new Double(total1));
        this.tblMain.getCell(28, 3).setValue((Object)new Double(total2));
        this.tblMain.getCell(31, 2).setValue((Object)new Double(sum1 += total1));
        this.tblMain.getCell(31, 3).setValue((Object)new Double(sum2 += total2));
    }
}

