/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractGDJInOutUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GDJInOutUI
extends AbstractGDJInOutUI {
    private static final Logger logger = CoreUIObject.getLogger(GDJInOutUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private Date startDate = new Date();
    private Date endDate = new Date();
    private HashMap mapAccountNumber = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setEnabled(true);
        this.btnFilter.setEnabled(true);
        this.setUITitle("\u4f9b\u7535\u5c40\u4ea4\u6613\u60c5\u51b5\u6c47\u603b\u8868");
        this.initTable();
        this.mapAccountNumber = ReportClientUtil.getAccountNumber();
        this.getQueryResult();
    }

    private boolean isInnerAccount(String number) {
        return this.mapAccountNumber.containsKey(number);
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.setNumericEditor();
    }

    private void setNumericEditor() {
        for (int i = 1; i < 11; ++i) {
            IColumn col = this.tblMain.getColumn(i);
            col.getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setWidth(120);
        }
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.startDate = (Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.endDate = (Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.getQueryResult();
    }

    private String getQuerySql() throws BOSException {
        String dateSql = " biztime >= {ts'" + ReportClientUtil.getFixedDataStr(this.startDate) + "'}";
        dateSql = dateSql + " and biztime <= {ts'" + ReportClientUtil.getFixedDataStr(this.endDate) + "'}";
        return "select bankinterfacetype,company_number,company_name,oppbanknumber,debitAmount,creditAmount from v_be_transdetail where " + dateSql + " order by company_number";
    }

    private void fillDataToTable() throws Exception {
        String sql = this.getQuerySql();
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        IRow row = null;
        String companyNumber = null;
        double eachIn = 0.0;
        double eachOut = 0.0;
        int rowIndex = 0;
        int currIndex = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>(128);
        while (rs.next()) {
            if (this.isInnerAccount(rs.getString("oppbanknumber"))) continue;
            companyNumber = rs.getString("company_number");
            if (map.containsKey(companyNumber)) {
                rowIndex = (Integer)map.get(companyNumber);
                row = this.tblMain.getRow(rowIndex);
            } else {
                row = this.tblMain.addRow();
                row.getCell(0).setValue((Object)rs.getString("company_name"));
                rowIndex = currIndex;
                map.put(companyNumber, new Integer(currIndex++));
            }
            int col = this.getColIndex(rs.getInt(1));
            eachIn = this.getValue(rowIndex, col);
            eachOut = this.getValue(rowIndex, col);
            row.getCell(col).setValue((Object)new Double(eachIn += rs.getDouble("debitAmount")));
            row.getCell(col + 1).setValue((Object)new Double(eachOut += rs.getDouble("creditAmount")));
        }
    }

    private int getColIndex(int type) {
        int index = 3;
        switch (type) {
            case 2: {
                index = 3;
                break;
            }
            case 3: {
                index = 5;
                break;
            }
            case 4: {
                index = 7;
                break;
            }
            default: {
                index = 9;
            }
        }
        return index;
    }

    private void sumColumn() {
        double eachIn = 0.0;
        double eachOut = 0.0;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            eachIn = this.getValue(i, 3) + this.getValue(i, 5) + this.getValue(i, 7) + this.getValue(i, 9);
            eachOut = this.getValue(i, 4) + this.getValue(i, 6) + this.getValue(i, 8) + this.getValue(i, 10);
            this.tblMain.getCell(i, 1).setValue((Object)new Double(eachIn));
            this.tblMain.getCell(i, 2).setValue((Object)new Double(eachOut));
        }
    }

    private double getValue(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    private void getQueryResult() throws Exception {
        this.fillDataToTable();
        this.sumColumn();
    }
}

