/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.GpgcReportFacadeFactory;
import com.kingdee.eas.custom.gpgc.HQBalanceInfo;
import com.kingdee.eas.custom.gpgc.IGpgcReportFacade;
import com.kingdee.eas.custom.gpgc.client.AbstractHQDailyBalanceEditUI;
import com.kingdee.eas.custom.gpgc.client.BankItemInfo;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class HQDailyBalanceEditUI
extends AbstractHQDailyBalanceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(HQDailyBalanceEditUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    KDComboBox combBank = new KDComboBox();
    KDComboBox combAccount = new KDComboBox();
    private HashMap mapAccountList = new HashMap(16);
    private int ACCOUNT_COUNT = 1;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u603b\u90e8\u5b58\u91cf\u8868\u5f55\u5165");
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.tblMain.checkParsed();
        this.setNumericEditor();
        this.addListener();
        this.initBankList();
    }

    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    protected void btnAdd_mouseClicked(MouseEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    protected void btnDelete_mouseClicked(MouseEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex != -1) {
            this.tblMain.removeRow(rowIndex);
        } else {
            this.tblMain.removeRow(this.tblMain.getRowCount() - 1);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        HashMap mapValue = this.getValueFromTable();
        try {
            IGpgcReportFacade facade = GpgcReportFacadeFactory.getRemoteInstance();
            facade.saveHQBalance(mapValue);
            MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setNumericEditor() {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setDataVerifierType(12);
        kft.setPrecision(6);
        this.tblMain.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn(2).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn(3).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(4).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn(4).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
    }

    private HashMap getValueFromTable() {
        HQBalanceInfo info = null;
        HashMap<String, HQBalanceInfo> map = new HashMap<String, HQBalanceInfo>(16);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String banktype;
            IRow row = this.tblMain.getRow(i);
            info = new HQBalanceInfo();
            BankItemInfo itemInfo = (BankItemInfo)row.getCell(0).getValue();
            if (itemInfo == null) continue;
            info.bankType = banktype = itemInfo.banktype;
            info.accountNumber = row.getCell(1).getValue().toString();
            info.current = this.getValue(i, 2);
            info.fixed = this.getValue(i, 3);
            info.spec = this.getValue(i, 4);
            String key = banktype + "_" + info.accountNumber;
            if (map.containsKey(key)) continue;
            map.put(key, info);
        }
        return map;
    }

    private Double getValue(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex != -1) {
            this.tblMain.removeRow(rowIndex);
        } else {
            this.tblMain.removeRow(this.tblMain.getRowCount() - 1);
        }
    }

    private void initBankList() {
        BankItemInfo item = new BankItemInfo();
        item.banktype = "G";
        item.name = "\u5e7f\u53d1\u94f6\u884c";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = "L";
        item.name = "\u5f00\u884c";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = "J";
        item.name = "\u6c11\u751f\u94f6\u884c";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = "I";
        item.name = "\u62db\u5546\u94f6\u884c";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = "H";
        item.name = "\u6df1\u53d1\u94f6\u884c";
        this.combBank.addItem((Object)item);
        item = new BankItemInfo();
        item.banktype = "M";
        item.name = "\u4e2d\u4fe1\u94f6\u884c";
        this.combBank.addItem((Object)item);
        this.tblMain.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.combBank));
    }

    private Vector getAccountNumber(String bank) throws Exception {
        if (this.mapAccountList.containsKey(bank)) {
            return (Vector)this.mapAccountList.get(bank);
        }
        List lst = ReportClientUtil.getAccount(bank);
        Vector vect = new Vector(lst);
        this.mapAccountList.put(bank, vect);
        return vect;
    }

    private void addListener() {
        this.combBank.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BankItemInfo itemInfo = (BankItemInfo)e.getItem();
                    HQDailyBalanceEditUI.this.setComBoxEditForAccount(itemInfo.banktype);
                }
            }
        });
        this.combAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && HQDailyBalanceEditUI.this.combAccount.getSelectedIndex() == 1) {
                    int rowIndex = KDTableUtil.getSelectedRow((KDTable)HQDailyBalanceEditUI.this.tblMain);
                    if (rowIndex == -1) {
                        return;
                    }
                    HQDailyBalanceEditUI.this.tblMain.getCell(rowIndex, 1).setValue(HQDailyBalanceEditUI.this.combAccount.getItemAt(2));
                    for (int i = 3; i < HQDailyBalanceEditUI.this.ACCOUNT_COUNT; ++i) {
                        IRow row = HQDailyBalanceEditUI.this.tblMain.addRow();
                        row.getCell(1).setValue(HQDailyBalanceEditUI.this.combAccount.getItemAt(i));
                    }
                }
            }
        });
        this.tblMain.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.combAccount));
    }

    private void setComBoxEditForAccount(String bank) {
        this.combAccount.removeAllItems();
        Vector vect = new Vector();
        try {
            vect = this.getAccountNumber(bank);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vect.size() == 0) {
            return;
        }
        this.ACCOUNT_COUNT = vect.size() + 2;
        this.combAccount.addItem((Object)"");
        this.combAccount.addItem((Object)"\u5168\u90e8");
        this.combAccount.addItems(vect);
    }
}

