/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.custom.gpgc.client.AbstractHQDailyBalanceUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class HQDailyBalanceUI
extends AbstractHQDailyBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(HQDailyBalanceUI.class);
    private static final String NUMBER_FORMATE = "#,###0.00";
    private static final int ACCOUNT_PROPERTY_INDEX = 11;
    private HashMap mapRowIndex = new HashMap(16);
    private Date dateQuery = new Date();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRefresh.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnFilter.setEnabled(true);
        this.setUITitle("\u603b\u90e8\u5b58\u91cf\u8868");
        this.initBankNameList();
        this.initTable();
        this.fillTable();
        this.getDataFromDB();
        this.sumColoumn();
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(0).setWidth(250);
        this.tblMain.getColumn(1).setWidth(150);
        this.tblMain.getColumn(2).setWidth(120);
        this.tblMain.getColumn(3).setWidth(120);
        this.tblMain.getColumn(4).setWidth(120);
        this.tblMain.getColumn(5).setWidth(120);
        this.setNumericEditor();
        this.tblMain.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setNumericEditor() {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setDataVerifierType(12);
        kft.setPrecision(6);
        this.tblMain.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn(2).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn(3).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(4).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        this.tblMain.getColumn(4).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
        this.tblMain.getColumn(5).getStyleAttributes().setNumberFormat(NUMBER_FORMATE);
    }

    private String getQuerySql() throws BOSException {
        String dateSql = ReportClientUtil.getDatePeriodString("bizdate", this.dateQuery);
        return "select bank_name,bankInterfaceType,accountBank_bankAccountNumber,accountBank_number,balance from v_be_accountbalance  where (accountbank_number like '00.01.%' or accountbank_number like '00.02.%') and " + dateSql + " order by bankInterfaceType";
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        System.out.println(sql);
        return exec.executeSQL();
    }

    private int getColumnIndex(String str) {
        int index = 2;
        String catalog = str.substring(6, 8);
        if (catalog.startsWith("C") || catalog.startsWith("D2")) {
            return 3;
        }
        char ch = str.charAt(11);
        index = ch == 'D' ? 4 : 2;
        return index;
    }

    private void fillQueryDataToTable() throws BOSException, SQLException {
        IRowSet rs = this.getRowSet(this.getQuerySql());
        int bankType = 0;
        int lastBankType = 0;
        IRow row = null;
        while (rs.next()) {
            bankType = rs.getInt("bankInterfaceType");
            String bankAccountNumber = rs.getString("accountBank_bankAccountNumber");
            if (bankType != lastBankType) {
                row = this.tblMain.addRow();
                lastBankType = bankType;
                String bank = this.getBankName(bankType);
                row.getCell(0).setValue((Object)bank);
                row.getCell(0).getStyleAttributes().setBold(true);
            }
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)rs.getString("bank_name"));
            row.getCell(1).setValue((Object)bankAccountNumber);
            String number = rs.getString("accountBank_number");
            int colIndex = this.getColumnIndex(number);
            row.getCell(colIndex).setValue((Object)rs.getBigDecimal("balance"));
        }
    }

    private String getBankName(int bankType) {
        String name = null;
        try {
            name = BankInterfaceTypeEnum.getEnum((int)bankType).getAlias();
        }
        catch (Exception e) {
            name = "\u4e2d\u56fd\u94f6\u884c";
        }
        return name;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.fillTable();
        this.getDataFromDB();
        this.sumColoumn();
    }

    private void fillTable() throws Exception {
        this.tblMain.removeRows();
        IRow row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)"\u5408\u8ba1");
        this.fillQueryDataToTable();
    }

    private void initBankNameList() {
        this.mapRowIndex.put("G", "\u5e7f\u53d1\u94f6\u884c");
        this.mapRowIndex.put("L", "\u5f00\u884c");
        this.mapRowIndex.put("J", "\u6c11\u751f\u94f6\u884c");
        this.mapRowIndex.put("I", "\u62db\u5546\u94f6\u884c");
        this.mapRowIndex.put("H", "\u6df1\u53d1\u94f6\u884c");
        this.mapRowIndex.put("M", "\u4e2d\u4fe1");
    }

    private void sumColoumn() {
        double sumCurrent = 0.0;
        double sumFixed = 0.0;
        double sumSpecial = 0.0;
        int size = this.tblMain.getRowCount();
        for (int i = 1; i < size; ++i) {
            sumCurrent += this.getCellValue(i, 2);
            sumSpecial += this.getCellValue(i, 3);
            sumFixed += this.getCellValue(i, 4);
            this.tblMain.getCell(i, 5).setValue((Object)new Double(this.getCellValue(i, 2) + this.getCellValue(i, 3) + this.getCellValue(i, 4)));
        }
        this.tblMain.getCell(0, 2).setValue((Object)new Double(sumCurrent));
        this.tblMain.getCell(0, 3).setValue((Object)new Double(sumSpecial));
        this.tblMain.getCell(0, 4).setValue((Object)new Double(sumFixed));
        this.tblMain.getCell(0, 5).setValue((Object)new Double(sumCurrent + sumFixed + sumSpecial));
    }

    private double getCellValue(int i, int j) {
        return ReportClientUtil.getValueFromCell(this.tblMain, i, j);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        this.sumColoumn();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"Owner", (Object)this.ui);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.custom.gpgc.client.HQDailyBalanceEditUI", (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
    }

    private void getDataFromDB() throws Exception {
        String strDate = ReportClientUtil.getFixedDataStr(this.dateQuery);
        String dateSql = " fdate = {ts'" + strDate + "'}";
        String sql = "select * from v_be_hqbalancedate where " + dateSql;
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)this.getBankName(rs.getString("fnumber")));
            row.getCell(1).setValue((Object)rs.getString("faccountnumber"));
            row.getCell(2).setValue((Object)new Double(rs.getDouble("fcurrent")));
            row.getCell(3).setValue((Object)new Double(rs.getDouble("fspec")));
            row.getCell(4).setValue((Object)new Double(rs.getDouble("ffixed")));
        }
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDateFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("QueryDate")) {
            this.dateQuery = (Date)map.get("QueryDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    private String getBankName(String banktype) {
        if (!this.mapRowIndex.containsKey(banktype)) {
            return null;
        }
        return this.mapRowIndex.get(banktype).toString();
    }
}

