/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.custom.gpgc.client.AbstractHQFluxUI;
import com.kingdee.eas.custom.gpgc.client.ReportClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HQFluxUI
extends AbstractHQFluxUI {
    private static final Logger logger = CoreUIObject.getLogger(HQFluxUI.class);
    private List lstBankName = new ArrayList(16);
    private Map mapColPos = new HashMap(32);
    private Map mapRowPos = new HashMap(32);
    private Date dateEnd = new Date();
    private Date dateStart = DateTimeUtils.addMonth((Date)this.dateEnd, (int)-2);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setHeasTailItem();
        this.fillDataToTable();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        ReportClientUtil.showDatePeriodFilterUI(this);
        Map map = this.getUIContext();
        if (map.containsKey("StartDate")) {
            this.dateStart = (Date)map.get("StartDate");
        }
        if (map.containsKey("EndDate")) {
            this.dateEnd = (Date)map.get("EndDate");
        }
        this.actionRefresh_actionPerformed(null);
    }

    public void onLoad() throws Exception {
        this.setUITitle("\u603b\u90e8\u73b0\u91d1\u6d41\u91cf\u7b80\u8868");
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnFilter.setEnabled(true);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.init();
        this.fillDataToTable();
    }

    private void init() {
        this.initBankList();
        this.initTableHeader();
        this.initTable();
        this.initColPos();
        this.initRowPos();
    }

    private void initTableHeader() {
        int i;
        IRow row = this.tblMain.addHeadRow();
        int size = this.lstBankName.size();
        for (i = 0; i < size; ++i) {
            this.tblMain.addColumn();
        }
        this.tblMain.getColumn(0).setWidth(180);
        for (i = 0; i < size; ++i) {
            row.getCell(i).setValue(this.lstBankName.get(i));
        }
    }

    private void initBankList() {
        this.lstBankName.add("\u9879\u76ee");
        this.lstBankName.add("\u5de5\u884c\u7ca4\u79c0\u652f\u884c");
        this.lstBankName.add("\u5de5\u884c\u4e00\u652f\u884c");
        this.lstBankName.add("\u5efa\u884c\u7535\u529b\u529e");
        this.lstBankName.add("\u7701\u4e2d\u884c");
        this.lstBankName.add("\u5e02\u519c\u884c");
        this.lstBankName.add("\u5e7f\u4e1c\u53d1\u5c55\u884c");
        this.lstBankName.add("\u5f00\u53d1\u884c");
        this.lstBankName.add("\u5e02\u4e2d\u884c");
        this.lstBankName.add("\u6c11\u751f\u884c");
        this.lstBankName.add("\u62db\u5546\u94f6\u884c");
        this.lstBankName.add("\u6df1\u53d1\u884c");
        this.lstBankName.add("\u4e2d\u4fe1");
        this.lstBankName.add("\u5408\u8ba1");
    }

    private void setHeasTailItem() {
        Date date = new Date();
        Date lastMonth = DateTimeUtils.addMonth((Date)date, (int)-1);
        Date preMonth = DateTimeUtils.addMonth((Date)date, (int)-2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(preMonth);
        int month = cal.get(2) + 1;
        String strDate = "\u4e00\u3001" + month + "\u6708\u5e95\u4f59\u989d\uff1a";
        this.tblMain.getCell(0, 0).setValue((Object)strDate);
        cal.setTime(lastMonth);
        month = cal.get(2) + 1;
        strDate = "\u622a\u81f3" + month + "\u6708\u5e95\u4f59\u989d\uff1a";
        this.tblMain.getCell(this.tblMain.getRowCount() - 1, 0).setValue((Object)strDate);
    }

    private void initTable() {
        int i = 0;
        for (i = 0; i < 28; ++i) {
            this.tblMain.addRow();
        }
        i = 0;
        IRow row = this.tblMain.getRow(i++);
        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\u4e8c\u3001\u73b0\u91d1\u6d41\u5165\uff1a");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\uff08\u4e00\uff09\u3001\u6536\u57fa\u5c42\u5355\u4f4d\u8d44\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"1\u300110\u6708\u5f52\u96c6\u8d44\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"2\u3001\u57fa\u5c42\u4e0a\u4ea4\u5de5\u7a0b\u5229\u606f\u3001\u8282\u4f59\u7b49");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\uff08\u4e8c\uff09\u3001\u5176\u4ed6");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"1\u3001\u8d37\u6b3e");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"2\u3001\u5176\u4ed6");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"3\u3001\u5229\u606f\u6536\u5165");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\u6d41\u5165\u5c0f\u8ba1");
        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\u4e09\u3001\u73b0\u91d1\u6d41\u51fa\uff1a");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\uff08\u4e00\uff09\u3001\u751f\u4ea7\u7ecf\u8425\u652f\u51fa");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"1\u3001\u652f\u4ed8\u8d2d\u5165\u7535\u529b\u8d39");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"2\u3001\u652f\u4ed8\u7a0e\u6b3e");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\uff08\u4e8c\uff09\u3001\u62e8\u57fa\u5c42\u5355\u4f4d\u8d44\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"1\u3001\u7ecf\u8425\u6027\u8d44\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"2\u3001\u8d44\u672c\u6027\u8d44\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\uff08\u4e09\uff09\u3001\u4e0a\u4ea4\u4e09\u5ce1\u57fa\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\uff08\u56db\uff09\u3001\u5176\u4ed6");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"1\u3001\u56fd\u503a\u8f6c\u8d37\u5229\u606f");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"2\u3001\u652f\u4ed8\u793e\u4fdd\u8d39");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"3\u3001\u652f\u4ed8\u5176\u4ed6");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"4\u3001\u5f52\u8fd8\u8d37\u6b3e\u672c\u91d1");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"5\u3001\u652f\u4ed8\u5229\u606f");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\u6d41\u51fa\u5c0f\u8ba1");
        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"\u56db\u3001\u73b0\u91d1\u8f6c\u6b3e");
        row = this.tblMain.getRow(i++);
        row.getCell(0).setValue((Object)"1\u3001\u94f6\u884c\u8f6c\u6b3e");
        row = this.tblMain.getRow(i++);
        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.setHeasTailItem();
    }

    private void initColPos() {
        this.mapColPos.put("3602015019200989838", new Integer(1));
        this.mapColPos.put("3602015029218181692", new Integer(1));
        this.mapColPos.put("3602015019200131348", new Integer(1));
        this.mapColPos.put("3602000119228888830", new Integer(2));
        this.mapColPos.put("44001403304050092162", new Integer(3));
        this.mapColPos.put("44001403304050092698", new Integer(3));
        this.mapColPos.put("44001403304050092652", new Integer(3));
        this.mapColPos.put("44001403304050092233", new Integer(3));
        this.mapColPos.put("44001403304050092199", new Integer(3));
        this.mapColPos.put("44001403304050092386", new Integer(3));
        this.mapColPos.put("44001403304050092206", new Integer(3));
        this.mapColPos.put("44001403304050092180", new Integer(3));
        this.mapColPos.put("44001403304050092171", new Integer(3));
        this.mapColPos.put("", new Integer(4));
        this.mapColPos.put("", new Integer(5));
        this.mapColPos.put("11-0034653943-01", new Integer(6));
        this.mapColPos.put("505010000268", new Integer(6));
        this.mapColPos.put("103015505010015036", new Integer(6));
        this.mapColPos.put("103014505010002259", new Integer(6));
        this.mapColPos.put("103705512010002926", new Integer(6));
        this.mapColPos.put("10231516010000662", new Integer(6));
        this.mapColPos.put("106004519010001829", new Integer(6));
        this.mapColPos.put("105001511010000586", new Integer(6));
        this.mapColPos.put("", new Integer(7));
        this.mapColPos.put("", new Integer(8));
        this.mapColPos.put("87403022200101011968", new Integer(9));
        this.mapColPos.put("4582076710001", new Integer(9));
        this.mapColPos.put("11002905198401", new Integer(10));
        this.mapColPos.put("11005896354401", new Integer(10));
        this.mapColPos.put("7442810182600062501", new Integer(10));
    }

    private void initRowPos() {
        this.mapRowPos.put("E04", new Integer(3));
        this.mapRowPos.put("A01", new Integer(12));
        this.mapRowPos.put("A06", new Integer(13));
        this.mapRowPos.put("E02", new Integer(15));
        this.mapRowPos.put("E03", new Integer(16));
        this.mapRowPos.put("A08", new Integer(17));
        this.mapRowPos.put("C01", new Integer(19));
        this.mapRowPos.put("A05", new Integer(21));
        this.mapRowPos.put("A10", new Integer(21));
        this.mapRowPos.put("A11", new Integer(21));
        this.mapRowPos.put("B01", new Integer(21));
        this.mapRowPos.put("B02", new Integer(21));
        this.mapRowPos.put("B03", new Integer(21));
        this.mapRowPos.put("B04", new Integer(21));
        this.mapRowPos.put("B05", new Integer(21));
        this.mapRowPos.put("B06", new Integer(21));
        this.mapRowPos.put("B07", new Integer(21));
        this.mapRowPos.put("C02", new Integer(21));
        this.mapRowPos.put("C03", new Integer(21));
        this.mapRowPos.put("E07", new Integer(21));
        this.mapRowPos.put("C01", new Integer(22));
        this.mapRowPos.put("C01", new Integer(23));
        this.mapRowPos.put("E01", new Integer(26));
    }

    private String getQuerySql() {
        String dateSql = ReportClientUtil.getQueryDateCondition("biztime", this.dateStart, this.dateEnd);
        return "select account_number,sum(debitamount) as debitamount,sum(creditamount) as creditamount,transcode,fisdebit from v_be_transdetail where  company_number like '00.%' and " + dateSql + " and transcode is not null group by account_number,transcode,fisdebit";
    }

    private void fillBalanceToTable() throws Exception {
        Date date = new Date();
        Date lastMonth = DateTimeUtils.addMonth((Date)date, (int)-1);
        Date preMonth = DateTimeUtils.addMonth((Date)date, (int)-2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastMonth);
        int year = cal.get(1);
        int month = cal.get(2);
        int days = ReportClientUtil.getDaysByMonth(year, month);
        cal.set(5, days);
        Map mapLast = this.getBalanceByAccount(cal.getTime());
        cal.setTime(preMonth);
        year = cal.get(1);
        month = cal.get(2);
        days = ReportClientUtil.getDaysByMonth(year, month);
        cal.set(5, days);
        Map mapPre = this.getBalanceByAccount(cal.getTime());
        IRow row = this.tblMain.getRow(0);
        this.fillDataToRow(mapPre, row);
        row = this.tblMain.getRow(this.tblMain.getRowCount() - 1);
        this.fillDataToRow(mapLast, row);
    }

    private void fillDataToRow(Map map, IRow row) {
        for (String key : map.keySet()) {
            if (!this.mapColPos.containsKey(key)) continue;
            int col = (Integer)this.mapColPos.get(key);
            row.getCell(col).setValue(map.get(key));
        }
    }

    private Map getBalanceByAccount(Date date) throws BOSException, SQLException {
        HashMap<String, BigDecimal> mapBalance = new HashMap<String, BigDecimal>(32);
        String dateSql = ReportClientUtil.getDatePeriodString("bizdate", date);
        String sql = "select accountbank_bankaccountnumber,balance from v_be_accountbalance where " + dateSql + " order by accountbank_bankaccountnumber";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        String accountNumber = null;
        while (rs.next()) {
            accountNumber = rs.getString(0);
            mapBalance.put(accountNumber, rs.getBigDecimal(1));
        }
        return mapBalance;
    }

    private void fillDataToTable() throws Exception {
        String account = null;
        String itemCode = null;
        int isdebit = 0;
        int row = 0;
        int col = 0;
        double value = 0.0;
        String sql = this.getQuerySql();
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            account = rs.getString("account_number");
            itemCode = rs.getString("transcode");
            isdebit = rs.getInt("fisdebit");
            col = this.getColIndex(account);
            row = this.getRowIndex(itemCode);
            value = isdebit == 0 ? rs.getDouble("debitamount") : rs.getDouble("creditamount");
            this.tblMain.getCell(row, col).setValue((Object)new Double(value += this.getValueFromCell(row, col)));
        }
        this.fillBalanceToTable();
    }

    private double getValueFromCell(int row, int col) {
        return ReportClientUtil.getValueFromCell(this.tblMain, row, col);
    }

    private int getColIndex(String account) {
        if (!this.mapColPos.containsKey(account)) {
            return 1;
        }
        return (Integer)this.mapColPos.get(account);
    }

    private int getRowIndex(String itemCode) {
        if (!this.mapRowPos.containsKey(itemCode)) {
            return 1;
        }
        return (Integer)this.mapRowPos.get(itemCode);
    }
}

