/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.gpgc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.custom.gpgc.GpgcReportFacadeFactory;
import com.kingdee.eas.custom.gpgc.IGpgcReportFacade;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportClientUtil {
    public static Double getValueFromCell(KDTable tbl, int row, int col) {
        Object obj = tbl.getCell(row, col).getValue();
        if (obj == null) {
            return new Double(0.0);
        }
        String value = obj.toString();
        if (value == null || value.length() == 0) {
            return new Double(0.0);
        }
        double dv = Double.parseDouble(value);
        return new Double(dv);
    }

    public static String getFixedDataStr(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(date);
    }

    public static void showDateFilterUI(CoreUI ui) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"Owner", (Object)ui);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.custom.gpgc.client.DateFilterUI", (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
    }

    public static void showDatePeriodFilterUI(CoreUI ui) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"Owner", (Object)ui);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.custom.gpgc.client.DatePeriodFilterUI", (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
    }

    public static String getDatePeriodString(String field, Date date) {
        Date datePre = DateTimeUtils.addDay((Date)date, (long)-1L);
        Date dateNext = DateTimeUtils.addDay((Date)date, (long)1L);
        String strDatePre = ReportClientUtil.getFixedDataStr(datePre);
        String strDateNext = ReportClientUtil.getFixedDataStr(dateNext);
        return field + " > {ts'" + strDatePre + "'} and " + field + " < {ts'" + strDateNext + "'} ";
    }

    public static String getQueryDateCondition(Date start, Date end) {
        return ReportClientUtil.getQueryDateCondition("biztime", start, end);
    }

    public static String getQueryDateCondition(String field, Date start, Date end) {
        String strDatePre = ReportClientUtil.getFixedDataStr(start);
        String strDateNext = ReportClientUtil.getFixedDataStr(end);
        return field + " >= {ts'" + strDatePre + "'} and " + field + " < {ts'" + strDateNext + "'} ";
    }

    public static String getConditionByMonth() {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        cal.set(5, 1);
        Date start = cal.getTime();
        cal.set(2, month);
        Date end = cal.getTime();
        return ReportClientUtil.getQueryDateCondition(start, end);
    }

    public static HashMap getAccountNumber() {
        HashMap<String, String> mapAccountNumber = new HashMap<String, String>(1024);
        String sql = "select fnumber from t_bd_accountbanks";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                mapAccountNumber.put(rs.getString(1), "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mapAccountNumber;
    }

    public static int getDaysByMonth(int year, int month) {
        if (month == 2) {
            if (DateTimeUtils.isLeap((int)year)) {
                return 28;
            }
            return 29;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        return 31;
    }

    public static void repareData() throws BOSException, EASBizException {
        IGpgcReportFacade facade = GpgcReportFacadeFactory.getRemoteInstance();
        facade.updDesc();
    }

    public static String getAccountByBankNumber(String bankNumber) {
        return " select a.fbankaccountnumber from t_bd_accountbanks a,t_bd_bank b where a.fbank = b.fid and b.fnumber = '" + bankNumber + "'";
    }

    public static List getAccount(String bankNumber) throws Exception {
        ArrayList<String> lst = new ArrayList<String>(16);
        String sql = ReportClientUtil.getAccountByBankNumber(bankNumber);
        System.out.println(sql);
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        while (rs.next()) {
            lst.add(rs.getString(1));
        }
        return lst;
    }

    public static void sumTable(KDTable tblMain, int sumColIndex) {
        int rows = tblMain.getRowCount();
        int cols = tblMain.getColumnCount();
        double value = 0.0;
        for (int i = 0; i < rows; ++i) {
            value = 0.0;
            for (int j = 2; j < cols; ++j) {
                value += ReportClientUtil.getValueFromCell(tblMain, i, j).doubleValue();
            }
            tblMain.getCell(i, sumColIndex).setValue((Object)new Double(value));
        }
    }
}

