/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.IBgCtrlHandler;
import com.kingdee.eas.ma.crbg.BgFundApplyEntryInfo;
import com.kingdee.eas.ma.crbg.BgFundApplyFactory;
import com.kingdee.eas.ma.crbg.BgFundApplyInfo;
import com.kingdee.eas.ma.crbg.BillstateEnum;
import com.kingdee.eas.ma.crbg.IBgFundApply;

public class BgCtrlFundApplyHandler
implements IBgCtrlHandler {
    public BgCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        BgCtrlParamCollection result = new BgCtrlParamCollection();
        boolean noPass = false;
        IBgFundApply bgFundApply = null;
        bgFundApply = ctx == null ? BgFundApplyFactory.getRemoteInstance() : BgFundApplyFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Expense_time"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("entrys.pjNum"));
        sic.add(new SelectorItemInfo("entrys.pjName.*"));
        sic.add(new SelectorItemInfo("entrys.curPayAmt"));
        System.out.print(noPass);
        sic.add(new SelectorItemInfo("entrys.contNum.*"));
        sic.add(new SelectorItemInfo("billstate"));
        BgFundApplyInfo info = bgFundApply.getBgFundApplyInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        if (info.getBillstate() == BillstateEnum.NOPASS) {
            noPass = true;
        }
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            BgFundApplyEntryInfo entryInfo = info.getEntrys().get(i);
            BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
            ctrlInfo.setOrgUnitId(info.getOrgUnit().getId().toString());
            ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
            ctrlInfo.setSrcBillId(billId);
            ctrlInfo.setSrcBillNumber(info.getNumber());
            if (entryInfo.getContNum() != null) {
                ctrlInfo.setItemCombinNumber(entryInfo.getPjNum() + "," + entryInfo.getContNum().getNumber());
                ctrlInfo.setItemCombinName(entryInfo.getPjName().getName().toString() + "_" + entryInfo.getContNum().getContractNum());
            } else {
                ctrlInfo.setItemCombinNumber(entryInfo.getPjNum());
                ctrlInfo.setItemCombinName(entryInfo.getPjName().getName().toString());
            }
            ctrlInfo.setBizDate(info.getExpense_time());
            if (noPass) {
                ctrlInfo.setAmount(entryInfo.getCurPayAmt().negate());
            } else {
                ctrlInfo.setAmount(entryInfo.getCurPayAmt());
            }
            result.add(ctrlInfo);
        }
        return result;
    }
}

