/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.exp.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.exp.client.AbstractBgExpRollRuleEditUI;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleFactory;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgRollTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgRollRuleEditUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgExpRollRuleEditUI
extends AbstractBgExpRollRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgExpRollRuleEditUI.class);

    protected IObjectValue createNewData() {
        BgRollRuleInfo rollRuleInfo = new BgRollRuleInfo();
        rollRuleInfo.setId(BOSUuid.create((BOSObjectType)rollRuleInfo.getBOSType()));
        rollRuleInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        rollRuleInfo.setOrgUnit(SysContext.getSysContext().getCurrentCostUnit().castToFullOrgUnitInfo());
        rollRuleInfo.setRollType(BgRollTypeEnum.limitLengthRoll);
        rollRuleInfo.setRollPart(BgRollPartEnum.monthRoll);
        ResourceBundleHelper resHelperTemp = new ResourceBundleHelper(AbstractBgRollRuleEditUI.class.getName());
        rollRuleInfo.setHisVersion(resHelperTemp.getString("txtHisVersion.text"));
        rollRuleInfo.setLength(1);
        return rollRuleInfo;
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeTemplateType();
        this.storeScenario();
        if (this.rdoLimitLength.isSelected()) {
            this.editData.setRollType(BgRollTypeEnum.limitLengthRoll);
        } else {
            this.editData.setRollType(BgRollTypeEnum.continuousRoll);
        }
        this.editData.setHisPeriodLength(((Integer)this.spnHisPeriod.getValue()).intValue());
        this.editData.setLength(((Integer)this.spnLength.getValue()).intValue());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("description"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("hisVersion"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("rollPart"));
        selectors.add("id");
        selectors.add("rollType");
        selectors.add("templateType");
        selectors.add("tptTypeNumber");
        selectors.add("hisPeriodLength");
        selectors.add("length");
        selectors.add("bgRollSettings.*");
        selectors.add("bgRollSettings.bgScenario.*");
        selectors.add("bgRollSettings.actScenario.*");
        selectors.add("orgUnit.id");
        return selectors;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadTemplateType();
        this.loadScenario();
        BgRollTypeEnum rollType = this.editData.getRollType();
        if (BgRollTypeEnum.limitLengthRoll.equals((Object)rollType)) {
            this.rdoLimitLength.setSelected(true);
        } else {
            this.rdoContinuous.setSelected(true);
            this.spnHisPeriod.setEnabled(true);
        }
        this.spnHisPeriod.setValue((Object)this.editData.getHisPeriodLength());
        this.spnLength.setValue((Object)this.editData.getLength());
        if (this.tblMain.getRowCount() <= 0) {
            this.tblMain.addRow();
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            try {
                if (BgRollRuleFactory.getRemoteInstance().checkExistsBgForm(this.editData.getId().toString())) {
                    this.rdoLimitLength.setEnabled(false);
                    this.rdoContinuous.setEnabled(false);
                    this.comboRollPart.setEnabled(false);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                SysUtil.abort();
            }
        }
        this.fillTxt();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }
}

