/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.calctrace;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import java.io.Serializable;
import java.util.Vector;

public class CalcTrace
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Member[] members = null;
    protected CalcTrace parent;
    protected Vector<CalcTrace> children;

    public Member[] getMembers() {
        return this.members;
    }

    public void setMembers(Member[] members) {
        this.members = members;
    }

    public void setParent(CalcTrace newParent) {
        this.parent = newParent;
    }

    public CalcTrace getParent() {
        return this.parent;
    }

    public void add(CalcTrace newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public void insert(CalcTrace newChild, int childIndex) {
        CalcTrace oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(CalcTrace aChild) {
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void remove(int childIndex) {
        CalcTrace child = this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public CalcTrace getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return this.children.elementAt(index);
    }

    public int getIndex(CalcTrace aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    public boolean isNodeChild(CalcTrace aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public static CalcTrace getInstance() {
        return new CalcTrace();
    }

    public CalcTrace getCalcTrace(CalcTrace calcTrace, Member[] members) {
        if (this.equalMembers(calcTrace.getMembers(), members)) {
            return calcTrace;
        }
        if (calcTrace.getMembers() == null) {
            calcTrace.setMembers(members);
            return calcTrace;
        }
        if (calcTrace.getChildCount() > 0) {
            int i = 0;
            int count = calcTrace.getChildCount();
            if (i < count) {
                CalcTrace info = this.getChildAt(i);
                if (this.equalMembers(info.getMembers(), members)) {
                    return this.getCalcTrace(info, members);
                }
                return info;
            }
        } else {
            CalcTrace info = new CalcTrace();
            info.setMembers(members);
            calcTrace.add(info);
            return info;
        }
        return calcTrace;
    }

    private boolean equalMembers(Member[] members1, Member[] members2) {
        if (members1 == null && members2 == null) {
            return true;
        }
        if (members1 == null && members2 != null || members1 != null && members2 == null) {
            return false;
        }
        StringBuffer str1 = new StringBuffer();
        StringBuffer str2 = new StringBuffer();
        for (Member member : members1) {
            str1.append(member.getUniqueName());
        }
        for (Member member : members2) {
            str2.append(member.getUniqueName());
        }
        return str1.equals(str2);
    }
}

