/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgAdjustBillFacadeFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.IBgAdjustBillFacade;
import com.kingdee.eas.ma.mbg.MbgAdjustBillConstant;
import com.kingdee.eas.ma.mbg.client.AbstractAdjustBillImportUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.RefDimInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBGAdjustBillHelper;
import com.kingdee.eas.ma.mbg.utils.RefFieldComparator;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class AdjustBillImportUI
extends AbstractAdjustBillImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(AdjustBillImportUI.class);
    public static final String IMPORT_RES = "com.kingdee.eas.tools.datatask.DatataskResource";
    public static final String res = "com.kingdee.eas.ma.mbg.DimensionCommonResource";
    private Map<Integer, Map<String, String>> passedData = new TreeMap<Integer, Map<String, String>>();
    private Map<Integer, Map<String, String>> errorData = new TreeMap<Integer, Map<String, String>>();
    private boolean isOperateImport = false;
    public static final String REASON = EASResource.getString((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"adjustReasion");

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOpenFile.setIcon((Icon)((ImageIcon)ResourceBase.getIcon((String)"com.kingdee.eas.tools.datatask.ui.ImageResource.tbtn_open", (Locale)new Locale("L1"))));
        this.panelProgress.setVisible(false);
        this.setBtnState(true);
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            this.kDLabelContainer2.setVisible(false);
            this.btnConfirm.setText(BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"export"));
            this.kDLabel1.setText(BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"exporting"));
            this.kDPanel1.setVisible(false);
            this.kDAdjustValue.setVisible(false);
            this.kDAdjustAfter.setVisible(false);
        } else {
            this.comboError.removeAllItems();
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
            this.comboError.setSelectedItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
            this.btnExportTemplate.setEnabled(false);
            this.btnExportTemplate.setVisible(false);
            this.kDLabelContainer2.setVisible(false);
            this.kDPanel1.setVisible(true);
            this.kDAdjustValue.setVisible(true);
            this.kDAdjustAfter.setVisible(true);
        }
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
        this.chkUpdate.setEnabled(state);
        this.btnExportTemplate.setEnabled(state);
        this.btnExportTemplate.setVisible(state);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFile.getText())) {
            return;
        }
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            ProgressThread process = new ProgressThread(false);
            process.start();
        } else {
            ProgressThread process = new ProgressThread(true);
            process.start();
            this.setOperateImport(true);
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        fileChooser = (Boolean)this.getUIContext().get("isImport") == false ? bgFileUtil.getFileChooserForExp((Object)this.getUIContext()) : bgFileUtil.getFileChooserForImp((Object)this.getUIContext());
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)res, (String)"dimensionMemberExport"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        if (filePath != null && !StringUtils.isEmpty((String)filePath)) {
            this.txtFile.setText(filePath.toString());
            this.txtFile.setUserObject((Object)fileChooser.getSelectedFile());
        }
    }

    @Override
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess;
        KDTable tbl;
        String filePath = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForExp((Object)this.getUIContext(), "TEMP");
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_TITLE_TEMPLATE"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ADJUST_TEMPLATE")));
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        if ((tbl = (KDTable)this.getUIContext().get("template")) != null) {
            tbl.removeRows();
        }
        if (!StringUtils.isEmpty((String)filePath) && (isSuccess = this.appendToExcel(filePath, tbl))) {
            bgFileUtil.storeDefaultPathForEXP((Object)filePath, (Object)this.getUIContext(), "TEMP");
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)res, (String)"templetExportSuccess"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean appendToExcel(String filePath, KDTable tbl) throws Exception {
        if (MBGAdjustBillHelper.checkParamsIsNull(filePath, tbl)) {
            return false;
        }
        File file = new File(filePath);
        KDTIOManager ioManager = tbl.getIOManager();
        KDSBook book = null;
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(5);
        try {
            this.progressBar.setValue(1);
            if (file.exists()) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"fileHasExisted"));
                if (result != 0) return false;
                if (!file.delete()) {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"openedfile"));
                    this.disableButtons();
                    return false;
                }
                file = new File(filePath);
                book = new KDSBook(file.getName());
            } else {
                book = new KDSBook(file.getName());
            }
            this.progressBar.setValue(2);
            book.addSheet(null, ioManager.saveToKDSSheet(book, true, false, BgCommCHelper.getMessageStr((String)res, (String)"dimensionMember")));
            this.progressBar.setValue(3);
            ExportManager man = new ExportManager();
            this.progressBar.setValue(4);
            try {
                man.exportToExcel(book, filePath);
            }
            catch (POIExportException ex) {
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"183_BgControlRuleEditUI"));
            }
            this.progressBar.setValue(5);
            return true;
        }
        catch (Exception err) {
            logger.error((Object)"mbg error:", (Throwable)err);
            this.handUIException(err);
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
    }

    protected void enableButtons() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.btnExportTemplate.setEnabled(true);
        this.panelProgress.setVisible(false);
    }

    protected void disableButtons() {
        this.btnConfirm.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpenFile.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.btnExportTemplate.setEnabled(false);
        this.panelProgress.setVisible(true);
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    private void _importDataNew(KDSSheet sheet) throws Exception {
        boolean isAdjustRangOrgUnit;
        if (sheet == null) {
            return;
        }
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        BgProcessEnum bgProcessType = this.getUIContext().get("processType") != null ? (BgProcessEnum)((Object)this.getUIContext().get("processType")) : BgProcessEnum.C01;
        BgSchemeDimensionHelper schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("schemeHelper");
        boolean isAdjustEntryScenAndEle = (Boolean)this.getUIContext().get("isAdjustEntryScenAndEle");
        BgElementInfo elemengInfo = (BgElementInfo)this.getUIContext().get("elemengInfo");
        BgScenarioInfo scenarioInfo = (BgScenarioInfo)this.getUIContext().get("scenarioInfo");
        BgAdjustBillTypeEnum adjustType = (BgAdjustBillTypeEnum)((Object)this.getUIContext().get(BgBaseConstants.ADJUST_WAY));
        boolean bl = isAdjustRangOrgUnit = BgAdjustBillTypeEnum.betweenOrg.equals((Object)adjustType) || BgAdjustBillTypeEnum.BETWEENORGADJUST.equals((Object)adjustType);
        if (MBGAdjustBillHelper.checkParamsIsNull(new Object[]{schemeHelper, adjustType, isAdjustRangOrgUnit})) {
            return;
        }
        HashSet<String> tempDims = new HashSet<String>();
        HashSet<String> dimSrcNumber = new HashSet<String>();
        MBGAdjustBillHelper.extractCombinDimension(schemeHelper, tempDims, dimSrcNumber);
        Map<Integer, String> sortList = MBGAdjustBillHelper.sortRefField(tempDims);
        Map<Integer, Map<String, String>> excelData = this.validateExcelDataFormat(sheet, sortList);
        if (excelData == null) {
            return;
        }
        String schemeID = (String)this.getUIContext().get("MBG_ADJUST_PARAMETER_KEY_SCHEME_ID");
        Set orgNumSet = BgOrgUnitFactory.getRemoteInstance().getDetailOrgNum(schemeID, !DimensionCommonHelper.isDecompose(bgProcessType));
        if (orgNumSet == null || orgNumSet.isEmpty()) {
            return;
        }
        String accViewId = schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId();
        if (accViewId == null) {
            return;
        }
        HashSet<String> accountNumberSet = new HashSet<String>();
        HashSet<String> accountLeafNumberSet = new HashSet<String>();
        BgAccountCollection accColls = BgAccountFactory.getRemoteInstance().getBgAccountCollection("select number, isLeaf where bgAccountView = '" + accViewId + "'");
        if (accColls != null && !accColls.isEmpty()) {
            int size = accColls.size();
            for (int index = 0; index < size; ++index) {
                BgAccountInfo bgAccountInfo = accColls.get(index);
                accountNumberSet.add(bgAccountInfo.getNumber());
                if (!bgAccountInfo.isIsLeaf()) continue;
                accountLeafNumberSet.add(bgAccountInfo.getNumber());
            }
        }
        HashMap memberMap = new HashMap();
        HashMap<String, String> showMsgMap = new HashMap<String, String>();
        HashMap<String, BgDimensionInfo> showDimsMap = new HashMap<String, BgDimensionInfo>();
        Map<String, BgDimensionInfo> allDim = schemeHelper.getDimensionBySrcNumber();
        List<String> otherDimLst = schemeHelper.getAccAndOtherDim(true);
        HashSet<String> viewIdSet = new HashSet<String>();
        HashMap<String, String> keyViewIdMap = new HashMap<String, String>();
        if (!otherDimLst.isEmpty()) {
            BgDimensionInfo dimInfo = null;
            String keyValue2 = null;
            HashMap<String, String> tempMap = new HashMap<String, String>();
            for (String keyValue2 : allDim.keySet()) {
                dimInfo = allDim.get(keyValue2);
                if (!otherDimLst.contains(dimInfo.getNumber())) continue;
                tempMap.put(dimInfo.getViewId(), dimInfo.getAttribute() + "_" + keyValue2);
                viewIdSet.add(dimInfo.getViewId());
                keyViewIdMap.put(dimInfo.getAttribute() + "_" + keyValue2, dimInfo.getViewId());
                showMsgMap.put(dimInfo.getAttribute() + "_" + keyValue2, dimInfo.getName());
                showDimsMap.put(dimInfo.getAttribute() + "_" + keyValue2, dimInfo);
            }
            String oql = "where viewID in (";
            for (String viewID : viewIdSet) {
                oql = oql + "'" + viewID + "',";
            }
            if (oql.endsWith(",")) {
                oql = oql.substring(0, oql.length() - 1) + ")";
            }
            MbgMemberCollection mbgMembers = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(oql);
            String memberViewId = null;
            if (mbgMembers != null && !mbgMembers.isEmpty()) {
                MbgMemberInfo memberInfo = null;
                for (int index = 0; index < mbgMembers.size(); ++index) {
                    memberInfo = mbgMembers.get(index);
                    memberViewId = memberInfo.getViewId().toString();
                    if (!memberMap.containsKey(tempMap.get(memberViewId))) {
                        memberMap.put(tempMap.get(memberViewId), new HashMap());
                    }
                    ((Map)memberMap.get(tempMap.get(memberViewId))).put(memberInfo.getNumber(), memberInfo);
                }
            }
        }
        HashMap<String, Set> segregationRuleOrg = new HashMap<String, Set>();
        HashMap<String, MbgMemberCollection> segregationMemberOrg = new HashMap<String, MbgMemberCollection>();
        HashSet<String> segregationViewId = new HashSet<String>();
        HashSet<String> segregationOrgViewId = new HashSet<String>();
        if (!viewIdSet.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("segregationRule");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", viewIdSet, CompareType.INCLUDE));
            MbgViewCollection viewCol = MbgViewFactory.getRemoteInstance().getMbgViewCollection(evi);
            for (int i = 0; i < viewCol.size(); ++i) {
                if (viewCol.get(i).getSegregationRule().getValue() == 0) {
                    segregationViewId.add(viewCol.get(i).getId().toString());
                    continue;
                }
                if (viewCol.get(i).getSegregationRule().getValue() != 2) continue;
                segregationOrgViewId.add(viewCol.get(i).getId().toString());
            }
        }
        String reason = null;
        HashMap<String, String> orgNumberId = new HashMap<String, String>();
        Iterator<Integer> it = excelData.keySet().iterator();
        while (it.hasNext()) {
            Object org;
            Integer key = Integer.parseInt(((Object)it.next()).toString());
            HashMap value = (HashMap)excelData.get(key);
            if (key.toString().equals(String.valueOf(MbgAdjustBillConstant.MBG_HEADKEY_LINE)) || (org = value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER")) == null || StringUtils.isEmpty((String)org.toString())) continue;
            orgNumberId.put(org.toString(), null);
        }
        if (!orgNumberId.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add("orgUnitId");
            view.getSelector().add("number");
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)schemeHelper.getBgOrgViewId()));
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(orgNumberId.keySet()), CompareType.INCLUDE));
            BgOrgUnitCollection orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
            orgNumberId.clear();
            for (int i = 0; i < orgCol.size(); ++i) {
                orgNumberId.put(orgCol.get(i).getNumber(), orgCol.get(i).getOrgUnitID());
            }
        }
        HashSet<String> bgEleMap = new HashSet<String>();
        HashSet<String> bgScenMap = new HashSet<String>();
        if (isAdjustEntryScenAndEle) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", schemeHelper.getMemberSet(DimensionConstants.DEF_ELEMENT_NUMBER, false), CompareType.INCLUDE));
            view.setFilter(filter);
            BgElementCollection coll = BgElementFactory.getRemoteInstance().getBgElementCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                bgEleMap.add(coll.get(i).getNumber());
            }
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", schemeHelper.getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, false), CompareType.INCLUDE));
            view.setFilter(filter);
            BgScenarioCollection colls = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                bgScenMap.add(colls.get(i).getNumber());
            }
        }
        Iterator<Integer> it2 = excelData.keySet().iterator();
        while (it2.hasNext()) {
            Integer key = Integer.parseInt(((Object)it2.next()).toString());
            HashMap value = (HashMap)excelData.get(key);
            if (key.toString().equals(String.valueOf(MbgAdjustBillConstant.MBG_HEADKEY_LINE))) {
                this.passedData.put(key, value);
                continue;
            }
            String errorInfo = null;
            Object org = value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER");
            if (isAdjustRangOrgUnit) {
                if (org == null || "".equals(org.toString().trim())) {
                    errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_ORGUNIT_NUMBER_IS_NULL", (Object[])new Object[]{key + 1});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
                if (!orgNumSet.contains(org.toString()) || !orgNumberId.containsKey(org.toString())) {
                    errorInfo = DimensionCommonHelper.isDecompose(bgProcessType) ? BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"orgNumNotFound1", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER")}) : BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"orgNumNotFound", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER")});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
            } else {
                Object object = this.getUIContext().get("MBG_HEADKEY_COSTCENTER_ORG_NAME");
                if (org == null || "".equals(org.toString().trim())) {
                    if (object != null && object instanceof OrgUnitInfo) {
                        OrgUnitInfo orgunit = (OrgUnitInfo)object;
                        org = orgunit.getNumber();
                        value.put("MBG_HEADKEY_COSTCENTER_ORG_NUMBER", orgunit.getNumber());
                        value.put("MBG_HEADKEY_COSTCENTER_ORG_NAME", orgunit.getName());
                    }
                } else if (!orgNumSet.contains(org.toString()) || !orgNumberId.containsKey(org.toString())) {
                    errorInfo = DimensionCommonHelper.isDecompose(bgProcessType) ? BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"orgNumNotFound1", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER")}) : BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"orgNumNotFound", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER")});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
            }
            if (!MBGAdjustBillHelper.checkBgAdjustRuleInOrg((CoreUI)this, org.toString().trim(), schemeHelper, adjustType, false)) {
                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"importNotInRule", (Object[])new Object[]{key + 1, DimensionConstants.DEF_ORGUNIT_NAME, org.toString().trim()});
                this.addErrorDataInfo(key, value, errorInfo);
                continue;
            }
            String accNumber = (String)value.get("MBG_HEADKEY_INDEX_MEMBER_NUMBER");
            boolean accCheck = true;
            if (StringUtils.isEmpty((String)accNumber)) {
                accCheck = false;
            } else if (!accountNumberSet.contains(accNumber)) {
                accCheck = false;
            }
            if (!accCheck) {
                String msgAccount = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"accountMember");
                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"account_notExist", (Object[])new Object[]{key + 1, msgAccount, accNumber});
                this.addErrorDataInfo(key, value, errorInfo);
                continue;
            }
            if (!accountLeafNumberSet.contains(accNumber)) {
                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_INDEX_MEMBER_NOT_EXIST", (Object[])new Object[]{key + 1, accNumber});
                this.addErrorDataInfo(key, value, errorInfo);
                continue;
            }
            Set<String> adjustRuleAccountNumbers = MBGAdjustBillHelper.queryAccNumsByAdjRuleOrgNum((CoreUI)this, schemeHelper, adjustType, org.toString().trim());
            if (adjustRuleAccountNumbers != null && !adjustRuleAccountNumbers.isEmpty() && !adjustRuleAccountNumbers.contains(accNumber)) {
                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"importNotInRule", (Object[])new Object[]{key + 1, DimensionConstants.DEF_ACCOUNT_MAME, accNumber});
                this.addErrorDataInfo(key, value, errorInfo);
                continue;
            }
            HashSet<String> currentAccountNumbers = new HashSet<String>();
            currentAccountNumbers.add(accNumber);
            Map<String, Map<String, Set<String>>> adjustDimMap = MBGAdjustBillHelper.queryOtherDimNumsByAdjRule((CoreUI)this, schemeHelper, adjustType, org.toString().trim(), currentAccountNumbers);
            List refFieldSrcNumber = (List)this.getUIContext().get("MBG_COMBINE_HEAD_KEY");
            String str = null;
            Map memNumMap = null;
            MbgMemberInfo member = null;
            boolean fla = true;
            for (int index = 0; index < refFieldSrcNumber.size(); ++index) {
                block64: {
                    block62: {
                        String orgId;
                        block63: {
                            str = (String)refFieldSrcNumber.get(index);
                            if (memberMap.isEmpty()) continue;
                            memNumMap = (Map)memberMap.get(str);
                            member = (MbgMemberInfo)memNumMap.get(value.get(str));
                            if (member == null) break block62;
                            if (!member.isIsLeaf()) {
                                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_COMBINDIM_NUMBER_NOT_EXIST", (Object[])new Object[]{key + 1, value.get(str)});
                                this.addErrorDataInfo(key, value, errorInfo);
                                fla = false;
                                break;
                            }
                            if (!segregationViewId.contains(keyViewIdMap.get(str))) break block63;
                            orgId = (String)orgNumberId.get(org.toString());
                            Set segrOrgIds = (Set)segregationRuleOrg.get(orgId);
                            if (segrOrgIds == null) {
                                segrOrgIds = BgOrgUnitFactory.getRemoteInstance().getMbgDimOrgIds(member.getViewId().toString(), schemeHelper.getBgSchemeId(), orgId, schemeHelper.getBgOrgViewId(), null);
                                segregationRuleOrg.put(orgId, segrOrgIds);
                            }
                            if (!segrOrgIds.contains(member.getOrgunit().getId().toString())) {
                                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"account_notExist", (Object[])new Object[]{key + 1, showMsgMap.get(str), value.get(str)});
                                this.addErrorDataInfo(key, value, errorInfo);
                                fla = false;
                                break;
                            }
                            break block64;
                        }
                        if (!segregationOrgViewId.contains(keyViewIdMap.get(str))) break block64;
                        orgId = (String)orgNumberId.get(org.toString());
                        MbgMemberCollection segrOrgNumbers = (MbgMemberCollection)segregationMemberOrg.get(orgId);
                        if (segrOrgNumbers == null || segrOrgNumbers.isEmpty()) {
                            DimensionFilterHelper help = DimensionFilterHelper.getRemoteIntance(orgId, schemeHelper.getBgSchemeId(), schemeHelper.getBgOrgViewId(), null, member.getViewId().toString());
                            segrOrgNumbers = help.getSegregationOrg();
                            segregationMemberOrg.put(orgId, segrOrgNumbers);
                        }
                        boolean isExist = false;
                        for (int i = 0; i < segrOrgNumbers.size(); ++i) {
                            if (!segrOrgNumbers.get(i).getNumber().equals(member.getNumber())) continue;
                            isExist = true;
                        }
                        if (!isExist) {
                            errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"account_notExist", (Object[])new Object[]{key + 1, showMsgMap.get(str), value.get(str)});
                            this.addErrorDataInfo(key, value, errorInfo);
                            fla = false;
                            break;
                        }
                        break block64;
                    }
                    if (member == null && fla) {
                        errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"account_notExist", (Object[])new Object[]{key + 1, showMsgMap.get(str), value.get(str)});
                        this.addErrorDataInfo(key, value, errorInfo);
                        fla = false;
                        break;
                    }
                }
                if (adjustDimMap == null || adjustDimMap.isEmpty() || !adjustDimMap.containsKey(accNumber) || member == null || showDimsMap.get(str) == null || !adjustDimMap.get(accNumber).containsKey(((BgDimensionInfo)showDimsMap.get(str)).getNumber()) || adjustDimMap.get(accNumber).get(((BgDimensionInfo)showDimsMap.get(str)).getNumber()).contains(value.get(str))) continue;
                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"importNotInRule", (Object[])new Object[]{key + 1, showMsgMap.get(str), value.get(str)});
                this.addErrorDataInfo(key, value, errorInfo);
                fla = false;
                break;
            }
            if (isAdjustEntryScenAndEle) {
                String scenNumber = (String)value.get("MBG_HEADKEY_BGSCENARIO_NUMBER");
                boolean scenCheck = true;
                if (StringUtils.isEmpty((String)scenNumber)) {
                    if (scenarioInfo == null) {
                        scenCheck = false;
                    } else {
                        value.put("MBG_HEADKEY_BGSCENARIO_NUMBER", scenarioInfo.getNumber());
                    }
                } else if (!bgScenMap.contains(scenNumber)) {
                    scenCheck = false;
                }
                if (!scenCheck) {
                    String msgScen = EASResource.getString((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"scen_number");
                    errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"account_notExist", (Object[])new Object[]{key + 1, msgScen, scenNumber});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
                String eleNumber = (String)value.get("MBG_HEADKEY_BGELEMENT_NUMBER");
                boolean eleCheck = true;
                if (StringUtils.isEmpty((String)eleNumber)) {
                    if (elemengInfo == null) {
                        eleCheck = false;
                    } else {
                        value.put("MBG_HEADKEY_BGELEMENT_NUMBER", elemengInfo.getNumber());
                    }
                } else if (!bgEleMap.contains(eleNumber)) {
                    eleCheck = false;
                }
                if (!eleCheck) {
                    String msgEle = EASResource.getString((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"ele_number");
                    errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"account_notExist", (Object[])new Object[]{key + 1, msgEle, eleNumber});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
            }
            if (!fla) continue;
            for (String flag : value.keySet()) {
                if (!flag.trim().endsWith(REASON) || (reason = (String)value.get(flag)) == null || reason.length() <= 2000) continue;
                BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"reasonMoreMax", (Object[])new Object[]{key + 1, flag});
            }
            this.passedData.put(key, value);
        }
    }

    private void _importData(KDSSheet sheet) {
        if (sheet == null) {
            return;
        }
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        BgProcessEnum bgProcessType = this.getUIContext().get("processType") != null ? (BgProcessEnum)((Object)this.getUIContext().get("processType")) : BgProcessEnum.C01;
        Map map = (Map)this.getUIContext().get("refDimens");
        BgAdjustBillTypeEnum obj = (BgAdjustBillTypeEnum)((Object)this.getUIContext().get(BgBaseConstants.ADJUST_WAY));
        boolean isAdjustRangOrgUnit = BgAdjustBillTypeEnum.betweenOrg.equals((Object)obj);
        if (MBGAdjustBillHelper.checkParamsIsNull(new Object[]{map, obj, isAdjustRangOrgUnit})) {
            return;
        }
        HashSet<String> tempDims = new HashSet<String>();
        HashSet<String> dimSrcNumber = new HashSet<String>();
        Map<String, List<String>> indexGroupMap = MBGAdjustBillHelper.extractCombinDimension(map, tempDims, dimSrcNumber);
        Map<Integer, String> sortList = MBGAdjustBillHelper.sortRefField(tempDims);
        Map<Integer, Map<String, String>> excelData = this.validateExcelDataFormat(sheet, sortList);
        if (excelData == null) {
            return;
        }
        String schemeID = (String)this.getUIContext().get("MBG_ADJUST_PARAMETER_KEY_SCHEME_ID");
        Set orgNumSet = null;
        try {
            orgNumSet = BgOrgUnitFactory.getRemoteInstance().getDetailOrgNum(schemeID, bgProcessType.equals((Object)BgProcessEnum.C01));
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        if (orgNumSet == null || orgNumSet.isEmpty()) {
            return;
        }
        Iterator<Integer> it = excelData.keySet().iterator();
        while (it.hasNext()) {
            String refField;
            Object object;
            String errorInfo;
            Integer key = Integer.parseInt(((Object)it.next()).toString());
            HashMap value = (HashMap)excelData.get(key);
            if (key.toString().equals("0")) {
                this.passedData.put(key, value);
                continue;
            }
            Object org = value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER");
            if (isAdjustRangOrgUnit) {
                if (org == null || "".equals(org.toString().trim())) {
                    errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_ORGUNIT_NUMBER_IS_NULL", (Object[])new Object[]{key + 1});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
                if (!orgNumSet.contains(org.toString())) {
                    errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"notDetailBgOrg", (Object[])new Object[]{key + 1});
                    this.addErrorDataInfo(key, value, errorInfo);
                    continue;
                }
            } else {
                object = this.getUIContext().get("MBG_HEADKEY_COSTCENTER_ORG_NAME");
                if ((org == null || "".equals(org.toString().trim())) && object != null && object instanceof OrgUnitInfo) {
                    OrgUnitInfo orgunit = (OrgUnitInfo)object;
                    value.put("MBG_HEADKEY_COSTCENTER_ORG_NUMBER", orgunit.getNumber());
                    value.put("MBG_HEADKEY_COSTCENTER_ORG_NAME", orgunit.getName());
                }
            }
            if (!orgNumSet.contains(value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER"))) {
                errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"orgNumNotFound", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_COSTCENTER_ORG_NAME")});
                this.addErrorDataInfo(key, value, errorInfo);
                continue;
            }
            object = value.get("MBG_HEADKEY_INDEX_GROUP_NUMBER");
            Object memberNumber = value.get("MBG_HEADKEY_INDEX_MEMBER_NUMBER");
            String info = (String)value.get("MBG_HEADKEY_INDEX_GROUP_NAME");
            if (object == null || "".equals(object.toString().trim())) {
                String str = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_HEADKEY_INDEX_GROUP_NUMBER");
                String errorInfo2 = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_NUMBER_IS_NULL", (Object[])new Object[]{key + 1, info + str});
                this.addErrorDataInfo(key, value, errorInfo2);
                continue;
            }
            if (!indexGroupMap.containsKey(object.toString())) {
                String errorInfo3 = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_INDEX_GROUP_NUMBER_IS_EXIST_IN_SCHEME", (Object[])new Object[]{key + 1, info});
                this.addErrorDataInfo(key, value, errorInfo3);
                continue;
            }
            boolean flag = true;
            List<String> reTurn = this.validateCombinDimension(map, object.toString().trim(), memberNumber.toString());
            if (reTurn == null) {
                this.passedData.put(key, value);
                continue;
            }
            for (int i = 0; i < reTurn.size() && ("F2".equals(refField = reTurn.get(i)) || (flag = this.checkCombinetemNumber(excelData, key, value, refField))); ++i) {
            }
            if (!flag) {
                this.passedData.put(key, value);
                continue;
            }
            this.passedData.put(key, value);
        }
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        try {
            IBgAdjustBillFacade remoteInstance = BgAdjustBillFacadeFactory.getRemoteInstance();
            paramMap.put("MBG_INDEX_SRCNUMBER", dimSrcNumber);
            paramMap.put("MBG_ADJUST_PARAMETER_KEY_WAY", Boolean.valueOf(isAdjustRangOrgUnit));
            paramMap.put("MBG_ADJUST_PARAMETER_KEY_SCHEME_ID", (Serializable)this.getUIContext().get("MBG_ADJUST_PARAMETER_KEY_SCHEME_ID"));
            paramMap.put("MBG_ADJUST_PARAMETER_KEY_ORGUNIT_ID", (Serializable)this.getUIContext().get("MBG_ADJUST_PARAMETER_KEY_ORGUNIT_ID"));
            Map result = remoteInstance.importBgAdjustBillService(this.passedData, paramMap, this.errorData);
            this.passedData = (Map)result.get("passedData");
            this.errorData = (Map)result.get("errorData");
            if (excelData.size() != this.passedData.size() + this.errorData.size()) {
                logger.error((Object)"data lost...");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"call remote importBgAdjustBillService error", (Throwable)e);
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"call remote importBgAdjustBillService error", (Throwable)e);
            this.handUIException(e);
        }
    }

    private boolean checkCombinetemNumber(Map<Integer, Map<String, String>> excelData, Integer key, HashMap<String, String> value, String refField) {
        int dimsrccount = 0;
        ArrayList<String> errorNumberKey = new ArrayList<String>();
        String numberkey = null;
        for (Map.Entry<String, String> entry : value.entrySet()) {
            numberkey = entry.getKey();
            if (!numberkey.startsWith(refField + "_") || numberkey.endsWith("_SUFFIX")) continue;
            String itemNumber = entry.getValue();
            if (itemNumber != null && !"".equals(itemNumber)) {
                ++dimsrccount;
            }
            errorNumberKey.add(numberkey);
        }
        String name = excelData.get(0).get(errorNumberKey.get(0));
        String dimname = name.split("_")[0];
        String errorInfo = null;
        if (errorNumberKey.size() == 0 || name == null || "".equals(name)) {
            return false;
        }
        if (dimsrccount == 0) {
            errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_NUMBER_IS_NULL", (Object[])new Object[]{key + 1, dimname});
            this.addErrorDataInfo(key, value, errorInfo);
            return false;
        }
        if (dimsrccount > 1) {
            errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_COMBINDIM_ELEMENT_NUMBER_IS_REPEAT", (Object[])new Object[]{key + 1, dimname});
            this.addErrorDataInfo(key, value, errorInfo);
            return false;
        }
        return true;
    }

    private List<String> validateCombinDimension(Map<String, List<String>> refDimens, String indexSrcNumber, String itemNumber) {
        BgElementInfo elemengInfo = (BgElementInfo)this.getUIContext().get("elemengInfo");
        BgScenarioInfo scenarioInfo = (BgScenarioInfo)this.getUIContext().get("scenarioInfo");
        if (elemengInfo == null || scenarioInfo == null) {
            return null;
        }
        String scenarioNums = DimensionFormulaHelper.getCombination(DimensionConstants.DEF_SCENARIO_SRCNUMBER, scenarioInfo.getNumber());
        String combin = RefDimInfo.getCombin(indexSrcNumber, itemNumber, elemengInfo.getNumber());
        combin = scenarioNums + "," + combin;
        if (refDimens.containsKey(combin)) {
            return refDimens.get(combin);
        }
        combin = RefDimInfo.getCombin(indexSrcNumber, null, elemengInfo.getNumber());
        combin = scenarioNums + "," + combin;
        if (refDimens.containsKey(combin)) {
            return refDimens.get(combin);
        }
        return null;
    }

    private void addErrorDataInfo(Integer key, Map<String, String> value, String errorInfo) {
        MBGAdjustBillHelper.addErrorDataInfo(this.errorData, key, value, errorInfo);
    }

    private Map<Integer, Map<String, String>> validateExcelDataFormat(KDSSheet sheet, Map<Integer, String> sortList) {
        if (MBGAdjustBillHelper.checkParamsIsNull(sheet, sortList)) {
            return null;
        }
        TreeMap<Integer, Map<String, String>> excelData = new TreeMap<Integer, Map<String, String>>();
        ArrayList refFieldSrcNumber = (ArrayList)this.getUIContext().get("MBG_COMBINE_HEAD_KEY");
        if (refFieldSrcNumber != null) {
            refFieldSrcNumber = new ArrayList(refFieldSrcNumber);
            Collections.sort(refFieldSrcNumber, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return RefFieldComparator.compareRefField(o1.substring(0, o1.indexOf("_")), o2.substring(0, o2.indexOf("_")));
                }
            });
        }
        int rowCount = sheet.getRowCount();
        int colCount = sheet.getColumnCount();
        this.progressBar.setMaximum(rowCount);
        ArrayList<String> headKeys = new ArrayList<String>();
        int combinCount = refFieldSrcNumber.size();
        if (colCount < 4 + 2 * combinCount) {
            logger.error((Object)"Excel data error, please check it!");
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"failedByExcelTemplateError"));
            SysUtil.abort();
            return null;
        }
        for (int col = 0; col < colCount; ++col) {
            Object key;
            if (col >= 4 && col < 4 + 2 * combinCount) {
                key = null;
                key = col % 2 == 0 ? (String)refFieldSrcNumber.get((col - 4) / 2) : (String)refFieldSrcNumber.get((col - 5) / 2) + "_SUFFIX";
                headKeys.add(((String)key).toString());
                continue;
            }
            if (col == 0) {
                headKeys.add("MBG_HEADKEY_COSTCENTER_ORG_NUMBER");
                continue;
            }
            if (col == 1) {
                headKeys.add("MBG_HEADKEY_COSTCENTER_ORG_NAME");
                continue;
            }
            if (col == 2) {
                headKeys.add("MBG_HEADKEY_INDEX_MEMBER_NUMBER");
                continue;
            }
            if (col == 3) {
                headKeys.add("MBG_HEADKEY_INDEX_MEMBER_NAME");
                continue;
            }
            if (((Boolean)this.getUIContext().get("isAdjustEntryScenAndEle")).booleanValue()) {
                if (col == 4 + 2 * combinCount) {
                    headKeys.add("MBG_HEADKEY_BGSCENARIO_NUMBER");
                    continue;
                }
                if (col == 5 + 2 * combinCount) {
                    headKeys.add("MBG_HEADKEY_BGSCENARIO_NAME");
                    continue;
                }
                if (col == 6 + 2 * combinCount) {
                    headKeys.add("MBG_HEADKEY_BGELEMENT_NUMBER");
                    continue;
                }
                if (col == 7 + 2 * combinCount) {
                    headKeys.add("MBG_HEADKEY_BGELEMENT_NAME");
                    continue;
                }
                key = sheet.getCell(0, col, false).getValue();
                if (key == null) continue;
                headKeys.add(key.toString().trim());
                continue;
            }
            key = sheet.getCell(0, col, false).getValue();
            if (key == null) continue;
            headKeys.add(key.toString().trim());
        }
        boolean allEmpty = true;
        try {
            for (int i = 0; i < rowCount; ++i) {
                this.progressBar.setValue(i);
                LinkedHashMap<String, String> rowData = new LinkedHashMap<String, String>();
                allEmpty = true;
                for (int j = 0; j < colCount; ++j) {
                    Object value = sheet.getCell(i, j, false).getValue();
                    if (value instanceof String && !StringUtils.isEmpty((String)value.toString())) {
                        allEmpty = false;
                    }
                    if (allEmpty) continue;
                    rowData.put((String)headKeys.get(j), value == null ? "" : value.toString().trim());
                }
                if (rowData.isEmpty() || this.checkIsTotalRow(rowData)) continue;
                excelData.put(i, rowData);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return excelData;
    }

    public Map<Integer, Map<String, String>> getPassedData() {
        return this.passedData;
    }

    public void setPassedData(Map<Integer, Map<String, String>> passedData) {
        this.passedData = passedData;
    }

    public Map<Integer, Map<String, String>> getErrorData() {
        return this.errorData;
    }

    public void setErrorData(Map<Integer, Map<String, String>> errorData) {
        this.errorData = errorData;
    }

    public void setOperateImport(boolean isOperateImport) {
        this.isOperateImport = isOperateImport;
    }

    public boolean isOperateImport() {
        return this.isOperateImport;
    }

    public boolean checkIsTotalRow(Map<String, String> rowData) {
        boolean isTotalRow = false;
        String COL_TOTAL = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"col_title_total");
        if (rowData.containsKey("MBG_HEADKEY_COSTCENTER_ORG_NUMBER") && rowData.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER").equals(COL_TOTAL) && rowData.containsKey("MBG_HEADKEY_COSTCENTER_ORG_NAME") && StringUtils.isEmpty((String)rowData.get("MBG_HEADKEY_COSTCENTER_ORG_NAME")) && rowData.containsKey("MBG_HEADKEY_INDEX_MEMBER_NUMBER") && StringUtils.isEmpty((String)rowData.get("MBG_HEADKEY_INDEX_MEMBER_NUMBER")) && rowData.containsKey("MBG_HEADKEY_INDEX_MEMBER_NAME") && StringUtils.isEmpty((String)rowData.get("MBG_HEADKEY_INDEX_MEMBER_NAME"))) {
            isTotalRow = true;
        }
        return isTotalRow;
    }

    class ProgressThread
    extends Thread {
        private boolean isImport = false;

        public ProgressThread(boolean isImport) {
            this.isImport = isImport;
        }

        @Override
        public void run() {
            AdjustBillImportUI.this.disableButtons();
            BgFileUtil bgFileUtil = new BgFileUtil();
            String fileName = AdjustBillImportUI.this.txtFile.getText();
            if (this.isImport) {
                KDSBook book = null;
                try {
                    book = POIXlsReader.parse((String)fileName);
                }
                catch (Exception e1) {
                    SysUtil.abort();
                }
                if (book == null) {
                    MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"notFile"));
                    AdjustBillImportUI.this.enableButtons();
                    SysUtil.abort();
                }
                KDSSheet sheet = book.getSheet((Object)new Integer(0));
                try {
                    AdjustBillImportUI.this._importDataNew(sheet);
                    bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)AdjustBillImportUI.this.getUIContext());
                }
                catch (Exception e) {
                    logger.error((Object)"_importDataNew Error");
                }
                AdjustBillImportUI.this.getUIWindow().hide();
            } else {
                KDTable tbl = (KDTable)AdjustBillImportUI.this.getUIContext().get("data");
                try {
                    boolean isSuccess = AdjustBillImportUI.this.appendToExcel(fileName, tbl);
                    if (isSuccess) {
                        bgFileUtil.storeDefaultPathForEXP((Object)fileName, (Object)AdjustBillImportUI.this.getUIContext());
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)AdjustBillImportUI.IMPORT_RES, (String)"exportSucceeded"));
                        AdjustBillImportUI.this.getUIWindow().hide();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AdjustBillImportUI.this.enableButtons();
        }
    }
}

