/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.control.client.BgControlDimensionMemberSelectDialog;
import com.kingdee.eas.ma.control.client.BgControlIndexMemberSelectDialog;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgAdjustBillBalanceFilterUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustBillEditUI;
import com.kingdee.eas.ma.mbg.client.MbgAdjustFormBlockSetUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionSourceMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgAdjustBillBalanceOverParameter;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.BgAnalyseConstants;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgAdjustBillBalanceFilterUI
extends AbstractBgAdjustBillBalanceFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustBillBalanceFilterUI.class);
    protected static final String COL_INDEX_SOURCE = "indexSource";
    protected static final String COL_INDEX = "indexMember";
    protected static final String COL_COMBIN = "combinMember";
    protected static final String RES = "com.kingdee.eas.ma.mbg.BgAdjustBillResource";
    private BgAdjustBillBalanceOverParameter queryParameter;
    protected DimensionSourceCollection sources;
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public void onLoad() throws Exception {
        this.table.checkParsed();
        super.onLoad();
        this.getCellHelper().init();
        this.initButton();
        this.initUI();
        this.reSetTableState();
    }

    private void initButton() {
        this.setButtonState(this.btnAddLine, true, true, "imgTbtn_addline");
        this.setButtonState(this.btnCopyLine, true, true, "imgTbtn_copyline");
        this.setButtonState(this.btnDelLine, true, true, "imgTbtn_deleteline");
        this.setButtonState(this.btnBgForm, true, true, "imgTbtn_distributelog");
    }

    private void setButtonState(KDWorkButton btn, boolean isVisible, boolean isEnable, String icoName) {
        if (btn == null) {
            return;
        }
        btn.setEnabled(isEnable);
        btn.setVisible(isVisible);
        if (!StringUtils.isEmpty((String)icoName)) {
            btn.setIcon(EASResource.getIcon((String)icoName));
        }
    }

    private void initUI() throws EASBizException, BOSException {
        this.initOrgUnit();
        this.initBgScheme();
        this.initBgVersion();
        this.initBgScenario();
        BgPeriodDialog dia = new BgPeriodDialog((CoreUIObject)this);
        this.prmtInPeriod.setSelector((KDPromptSelector)dia);
        this.prmtOutPeriod.setSelector((KDPromptSelector)dia);
        KDComboBox cbxDimension = this.newInstanceKDComboBox();
        this.table.getColumn(COL_INDEX_SOURCE).setRequired(true);
        this.table.getColumn(COL_INDEX_SOURCE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxDimension));
    }

    protected void initOrgUnit() {
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setMultiSelect(true);
        this.prmtOrgunit.setSelector((KDPromptSelector)f7);
        this.prmtOrgunit.setRequired(true);
        this.prmtOrgunit.setData((Object)new OrgUnitInfo[]{SysContext.getSysContext().getCurrentCostUnit()});
        this.prmtOrgunit.setDisplayFormat("$name$");
        this.prmtOrgunit.setEditFormat("$number$");
        this.prmtOrgunit.setCommitFormat("$number$");
        this.prmtOrgunit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BgAdjustBillBalanceFilterUI.this.prmtOrgunitDataChange(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void initBgScheme() throws EASBizException {
        OrgUnitInfo[] orgUnit = (OrgUnitInfo[])this.prmtOrgunit.getData();
        BOSUuid[] bosUuidArr = new BOSUuid[orgUnit.length];
        for (int i = 0; i < orgUnit.length; ++i) {
            bosUuidArr[i] = orgUnit[i].getId();
        }
        this.prmtScheme.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BgAdjustBillBalanceFilterUI.this.prmtScheme_willShow(e);
                }
                catch (Exception exc) {
                    BgAdjustBillBalanceFilterUI.this.handUIException(exc);
                }
            }
        });
        try {
            BgNFCHelper.initPrmpBgschemeInfo(this.prmtScheme, this.queryBgSchemeIds(bosUuidArr), false, BgNFCHelper.getSourceType((IUIObject)this), false, false);
        }
        catch (Exception e) {
            throw new EASBizException(null, (Throwable)e);
        }
    }

    protected Set<BOSUuid> queryBgSchemeIds(BOSUuid[] orgUnitIds) throws Exception {
        return BgSchemeFactory.getRemoteInstance().queryShowScheme(orgUnitIds);
    }

    private void initBgVersion() {
        this.prmtBgVersion.setQueryInfo("com.kingdee.eas.ma.base.BgVersionQuery");
        this.prmtBgVersion.setDisplayFormat("$name$");
        this.prmtBgVersion.setCommitFormat("$number$");
        this.prmtBgVersion.setEditFormat("$number$");
        this.prmtBgVersion.setEnabledMultiSelection(false);
    }

    private void initBgScenario() {
        this.prmtBgScenario.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        this.prmtBgScenario.setDisplayFormat("$name$");
        this.prmtBgScenario.setCommitFormat("$number$");
        this.prmtBgScenario.setEditFormat("$number$");
        this.prmtBgScenario.setEnabledMultiSelection(false);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        env.setFilter(filter);
        this.prmtBgScenario.setEntityViewInfo(env);
    }

    private KDComboBox newInstanceKDComboBox() throws BOSException, EASBizException {
        BgDimensionInfo dimObj = new BgDimensionInfo(null);
        dimObj.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        this.sources = null;
        this.sources = this.filterIndexSource(this.sources);
        KDComboBox cbxDimension = new KDComboBox();
        if (this.sources != null && !this.sources.isEmpty()) {
            DimensionClientHelper.loadSourceNameInfo(this.sources);
            cbxDimension.addItems(this.sources.toArray());
        }
        return cbxDimension;
    }

    protected DimensionSourceCollection filterIndexSource(DimensionSourceCollection sources) {
        return sources;
    }

    protected void prmtOrgunitDataChange(DataChangeEvent e) throws Exception {
        this.initBgScheme();
        this.reSetTableState();
    }

    protected void prmtScheme_willShow(SelectorEvent e) throws Exception {
        BgViewClientHelper.prmtScheme_willShow((Component)((Object)this), this.prmtOrgunit);
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtScheme_dataChanged(e);
        this.reSetTableState();
        String accountViewId = null;
        if (e.getNewValue() instanceof BgSchemeInfo) {
            accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)e.getNewValue());
        }
        this.getDetailTable().getColumn(COL_INDEX).setRenderer((IBasicRender)this.getCellHelper().getOVRender(accountViewId));
    }

    protected void reSetTableState() {
        boolean isEnable = false;
        if (!(this.prmtOrgunit.getData() instanceof OrgUnitInfo[])) {
            this.table.removeRows();
            isEnable = false;
        } else {
            OrgUnitInfo[] orgunit = (OrgUnitInfo[])this.prmtOrgunit.getData();
            this.updataTableColumnEditor(orgunit);
            isEnable = true;
        }
        this.buttonState(isEnable);
    }

    protected void updataTableColumnEditor(OrgUnitInfo[] orgunit) {
        if (orgunit == null) {
            return;
        }
        this.table.checkParsed();
        this.table.removeRows();
        this.table.setEditable(true);
        BgControlIndexMemberSelectDialog indexDia = this.getIndexPromptBox();
        NewDimensionMemberSelectDialog combinDialog = this.getCombinRowPromptBox();
    }

    private BgControlIndexMemberSelectDialog getIndexPromptBox() {
        BgControlIndexMemberSelectDialog dia = null;
        if (this.table.getColumn(COL_INDEX).getEditor() instanceof KDTDefaultCellEditor && this.table.getColumn(COL_INDEX).getEditor() instanceof KDBizPromptBox && ((KDBizPromptBox)this.table.getColumn(COL_INDEX).getEditor().getComponent()).getSelector() instanceof BgControlIndexMemberSelectDialog) {
            dia = (BgControlIndexMemberSelectDialog)((KDBizPromptBox)this.table.getColumn(COL_INDEX).getEditor().getComponent()).getSelector();
        } else {
            KDBizPromptBox indexMemberF7 = new KDBizPromptBox();
            indexMemberF7.setEditable(false);
            dia = this.newInstanceIndexMemberSelectDiaLog();
            indexMemberF7.setSelector((KDPromptSelector)dia);
            this.table.getColumn(COL_INDEX).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)indexMemberF7));
        }
        return dia;
    }

    protected BgControlIndexMemberSelectDialog newInstanceIndexMemberSelectDiaLog() {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        return new BgControlIndexMemberSelectDialog((Component)((Object)this), dimension);
    }

    protected NewDimensionMemberSelectDialog newDimensionMemberSelectDialog(CostCenterOrgUnitInfo org) {
        NewDimensionMemberSelectDialog dia = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)null, org.getId().toString(), false, true);
        dia.setOnlyRefDim(true);
        dia.setOnlySelectItem(true);
        return dia;
    }

    private NewDimensionMemberSelectDialog getCombinRowPromptBox() {
        NewDimensionMemberSelectDialog dia = null;
        if (this.table.getColumn(COL_COMBIN).getEditor() instanceof KDTDefaultCellEditor && this.table.getColumn(COL_COMBIN).getEditor().getComponent() instanceof KDBizPromptBox && ((KDBizPromptBox)this.table.getColumn(COL_COMBIN).getEditor().getComponent()).getSelector() instanceof BgControlDimensionMemberSelectDialog) {
            dia = (BgControlDimensionMemberSelectDialog)((KDBizPromptBox)this.table.getColumn(COL_COMBIN).getEditor().getComponent()).getSelector();
        } else {
            CostCenterOrgUnitInfo org = null;
            org = this.prmtOrgunit.getData() instanceof CostCenterOrgUnitInfo ? (CostCenterOrgUnitInfo)this.prmtOrgunit.getData() : SysContext.getSysContext().getCurrentCostUnit();
            KDBizPromptBox memberF7 = new KDBizPromptBox();
            dia = this.newDimensionMemberSelectDialog(org);
            memberF7.setEditable(false);
            memberF7.setSelector((KDPromptSelector)dia);
            this.table.getColumn(COL_COMBIN).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)memberF7));
            this.table.getColumn(COL_COMBIN).setRenderer((IBasicRender)BgCellRenderHelper.getMemberComRender());
        }
        return dia;
    }

    private void buttonState(boolean isEnable) {
        this.btnAddLine.setEnabled(isEnable);
        this.btnCopyLine.setEnabled(isEnable);
        this.btnDelLine.setEnabled(isEnable);
        this.btnBgForm.setEnabled(isEnable);
    }

    @Override
    protected void table_editStopped(KDTEditEvent e) throws Exception {
        Object ob;
        if (COL_INDEX_SOURCE.equals(this.table.getColumnKey(e.getColIndex()))) {
            DimensionSourceInfo source = (DimensionSourceInfo)e.getValue();
            this.setIndexMemberF7(source, (DimensionSourceInfo)e.getOldValue(), e.getRowIndex());
        } else if (e.getColIndex() == this.table.getColumnIndex(COL_INDEX) && (ob = this.table.getCell(e.getRowIndex(), e.getColIndex()).getValue()) instanceof List) {
            List list = (List)ob;
            this.addRowData(list);
        }
    }

    protected void setIndexMemberF7(DimensionSourceInfo source, DimensionSourceInfo oldValue, int rowIndex) {
        ICell memberCell = this.table.getCell(rowIndex, COL_INDEX);
        if (source == null) {
            memberCell.setValue(null);
            memberCell.setEditor(null);
            memberCell.getStyleAttributes().setLocked(true);
            return;
        }
        if (oldValue != null && oldValue.getId().equals((Object)source.getId())) {
            return;
        }
        memberCell.setValue(null);
        memberCell.getStyleAttributes().setLocked(false);
        NewDimensionSourceMemberDialog dialog = new NewDimensionSourceMemberDialog(this.getCoreUI(), source, SysContext.getSysContext().getCurrentCostUnit().getId().toString(), true);
        dialog.setCanFillType(false);
        KDBizPromptBox prmtMember = new KDBizPromptBox();
        prmtMember.setEditable(false);
        prmtMember.setSelector((KDPromptSelector)dialog);
        memberCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMember));
    }

    protected CoreUI getCoreUI() {
        if (this.getUIContext().get("Owner") instanceof CoreUI) {
            return (CoreUI)this.getUIContext().get("Owner");
        }
        return null;
    }

    private void addRowData(List list) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            BgDimensionMember member = (BgDimensionMember)list.get(index);
            IRow row = index == 0 ? this.table.getRow(this.table.getSelectManager().getActiveRowIndex()) : this.table.addRow();
            row.getCell(COL_INDEX_SOURCE).setValue((Object)this.getIndexSource(member.getSrcNumber()));
            row.getCell(COL_INDEX).setValue((Object)member);
            row.getCell(COL_COMBIN).setValue(null);
        }
    }

    public RequestContext prepareLoadData(EntityViewInfo entityViewInfo) {
        return super.prepareLoadData(entityViewInfo);
    }

    public RequestContext prepareGetCustomerParams() {
        return super.prepareGetCustomerParams();
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.createNewRefRow(true);
    }

    protected IRow createNewRefRow(boolean setDefault) {
        IRow row = this.table.addRow();
        if (setDefault) {
            if (this.sources == null || this.sources.isEmpty()) {
                row.getCell(COL_INDEX).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(COL_INDEX_SOURCE).setValue((Object)this.sources.get(0));
                this.setIndexMemberF7(this.sources.get(0), null, row.getRowIndex());
            }
        }
        return row;
    }

    @Override
    protected void btnCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.table.getRow(rowIndex);
        IRow newRow = (IRow)row.clone();
        this.table.addRow(this.table.getRowCount() - 1, newRow);
    }

    @Override
    protected void btnDelLine_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.table.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                for (int j = rowEnd = block.getEndRow(); j >= rowBegin; --j) {
                    this.table.removeRow(j);
                }
            }
        }
    }

    public String getResourceStr() {
        return BgAnalyseConstants.ANALYSE_RESOURCESTR;
    }

    @Override
    protected void btnBgForm_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getAdjustFormFilterUIName() {
        return MbgAdjustFormBlockSetUI.class.getName();
    }

    private int indexOfDuplicateData(KDTable table, String indexGroupNumber, String combinNumber) throws BOSException {
        int rowCount = table.getRowCount();
        BgDimensionMember member0 = null;
        BgDimensionMember member1 = null;
        StringBuilder sb = null;
        for (int i = 0; i < rowCount; ++i) {
            String[] number;
            sb = new StringBuilder();
            IRow row = table.getRow(i);
            Object value0 = row.getCell(COL_INDEX).getValue();
            Object value1 = row.getCell(COL_COMBIN).getValue();
            if (value0 == null || !(value0 instanceof BgDimensionMember) || value1 == null || !(value1 instanceof BgDimensionMember)) continue;
            member0 = (BgDimensionMember)value0;
            member1 = (BgDimensionMember)value1;
            String number0 = member0.getSrcNumber() + ":" + member0.getNumber();
            String[] srcNumber = member1.getSrcNumber().split(",");
            if (srcNumber.length != (number = member1.getNumber().split(",")).length) continue;
            for (int j = 0; j < number.length; ++j) {
                sb.append(srcNumber[j]).append(":").append(number[j]).append(",");
            }
            if (!indexGroupNumber.equals(number0) || !combinNumber.equals(this.removeEndComma(sb))) continue;
            return i;
        }
        return -1;
    }

    private String removeEndComma(StringBuilder sb) {
        return BgAdjustBillEditUI.removeEndComma(sb);
    }

    public boolean verify() {
        if (!(this.prmtOrgunit.getData() instanceof OrgUnitInfo[])) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("orgunitIsEmpty"));
            SysUtil.abort();
        }
        if (!(this.prmtScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("schemeIsEmpty"));
            SysUtil.abort();
        }
        if (!(this.prmtOutPeriod.getData() instanceof BgPeriodInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("outPeriodIsEmpty"));
            SysUtil.abort();
        }
        if (!(this.prmtInPeriod.getData() instanceof BgPeriodInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("inPeriodIsEmpty"));
            SysUtil.abort();
        }
        if (!(this.prmtBgScenario.getData() instanceof BgScenarioInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("bgScenarioIsEmpty"));
            SysUtil.abort();
        }
        BgSchemeInfo schemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
        Date from = schemeInfo.getDateFrom();
        Date to = schemeInfo.getDateTo();
        BgPeriodInfo outPeriodInfo = (BgPeriodInfo)this.prmtOutPeriod.getData();
        BgPeriodInfo inPeriodInfo = (BgPeriodInfo)this.prmtInPeriod.getData();
        if (outPeriodInfo.getPeriodType().getValue() != schemeInfo.getPeriod().getValue() || inPeriodInfo.getPeriodType().getValue() != schemeInfo.getPeriod().getValue()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("periodTypeError"));
            SysUtil.abort();
        }
        if (outPeriodInfo.getEndDate().getTime() > inPeriodInfo.getBeginDate().getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("periodError"));
            SysUtil.abort();
        }
        if (from != null && to != null && (outPeriodInfo.getBeginDate().getTime() < from.getTime() || outPeriodInfo.getBeginDate().getTime() > to.getTime() || inPeriodInfo.getBeginDate().getTime() < from.getTime() || inPeriodInfo.getBeginDate().getTime() > to.getTime())) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("periodRangoutScheme"));
            SysUtil.abort();
        }
        if (this.table.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("indexMemberNotEmpty"));
            SysUtil.abort();
        }
        HashSet<String> key = new HashSet<String>();
        DimensionSourceInfo sourceInfo = null;
        for (int index = this.table.getRowCount() - 1; index >= 0; --index) {
            BgDimensionMember member;
            String strKey = "";
            if (this.table.getCell(index, COL_INDEX_SOURCE).getValue() instanceof DimensionSourceInfo) {
                sourceInfo = (DimensionSourceInfo)this.table.getCell(index, COL_INDEX_SOURCE).getValue();
                strKey = strKey + sourceInfo.getSrcNumber() + "_" + sourceInfo.getSrcTable() + ",";
            }
            if (this.table.getCell(index, COL_INDEX).getValue() instanceof BgDimensionMember) {
                member = (BgDimensionMember)this.table.getCell(index, COL_INDEX).getValue();
                strKey = strKey + member.getSrcNumber() + "_" + member.getNumber() + ",";
            }
            if (this.table.getCell(index, COL_COMBIN).getValue() instanceof BgDimensionMember) {
                member = (BgDimensionMember)this.table.getCell(index, COL_COMBIN).getValue();
                strKey = strKey + member.getSrcNumber() + "_" + member.getNumber() + ",";
            }
            if (key.contains(strKey)) {
                this.table.removeRow(index);
                continue;
            }
            key.add(strKey);
        }
        try {
            this.createParameter();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return super.verify();
    }

    private void createParameter() throws BOSException {
        this.queryParameter = new BgAdjustBillBalanceOverParameter();
        this.queryParameter.setBgScheme((BgSchemeInfo)this.prmtScheme.getData());
        this.queryParameter.setBgScenario((BgScenarioInfo)this.prmtBgScenario.getData());
        this.queryParameter.setBgVersion(BgVersionHelper.getSysVersionInfo(null));
        this.queryParameter.setOrgunit((OrgUnitInfo[])this.prmtOrgunit.getData());
        this.queryParameter.setSourcePeriod((BgPeriodInfo)this.prmtOutPeriod.getData());
        this.queryParameter.setTargetPeriod((BgPeriodInfo)this.prmtInPeriod.getData());
        if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
            this.queryParameter.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        }
        if (this.prmtElement.getData() instanceof BgElementInfo) {
            this.queryParameter.setBgElement((BgElementInfo)this.prmtElement.getData());
        }
        List<BgDimensionMember[]> members = this.queryParameter.getMembers();
        members.clear();
        for (int index = 0; index < this.table.getRowCount(); ++index) {
            BgDimensionMember[] me = new BgDimensionMember[2];
            IRow row = this.table.getRow(index);
            me[0] = (BgDimensionMember)row.getCell(COL_INDEX).getValue();
            if (me[0] == null) {
                DimensionSourceInfo source = (DimensionSourceInfo)row.getCell(COL_INDEX_SOURCE).getValue();
                me[0] = new BgDimensionMember(source.getDimension().getNumber(), null, null, null);
                me[0].setSrcNumber(source.getSrcNumber());
            }
            if (row.getCell(COL_COMBIN).getValue() instanceof BgDimensionMember) {
                me[1] = (BgDimensionMember)row.getCell(COL_COMBIN).getValue();
            }
            members.add(me);
        }
    }

    protected String getString(String key) {
        return EASResource.getString((String)RES, (String)key);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    protected KDTable getDetailTable() {
        return this.table;
    }

    public BgAdjustBillBalanceOverParameter getQueryParameter() {
        return this.queryParameter;
    }

    public void setQueryParameter(BgAdjustBillBalanceOverParameter queryParameter) {
        this.queryParameter = queryParameter;
    }

    public void setCustomerParams(CustomerParams cp) {
        BgPeriodInfo period;
        BgSchemeInfo info;
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("orgSize") != null) {
            CostCenterOrgUnitInfo[] org = new CostCenterOrgUnitInfo[Integer.valueOf(cp.getCustomerParam("orgSize")).intValue()];
            for (int index = 0; index < Integer.valueOf(cp.getCustomerParam("orgSize")); ++index) {
                CostCenterOrgUnitInfo oInfo = new CostCenterOrgUnitInfo();
                oInfo.setId(BOSUuid.read((String)cp.getCustomerParam("orgUnitID_" + index)));
                oInfo.setName(cp.getCustomerParam("orgUnitName_" + index));
                oInfo.setNumber(cp.getCustomerParam("orgUnitNumber_" + index));
                oInfo.setLongNumber(cp.getCustomerParam("orgUnitLongNumber_" + index));
                org[index] = oInfo;
            }
            this.prmtOrgunit.setData((Object)org);
        } else {
            this.prmtOrgunit.setData(null);
        }
        if (cp.getCustomerParam("schemeID") != null) {
            info = new BgSchemeInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("schemeID")));
            info.setNumber(cp.getCustomerParam("schemeNumber"));
            info.setName(cp.getCustomerParam("schemeName"));
            info.setPeriod(BgPeriodEnum.getEnum((int)Integer.valueOf(cp.getCustomerParam("period"))));
            info.setRefCube(cp.getCustomerParam("refCube"));
            if (!StringUtils.isEmpty((String)cp.getCustomerParam("dateFrom"))) {
                info.setDateFrom(new Date(Long.valueOf(cp.getCustomerParam("dateFrom"))));
            }
            if (!StringUtils.isEmpty((String)cp.getCustomerParam("dateTo"))) {
                info.setDateTo(new Date(Long.valueOf(cp.getCustomerParam("dateTo"))));
            }
            this.prmtScheme.setData((Object)info);
        } else {
            this.prmtScheme.setData(null);
        }
        if (cp.getCustomerParam("outPeriodID") != null) {
            period = new BgPeriodInfo();
            period.setId(BOSUuid.read((String)cp.getCustomerParam("outPeriodID")));
            period.setNumber(cp.getCustomerParam("outPeriodNumber"));
            period.setName(cp.getCustomerParam("outPeriodName"));
            period.setPeriodType(BgPeriodEnum.getEnum((int)Integer.valueOf(cp.getCustomerParam("outPeriodType"))));
            period.setBeginDate(new Date(Long.valueOf(cp.getCustomerParam("outBeginDate"))));
            period.setEndDate(new Date(Long.valueOf(cp.getCustomerParam("outEndDate"))));
            this.prmtOutPeriod.setData((Object)period);
        } else {
            this.prmtOutPeriod.setData(null);
        }
        if (cp.getCustomerParam("inPeriodID") != null) {
            period = new BgPeriodInfo();
            period.setId(BOSUuid.read((String)cp.getCustomerParam("inPeriodID")));
            period.setNumber(cp.getCustomerParam("inPeriodNumber"));
            period.setName(cp.getCustomerParam("inPeriodName"));
            period.setPeriodType(BgPeriodEnum.getEnum((int)Integer.valueOf(cp.getCustomerParam("inPeriodType"))));
            period.setBeginDate(new Date(Long.valueOf(cp.getCustomerParam("inBeginDate"))));
            period.setEndDate(new Date(Long.valueOf(cp.getCustomerParam("inEndDate"))));
            this.prmtInPeriod.setData((Object)period);
        } else {
            this.prmtInPeriod.setData(null);
        }
        if (cp.getCustomerParam("currencyID") != null) {
            info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("currencyID")));
            info.setNumber(cp.getCustomerParam("currencyNumber"));
            info.setName(cp.getCustomerParam("currencyName"));
            this.prmtCurrency.setData((Object)info);
        } else {
            this.prmtCurrency.setData(null);
        }
        if (cp.getCustomerParam("elementID") != null) {
            info = new BgElementInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("elementID")));
            info.setNumber(cp.getCustomerParam("elementNumber"));
            info.setName(cp.getCustomerParam("elementName"));
            this.prmtElement.setData((Object)info);
        } else {
            this.prmtElement.setData(null);
        }
        if (cp.getCustomerParam("scenarioID") != null) {
            info = new BgScenarioInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("scenarioID")));
            info.setNumber(cp.getCustomerParam("scenarioNumber"));
            info.setName(cp.getCustomerParam("scenarioName"));
            this.prmtBgScenario.setData((Object)info);
        } else {
            this.prmtBgScenario.setData(null);
        }
        if (cp.getCustomerParam("rowSize") != null) {
            int rowCount = Integer.valueOf(cp.getCustomerParam("rowSize"));
            this.table.removeRows();
            for (int index = 0; index < rowCount; ++index) {
                IRow row = this.table.addRow();
                BgDimensionMember member = new BgDimensionMember(cp.getCustomerParam("index_type_" + index), cp.getCustomerParam("index_att_" + index), cp.getCustomerParam("index_name_" + index), cp.getCustomerParam("index_number_" + index));
                member.setSrcNumber(cp.getCustomerParam("index_srcnumber_" + index));
                row.getCell(COL_INDEX_SOURCE).setValue((Object)this.getIndexSource(member.getSrcNumber()));
                this.setIndexMemberF7(this.getIndexSource(member.getSrcNumber()), null, row.getRowIndex());
                if (member.getNumber() != null) {
                    row.getCell(COL_INDEX).setValue((Object)member);
                }
                if (!Boolean.valueOf(cp.getCustomerParam("hasItemCombin_" + index)).booleanValue()) continue;
                member = new BgDimensionMember(cp.getCustomerParam("itemCombin_type_" + index), cp.getCustomerParam("itemCombin_att_" + index), cp.getCustomerParam("itemCombin_name_" + index), cp.getCustomerParam("itemCombin_number_" + index));
                member.setSrcNumber(cp.getCustomerParam("itemCombin_srcnumber_" + index));
                row.getCell(COL_COMBIN).setValue((Object)member);
            }
        } else {
            this.table.removeRows();
        }
    }

    private DimensionSourceInfo getIndexSource(String srcNumber) {
        if (this.sources == null || this.sources.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!this.sources.get(i).getSrcNumber().equals(srcNumber)) continue;
            return this.sources.get(i);
        }
        return null;
    }

    public CustomerParams getCustomerParams() {
        BgPeriodInfo period;
        BgSchemeInfo info;
        int index;
        CustomerParams param = new CustomerParams();
        if (this.prmtOrgunit.getData() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] org = (OrgUnitInfo[])this.prmtOrgunit.getData();
            for (index = 0; index < org.length; ++index) {
                OrgUnitInfo oInfo = org[index];
                param.addCustomerParam("orgUnitID_" + index, oInfo.getId().toString());
                param.addCustomerParam("orgUnitName_" + index, oInfo.getName());
                param.addCustomerParam("orgUnitNumber_" + index, oInfo.getNumber());
                param.addCustomerParam("orgUnitLongNumber_" + index, oInfo.getLongNumber());
            }
            param.addCustomerParam("orgSize", String.valueOf(org.length));
        }
        if (this.prmtScheme.getData() instanceof BgSchemeInfo) {
            info = (BgSchemeInfo)this.prmtScheme.getData();
            param.addCustomerParam("schemeID", info.getId().toString());
            param.addCustomerParam("schemeNumber", info.getNumber());
            param.addCustomerParam("schemeName", info.getName());
            param.addCustomerParam("period", String.valueOf(info.getPeriod().getValue()));
            param.addCustomerParam("refCube", info.getRefCube());
            param.addCustomerParam("dateFrom", String.valueOf(info.getDateFrom().getTime()));
            param.addCustomerParam("dateTo", String.valueOf(info.getDateTo().getTime()));
        }
        if (this.prmtOutPeriod.getData() instanceof BgPeriodInfo) {
            period = (BgPeriodInfo)this.prmtOutPeriod.getData();
            param.addCustomerParam("outPeriodID", period.getId().toString());
            param.addCustomerParam("outPeriodNumber", period.getNumber());
            param.addCustomerParam("outPeriodName", period.getName());
            param.addCustomerParam("outPeriodType", String.valueOf(period.getPeriodType().getValue()));
            param.addCustomerParam("outBeginDate", String.valueOf(period.getBeginDate().getTime()));
            param.addCustomerParam("outEndDate", String.valueOf(period.getEndDate().getTime()));
        }
        if (this.prmtInPeriod.getData() instanceof BgPeriodInfo) {
            period = (BgPeriodInfo)this.prmtInPeriod.getData();
            param.addCustomerParam("inPeriodID", period.getId().toString());
            param.addCustomerParam("inPeriodNumber", period.getNumber());
            param.addCustomerParam("inPeriodName", period.getName());
            param.addCustomerParam("inPeriodType", String.valueOf(period.getPeriodType().getValue()));
            param.addCustomerParam("inBeginDate", String.valueOf(period.getBeginDate().getTime()));
            param.addCustomerParam("inEndDate", String.valueOf(period.getEndDate().getTime()));
        }
        if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
            info = (CurrencyInfo)this.prmtCurrency.getData();
            param.addCustomerParam("currencyID", info.getId().toString());
            param.addCustomerParam("currencyNumber", info.getNumber());
            param.addCustomerParam("currencyName", info.getName());
        }
        if (this.prmtElement.getData() instanceof BgElementInfo) {
            info = (BgElementInfo)this.prmtElement.getData();
            param.addCustomerParam("elementID", info.getId().toString());
            param.addCustomerParam("elementNumber", info.getNumber());
            param.addCustomerParam("elementName", info.getName());
        }
        if (this.prmtBgScenario.getData() instanceof BgScenarioInfo) {
            info = (BgScenarioInfo)this.prmtBgScenario.getData();
            param.addCustomerParam("scenarioID", info.getId().toString());
            param.addCustomerParam("scenarioNumber", info.getNumber());
            param.addCustomerParam("scenarioName", info.getName());
        }
        if (this.table.getRowCount() > 0) {
            param.addCustomerParam("rowSize", String.valueOf(this.table.getRowCount()));
            for (index = 0; index < this.table.getRowCount(); ++index) {
                IRow row = this.table.getRow(index);
                BgDimensionMember member = (BgDimensionMember)row.getCell(COL_INDEX).getValue();
                if (member != null) {
                    param.addCustomerParam("index_att_" + index, member.getAttribute());
                    param.addCustomerParam("index_name_" + index, member.getName());
                    param.addCustomerParam("index_number_" + index, member.getNumber());
                    param.addCustomerParam("index_srcnumber_" + index, member.getSrcNumber());
                    param.addCustomerParam("index_type_" + index, member.getType());
                } else {
                    DimensionSourceInfo source = (DimensionSourceInfo)row.getCell(COL_INDEX_SOURCE).getValue();
                    param.addCustomerParam("index_srcnumber_" + index, source.getSrcNumber());
                    param.addCustomerParam("index_type_" + index, source.getDimension().getNumber());
                }
                if (row.getCell(COL_COMBIN).getValue() instanceof BgDimensionMember) {
                    param.addCustomerParam("hasItemCombin_" + index, String.valueOf(true));
                    member = (BgDimensionMember)row.getCell(COL_COMBIN).getValue();
                    param.addCustomerParam("itemCombin_att_" + index, member.getAttribute());
                    param.addCustomerParam("itemCombin_name_" + index, member.getName());
                    param.addCustomerParam("itemCombin_number_" + index, member.getNumber());
                    param.addCustomerParam("itemCombin_srcnumber_" + index, member.getSrcNumber());
                    param.addCustomerParam("itemCombin_type_" + index, member.getType());
                    continue;
                }
                param.addCustomerParam("hasItemCombin_" + index, String.valueOf(false));
            }
        }
        return param;
    }

    public void clear() {
        this.prmtCurrency.setData(null);
        this.prmtElement.setData(null);
        this.prmtInPeriod.setData(null);
        this.prmtOutPeriod.setData(null);
        this.prmtBgScenario.setData(null);
        this.prmtBgVersion.setData(null);
        this.prmtScheme.setData(null);
        this.prmtOrgunit.setData(null);
        this.btnAddLine.setEnabled(false);
        this.btnBgForm.setEnabled(false);
        this.btnCopyLine.setEnabled(false);
        this.btnDelLine.setEnabled(false);
        this.getDetailTable().removeRows();
        this.prmtOrgunit.setData((Object)new OrgUnitInfo[]{SysContext.getSysContext().getCurrentCostUnit()});
        this.prmtScheme.setData(null);
        this.table.removeRows();
        this.createNewRefRow(true);
        this.prmtOutPeriod.setData(null);
        this.prmtInPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtElement.setData(null);
    }
}

