/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.BgAdjustBillFacadeFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgAdjustBillBalanceOverListUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustBillBalanceFilterUI;
import com.kingdee.eas.ma.mbg.common.BgAdjustBillBalanceOverParameter;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgAdjustBillBalanceOverListUI
extends AbstractBgAdjustBillBalanceOverListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustBillBalanceOverListUI.class);
    protected static final String RES = "com.kingdee.eas.ma.mbg.BgAdjustBillResource";
    protected static final String COL_SELECT = "select";
    protected static final String COL_ORGUNIT = "orgunit";
    protected static final String COL_INDEXMEMBER = "indexMember";
    protected static final String COL_COMBINMEMBER = "combinMember";
    protected static final String COL_ELEMENT = "element";
    protected static final String COL_CURRENCY = "currency";
    protected static final String COL_CTRLWAY = "ctrlWay";
    protected static final String COL_CTRLPERIOD = "ctrlPeriod";
    protected static final String COL_RATIO = "ratio";
    protected static final String COL_BUDGETVALUE = "budgetValue";
    protected static final String COL_ACTUALVALUE = "actualValue";
    protected static final String COL_BALANCEVALUE = "balanceValue";
    protected static final String COL_ADJUSTVALUE = "adjustValue";
    protected static final String COL_BGDATAID = "bgDataID";
    protected IMetaDataPK mainQueryPk = null;
    private CommonQueryDialog queryDialog = null;
    protected KDPanel filterPanel;
    private BgAdjustBillBalanceOverParameter queryParameter;
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getCellHelper().init();
        this.mainQueryPk = MetaDataPK.create((String)"com.kingdee.eas.ma.mbg", (String)"BgAdjustBillListQuery");
        this.initTableEditor();
        if (this.hasDefaultQuery()) {
            this.doQuery();
            this.reSetUI();
        } else {
            this.showFilter();
        }
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getValue() instanceof Boolean) {
                    if (((Boolean)e.getValue()).booleanValue()) {
                        if (BgAdjustBillBalanceOverListUI.this.getTable().getRow(e.getRowIndex()).getCell(BgAdjustBillBalanceOverListUI.COL_ADJUSTVALUE).getValue() == null) {
                            BgAdjustBillBalanceOverListUI.this.getTable().getRow(e.getRowIndex()).getCell(BgAdjustBillBalanceOverListUI.COL_ADJUSTVALUE).setValue(BgAdjustBillBalanceOverListUI.this.getTable().getRow(e.getRowIndex()).getCell(BgAdjustBillBalanceOverListUI.COL_BALANCEVALUE).getValue());
                        }
                    } else {
                        BgAdjustBillBalanceOverListUI.this.getTable().getRow(e.getRowIndex()).getCell(BgAdjustBillBalanceOverListUI.COL_ADJUSTVALUE).setValue(null);
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
                super.editStopped(e);
            }
        });
        this.prmtOutPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgAdjustBillBalanceOverListUI.this.periodChange(eventObj);
            }
        });
        this.prmtInPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgAdjustBillBalanceOverListUI.this.periodChange(eventObj);
            }
        });
    }

    protected void initTableEditor() {
        this.getTable().checkParsed();
        this.getTable().removeRows();
        this.getTable().setEditable(true);
        KDCheckBox box = new KDCheckBox();
        this.getTable().getColumn(COL_SELECT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)box));
        this.getTable().getColumn(COL_SELECT).getStyleAttributes().setLocked(false);
        this.getTable().getColumn(COL_ORGUNIT).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_INDEXMEMBER).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_COMBINMEMBER).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_ELEMENT).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_CURRENCY).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_CTRLWAY).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_CTRLPERIOD).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_RATIO).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_BUDGETVALUE).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_ACTUALVALUE).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_BALANCEVALUE).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_ADJUSTVALUE).getStyleAttributes().setLocked(false);
        this.getTable().getColumn(COL_BGDATAID).getStyleAttributes().setLocked(true);
        KDNumberTextField number = new KDNumberTextField();
        number.setPrecision(2);
        number.setNegatived(false);
        number.setHorizontalAlignment(4);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)number);
        this.getTable().getColumn(COL_ADJUSTVALUE).setEditor((ICellEditor)editor);
        this.getTable().getColumn(COL_ADJUSTVALUE).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)2));
        this.getTable().getColumn(COL_ADJUSTVALUE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getTable().getColumn(COL_BUDGETVALUE).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)2));
        this.getTable().getColumn(COL_BUDGETVALUE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getTable().getColumn(COL_BALANCEVALUE).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)2));
        this.getTable().getColumn(COL_BALANCEVALUE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected IQuerySolutionFacade getQueryFacadeInterface() throws BOSException {
        return QuerySolutionFacadeFactory.getRemoteInstance();
    }

    protected boolean hasDefaultQuery() throws Exception {
        QuerySolutionInfo ds = this.getQueryFacadeInterface().getDefaultSolution(BgAdjustBillBalanceOverListUI.class.getName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            this.buildDefaultQuery(cp);
            return true;
        }
        return false;
    }

    protected void buildDefaultQuery(CustomerParams cp) {
        BgPeriodInfo period;
        BgSchemeInfo info;
        this.queryParameter = new BgAdjustBillBalanceOverParameter();
        if (cp.getCustomerParam("orgSize") != null) {
            CostCenterOrgUnitInfo[] org = new CostCenterOrgUnitInfo[Integer.valueOf(cp.getCustomerParam("orgSize")).intValue()];
            for (int index = 0; index < Integer.valueOf(cp.getCustomerParam("orgSize")); ++index) {
                CostCenterOrgUnitInfo oInfo = new CostCenterOrgUnitInfo();
                oInfo.setId(BOSUuid.read((String)cp.getCustomerParam("orgUnitID_" + index)));
                oInfo.setName(cp.getCustomerParam("orgUnitName_" + index));
                oInfo.setNumber(cp.getCustomerParam("orgUnitNumber_" + index));
                org[index] = oInfo;
            }
            this.queryParameter.setOrgunit((OrgUnitInfo[])org);
        }
        if (cp.getCustomerParam("schemeID") != null) {
            info = new BgSchemeInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("schemeID")));
            info.setNumber(cp.getCustomerParam("schemeNumber"));
            info.setName(cp.getCustomerParam("schemeName"));
            info.setPeriod(BgPeriodEnum.getEnum((int)Integer.valueOf(cp.getCustomerParam("period"))));
            info.setRefCube(cp.getCustomerParam("refCube"));
            this.queryParameter.setBgScheme(info);
        }
        if (cp.getCustomerParam("outPeriodID") != null) {
            period = new BgPeriodInfo();
            period.setId(BOSUuid.read((String)cp.getCustomerParam("outPeriodID")));
            period.setNumber(cp.getCustomerParam("outPeriodNumber"));
            period.setName(cp.getCustomerParam("outPeriodName"));
            period.setPeriodType(BgPeriodEnum.getEnum((int)Integer.valueOf(cp.getCustomerParam("outPeriodType"))));
            period.setBeginDate(new Date(Long.valueOf(cp.getCustomerParam("outBeginDate"))));
            period.setEndDate(new Date(Long.valueOf(cp.getCustomerParam("outEndDate"))));
            this.queryParameter.setSourcePeriod(period);
        }
        if (cp.getCustomerParam("inPeriodID") != null) {
            period = new BgPeriodInfo();
            period.setId(BOSUuid.read((String)cp.getCustomerParam("inPeriodID")));
            period.setNumber(cp.getCustomerParam("inPeriodNumber"));
            period.setName(cp.getCustomerParam("inPeriodName"));
            period.setPeriodType(BgPeriodEnum.getEnum((int)Integer.valueOf(cp.getCustomerParam("inPeriodType"))));
            period.setBeginDate(new Date(Long.valueOf(cp.getCustomerParam("inBeginDate"))));
            period.setEndDate(new Date(Long.valueOf(cp.getCustomerParam("inEndDate"))));
            this.queryParameter.setTargetPeriod(period);
        }
        if (cp.getCustomerParam("currencyID") != null) {
            info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("currencyID")));
            info.setNumber(cp.getCustomerParam("currencyNumber"));
            info.setName(cp.getCustomerParam("currencyName"));
            this.queryParameter.setCurrency((CurrencyInfo)info);
        }
        if (cp.getCustomerParam("elementID") != null) {
            info = new BgElementInfo();
            info.setId(BOSUuid.read((String)cp.getCustomerParam("elementID")));
            info.setNumber(cp.getCustomerParam("elementNumber"));
            info.setName(cp.getCustomerParam("elementName"));
            this.queryParameter.setBgElement((BgElementInfo)info);
        }
        if (cp.getCustomerParam("rowSize") != null) {
            int rowCount = Integer.valueOf(cp.getCustomerParam("rowSize"));
            List<BgDimensionMember[]> members = this.queryParameter.getMembers();
            members.clear();
            for (int index = 0; index < rowCount; ++index) {
                BgDimensionMember[] me = new BgDimensionMember[2];
                BgDimensionMember member = new BgDimensionMember(cp.getCustomerParam("index_type_" + index), cp.getCustomerParam("index_att_" + index), cp.getCustomerParam("index_name_" + index), cp.getCustomerParam("index_number_" + index));
                member.setSrcNumber(cp.getCustomerParam("index_srcnumber_" + index));
                me[0] = member;
                if (Boolean.valueOf(cp.getCustomerParam("hasItemCombin_" + index)).booleanValue()) {
                    member = new BgDimensionMember(cp.getCustomerParam("itemCombin_type_" + index), cp.getCustomerParam("itemCombin_att_" + index), cp.getCustomerParam("itemCombin_name_" + index), cp.getCustomerParam("itemCombin_number_" + index));
                    member.setSrcNumber(cp.getCustomerParam("itemCombin_srcnumber_" + index));
                    me[1] = member;
                }
                members.add(me);
            }
        }
    }

    protected void showFilter() throws EASBizException, BOSException {
        if (!this.getQueryDialog().show()) {
            SysUtil.abort();
        }
        if (this.getQueryDialog().getUserPanel(0) instanceof BgAdjustBillBalanceFilterUI) {
            BgAdjustBillBalanceFilterUI filterUI = (BgAdjustBillBalanceFilterUI)this.getQueryDialog().getUserPanel(0);
            this.queryParameter = filterUI.getQueryParameter();
            this.doQuery();
            this.reSetUI();
        }
    }

    protected void doQuery() throws EASBizException, BOSException {
        KDTable table = this.getTable();
        table.removeRows();
        table.checkParsed();
        if (this.queryParameter == null) {
            return;
        }
        Object ob = BgAdjustBillFacadeFactory.getRemoteInstance().queryCtrlBgDataByParameter(this.queryParameter);
        if (!(ob instanceof IBudgetBalance)) {
            return;
        }
        IBudgetBalance balance = (IBudgetBalance)ob;
        List data = balance.getBalance();
        if (data == null || data.isEmpty()) {
            return;
        }
        this.fillDataToTable(data);
    }

    protected void fillDataToTable(List<BgControlParam> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        KDTable table = this.getTable();
        table.removeRows();
        table.checkParsed();
        String companyId = this.company.getId().toString();
        String accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme(this.queryParameter.getBgScheme());
        for (int index = 0; index < dataList.size(); ++index) {
            BgControlParam data = dataList.get(index);
            IRow row = table.addRow();
            row.setUserObject((Object)data);
            String dimName = data.getDimItemName();
            String dimNumber = data.getDimItemNumber();
            if (!StringUtils.isEmpty((String)dimName)) {
                String[] dimNames = dimName.split("_");
                String[] dimNumbers = dimNumber.split(",");
                row.getCell(COL_INDEXMEMBER).setValue((Object)this.getCellHelper().getIndexDisplayName(accountViewId, data.getBgIndexNumber(), dimNames[0]));
                if (dimNames.length > 1) {
                    row.getCell(COL_COMBINMEMBER).setValue((Object)this.getMemberComRender(dimNames, dimNumbers));
                }
            }
            row.getCell(COL_SELECT).setValue((Object)false);
            row.getCell(COL_ORGUNIT).setValue((Object)data.getOrgUnit().getName());
            row.getCell(COL_ELEMENT).setValue((Object)data.getBgElement().getName());
            row.getCell(COL_CURRENCY).setValue((Object)data.getCurrency().getName());
            row.getCell(COL_CTRLWAY).setValue((Object)data.getControlSetting().getCtrlType());
            row.getCell(COL_CTRLPERIOD).setValue((Object)data.getControlSetting().getPeriodType());
            row.getCell(COL_RATIO).setValue((Object)data.getControlSetting().getFlexParam());
            row.getCell(COL_BUDGETVALUE).setValue((Object)data.getBudgetValue());
            row.getCell(COL_ACTUALVALUE).setValue((Object)data.getActualValue());
            row.getCell(COL_BALANCEVALUE).setValue((Object)data.getBalance());
            if (data.getBalance() instanceof BigDecimal && data.getBalance().compareTo(new BigDecimal("0.00")) > 0) {
                row.getStyleAttributes().setLocked(false);
                continue;
            }
            row.getStyleAttributes().setLocked(true);
        }
        this.getTable().getColumn(COL_BGDATAID).getStyleAttributes().setHided(true);
    }

    private String getMemberComRender(String[] dimNames, String[] dimNumbers) {
        String displayName = null;
        if (dimNames.length > 1 && dimNumbers.length > 1) {
            String[] newDimNames = dimNames[1].split(",");
            String[] newDimNumbers = new String[dimNumbers.length - 1];
            int index = 0;
            int i = 1;
            while (i < dimNumbers.length) {
                newDimNumbers[index] = dimNumbers[i];
                ++i;
                ++index;
            }
            if (newDimNames.length == newDimNumbers.length) {
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < newDimNumbers.length; ++i) {
                    String number;
                    String string = number = newDimNumbers[i].split(":").length > 1 ? newDimNumbers[i].split(":")[1] : newDimNumbers[i];
                    if (i != newDimNumbers.length - 1) {
                        sb.append(number + "(" + newDimNames[i] + "),");
                        continue;
                    }
                    sb.append(number + "(" + newDimNames[i] + ")");
                }
                displayName = sb.toString();
            }
        }
        return displayName;
    }

    protected void reSetUI() {
        if (this.queryParameter == null) {
            return;
        }
        BgPeriodDialog dia = new BgPeriodDialog((CoreUIObject)this);
        this.prmtOutPeriod.setSelector((KDPromptSelector)dia);
        this.prmtInPeriod.setSelector((KDPromptSelector)dia);
        this.prmtOutPeriod.setData((Object)this.queryParameter.getSourcePeriod());
        this.prmtInPeriod.setData((Object)this.queryParameter.getTargetPeriod());
        this.prmtBgScenario.setData((Object)this.queryParameter.getBgScenario());
        this.prmtBgVersion.setData((Object)this.queryParameter.getBgVersion());
    }

    protected void periodChange(DataChangeEvent e) {
        if (this.queryParameter == null) {
            return;
        }
        BgSchemeInfo schemeInfo = this.queryParameter.getBgScheme();
        if (e.getNewValue() instanceof BgPeriodInfo) {
            BgPeriodInfo info = (BgPeriodInfo)e.getNewValue();
            if (this.queryParameter.getTargetPeriod().getPeriodType().getValue() != info.getPeriodType().getValue()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"periodTypeError"));
                ((KDBizPromptBox)e.getSource()).setData(e.getOldValue());
                SysUtil.abort();
            } else if (schemeInfo != null && schemeInfo.getDateFrom() != null && schemeInfo.getDateTo() != null) {
                Date from = schemeInfo.getDateFrom();
                Date to = schemeInfo.getDateTo();
                if (from != null && to != null && (info.getBeginDate().getTime() < from.getTime() || info.getBeginDate().getTime() > to.getTime())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"periodRangoutScheme"));
                    ((KDBizPromptBox)e.getSource()).setDataNoNotify(e.getOldValue());
                    SysUtil.abort();
                }
            } else if ("prmtInPeriod".equals(((KDBizPromptBox)e.getSource()).getName())) {
                this.queryParameter.setTargetPeriod(info);
            } else {
                this.queryParameter.setSourcePeriod(info);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtOutPeriod.setEnabled(false);
        this.prmtBgScenario.setEnabled(false);
        this.prmtBgVersion.setEnabled(false);
        this.setButtonState(this.btnReflush, true, true, "imgTbtn_refresh");
        this.setButtonState(this.btnQuery, true, true, "imgTbtn_filter");
        this.setButtonState(this.btnSelAll, true, true, "imgTbtn_selectall");
        this.setButtonState(this.btnClearAll, true, true, "imgTbtn_deleteall");
        this.setButtonState(this.btnAdjust, true, true, "imgTbtn_replace");
        this.setButtonState(this.btnPrint, true, true, "imgTbtn_print");
        this.setButtonState(this.btnPrintView, true, true, "imgTbtn_preview");
        this.setButtonState(this.btnExport, true, true, "imgTbtn_importexcel");
    }

    private void setButtonState(KDWorkButton btn, boolean isVisible, boolean isEnable, String icoName) {
        if (btn == null) {
            return;
        }
        btn.setEnabled(isEnable);
        btn.setVisible(isVisible);
        if (!StringUtils.isEmpty((String)icoName)) {
            btn.setIcon(EASResource.getIcon((String)icoName));
        }
    }

    @Override
    public void actionReflush_actionPerformed(ActionEvent e) throws Exception {
        this.doQuery();
    }

    @Override
    public void actionQueryFilter_actionPerformed(ActionEvent e) throws Exception {
        this.showFilter();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectRow(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectRow(false);
    }

    private void selectRow(boolean isSelect) {
        if (this.getTable() == null || this.getTable().getRowCount() == 0) {
            return;
        }
        for (int index = 0; index < this.getTable().getRowCount(); ++index) {
            if (this.getTable().getRow(index).getStyleAttributes().isLocked()) continue;
            this.getTable().getRow(index).getCell(COL_SELECT).setValue((Object)isSelect);
            if (this.getTable().getRow(index).getCell(COL_ADJUSTVALUE).getValue() != null) continue;
            this.getTable().getRow(index).getCell(COL_ADJUSTVALUE).setValue(this.getTable().getRow(index).getCell(COL_BALANCEVALUE).getValue());
        }
    }

    @Override
    public void actionCreateAdjustBill_actionPerformed(ActionEvent e) throws Exception {
        List msg;
        if (!(this.prmtInPeriod.getData() instanceof BgPeriodInfo) || !(this.prmtOutPeriod.getData() instanceof BgPeriodInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"periodInOrOutNotEmpty"));
            SysUtil.abort();
        }
        if (this.getTable().getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"notBalanceValue"));
            SysUtil.abort();
        }
        ArrayList<BgControlParam> dataList = new ArrayList<BgControlParam>();
        KDTable table = this.getTable();
        for (int index = 0; index < table.getRowCount(); ++index) {
            IRow row = table.getRow(index);
            if (!Boolean.valueOf(row.getCell(COL_SELECT).getValue().toString()).booleanValue() || !(row.getUserObject() instanceof BgControlParam) || row.getStyleAttributes().isLocked() || row.getCell(COL_ADJUSTVALUE).getValue() == null) continue;
            BgControlParam param = (BgControlParam)row.getUserObject();
            BigDecimal balanceValue = new BigDecimal(row.getCell(COL_ADJUSTVALUE).getValue().toString());
            if (balanceValue.compareTo(param.getBalance()) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"checkBalance"));
                SysUtil.abort();
            }
            if (balanceValue.compareTo(new BigDecimal("0.00")) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"notZero"));
                SysUtil.abort();
            }
            param.setOverBalance(balanceValue);
            dataList.add(param);
        }
        if (dataList.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"pleaseSelectRow"));
            SysUtil.abort();
        }
        this.queryParameter.setOverDataList(dataList);
        Object ob = BgAdjustBillFactory.getRemoteInstance().balanceOver(this.queryParameter);
        if (ob instanceof List && !(msg = (List)ob).isEmpty()) {
            StringBuffer msgDetail = new StringBuffer();
            int size = msg.size();
            for (int index = 0; index < size; ++index) {
                msgDetail.append(EASResource.getString((String)RES, (String)"overDetailMsg", (Object[])((Object[])msg.get(index)))).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"overSuccess", (Object[])new Object[]{msg.size()}), (String)msgDetail.toString(), (int)1);
        }
        this.destroyWindow();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.getTable());
        this.getTable().getPrintManager().print();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.getTable());
        this.getTable().getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    protected KDTable getTableForCommon() {
        return this.getTable();
    }

    protected CommonQueryDialog getQueryDialog() {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDialog.setEntityViewInfo(new EntityViewInfo());
            this.queryDialog.setQueryObjectPK(this.mainQueryPk);
            this.queryDialog.setTitle(EASResource.getString((String)RES, (String)"titleBalanceOver"));
            this.queryDialog.setWidth(this.getWidthOfDialog());
            this.queryDialog.setHeight(this.getHeightOfDialog());
            this.queryDialog.addUserPanel(this.getFilterUI());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
        }
        return this.queryDialog;
    }

    protected int getWidthOfDialog() {
        return 415;
    }

    protected int getHeightOfDialog() {
        return 450;
    }

    protected KDPanel getFilterUI() {
        if (this.filterPanel == null) {
            try {
                this.filterPanel = new BgAdjustBillBalanceFilterUI();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.filterPanel;
    }

    protected KDTable getTableForPrintSetting() {
        return this.getTable();
    }

    protected KDTable getTable() {
        return this.kDTable1;
    }
}

