/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgAdjustBillTypeEnum;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgAdjustFormProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.BgAdjustProcessHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.MBGAdjustBillHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class BgAdjustFormProcessUI
extends AbstractBgAdjustFormProcessUI {
    private static final long serialVersionUID = -8479804071058749332L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustFormProcessUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgAdjustBillResource";
    private DimensionMemberCheckFactory checkFactory = null;
    private List formulaList = null;
    private boolean isClearEntry = false;

    public boolean isClearEntry() {
        return this.isClearEntry;
    }

    public void setClearEntry(boolean isClearEntry) {
        this.isClearEntry = isClearEntry;
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuRightClear.setVisible(false);
        this.menuItemRPasteSelective.setVisible(false);
        this.itemRCSetFormula.setVisible(false);
        this.menuItemRCMultiModifyExp.setVisible(false);
        this.menuItemRCMultiModifyExp.setVisible(false);
        this.menuItemRCCreateBgFormula.setVisible(false);
        this.menuRCBgFormula.setVisible(false);
        this.menuRemoveItem.setVisible(false);
        this.menuRCBgLink.setVisible(false);
        this.rMenuSendMail.setVisible(false);
        this.rMenuPublishReport.setVisible(false);
        this.menuItemRCCreateBgFormula.setVisible(false);
        this.menuRCBgFormulaToExp.setVisible(false);
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").setVisible(false);
        toolBarManager.getToolBar("common").removeAllToolBarComponents();
        toolBarManager.getToolBar("common").add((Action)this.actionExitCurrent);
        this.btnBlockSetting.setEnabled(true);
        this.btnBlockSetting.setVisible(true);
        this.actionBlockSetting.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        this.actionBlockSetting.setEnabled(true);
        toolBarManager.getToolBar("common").add((Action)((Object)this.actionBlockSetting));
    }

    @Override
    public void actionBlockSetting_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<ItemFormula> list = new ArrayList<ItemFormula>();
        Book book = this.getBook();
        Range range = book.getActiveSheet().getSelectionRange();
        Sheet sheet = book.getActiveSheet();
        IMbgViewManager dimensionManager = (IMbgViewManager)DimensionCommonHelper.getBgFormView(null, (BgFormInfo)this.getEditData());
        String orgUnitId = ((BgFormInfo)this.getEditData()).getOrgUnit().getId().toString();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= Math.min(sheet.getMaxRowIndex(), block.getRow2()); ++j) {
                for (int k = block.getCol(); k <= Math.min(sheet.getMaxColIndex(), block.getCol2()); ++k) {
                    Cell cell = sheet.getCell(j, k, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
                    String _itemFormula = itemFormula.getFormula();
                    String ext = itemFormula.getExt("ORGUNITID");
                    if (ext != null) {
                        orgUnitId = ext;
                    }
                    if (!DimensionClientHelper.isDetailDataCell(this.getBgFormInfo(), this.getCheckFactory(), _itemFormula, orgUnitId, dimensionManager, this.getEditScenario()) || list.contains(itemFormula)) continue;
                    list.add(itemFormula);
                }
            }
        }
        if (list.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_MESSAGE_SELECT_DETAILED_CELL"));
            return;
        }
        if (!this.checkFormulasMatchAdjustRule(list)) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"membersNotInRule"));
            return;
        }
        this.setFormulaList(list);
        BgAdjustProcessHelper bgAdjustProcessHelper = new BgAdjustProcessHelper(this.getUIContext(), RESOURCE, (Component)((Object)this));
        boolean checkIsSameDim = bgAdjustProcessHelper.checkIsSameDim(list);
        if (checkIsSameDim) {
            this.getUIWindow().close();
        } else {
            this.setFormulaList(null);
        }
    }

    protected boolean checkFormulasMatchAdjustRule(List<ItemFormula> formulaList) throws EASBizException, BOSException {
        if (this.getUIContext().get(BgBaseConstants.ADJUST_WAY) instanceof BgAdjustBillTypeEnum && this.getUIContext().get("BGSCHEME_HELPER") instanceof BgSchemeDimensionHelper && this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo) {
            BgSchemeDimensionHelper schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
            BgAdjustBillTypeEnum bgAdjustBillType = (BgAdjustBillTypeEnum)((Object)this.getUIContext().get(BgBaseConstants.ADJUST_WAY));
            String currentOrgNumber = ((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getNumber();
            return MBGAdjustBillHelper.checkFormulasMatchAdjustRule((CoreUI)this, schemeHelper, bgAdjustBillType, currentOrgNumber, formulaList);
        }
        return true;
    }

    public DimensionMemberCheckFactory getCheckFactory() throws EASBizException, BOSException {
        if (this.checkFactory == null) {
            this.checkFactory = this.createCheckFactory();
        }
        return this.checkFactory;
    }

    protected DimensionMemberCheckFactory createCheckFactory() throws EASBizException, BOSException {
        BgFormInfo bgForm = (BgFormInfo)this.getEditData();
        DimensionMemberCheckFactory checkFactory = new DimensionMemberCheckFactory(null, bgForm.getBgTemplate().getId().toString(), this.getSchemeHelper(), this.isDecompose());
        return checkFactory;
    }

    @Override
    public boolean isDecompose() {
        if (this.getBgFormInfo() instanceof BgFormInfo) {
            return this.getBgFormInfo().isDecompose();
        }
        return false;
    }
}

