/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgAdjustRuleFactory;
import com.kingdee.eas.ma.mbg.BgAdjustRuleInfo;
import com.kingdee.eas.ma.mbg.BgAdjustRuleStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgAdjustRule;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgAdjustRuleListUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustRuleEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustRuleListUI
extends AbstractBgAdjustRuleListUI {
    private static final long serialVersionUID = -7280818538678215412L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustRuleListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterOnLoad();
    }

    protected void afterOnLoad() {
        this.initCostCenter();
        this.prmtCostCenter.setEditable(false);
        this.prmtBgScheme.setEditable(false);
    }

    private void initCostCenter() {
        this.prmtCostCenter.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setPermissionItem(this.getPermissionNum());
        f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtCostCenter.setSelector((KDPromptSelector)f7);
    }

    protected String getPermissionNum() {
        return "mbg_bgAdjustRule00_list";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        viewInfo = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone();
        if (this.prmtBgScheme.getData() == null) {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
            return super.getQueryExecutor(queryPK, viewInfo);
        }
        this.filterQuery(viewInfo);
        IQueryExecutor exc = super.getQueryExecutor(queryPK, viewInfo);
        return exc;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void filterQuery(EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        try {
            MbgPermissionHelper.addBgSchemePermission(null, this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter, "bgscheme.id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.prmtBgScheme.getData() != null) {
            BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)((BgSchemeInfo)this.prmtBgScheme.getData()).getNumber()));
        }
        try {
            if (viewInfo.getFilter() != null) {
                viewInfo.getFilter().mergeFilter(filter, "AND");
            } else {
                viewInfo.setFilter(filter);
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtCostCenter.getData());
        if (this.prmtBgScheme.getData() != null) {
            uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
        }
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        OrgUnitInfo oldInfo = (OrgUnitInfo)e.getOldValue();
        OrgUnitInfo newInfo = (OrgUnitInfo)e.getNewValue();
        if (newInfo == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
            this.prmtCostCenter.setDataNoNotify(e.getOldValue());
        } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
            this.setBgSchemeFilter();
            this.refreshList();
        }
    }

    public void setBgSchemeFilter() throws Exception {
        this.setBgSchemeView();
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), ((OrgUnitInfo)this.prmtCostCenter.getData()).getId());
    }

    protected void setBgSchemeView() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)((OrgUnitInfo)this.prmtCostCenter.getValue()).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgSchemeType.schemeType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
        this.prmtBgScheme.setEntityViewInfo(view);
        Set<String> tmpList = BgNFCHelper.getBgSchemeIds(((OrgUnitInfo)this.prmtCostCenter.getValue()).getId());
        BgNFCHelper.setSchemeIdFilter(tmpList, filter);
        filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        try {
            if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
                this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
                this.bgSchemeChanged(newInfo);
            }
        }
        finally {
            this.prmtBgScheme.setUserObject(null);
        }
        this.refreshList();
    }

    protected void bgSchemeChanged(BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        if (bgSchemeInfo != null) {
            // empty if block
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        super.actionAddNew_actionPerformed(e);
        this.afterShow();
    }

    public void afterShow() {
        IUIWindow uiWindow = super.getUIController().getNavigator().getUIWindow();
        if (uiWindow != null && uiWindow.getUIObject() instanceof BgAdjustRuleEditUI) {
            ((BgAdjustRuleEditUI)uiWindow.getUIObject()).afterShow();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (!StringUtils.isEmpty((String)id) && BgAdjustRuleFactory.getRemoteInstance().getBgAdjustRuleInfo("select id, state where id = '" + id + "'").getState().equals((Object)BgAdjustRuleStateEnum.SAVED)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"invalidStateEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (!StringUtils.isEmpty((String)id)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("bgScenarios");
            sic.add("bgElements");
            sic.add("currencys");
            sic.add("bgVersions");
            sic.add("bgPeriods");
            sic.add("orgUnit.id");
            sic.add("bgScheme.id");
            sic.add("bgScheme.number");
            sic.add("bgScheme.name");
            sic.add("lastUpdateUser.id");
            sic.add("lastUpdateUser.number");
            sic.add("lastUpdateUser.name");
            sic.add("creator.id");
            sic.add("creator.number");
            sic.add("creator.name");
            sic.add("entry.*");
            BgAdjustRuleInfo info = BgAdjustRuleFactory.getRemoteInstance().getBgAdjustRuleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())), sic);
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setState(BgAdjustRuleStateEnum.TMPSAVED);
            info.setNumber(null);
            info.setName(null);
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            UIContext uicontext = new UIContext((Object)this);
            uicontext.put((Object)"InitDataObject", (Object)info);
            uicontext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtCostCenter.getData());
            if (this.prmtBgScheme.getData() != null) {
                uicontext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
            }
            IUIWindow copyUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uicontext, null, OprtState.COPYADDNEW);
            copyUI.show();
            this.refreshList();
            if (copyUI.getUIObject() instanceof BgAdjustRuleEditUI) {
                ((BgAdjustRuleEditUI)copyUI.getUIObject()).afterShow();
            }
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        this.checkSelected();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getSelectedKeyValue());
        ((IBgAdjustRule)this.getBizInterface()).cancelCancel(ids);
        this.refreshList();
        this.tblMain.getSelectManager().select(selectIndex, 0);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        this.checkSelected();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getSelectedKeyValue());
        ((IBgAdjustRule)this.getBizInterface()).cancel(ids);
        this.refreshList();
        this.tblMain.getSelectManager().select(selectIndex, 0);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        super.actionRemove_actionPerformed(e);
    }

    protected void Remove() throws Exception {
        super.Remove();
    }

    protected void isBgSchemeIsFiling() throws EASBizException, BOSException {
        BgSchemeInfo scheme;
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            SysUtil.abort();
        } else if (this.prmtBgScheme.getData() instanceof BgSchemeInfo && (scheme = (BgSchemeInfo)this.prmtBgScheme.getData()) != null) {
            BgSchemeFactory.getRemoteInstance().checkFilling(scheme.getId().toString());
        }
    }

    protected String getEditUIName() {
        return BgAdjustRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAdjustRuleFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }
}

