/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.client.BgElimContextManager;
import com.kingdee.eas.ma.mbg.BgAnalysRptDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateCollection;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateInfo;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateNodeInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.IBgAnalysRptDispatchFacade;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.client.AbstractBgAnalysRptDispatchUI;
import com.kingdee.eas.ma.mbg.client.BgPropertyChooseUI;
import com.kingdee.eas.ma.mbg.client.SearchKeyEnum;
import com.kingdee.eas.ma.mbg.client.analysisReport.BgAnalysRptDispatchReportUI;
import com.kingdee.eas.ma.mbg.designer.IAction;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.analysisReport.BgAnalysRptDispatchUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgAnalysRptDispatchUI
extends AbstractBgAnalysRptDispatchUI {
    private static final long serialVersionUID = -3908856334478019843L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalysRptDispatchUI.class);
    private static final String COL_SELECT = "select";
    private static final Color NO_DISPATCHED = Color.BLACK;
    private static final Color DISPATCHED_BY_CURRSCHEME = Color.RED;
    private static final Color NOFINANCE = Color.GRAY;
    protected Set<String> selectIds = null;
    private Set<BOSUuid> companyIds = new HashSet<BOSUuid>();
    private Map<BOSUuid, Set<BgAnalysRptTemplateNodeInfo>> dispatchMap = new HashMap<BOSUuid, Set<BgAnalysRptTemplateNodeInfo>>();
    private TreeModel oldTree = null;
    private TreeModel oldCslTree = null;
    private TreeWillExpandListener listener = null;
    private BgAnalysRptTemplateCollection temColls = new BgAnalysRptTemplateCollection();
    private KDPopupMenu popMenu = new KDPopupMenu();
    private KDPopupMenu cslPopMenu = new KDPopupMenu();
    private LongTimeDialog dialog = null;
    private LongTimeDialog dialogCsl = null;
    private boolean isRefeshOrgUnitTree = false;

    public Set<String> getSelectIds() {
        return this.selectIds;
    }

    public void setSelectIds(Set<String> selectIds) {
        this.selectIds = selectIds;
    }

    public Set<BOSUuid> getCompanyIds() {
        return this.companyIds;
    }

    public Map<BOSUuid, Set<BgAnalysRptTemplateNodeInfo>> getDispatchMap() {
        return this.dispatchMap;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public TreeModel getOldCslTree() {
        return this.oldCslTree;
    }

    public void setOldCslTree(TreeModel oldCslTree) {
        this.oldCslTree = oldCslTree;
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public BgAnalysRptTemplateCollection getTemColls() {
        return this.temColls;
    }

    protected String getBgSchemeId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
    }

    protected BgSchemeInfo getBgScheme() {
        return (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
    }

    protected String getBgOrgViewId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGORGVIEW_ID);
    }

    protected String getOrgUnitId() {
        return (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        super.onLoad();
        if (this.getUIContext().get("selectTemplates") != null) {
            this.setSelectIds((Set)this.getUIContext().get("selectTemplates"));
        } else {
            this.setSelectIds(new HashSet<String>());
        }
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.comCslOrgView.setEnabled(false);
        this.comCslOrgView.setEditable(false);
    }

    protected void initListener() {
        super.initListener();
        this.treeOrgUnit.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                BgAnalysRptDispatchUI.this.treeOrgUnit_nodeStateChange(event);
            }
        });
        this.iniPoppMenu();
    }

    protected String getSelectOrgViewId() {
        return this.getBgOrgViewId();
    }

    protected void init() throws Exception {
        BgOrgTreeHelper.resetAction(this.treeViewOrgUnit, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgAnalysRptDispatchUI.this.loadOrgUnitTree();
                TreeNode root = (TreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getModel().getRoot();
                BgAnalysRptDispatchUI.this.treeOrgUnit.expandAllNodes(true, root);
            }
        });
        BgOrgTreeHelper.resetAction(this.treeViewCslUnit, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgAnalysRptDispatchUI.this.loadCslUnitTree();
                TreeNode root = (TreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getModel().getRoot();
                BgAnalysRptDispatchUI.this.treeCslUnit.expandAllNodes(true, root);
            }
        });
        this.initData();
        this.initBgOrgUnit();
        this.initBgTemplate();
        this.initCslTreeComb();
        this.initCslOrgUnit();
    }

    protected void initData() throws Exception {
        this.initCompanyIds();
        this.initDispatchData();
    }

    protected void initCslTreeComb() throws Exception {
        boolean isElimContextSetted = BgElimContextManager.getInstance().isElimContextSetted();
        if (isElimContextSetted) {
            BgElimContextHelper.isInitialized((CoreUIObject)this, (Map)this.getUIContext());
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.getBgSchemeId());
        BgDimSettingsInfo setinfo = schemeHelper.getDimSettingMap().get(DimensionConstants.DEF_ORGUNIT_NUMBER);
        HashSet<String> schemeTreeIds = new HashSet<String>();
        if (setinfo.getMembers() != null && setinfo.getMembers().size() > 0) {
            BgDimSettingsMemberCollection colls = setinfo.getMembers();
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getType().getValue() != 3) continue;
                schemeTreeIds.add(colls.get(i).getMemberID().toString());
            }
        }
        OrgTreeInfo orgTreeInfo = BgElimContextHelper.getBgElimContext().getCurOrgBound();
        OrgTreeCollection colls = BgEliminationHelper.getOrgTreeCollection();
        for (int i = 0; i < colls.size(); ++i) {
            if (!schemeTreeIds.contains(colls.get(i).getId().toString())) continue;
            this.comCslOrgView.addItem((Object)colls.get(i));
            if (orgTreeInfo == null || !orgTreeInfo.getId().equals((Object)colls.get(i).getId())) continue;
            this.comCslOrgView.setSelectedItem((Object)colls.get(i));
        }
    }

    protected boolean isContainSealUp() {
        return false;
    }

    protected void initBgOrgUnit() throws Exception {
        String schemeOrgId = this.getBgScheme().getOrgUnit().getId().toString();
        if (!schemeOrgId.equals(this.getOrgUnitId())) {
            String bgOrgId = BgOrgUnitUtils.getBgOrgUnitIdByOrgUnitId(this.getOrgUnitId(), this.getSelectOrgViewId(), false);
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, bgOrgId, this.getListener(), this.getSelectOrgViewId(), true, null, false, this.isContainSealUp()));
        } else {
            this.setOldTree(BgOrgUnitUtils.loadBgOrgTreeModel(this.treeOrgUnit, null, this.getListener(), this.getSelectOrgViewId(), true, null, false, this.isContainSealUp()));
        }
        this.setRefeshOrgUnitTree(false);
        this.treeOrgUnit.setRootVisible(false);
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.setModel(this.getOldTree());
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitId(), null);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        this.treeOrgUnit.expandOnLevel(3);
    }

    protected void initCslOrgUnit() throws Exception {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.comCslOrgView.getSelectedItem();
        if (treeInfo == null) {
            this.treeCslUnit.setModel(null);
            return;
        }
        CtrlUnitInfo ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPK = new ObjectUuidPK(ctrlInfo.getId());
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        TreeModel treeModel = OrgF7InnerUtils.buildUnionTreeModel((IObjectPK)cuPK, (IObjectPK)userPK, (String)treeInfo.getId().toString(), (String)this.getOrgUnitId(), (boolean)false, (boolean)false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        BgEliminationHelper.traceUnionDebtTreeForBudget((DefaultKingdeeTreeNode)root);
        List orgIdList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        BgEliminationHelper.traceUnionDebtTreeInOrgRange((ObjectUuidPK)userPK, (DefaultKingdeeTreeNode)root, (List)orgIdList);
        BgAnalysRptDispatchUI.traceUnionDebtTreeInOrgRange(userPK, root, orgIdList);
        if (root != null) {
            root.setChecked(false);
        }
        this.setOldCslTree(treeModel);
        this.treeCslUnit.setRootVisible(true);
        this.treeCslUnit.setShowCheckBox(true);
        this.treeCslUnit.setModel(this.getOldCslTree());
        BgBaseHelper.setRootCannotClose((KDTree)this.treeCslUnit);
        this.treeCslUnit.expandOnLevel(2);
    }

    public static void traceUnionDebtTreeInOrgRange(ObjectUuidPK userPK, DefaultKingdeeTreeNode root, List orgIdList) {
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            oui = (OrgStructureInfo)root.getUserObject();
            info = oui.getUnit();
            if (!orgIdList.contains(info.getId().toString())) {
                root.setCheckBoxVisible(false);
                root.setCheckBoxEnabled(false);
            }
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!orgIdList.contains(info.getId().toString())) {
                    node.setCheckBoxVisible(false);
                    node.setCheckBoxEnabled(false);
                    continue;
                }
                if (node.isLeaf()) continue;
                BgAnalysRptDispatchUI.traceUnionDebtTreeInOrgRange(userPK, node, orgIdList);
            }
        }
    }

    protected boolean isContainCancel() {
        return false;
    }

    protected void initBgTemplate() throws Exception {
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.temTable.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getTemColls().clear();
        BgAnalysRptTemplateCollection colls = this.getBgTemplateColls(this.getBgSchemeId(), this.getOrgUnitId());
        if (colls != null) {
            int i;
            BgAnalysRptTemplateInfo template = null;
            int in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (!this.isContainCancel() && BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus()) || !this.selectIds.contains(template.getId().toString())) continue;
                this.getTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, true);
            }
            in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (!this.isContainCancel() && BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus()) || this.selectIds.contains(template.getId().toString())) continue;
                this.getTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, false);
            }
            this.temTable.getSelectManager().select(0, 0);
        }
    }

    protected void addRowByTemplate(KDTable table, BgAnalysRptTemplateInfo template, boolean isChoose) {
        if (table == null || template == null) {
            return;
        }
        IRow row = this.temTable.addRow();
        row.setUserObject((Object)template);
        row.getCell("id").setValue((Object)template.getId());
        row.getCell(COL_SELECT).setValue((Object)isChoose);
        row.getCell("number").setValue((Object)template.getNumber());
        row.getCell("name").setValue((Object)template.getName());
        row.getCell("updator").setValue((Object)template.getCreator().getName());
        row.getCell("lastUpdateTime").setValue((Object)template.getCreateTime());
    }

    protected BgAnalysRptTemplateCollection getBgTemplateColls(String bgSchemeId, String orgUnitId) throws Exception {
        return BgAnalysRptDispatchUtils.getBgTemplateColls(bgSchemeId, orgUnitId);
    }

    protected void initCompanyIds() throws Exception {
        this.getCompanyIds().addAll(this.queryCompanyIds());
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return this.getDispatchInterface().queryCompanyIds();
    }

    protected void initDispatchData() throws Exception {
        this.getDispatchMap().clear();
        Map tmpMap = this.getDispatchInterface().queryDispatchInfo(BOSUuid.read((String)this.getBgSchemeId()));
        if (tmpMap != null) {
            Map disMap = (Map)tmpMap.get(BgSchemeDispatchConstants.SCHEME_DISPATCH);
            this.getDispatchMap().putAll(disMap);
        }
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    public KDPopupMenu getCslPopMenu() {
        return this.cslPopMenu;
    }

    protected void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        this.treeCslUnit.addMouseListener((MouseListener)new CslTreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"allLeafOrg"));
        menuItem.addActionListener((ActionListener)new AllLeafOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new AllSubOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectDispatch"));
        menuItem.addActionListener((ActionListener)new DispatchOrgUnitListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectCompany"));
        menuItem.addActionListener((ActionListener)new CompanyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"propertyChoose"));
        menuItem.addActionListener((ActionListener)new PropertyListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new CslSubOrgUnitListener());
        this.getCslPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"allsub"));
        menuItem.addActionListener((ActionListener)new CslAllSubOrgUnitListener());
        this.getCslPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"selectDispatch"));
        menuItem.addActionListener((ActionListener)new CslDispatchOrgUnitListener());
        this.getCslPopMenu().add((JMenuItem)menuItem);
    }

    protected void treeOrgUnit_nodeStateChange(TreeNodeStateChangeEvent event) {
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.fillDispatchInfo();
    }

    protected BgAnalysRptTemplateInfo getSelectedTemplate() {
        int rowIndex = this.temTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        IRow row = this.temTable.getRow(rowIndex);
        BgAnalysRptTemplateInfo template = (BgAnalysRptTemplateInfo)row.getUserObject();
        return template;
    }

    protected List<String> getSelectedTemplateIds() {
        ArrayList<String> selBgTemplateIds = new ArrayList<String>();
        Object obj = null;
        IRow row = null;
        BgAnalysRptTemplateInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgAnalysRptTemplateInfo)row.getUserObject();
            obj = row.getCell(COL_SELECT).getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            selBgTemplateIds.add(template.getId().toString());
        }
        return selBgTemplateIds;
    }

    protected void selectedTemplateIds(Collection<String> selBgTemplateIds) {
        IRow row = null;
        BgAnalysRptTemplateInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgAnalysRptTemplateInfo)row.getUserObject();
            if (selBgTemplateIds != null && selBgTemplateIds.contains(template.getId().toString())) {
                row.getCell(COL_SELECT).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
        }
    }

    protected List<String> getSelectedOrgUnitIds() {
        if (this.btnCslOrg.isSelected()) {
            return BgOrgUnitUtils.getSelectOrgUnitIds(this.treeCslUnit);
        }
        return BgOrgUnitUtils.getSelectOrgUnitIds(this.treeOrgUnit);
    }

    protected String getSelectTreeId() {
        OrgTreeInfo tree = (OrgTreeInfo)this.comCslOrgView.getSelectedItem();
        if (tree == null || tree.getId() == null) {
            return null;
        }
        return tree.getId().toString();
    }

    public void verifyData() throws Exception {
        List<String> bgOrgUnitIds;
        super.verifyData();
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)("selectBgTemplate" + this.getMessageFlag())));
            SysUtil.abort();
        }
        if ((bgOrgUnitIds = this.getSelectedOrgUnitIds()) == null || bgOrgUnitIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)("selectBgOrgUnit" + this.getMessageFlag())));
            SysUtil.abort();
        }
    }

    protected String getMessageFlag() {
        return "";
    }

    @Override
    protected void btnConferm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConferm_actionPerformed(e);
        this.verifyData();
        this.assign();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public boolean conferm(Object invokeUi) throws Exception {
        this.verifyData();
        this.assign();
        return false;
    }

    protected void assign() throws Exception {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                return BgAnalysRptDispatchUI.this.bgAnalysRptTemplateDispatch();
            }

            public void afterExec(Object result) throws Exception {
                List _result = (List)result;
                if (_result != null) {
                    KDTree tree = null;
                    tree = BgAnalysRptDispatchUI.this.btnCslOrg.isSelected() ? BgAnalysRptDispatchUI.this.treeCslUnit : BgAnalysRptDispatchUI.this.treeOrgUnit;
                    BgOrgTreeHelper.selectAllSubNode((DefaultKingdeeTreeNode)tree.getModel().getRoot(), false);
                    tree.repaint();
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH, (Object)Boolean.TRUE);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)_result);
                    uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)BgAnalysRptDispatchUI.this.getBgScheme());
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAnalysRptDispatchUI.this.getDispatchReportUIName(), (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
            }
        });
        this.dialog.show();
        this.setRefeshOrgUnitTree(false);
        this.initDispatchData();
        if (this.btnCslOrg.isSelected()) {
            this.refeshOrgUnitTree(this.getOldCslTree(), this.treeCslUnit);
        } else {
            this.refeshOrgUnitTree(this.getOldTree(), this.treeOrgUnit);
        }
    }

    protected List<String[]> bgAnalysRptTemplateDispatch() throws BOSException, EASBizException {
        return this.getDispatchInterface().dispatch(this.getParameter());
    }

    protected Map<String, Object> getParameter() {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put(BgBaseConstants.BGSCHEME_ID, this.getBgSchemeId());
        parameter.put(BgBaseConstants.BGTEMPLATE_ID, this.getSelectedTemplateIds());
        parameter.put(BgBaseConstants.ORGUNIT_ID, this.getSelectedOrgUnitIds());
        parameter.put(BgBaseConstants.UNIONGROUP_ID, this.btnCslOrg.isSelected() ? this.getSelectTreeId() : null);
        return parameter;
    }

    protected String getDispatchReportUIName() {
        return BgAnalysRptDispatchReportUI.class.getName();
    }

    protected String getPropertyChooseUIName() {
        return BgPropertyChooseUI.class.getName();
    }

    public boolean cancel() throws Exception {
        this.destroyWindow();
        return true;
    }

    public String getNewConfermLabel() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeResource", (String)"re.assign");
    }

    public LongTimeDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    private void loadOrgUnitTree() {
        this.loadOrgUnitTree(null);
    }

    public LongTimeDialog getDialogCsl() {
        return this.dialogCsl;
    }

    public void setDialogCsl(LongTimeDialog dialogCsl) {
        this.dialogCsl = dialogCsl;
    }

    private void loadCslUnitTree() {
        this.loadCslUnitTree(null);
    }

    private void loadOrgUnitTree(final IAction afterAction) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgAnalysRptDispatchUI.this.refeshOrgUnitTree(BgAnalysRptDispatchUI.this.getOldTree(), BgAnalysRptDispatchUI.this.treeOrgUnit);
                if (afterAction != null) {
                    afterAction.doAction();
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    private void loadCslUnitTree(final IAction afterAction) {
        if (this.dialogCsl == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialogCsl = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialogCsl = new LongTimeDialog((Dialog)win);
            }
            if (this.dialogCsl == null) {
                return;
            }
        }
        this.dialogCsl.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgAnalysRptDispatchUI.this.refeshOrgUnitTree(BgAnalysRptDispatchUI.this.getOldCslTree(), BgAnalysRptDispatchUI.this.treeCslUnit);
                if (afterAction != null) {
                    afterAction.doAction();
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialogCsl.show();
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void refeshOrgUnitTree(TreeModel treeModel, KDTree tree) throws Exception {
        if (!this.isRefeshOrgUnitTree() && treeModel != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            this.refeshOrgUnitTree(root);
            this.fillOrgUnitColor(tree);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1 && this.btnBgOrg.isSelected()) {
            try {
                BgOrgUnitUtils.addChildNode(root, this.getSelectOrgViewId(), false);
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    protected void fillOrgUnitColor(KDTree tree) throws Exception {
        BgAnalysRptTemplateInfo template = this.getSelectedTemplate();
        if (template != null) {
            this.fillOrgUnitColor(template, tree);
            tree.repaint();
        }
    }

    protected void fillOrgUnitColor(BgAnalysRptTemplateInfo template, KDTree tree) throws Exception {
        if (template == null || tree.getModel() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        this.fillOrgUnitColor(template, root);
    }

    protected void fillOrgUnitColor(BgAnalysRptTemplateInfo template, DefaultKingdeeTreeNode root) throws Exception {
        if (template == null || root == null) {
            return;
        }
        Set<BOSUuid> orgUnitIds = this.getFillOrgUnitIds(template);
        this.fillOrgUnitColor(root, orgUnitIds);
    }

    protected void fillOrgUnitColor(DefaultKingdeeTreeNode root, Set<BOSUuid> orgUnitIds) {
        if (root == null || orgUnitIds == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        BgOrgUnitInfo bgOrgUnit = null;
        BOSUuid uuid = null;
        if (this.btnCslOrg.isSelected()) {
            if (root.getUserObject() instanceof BgOrgUnitInfo) {
                bgOrgUnit = (BgOrgUnitInfo)root.getUserObject();
                uuid = BOSUuid.read((String)bgOrgUnit.getOrgUnitID());
            } else if (root.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)root.getUserObject();
                if (oui.getUnit() != null) {
                    uuid = oui.getUnit().getId();
                }
            } else if (root.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)root.getUserObject();
                uuid = tmpUnit.getId();
            }
            if (orgUnitIds.contains(uuid)) {
                root.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                root.setTextColor(NO_DISPATCHED);
            }
        }
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                bgOrgUnit = (BgOrgUnitInfo)node.getUserObject();
                uuid = BOSUuid.read((String)bgOrgUnit.getOrgUnitID());
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    uuid = oui.getUnit().getId();
                }
            } else if (node.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)node.getUserObject();
                uuid = tmpUnit.getId();
            }
            if (orgUnitIds.contains(uuid)) {
                node.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                node.setTextColor(NO_DISPATCHED);
            }
            if (node.isLeaf()) continue;
            this.fillOrgUnitColor(node, orgUnitIds);
        }
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_SELECT).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        boolean isCsl = this.btnCslOrg.isSelected();
        if (isCsl) {
            BgOrgUnitUtils.selectOrgUnit(this.treeCslUnit.getModel(), true);
            this.treeCslUnit.expandOnLevel(7);
            this.treeCslUnit.repaint();
        } else {
            BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), true);
            this.treeOrgUnit.expandOnLevel(7);
            this.treeOrgUnit.repaint();
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        boolean isCsl = this.btnCslOrg.isSelected();
        if (isCsl) {
            if (this.treeCslUnit.getModel() == null) {
                return;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeCslUnit.getModel().getRoot();
            if (node == null) {
                node = (DefaultKingdeeTreeNode)this.treeCslUnit.getModel().getRoot();
            }
            BgOrgUnitUtils.selectOrgUnit(node, false);
            this.treeCslUnit.repaint();
        } else {
            if (this.treeOrgUnit.getModel() == null) {
                return;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            if (node == null) {
                node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            }
            BgOrgUnitUtils.selectOrgUnit(node, false);
            this.treeOrgUnit.repaint();
        }
    }

    @Override
    protected void txtKey_focusLost(FocusEvent e) throws Exception {
        super.txtKey_focusLost(e);
        this.doSearch();
    }

    @Override
    public void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.doSearch();
    }

    private Set<BOSUuid> getFillOrgUnitIds(BgAnalysRptTemplateInfo template) {
        Set<BgAnalysRptTemplateNodeInfo> nodeInfos;
        HashSet<BOSUuid> orgUnitIds = new HashSet<BOSUuid>();
        if (template != null && (nodeInfos = this.getDispatchMap().get(template.getId())) != null) {
            for (BgAnalysRptTemplateNodeInfo nodeInfo : nodeInfos) {
                if (!this.btnCslOrg.isSelected()) {
                    orgUnitIds.add(nodeInfo.getOrgUnit().getId());
                    continue;
                }
                if (nodeInfo.getTreeID() != null) {
                    if (!nodeInfo.getTreeID().toString().equals(this.getSelectTreeId())) continue;
                    orgUnitIds.add(nodeInfo.getOrgUnit().getId());
                    continue;
                }
                orgUnitIds.add(nodeInfo.getOrgUnit().getId());
            }
        }
        return orgUnitIds;
    }

    protected void doSearch() {
        boolean isCsl = this.btnCslOrg.isSelected();
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)((Object)this.comSearchKey.getSelectedItem());
        if (StringUtils.isEmpty((String)value)) {
            this.restartTemplateColls(this.getTemColls());
            if (!isCsl) {
                this.treeOrgUnit.setModel(this.getOldTree());
                this.treeOrgUnit.updateUI();
                BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
            } else {
                this.treeCslUnit.setModel(this.getOldCslTree());
                this.treeCslUnit.updateUI();
                BgOrgUnitUtils.selectOrgUnit(this.treeCslUnit.getModel(), false);
            }
            return;
        }
        BgAnalysRptTemplateInfo template = this.getSelectedTemplate();
        Set<BOSUuid> orgUnitIds = this.getFillOrgUnitIds(template);
        TreeModel model = null;
        TreeModel models = null;
        models = !isCsl ? this.getOldTree() : this.getOldCslTree();
        if (keyEnum.getValue() == 0 || keyEnum.getValue() == 10) {
            if (keyEnum.getValue() == 0) {
                model = BgOrgUnitUtils.clipAndCloneTreeModel(models, new String[]{"name"}, value, true, orgUnitIds);
            } else if (keyEnum.getValue() == 10) {
                model = BgOrgUnitUtils.clipAndCloneTreeModel(models, new String[]{"number"}, value, true, orgUnitIds);
            }
            if (!isCsl) {
                this.treeOrgUnit.setModel(model);
                BgOrgUnitUtils.selectOrgUnit(this.treeOrgUnit.getModel(), false);
                BgOrgTreeHelper.setOrgTreeVisibleAndEnable((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), true, true, this.getOrgUnitId(), null);
            } else {
                this.treeCslUnit.setModel(model);
                BgOrgUnitUtils.selectOrgUnit(this.treeCslUnit.getModel(), false);
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)models.getRoot();
            if (root != null) {
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
                root.setChecked(false);
            }
            if (!isCsl) {
                this.treeOrgUnit.expandOnLevel(7);
            } else {
                this.treeCslUnit.expandOnLevel(7);
            }
        } else if (keyEnum.getValue() == 30) {
            this.filterTemplateColls(this.getTemColls(), "number", value, true);
        } else if (keyEnum.getValue() == 20) {
            this.filterTemplateColls(this.getTemColls(), "name", value, true);
        }
    }

    protected void restartTemplateColls(BgAnalysRptTemplateCollection colls) {
        List<String> selectIds = this.getSelectedTemplateIds();
        this.temTable.removeRows();
        if (colls == null) {
            return;
        }
        BgAnalysRptTemplateInfo template = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            if (BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus())) continue;
            this.addRowByTemplate(this.temTable, template, selectIds != null && selectIds.contains(template.getId().toString()));
        }
        this.temTable.repaint();
    }

    protected void filterTemplateColls(BgAnalysRptTemplateCollection colls, String fields, String value, boolean isBlured) {
        this.temTable.removeRows();
        if (colls == null || fields == null || value == null) {
            return;
        }
        BgAnalysRptTemplateInfo template = null;
        Object obj = null;
        String tmpValue = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            if (BgTemplateStatusEnum.CANCEL.equals((Object)template.getTemplateStatus()) || (obj = template.get(fields)) == null) continue;
            tmpValue = obj.toString();
            if (isBlured) {
                if (tmpValue.indexOf(value) < 0) continue;
                this.addRowByTemplate(this.temTable, template, false);
                continue;
            }
            if (!tmpValue.equals(value)) continue;
            this.addRowByTemplate(this.temTable, template, false);
        }
        this.temTable.repaint();
    }

    @Override
    protected void temTable_editValueChanged(KDTEditEvent e) throws Exception {
        this.temTable.getEditManager().stopEditing();
        this.fillDispatchInfo();
    }

    @Override
    protected void temTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() > 0 && !COL_SELECT.equals(this.temTable.getColumnKey(e.getColIndex()))) {
            ICell cell;
            cell.setValue((Object)(!Boolean.TRUE.equals((cell = this.temTable.getCell(e.getRowIndex(), COL_SELECT)).getValue()) ? 1 : 0));
            this.fillDispatchInfo();
        }
    }

    private void fillDispatchInfo() throws Exception {
        HashSet<String> selectTemplateIds = new HashSet<String>(this.getSelectedTemplateIds());
        this.selectIds = selectTemplateIds;
        DefaultKingdeeTreeNode root = null;
        boolean isCsl = this.btnCslOrg.isSelected();
        if (!isCsl) {
            if (this.treeOrgUnit.getModel() == null) {
                return;
            }
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        } else {
            if (this.treeCslUnit.getModel() == null) {
                return;
            }
            root = (DefaultKingdeeTreeNode)this.treeCslUnit.getModel().getRoot();
        }
        this.fillDispatchInfo(root, selectTemplateIds);
        if (!isCsl) {
            this.treeOrgUnit.repaint();
        } else {
            this.treeCslUnit.repaint();
        }
    }

    private void fillDispatchInfo(DefaultKingdeeTreeNode root, Set<String> selectTemplateIds) throws Exception {
        if (root == null || selectTemplateIds == null) {
            return;
        }
        HashMap orgAndBgTemplateIds = new HashMap();
        Iterator<BOSUuid> it = this.getDispatchMap().keySet().iterator();
        while (it.hasNext()) {
            String bgTemplateId = it.next().toString();
            Set<BgAnalysRptTemplateNodeInfo> nodeInfos = this.getDispatchMap().get(BOSUuid.read((String)bgTemplateId));
            for (BgAnalysRptTemplateNodeInfo nodeInfo : nodeInfos) {
                if (!this.btnCslOrg.isSelected()) {
                    if (!orgAndBgTemplateIds.containsKey(nodeInfo.getOrgUnit().getId().toString())) {
                        orgAndBgTemplateIds.put(nodeInfo.getOrgUnit().getId().toString(), new HashSet());
                    }
                    ((Set)orgAndBgTemplateIds.get(nodeInfo.getOrgUnit().getId().toString())).add(bgTemplateId);
                    continue;
                }
                if (nodeInfo.getTreeID() != null) {
                    if (!nodeInfo.getTreeID().toString().equals(this.getSelectTreeId())) continue;
                    if (!orgAndBgTemplateIds.containsKey(nodeInfo.getOrgUnit().getId().toString())) {
                        orgAndBgTemplateIds.put(nodeInfo.getOrgUnit().getId().toString(), new HashSet());
                    }
                    ((Set)orgAndBgTemplateIds.get(nodeInfo.getOrgUnit().getId().toString())).add(bgTemplateId);
                    continue;
                }
                if (!orgAndBgTemplateIds.containsKey(nodeInfo.getOrgUnit().getId().toString())) {
                    orgAndBgTemplateIds.put(nodeInfo.getOrgUnit().getId().toString(), new HashSet());
                }
                ((Set)orgAndBgTemplateIds.get(nodeInfo.getOrgUnit().getId().toString())).add(bgTemplateId);
            }
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        String orgUnitId = null;
        Object dispatchIds = null;
        HashSet cloneDispatchIds = new HashSet();
        if (this.btnCslOrg.isSelected()) {
            if (root.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)root.getUserObject();
                if (oui.getUnit() != null) {
                    orgUnitId = oui.getUnit().getId().toString();
                }
            } else if (root.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)root.getUserObject();
                orgUnitId = tmpUnit.getId().toString();
            } else if (root.getUserObject() instanceof BgOrgUnitInfo) {
                orgUnitId = ((BgOrgUnitInfo)root.getUserObject()).getOrgUnitID();
            }
            if (orgUnitId != null && orgAndBgTemplateIds.get(orgUnitId) != null) {
                cloneDispatchIds.addAll((Collection)orgAndBgTemplateIds.get(orgUnitId));
            }
            cloneDispatchIds.retainAll(selectTemplateIds);
            if (!cloneDispatchIds.isEmpty()) {
                root.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                root.setTextColor(NO_DISPATCHED);
            }
        }
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            cloneDispatchIds.clear();
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    orgUnitId = oui.getUnit().getId().toString();
                }
            } else if (node.getUserObject() instanceof OrgUnitInfo) {
                tmpUnit = (OrgUnitInfo)node.getUserObject();
                orgUnitId = tmpUnit.getId().toString();
            } else {
                if (!(node.getUserObject() instanceof BgOrgUnitInfo)) continue;
                orgUnitId = ((BgOrgUnitInfo)node.getUserObject()).getOrgUnitID();
            }
            if (orgUnitId != null && orgAndBgTemplateIds.get(orgUnitId) != null) {
                cloneDispatchIds.addAll((Collection)orgAndBgTemplateIds.get(orgUnitId));
            }
            cloneDispatchIds.retainAll(selectTemplateIds);
            if (!cloneDispatchIds.isEmpty()) {
                node.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                node.setTextColor(NO_DISPATCHED);
            }
            if (node.isLeaf()) continue;
            this.fillDispatchInfo(node, selectTemplateIds);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put(BgBaseConstants.BGSCHEME_ID, (Object)this.getBgSchemeId());
            request.put(BgBaseConstants.BGORGVIEW_ID, (Object)this.getBgOrgViewId());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitId());
            request.put(BgBaseConstants.USER_ID, (Object)this.getUserPk().toString());
        }
        return handler;
    }

    protected IBgOrgView getBgOrgViewInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    protected IBgAnalysRptDispatchFacade getDispatchInterface() throws BOSException {
        return BgAnalysRptDispatchFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void comCslOrgView_itemStateChanged(ItemEvent e) throws Exception {
        this.initCslOrgUnit();
        this.fillDispatchInfo();
    }

    @Override
    protected void btnBgOrg_stateChanged(ChangeEvent e) throws Exception {
        this.setTreeVisible();
    }

    @Override
    protected void btnCslOrg_stateChanged(ChangeEvent e) throws Exception {
        this.setTreeVisible();
        this.fillDispatchInfo();
    }

    private void setTreeVisible() {
        if (this.btnBgOrg.isSelected()) {
            this.treeViewOrgUnit.setVisible(true);
            this.treeOrgUnit.setVisible(true);
            this.treeViewCslUnit.setVisible(false);
            this.treeCslUnit.setVisible(false);
            this.comCslOrgView.setEnabled(false);
        } else {
            this.treeViewOrgUnit.setVisible(false);
            this.treeOrgUnit.setVisible(false);
            this.treeViewCslUnit.setVisible(true);
            this.treeCslUnit.setVisible(true);
            this.comCslOrgView.setEnabled(true);
        }
    }

    class CslPropertyListener
    implements ActionListener {
        CslPropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set<String> set = new HashSet<String>();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAnalysRptDispatchUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getModel().getRoot();
            if (set != null) {
                set = BgOrgUnitHelper.getOrgIdByFid(set, BgAnalysRptDispatchUI.this.getBgOrgViewId()).keySet();
            }
            BgOrgUnitUtils.selectOrgUnitIds(node, set);
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class CslCompanyListener
    implements ActionListener {
        CslCompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgAnalysRptDispatchUI.this.getCompanyIds());
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class CslAllSubOrgUnitListener
    implements ActionListener {
        CslAllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class CslAllLeafOrgUnitListener
    implements ActionListener {
        CslAllLeafOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectLeafOrgUnit(node, true);
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class CslAllOrgUnitListener
    implements ActionListener {
        CslAllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgUnitUtils.selectOrgUnit(BgAnalysRptDispatchUI.this.treeCslUnit.getModel(), true);
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class CslDispatchOrgUnitListener
    implements ActionListener {
        CslDispatchOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getLastSelectedPathComponent();
            BgAnalysRptTemplateInfo template = BgAnalysRptDispatchUI.this.getSelectedTemplate();
            if (template != null) {
                Set selOrgUnitIds = BgAnalysRptDispatchUI.this.getFillOrgUnitIds(template);
                BgOrgUnitUtils.selectOrgUnitByIds(node, (Set<BOSUuid>)selOrgUnitIds);
            }
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class CslSubOrgUnitListener
    implements ActionListener {
        CslSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeCslUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgAnalysRptDispatchUI.this.treeCslUnit.repaint();
        }
    }

    class PropertyListener
    implements ActionListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set<String> set = new HashSet<String>();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAnalysRptDispatchUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getModel().getRoot();
            if (set != null) {
                set = BgOrgUnitHelper.getOrgIdByFid(set, BgAnalysRptDispatchUI.this.getBgOrgViewId()).keySet();
            }
            BgOrgUnitUtils.selectOrgUnitIds(node, set);
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class CompanyListener
    implements ActionListener {
        CompanyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds(node, BgAnalysRptDispatchUI.this.getCompanyIds());
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class AllSubOrgUnitListener
    implements ActionListener {
        AllSubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit(node, true);
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class AllLeafOrgUnitListener
    implements ActionListener {
        AllLeafOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectLeafOrgUnit(node, true);
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgUnitListener
    implements ActionListener {
        AllOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgUnitUtils.selectOrgUnit(BgAnalysRptDispatchUI.this.treeOrgUnit.getModel(), true);
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class DispatchOrgUnitListener
    implements ActionListener {
        DispatchOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgAnalysRptTemplateInfo template = BgAnalysRptDispatchUI.this.getSelectedTemplate();
            if (template != null) {
                Set selOrgUnitIds = BgAnalysRptDispatchUI.this.getFillOrgUnitIds(template);
                BgOrgUnitUtils.selectOrgUnitByIds(node, (Set<BOSUuid>)selOrgUnitIds);
            }
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class SubOrgUnitListener
    implements ActionListener {
        SubOrgUnitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgAnalysRptDispatchUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectDirectOrgUnit(node, true);
            BgAnalysRptDispatchUI.this.treeOrgUnit.repaint();
        }
    }

    class CslTreePopupMenuListener
    extends MouseAdapter {
        CslTreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgAnalysRptDispatchUI.this.getCslPopMenu().show((Component)BgAnalysRptDispatchUI.this.treeCslUnit, e.getX(), e.getY());
            }
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgAnalysRptDispatchUI.this.getPopMenu().show((Component)BgAnalysRptDispatchUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

