/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesConstant;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgAnalysReportFactory;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.client.AbstractBgAnalysRptTemplateEditUI;
import com.kingdee.eas.ma.mbg.client.BgTypeSelectorDialog;
import com.kingdee.eas.ma.mbg.client.analysisReport.BgAnalysRptClientUtil;
import com.kingdee.eas.ma.mbg.client.analysisReport.FileHandle;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.poi.wp.usermodel.HeaderFooterType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class BgAnalysRptTemplateEditUI
extends AbstractBgAnalysRptTemplateEditUI {
    private static final long serialVersionUID = 5995232359232075433L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalysRptTemplateEditUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBgType.setSelector(this.getBgTypeSelectorDialog());
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData != null && this.editData.getId() != null) {
            if (BgAnalysReportFactory.getRemoteInstance().exists("select id where bgScheme.id='" + this.editData.getBgScheme().getId() + "' and bgTemplate.id ='" + this.editData.getId() + "'")) {
                this.txtNumber.setEditable(false);
            } else {
                this.txtNumber.setEditable(true);
            }
        }
        this.prmtBgType.setEditable(false);
    }

    protected KDPromptSelector getBgTypeSelectorDialog() {
        BgTypeSelectorDialog dialog = new BgTypeSelectorDialog();
        dialog.setDisplaySelf(false);
        dialog.setOnlyDisplaySelf(false);
        return dialog;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.menuBar.setVisible(false);
        this.getUIMenuBar().removeAll();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.virfyInput();
        boolean isCreate = false;
        String filePath = null;
        String boid = null;
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.storeFields();
            String fileName = this.editData.getName() + "(" + this.editData.getNumber() + ")";
            StringBuffer name = new StringBuffer();
            name.append(System.getProperty("java.io.tmpdir"));
            name.append(File.separator).append(fileName);
            name.append(System.currentTimeMillis());
            name.append("--").append(ReportNotesConstant.edit);
            name.append(".docx");
            File file = new File(name.toString());
            file.createNewFile();
            filePath = file.getPath();
            BOSUuid id = BOSUuid.create((BOSObjectType)this.editData.getBOSType());
            boid = id.toString();
            if (!StringUtils.isEmpty((String)filePath)) {
                AttachmentUIContextInfo info = new AttachmentUIContextInfo();
                info.setBoID(id.toString());
                info.setCode("");
                info.setEdit(true);
                info.setBeizhu(" ");
                FileOutputStream outputStream = new FileOutputStream(filePath);
                XWPFDocument xwpfDocument = new XWPFDocument();
                xwpfDocument.createHeader(HeaderFooterType.DEFAULT);
                xwpfDocument.write((OutputStream)outputStream);
                outputStream.close();
                FileHandle uploadFile = new FileHandle();
                AttachmentInfo attachInfo = uploadFile.makeAttachmentInfo(file, id.toString(), info);
                AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
                String attchID = attachmentClientManager.submitAttachment(attachInfo);
                this.editData.setId(id);
                this.editData.setWordAttachId(BOSUuid.read((String)attchID));
                isCreate = true;
            }
        } else if (OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.storeFields();
            String fileName = this.editData.getName() + "(" + this.editData.getNumber() + ")";
            String wordId = this.editData.getWordAttachId().toString();
            String dir = System.getProperty("java.io.tmpdir");
            FileHandle fileHandle = new FileHandle();
            dir = FilenameUtils.normalize((String)dir);
            filePath = fileHandle.download(wordId, dir, fileName, true, (Component)((Object)this));
            BOSUuid id = BOSUuid.create((BOSObjectType)this.editData.getBOSType());
            boid = id.toString();
            if (!StringUtils.isEmpty((String)filePath)) {
                AttachmentUIContextInfo info = new AttachmentUIContextInfo();
                info.setBoID(id.toString());
                info.setCode("");
                info.setEdit(true);
                info.setBeizhu(" ");
                FileHandle uploadFile = new FileHandle();
                File file = new File(filePath);
                AttachmentInfo attachInfo = uploadFile.makeAttachmentInfo(file, id.toString(), info);
                AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
                String attchID = attachmentClientManager.submitAttachment(attachInfo);
                this.editData.setId(id);
                this.editData.setWordAttachId(BOSUuid.read((String)attchID));
                isCreate = true;
            }
        }
        super.actionSubmit_actionPerformed(e);
        if (!StringUtils.isEmpty(filePath) && isCreate) {
            try {
                BgAnalysRptClientUtil.openFile(filePath);
                BgAnalysRptClientUtil.saveThread(filePath, boid, this.editData.getBgScheme().getId().toString(), null, true, (Component)((Object)this), false, true);
            }
            catch (Throwable ex) {
                BgAnalysRptClientUtil.handleMutexLock(this.getVOChangeListener(), boid, (Component)((Object)this), false);
            }
        }
        this.getUIWindow().close();
    }

    protected void showSubmitSuccess() {
    }

    private void virfyInput() throws Exception {
        if (this.txtNumber == null || StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"numberIsNull"));
            SysUtil.abort();
        }
        if (this.txtName == null || StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
        if (!OprtState.EDIT.equals(this.getOprtState()) && BgAnalysRptTemplateFactory.getRemoteInstance().checkNumberDup(this.editData.getBgScheme().getId().toString(), this.txtNumber.getText(), "", this.editData.getOrgUnit().getId().toString())) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
    }

    protected IObjectValue createNewData() {
        BgAnalysRptTemplateInfo info = new BgAnalysRptTemplateInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setBgScheme((BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO));
        info.setDescription(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"tempDescription"));
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("bgScheme.id");
        sic.add("orgUnit.id");
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAnalysRptTemplateFactory.getRemoteInstance();
    }
}

