/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgAnalyseCourseUI;
import com.kingdee.eas.ma.mbg.client.BgTemplateF7UI;
import com.kingdee.eas.ma.mbg.client.NewBgTemplateDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCourseFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgFormCourseHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.BgTemplateObject;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgAnalyseCourseUI
extends AbstractBgAnalyseCourseUI {
    private static final long serialVersionUID = 1216036738629156598L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseCourseUI.class);
    private DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);
    private CtrlUnitInfo currCU = null;
    private OrgUnitInfo currOrgUnit = null;
    private CostCenterOrgUnitInfo currCCOrgUnit = null;
    private boolean isExistBgScheme = true;
    private static final CalendarHelper calendarHelper = new CalendarHelper();
    private static final String BGSCHEME_ID = "BGSCHEME_ID";
    private static final String BGPERIOD_ID = "BGPERIOD_ID";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String BGVERSION_ID = "BGVERSION_ID";
    private static final String TEMPLATE_ID = "TEMPLATE_ID";
    private static final String STATE = "STATE";
    private static final String FORBIDDENTEMPLATE = "FORBIDDENTEMPLATE";
    private CustomerParams cp;
    private BgSchemeDimensionHelper schemeHelper = null;
    private BgPeriodDialog bgPeriodDialog = null;

    public boolean isExistBgScheme() {
        return this.isExistBgScheme;
    }

    public void setExistBgScheme(boolean isExistBgScheme) {
        this.isExistBgScheme = isExistBgScheme;
    }

    public BgAnalyseCourseUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilter();
    }

    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            if (this.getBgSchemeInfo() instanceof BgSchemeInfo) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, ((BgSchemeInfo)this.getBgSchemeInfo()).getId().toString());
            } else if (this.getBgSchemeInfo() instanceof BgSchemeInfo[]) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, ((BgSchemeInfo[])this.getBgSchemeInfo())[0].getId().toString());
            }
        }
        return this.schemeHelper;
    }

    public Object getBgSchemeInfo() {
        return this.prmtBgScheme.getData();
    }

    protected void checkBgScheme() {
        if (!(this.getBgSchemeInfo() instanceof BgSchemeInfo[]) && !(this.getBgSchemeInfo() instanceof BgSchemeInfo)) {
            this.prmtBgScheme.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noBgScheme"));
        }
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtBgPeriod_willShow(e);
        this.checkBgScheme();
    }

    @Override
    protected void prmptBgVersion_willShow(SelectorEvent e) throws Exception {
        super.prmptBgVersion_willShow(e);
        this.checkBgScheme();
        if (this.prmptBgVersion == null) {
            BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noBgScheme"));
            return;
        }
        EntityViewInfo evi = this.prmptBgVersion.getEntityViewInfo();
        FilterInfo filter = evi.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("isRollVersion", (Object)false, CompareType.EQUALS));
        this.prmptBgVersion.setEntityViewInfo(evi);
        this.prmptBgVersion.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        super.prmtCurrency_willShow(e);
        this.checkBgScheme();
    }

    protected void initBgVersion() throws EASBizException, BOSException {
        if (this.getSchemeHelper() != null) {
            DimensionMemberSelectHelper.addIdFilter(this.prmptBgVersion, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
        }
    }

    @Override
    protected void prmtBgTemplate_willShow(SelectorEvent e) {
        this.checkBgScheme();
        Object obj = this.prmtBgScheme.getData();
        NewBgTemplateDialog dialog = (NewBgTemplateDialog)this.prmtBgTemplate.getSelector();
        if (obj != null && obj instanceof BgSchemeInfo) {
            BgSchemeInfo info = (BgSchemeInfo)obj;
            dialog.setSchemeId(info.getId() == null ? "" : info.getId().toString());
        } else if (obj != null && obj instanceof BgSchemeInfo[]) {
            BgSchemeInfo[] infos = (BgSchemeInfo[])obj;
            dialog.setSchemeId(infos[0].getId() == null ? "" : infos[0].getId().toString());
        }
        dialog.setIsDisplayForbidTemp(this.chxIsContainForbidden.isSelected());
        dialog.setIsDisplaySelfTemp(false);
        dialog.setIsDisplaySelfTemp(false);
        dialog.setDisplaySpecialTemp(true);
    }

    @Override
    protected void chxIsContainForbidden_itemStateChanged(ItemEvent e) throws Exception {
        Object oldTmplate = this.prmtBgTemplate.getData();
        this.initBgTemplate();
        Object obj = this.prmtBgScheme.getData();
        NewBgTemplateDialog dialog = (NewBgTemplateDialog)this.prmtBgTemplate.getSelector();
        if (obj != null && obj instanceof BgSchemeInfo) {
            BgSchemeInfo info = (BgSchemeInfo)obj;
            dialog.setSchemeId(info.getId() == null ? "" : info.getId().toString());
        } else if (obj != null && obj instanceof BgSchemeInfo[]) {
            BgSchemeInfo[] infos = (BgSchemeInfo[])obj;
            dialog.setSchemeId(infos[0].getId() == null ? "" : infos[0].getId().toString());
        }
        dialog.setIsDisplayForbidTemp(this.chxIsContainForbidden.isSelected());
        dialog.setIsDisplaySelfTemp(false);
        dialog.setIsDisplaySelfTemp(false);
        dialog.setDisplaySpecialTemp(true);
        BgTemplateF7UI ui = (BgTemplateF7UI)dialog.getF7UI().getUIObject();
        KDTable tbTemplate = ui.tbTemplate;
        HashSet<String> bgTemplateIds = new HashSet<String>();
        int in = tbTemplate.getRowCount();
        for (int i = 0; i < in; ++i) {
            bgTemplateIds.add(((BgTemplateInfo)tbTemplate.getRow(i).getUserObject()).getId().toString());
        }
        Object bgTmplate = this.prmtBgTemplate.getData();
        BgTemplateInfo templateInfo = null;
        if (bgTmplate != null && bgTmplate instanceof BgTemplateInfo) {
            templateInfo = (BgTemplateInfo)bgTmplate;
            if (!bgTemplateIds.contains(templateInfo.getId().toString())) {
                this.prmtBgTemplate.setData(null);
            }
        } else if (bgTmplate != null && bgTmplate instanceof BgTemplateObject) {
            BgTemplateObject templateobj = (BgTemplateObject)bgTmplate;
            BgTemplateCollection templateInfos = templateobj.getResult();
            BgTemplateCollection coll = new BgTemplateCollection();
            int in2 = templateInfos.size();
            for (int i = 0; i < in2; ++i) {
                if (bgTemplateIds == null || !bgTemplateIds.contains(templateInfos.get(i).getId().toString())) continue;
                coll.add(templateInfos.get(i));
            }
            BgTemplateObject newTmpObj = new BgTemplateObject(coll);
            this.prmtBgTemplate.setData((Object)newTmpObj);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "analyse_title");
    }

    protected ICostCenterOrgUnit getCCOrgUnitInterface() throws Exception {
        return CostCenterOrgUnitFactory.getRemoteInstance();
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    protected IBgPeriod getBgPeriodInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    protected ICurrency getCurrencyInterface() throws Exception {
        return CurrencyFactory.getRemoteInstance();
    }

    public CtrlUnitInfo getCtrlUnit() {
        return this.currCU;
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public CostCenterOrgUnitInfo getCCorgUnit() {
        return this.currCCOrgUnit;
    }

    protected void initFilter() throws Exception {
        this.currCU = SysContext.getSysContext().getCurrentCtrlUnit();
        this.currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        this.currCCOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
        if (this.currCCOrgUnit != null) {
            this.currCCOrgUnit = this.getCCOrgUnitInterface().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currCCOrgUnit.getId()));
        }
        this.initBgScheme();
        this.initBgTemplate();
        this.initBgPeriod();
        this.initCurrency();
        this.initBgVersion();
        BgSchemeUtils.setDefualtMembers(this.getSchemeHelper(), (JComponent)this.prmptBgVersion, (JComponent)this.prmtBgPeriod, (JComponent)this.prmtCurrency, false, false);
        this.initState();
        this.initProcessType();
        this.initForbiddenTempalate();
    }

    protected void initProcessType() {
        this.cmbProcessType.addItem((Object)BgProcessEnum.C01);
        this.cmbProcessType.addItem((Object)BgProcessEnum.C02);
        this.cmbProcessType.addItem((Object)BgProcessEnum.C04);
    }

    private void initForbiddenTempalate() {
        this.chxIsContainForbidden.setSelected(false);
    }

    protected void initBgTemplate() throws Exception {
        this.prmtBgTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgAnalyseCourseUI.this.prmtBgTemplate_willShow(e);
            }
        });
        NewBgTemplateDialog dialog = new NewBgTemplateDialog((IUIObject)this);
        this.prmtBgTemplate.addDataChangeListener((DataChangeListener)dialog);
        this.prmtBgTemplate.setSelector((KDPromptSelector)dialog);
    }

    public void loadFilterInfo() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)method.invoke(this.ui, null)) != null) {
                    if (filterParam.getBgScheme() != null) {
                        this.prmtBgScheme.setData((Object)filterParam.getBgScheme());
                    }
                    if (filterParam.getBgPeriod() != null) {
                        this.prmtBgPeriod.setData((Object)filterParam.getBgPeriod());
                    }
                    this.prmptBgVersion.setData((Object)filterParam.getBgVersion());
                    this.prmtCurrency.setData((Object)filterParam.getCurrency());
                    this.prmtBgTemplate.setData((Object)BgFormCourseHelper.tempArray2TempObj(filterParam.getTemplateInfo()));
                    BgFormStateEnum[] state2 = filterParam.getState();
                    if (state2 != null) {
                        this.setState(state2);
                    } else {
                        this.clearState();
                    }
                    this.cmbProcessType.setSelectedItem((Object)filterParam.getProcessType()[0]);
                    this.chxIsContainForbidden.setSelected(filterParam.isContainForbidden());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected boolean isMultiSelect() {
        return true;
    }

    protected boolean isReturnSuperior() {
        return true;
    }

    protected void initBgScheme() throws Exception {
        this.prmtBgScheme.setEnabledMultiSelection(false);
        this.prmtBgScheme.setHistoryRecordEnabled(false);
        BgNFCHelper.setSchemeView(this.prmtBgScheme, this.currOrgUnit, false, BgNFCHelper.getSourceType((IUIObject)this), false, true);
        FilterInfo filter = MbgPermissionHelper.addBgSchemePermission(BgNFCHelper.getSourceType((IUIObject)this), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, BgNFCHelper.getSourceType((IUIObject)this), this.currOrgUnit);
    }

    protected Set<BOSUuid> queryBgSchemeIds(BOSUuid orgUnitId) throws Exception {
        return BgSchemeFactory.getRemoteInstance().queryShowScheme(orgUnitId);
    }

    protected void showBgScheme() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtBgScheme.setData((Object)filterParam.getBgScheme());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void showBgTemplate() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtBgTemplate.setData((Object)BgFormCourseHelper.tempArray2TempObj(filterParam.getTemplateInfo()));
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    public BgPeriodDialog getBgPeriodDialog() {
        if (this.bgPeriodDialog == null) {
            this.bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, true);
        }
        return this.bgPeriodDialog;
    }

    protected void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = this.getBgPeriodDialog();
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            bgPeriodDialog.setBgPeriodBeginDate(((BgSchemeInfo)this.prmtBgScheme.getData()).getDateFrom());
            bgPeriodDialog.setBgPeriodEndDate(((BgSchemeInfo)this.prmtBgScheme.getData()).getDateTo());
            bgPeriodDialog.setBgPeriodTypeNumbers(this.getSchemeHelper() != null ? this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true) : null);
        }
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgPeriod.setEnabledMultiSelection(false);
        this.prmtBgPeriod.setHistoryRecordEnabled(false);
    }

    protected void showBgPeriod() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)method.invoke(this.ui, null)) != null && filterParam.getBgPeriod() != null) {
                    this.prmtBgPeriod.setData((Object)filterParam.getBgPeriod());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initCurrency() throws Exception {
        this.prmtCurrency.setHistoryRecordEnabled(false);
        if (this.getSchemeHelper() != null) {
            DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
        }
    }

    protected void showCurrency() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtCurrency.setData((Object)filterParam.getCurrency());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initState() throws Exception {
        this.setState();
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        BgSchemeInfo oldInfo = null;
        if (e.getNewValue() == null) {
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
        }
        if (e.getOldValue() instanceof BgSchemeInfo) {
            oldInfo = (BgSchemeInfo)e.getOldValue();
        } else if (e.getOldValue() instanceof BgSchemeInfo[]) {
            oldInfo = ((BgSchemeInfo[])e.getOldValue())[0];
        }
        BgSchemeInfo _info = null;
        Object _obj = this.prmtBgScheme.getData();
        BgSchemeInfo _bgSchemeInfo = null;
        if (_obj != null) {
            if (_obj instanceof String && !StringUtils.isEmpty((String)_obj.toString())) {
                try {
                    _info = this.getBgSchemeInterface().getBgSchemeInfo("select id, name, number, orgUnit, bgOrgView where fnumber = '" + _obj.toString() + "'");
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                if (_info != null) {
                    this.prmtBgScheme.setData(_info);
                    _bgSchemeInfo = _info;
                } else {
                    this.prmtBgScheme.setData(null);
                    this.prmtBgTemplate.setData(null);
                }
            } else if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = (BgSchemeInfo)_obj;
            } else if (_obj instanceof Object[]) {
                Object[] obj = (Object[])_obj;
                _bgSchemeInfo = (BgSchemeInfo)obj[0];
            }
            if (_bgSchemeInfo != null) {
                try {
                    BgSchemeInfo dateTo = this.getBgSchemeInterface().getBgSchemeInfo("select id, dateTo where id = '" + _bgSchemeInfo.getId().toString() + "'");
                    _bgSchemeInfo.setDateTo(dateTo.getDateTo());
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                this.prmtBgTemplate.setData(null);
                this.initTemplateSelectorFormBgScheme2(this.prmtBgTemplate, _bgSchemeInfo);
                if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)_bgSchemeInfo)) {
                    this.schemeHelper = new BgSchemeDimensionHelper(null, _bgSchemeInfo.getId().toString());
                    this.resetPrmt();
                }
            } else {
                this.prmtBgTemplate.setData(null);
            }
            BgSchemeUtils.setDefualtMembers(this.getSchemeHelper(), (JComponent)this.prmptBgVersion, (JComponent)this.prmtBgPeriod, (JComponent)this.prmtCurrency, false, false);
        }
        if (this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
            bgPeriodDialog.setBgPeriodBeginDate(_bgSchemeInfo.getDateFrom());
            bgPeriodDialog.setBgPeriodEndDate(_bgSchemeInfo.getDateTo());
            bgPeriodDialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
            bgPeriodDialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        }
    }

    private void resetPrmt() throws EASBizException, BOSException {
        if (this.getSchemeHelper() != null) {
            DimensionMemberSelectHelper.addIdFilter(this.prmptBgVersion, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
            DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
            if (this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
                BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
                bgPeriodDialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
                Object objPeriod = this.prmtBgPeriod.getData();
                BgPeriodCollection periodColl = null;
                if (objPeriod != null && objPeriod instanceof BgPeriodCollection) {
                    periodColl = (BgPeriodCollection)objPeriod;
                    BgPeriodInfo[] periodArray = new BgPeriodInfo[periodColl.size()];
                    for (int i = 0; i < periodColl.size(); ++i) {
                        if (periodColl.get(i) == null) continue;
                        periodArray[i] = periodColl.get(i);
                    }
                    this.prmtBgPeriod.setDataNoNotify((Object)periodArray);
                    bgPeriodDialog.setBgPeriods(periodArray);
                }
            }
            this.prmptBgVersion.setData(null);
            this.prmtCurrency.setData(null);
        }
    }

    private void setBgPeriodF7Display() throws EASBizException, BOSException {
        BgNFCHelper.setBgPeriodF7Display(this.cacheHelper, this.prmtBgPeriod, this.prmtBgScheme, this.currCCOrgUnit != null ? this.currCCOrgUnit.getId().toString() : null);
    }

    protected void initTemplateSelectorFormBgScheme(KDBizPromptBox promptBox, BgSchemeInfo bgSchemeInfo) throws Exception {
        BgFormCourseHelper.initTemplateFormBgScheme(this.prmtBgTemplate, bgSchemeInfo, (IUIObject)this);
        this.prmtBgTemplate.getSelector();
    }

    protected void initTemplateSelectorFormBgScheme2(KDBizPromptBox promptBox, BgSchemeInfo bgSchemeInfo) throws Exception {
        BgFormCourseHelper.initTemplateForCourse(this.prmtBgTemplate, bgSchemeInfo, (IUIObject)this);
        this.prmtBgTemplate.getSelector();
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        BgPeriodInfo _info = null;
        Object _obj = this.prmtBgPeriod.getData();
        if (_obj != null) {
            if (_obj instanceof String && !StringUtils.isEmpty((String)_obj.toString())) {
                try {
                    _info = this.getBgPeriodInterface().getBgPeriodInfo("select id, name, number where fnumber = '" + _obj.toString() + "'");
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                if (_info != null) {
                    this.prmtBgPeriod.setData(_info);
                }
            } else if (_obj instanceof BgPeriodInfo || _obj instanceof BgPeriodInfo[]) {
                // empty if block
            }
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        CurrencyInfo _info = null;
        CurrencyCollection _col = null;
        Object _obj = this.prmtCurrency.getData();
        if (_obj != null) {
            if (_obj instanceof String && !StringUtils.isEmpty((String)_obj.toString())) {
                _col = this.getCurrencyInterface().getCurrencyCollection("select id, name, number where fnumber = '" + _obj.toString() + "'");
                if (_col != null && !_col.isEmpty()) {
                    _info = _col.get(0);
                    _col.clear();
                }
                if (_info != null) {
                    this.prmtCurrency.setData(_info);
                } else {
                    this.prmtCurrency.setData(null);
                }
            } else if (_obj instanceof CurrencyInfo || _obj instanceof CurrencyInfo[]) {
                // empty if block
            }
        }
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            int i;
            int in;
            Object[] _objs;
            boolean _hasObject;
            Object _obj = null;
            _obj = this.prmtBgScheme.getData();
            if (_obj == null) {
                this.prmtBgScheme.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectBgScheme"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtBgScheme.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectBgScheme"));
                        return false;
                    }
                }
            }
            _obj = this.prmtBgPeriod.getData();
            if (_obj == null) {
                this.prmtBgPeriod.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectBgPeriod"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtBgPeriod.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectBgPeriod"));
                        return false;
                    }
                }
            }
            _obj = this.prmtCurrency.getData();
            if (_obj == null) {
                this.prmtCurrency.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectCurrency"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtCurrency.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectCurrency"));
                        SysUtil.abort();
                    }
                }
            }
            _obj = this.prmptBgVersion.getData();
            if (_obj == null) {
                this.prmptBgVersion.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "isNullBgVersion"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmptBgVersion.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "isNullBgVersion"));
                        return false;
                    }
                }
            }
            _obj = this.getSelelctedState();
            if (_obj == null) {
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectState"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "selectState"));
                        SysUtil.abort();
                    }
                }
            }
        }
        return re;
    }

    private Object getSelelctedState() {
        BgFormStateEnum[] reVal = null;
        ArrayList<BgFormStateEnum> list = new ArrayList<BgFormStateEnum>();
        if (this.kDCheckBox1.isSelected()) {
            list.add(BgFormStateEnum.CANTEDIT);
        }
        if (this.kDCheckBox2.isSelected()) {
            list.add(BgFormStateEnum.Edited);
        }
        if (this.kDCheckBox3.isSelected()) {
            list.add(BgFormStateEnum.Report);
        }
        if (this.kDCheckBox4.isSelected()) {
            list.add(BgFormStateEnum.Certificate);
        }
        if (this.kDCheckBox5.isSelected()) {
            list.add(BgFormStateEnum.Back);
        }
        if (this.kDCheckBox6.isSelected()) {
            list.add(BgFormStateEnum.Approved);
            list.add(BgFormStateEnum.RollEdited);
            list.add(BgFormStateEnum.RollApproving);
        }
        if (this.kDCheckBox7.isSelected()) {
            list.add(BgFormStateEnum.REFERRING);
        }
        if (this.kDCheckBox8.isSelected()) {
            list.add(BgFormStateEnum.Approving);
        }
        if (list.size() > 0) {
            reVal = new BgFormStateEnum[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                reVal[i] = (BgFormStateEnum)((Object)list.get(i));
            }
        }
        return reVal;
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgCourseFilterParam();
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgCourseFilterParam) {
            BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
            Object _obj = null;
            _obj = this.prmtBgScheme.getData();
            if (_obj != null) {
                if (_obj instanceof BgSchemeInfo) {
                    _filterParam.setBgScheme((BgSchemeInfo)_obj);
                } else if (_obj instanceof BgSchemeInfo[]) {
                    _filterParam.setBgScheme((BgSchemeInfo[])_obj);
                }
            } else {
                _filterParam.clearBgScheme();
            }
            _obj = this.prmtBgTemplate.getData();
            if (_obj != null) {
                if (_obj instanceof BgTemplateObject) {
                    _filterParam.setTemplateInfo(BgFormCourseHelper.tempObj2TempArray((BgTemplateObject)_obj));
                } else {
                    this.prmtBgTemplate.setData(null);
                }
            } else {
                _filterParam.clearBgTemplate();
            }
            _obj = this.prmtBgPeriod.getData();
            if (_obj != null) {
                if (_obj instanceof BgPeriodInfo) {
                    _filterParam.setBgPeriod((BgPeriodInfo)_obj);
                } else if (_obj instanceof BgPeriodInfo[]) {
                    _filterParam.setBgPeriod((BgPeriodInfo[])_obj);
                }
            }
            if ((_obj = this.prmtCurrency.getData()) != null) {
                if (_obj instanceof CurrencyInfo) {
                    _filterParam.setCurrency((CurrencyInfo)_obj);
                } else if (_obj instanceof BgPeriodInfo[]) {
                    _filterParam.setCurrency((CurrencyInfo[])_obj);
                } else if (_obj instanceof Object[]) {
                    _filterParam.setCurrency((Object[])_obj);
                }
            } else {
                _filterParam.clearCurrency();
            }
            _obj = this.prmptBgVersion.getData();
            if (_obj != null) {
                if (_obj instanceof BgVersionInfo) {
                    _filterParam.setBgVersion((BgVersionInfo)_obj);
                } else if (_obj instanceof BgVersionInfo[]) {
                    _filterParam.setBgVersion((BgVersionInfo[])_obj);
                }
            } else {
                _filterParam.clearBgVersion();
            }
            _obj = this.getSelelctedState();
            if (_obj != null) {
                if (_obj instanceof BgFormStateEnum) {
                    _filterParam.setState((BgFormStateEnum)((Object)_obj));
                } else if (_obj instanceof Object[]) {
                    _filterParam.setState((BgFormStateEnum[])_obj);
                }
            } else {
                _filterParam.clearState();
            }
            _obj = this.cmbProcessType.getSelectedItem();
            if (_obj != null) {
                if (_obj instanceof BgProcessEnum) {
                    _filterParam.setProcessType((BgProcessEnum)((Object)_obj));
                }
            } else {
                _filterParam.clearProcessType();
            }
            _filterParam.setContainForbidden(this.getSelectedForbiddenTemplate());
        }
    }

    private boolean getSelectedForbiddenTemplate() {
        return this.chxIsContainForbidden.isSelected();
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        boolean isFolling = false;
        if (filterParam != null && filterParam instanceof BgCourseFilterParam) {
            BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
            try {
                BgSchemeCollection bgSchemeCollection = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection("select id, isFiling where id = '" + _filterParam.getBgScheme()[0].getId() + "'");
                if (bgSchemeCollection.size() != 0) {
                    this.isExistBgScheme = true;
                    isFolling = bgSchemeCollection.get(0).isIsFiling();
                } else {
                    this.isExistBgScheme = false;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getCause());
            }
            if (!this.isExistBgScheme || isFolling) {
                this.prmtBgScheme.setDataNoNotify(null);
                this.prmtBgPeriod.setDataNoNotify(null);
                this.prmtBgTemplate.setDataNoNotify(null);
                this.prmtCurrency.setData(null);
                this.prmptBgVersion.setData(null);
                this.setState();
                return;
            }
            if (_filterParam.getBgScheme() != null) {
                this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
            } else {
                BOSUuid orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId();
                try {
                    this.getDefaultScheme(orgUnitId);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    logger.error((Object)"", (Throwable)e);
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    logger.error((Object)"", (Throwable)e);
                    this.handUIException(e);
                }
            }
            if (_filterParam.getBgPeriod() != null) {
                this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriod());
            }
            if (!this.isExistBgScheme) {
                this.prmtBgTemplate.setDataNoNotify(null);
            } else if (_filterParam.getTemplateInfo() != null) {
                this.prmtBgTemplate.setData((Object)BgFormCourseHelper.tempArray2TempObj(_filterParam.getTemplateInfo()));
            } else {
                this.prmtBgTemplate.setData(null);
            }
            if (_filterParam.getCurrency() != null) {
                this.prmtCurrency.setData((Object)_filterParam.getCurrency());
            } else {
                this.prmtCurrency.setData(null);
            }
            if (_filterParam.getBgVersion() != null) {
                this.prmptBgVersion.setData((Object)_filterParam.getBgVersion());
            }
            if (_filterParam.getProcessType() != null) {
                this.cmbProcessType.setSelectedItem((Object)_filterParam.getProcessType()[0]);
            }
            if (_filterParam.getState() != null) {
                this.setState(_filterParam.getState());
            } else {
                this.setState();
            }
            this.chxIsContainForbidden.setSelected(_filterParam.isContainForbidden());
        }
    }

    private void setState(BgFormStateEnum[] state2) {
        if (state2 == null || state2.length == 0) {
            this.clearState();
        } else {
            this.clearState();
            block10: for (BgFormStateEnum bgFormStateEnum : state2) {
                switch (bgFormStateEnum.getValue()) {
                    case 97: {
                        this.kDCheckBox1.setSelected(true);
                        continue block10;
                    }
                    case 1: {
                        this.kDCheckBox2.setSelected(true);
                        continue block10;
                    }
                    case 40: {
                        this.kDCheckBox3.setSelected(true);
                        continue block10;
                    }
                    case 41: {
                        this.kDCheckBox4.setSelected(true);
                        continue block10;
                    }
                    case 42: {
                        this.kDCheckBox5.setSelected(true);
                        continue block10;
                    }
                    case 2: {
                        this.kDCheckBox6.setSelected(true);
                        continue block10;
                    }
                    case 25: {
                        this.kDCheckBox7.setSelected(true);
                        continue block10;
                    }
                    case 14: {
                        this.kDCheckBox8.setSelected(true);
                    }
                }
            }
        }
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgCourseFilterParam)) {
            return;
        }
        String tmpStr = null;
        List tmpList = null;
        boolean isContainForbidden = true;
        BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
        try {
            tmpStr = cp.getCustomerParam(BGSCHEME_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgScheme(new BgSchemeInfo());
                _filterParam.getBgScheme()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearBgScheme();
            }
            tmpStr = cp.getCustomerParam(TEMPLATE_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setTemplateInfo(this.getBgTemplateInfos(tmpStr));
            } else {
                _filterParam.clearBgScheme();
            }
            tmpStr = cp.getCustomerParam(BGPERIOD_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgPeriod(new BgPeriodInfo());
                _filterParam.getBgPeriod()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearBgPeriod();
            }
            tmpStr = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearCurrency();
            }
            tmpStr = cp.getCustomerParam(BGVERSION_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgVersion(new BgVersionInfo());
                _filterParam.getBgVersion()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearBgVersion();
            }
            tmpList = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(STATE)));
            if (tmpList != null && !tmpList.isEmpty()) {
                BgFormStateEnum[] state = new BgFormStateEnum[tmpList.size()];
                int in = tmpList.size();
                for (int i = 0; i < in; ++i) {
                    state[i] = BgFormStateEnum.getEnum((Integer)tmpList.get(i));
                }
                _filterParam.setState(state);
            } else {
                _filterParam.clearState();
            }
            isContainForbidden = (Boolean)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(FORBIDDENTEMPLATE)));
            _filterParam.setContainForbidden(isContainForbidden);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgCourseFilterParam)) {
            return;
        }
        Serializable[] _objs = null;
        BgFormStateEnum state2 = null;
        BgFormStateEnum[] states = null;
        ArrayList<Integer> tmpList = null;
        boolean isContainForbidden = true;
        BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
        try {
            _objs = _filterParam.getBgScheme();
            if (_objs != null && _objs[0] instanceof BgSchemeInfo) {
                cp.addCustomerParam(BGSCHEME_ID, ((BgSchemeInfo)_objs[0]).getId().toString());
            } else {
                cp.removeCustomerParam(BGSCHEME_ID);
            }
            _objs = _filterParam.getTemplateInfo();
            if (_objs != null && _objs instanceof BgTemplateInfo[]) {
                cp.addCustomerParam(TEMPLATE_ID, this.combineBgTemplateIDS((BgTemplateInfo[])_objs));
            } else {
                cp.removeCustomerParam(TEMPLATE_ID);
            }
            _objs = _filterParam.getBgPeriod();
            if (_objs != null && _objs[0] instanceof BgPeriodInfo) {
                cp.addCustomerParam(BGPERIOD_ID, ((BgPeriodInfo)_objs[0]).getId().toString());
            } else {
                cp.removeCustomerParam(BGPERIOD_ID);
            }
            _objs = _filterParam.getCurrency();
            if (_objs != null && _objs[0] instanceof CurrencyInfo) {
                cp.addCustomerParam(CURRENCY_ID, ((CurrencyInfo)_objs[0]).getId().toString());
            } else {
                cp.removeCustomerParam(CURRENCY_ID);
            }
            states = _filterParam.getState();
            if (states != null && states.length > 0) {
                tmpList = new ArrayList<Integer>();
                for (BgFormStateEnum state2 : states) {
                    tmpList.add(new Integer(state2.getValue()));
                }
                cp.addCustomerParam(STATE, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(STATE);
            }
            isContainForbidden = _filterParam.isContainForbidden();
            cp.addCustomerParam(FORBIDDENTEMPLATE, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(isContainForbidden)));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    private String combineBgTemplateIDS(BgTemplateInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = infos.length;
        for (int i = 0; i < size; ++i) {
            sb.append(infos[i].getId().toString()).append("!");
        }
        return sb.toString();
    }

    private BgTemplateInfo[] getBgTemplateInfos(String ids) throws BOSException {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        String[] tmps = ids.split("!");
        BgTemplateInfo[] infos = new BgTemplateInfo[tmps.length];
        BOSUuid id = null;
        BgTemplateInfo info = null;
        int size = tmps.length;
        for (int i = 0; i < size; ++i) {
            id = BOSUuid.read((String)tmps[i]);
            info = new BgTemplateInfo();
            info.setId(id);
            infos[i] = info;
        }
        return infos;
    }

    @Override
    public void clear() {
        super.clear();
        BOSUuid orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId();
        try {
            this.getDefaultScheme(orgUnitId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        this.setState();
        this.prmtBgTemplate.setData(null);
        BgNFCHelper.setSelectObject(this.cmbProcessType, (Object)BgProcessEnum.C01);
        this.chxIsContainForbidden.setSelected(false);
    }

    private void clearState() {
        this.kDCheckBox1.setSelected(false);
        this.kDCheckBox2.setSelected(false);
        this.kDCheckBox3.setSelected(false);
        this.kDCheckBox4.setSelected(false);
        this.kDCheckBox5.setSelected(false);
        this.kDCheckBox6.setSelected(false);
        this.kDCheckBox7.setSelected(false);
        this.kDCheckBox8.setSelected(false);
    }

    private void setState() {
        this.kDCheckBox1.setSelected(true);
        this.kDCheckBox2.setSelected(true);
        this.kDCheckBox3.setSelected(true);
        this.kDCheckBox4.setSelected(true);
        this.kDCheckBox5.setSelected(true);
        this.kDCheckBox6.setSelected(true);
        this.kDCheckBox7.setSelected(true);
        this.kDCheckBox8.setSelected(true);
    }

    protected void getDefaultScheme(BOSUuid orgUnitId) throws BOSException, EASBizException {
        BgNFCHelper.setSchemeView(this.prmtBgScheme, this.currOrgUnit, false, BgNFCHelper.getSourceType((IUIObject)this), false, true);
        FilterInfo filter = MbgPermissionHelper.addBgSchemePermission(BgNFCHelper.getSourceType((IUIObject)this), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, BgNFCHelper.getSourceType((IUIObject)this), this.currOrgUnit);
    }

    @Override
    public boolean destroyWindow() {
        KDPromptSelector _obj;
        boolean re = super.destroyWindow();
        if (re && (_obj = this.prmtBgPeriod.getSelector()) != null && _obj instanceof BgPeriodDialog) {
            ((BgPeriodDialog)_obj).close();
        }
        return re;
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId, String orgId) throws Exception {
        return TemplateFacadeFactory.getRemoteInstance().getBgTemplateInfo(bgSchemeId, orgId);
    }
}

