/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IWizzardComment;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgCommentEditUI;
import com.kingdee.eas.ma.mbg.client.BgNFProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.BgCommentClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgTemplateComment;
import com.kingdee.eas.ma.mbg.utils.BgTemplateCommentTank;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCommentEditUI
extends AbstractBgCommentEditUI
implements IWizzardComment {
    private static final long serialVersionUID = -296196371319634672L;
    private static final Logger logger = CoreUIObject.getLogger(BgCommentEditUI.class);
    private SpreadContext _context = null;
    private int _mode = 0;
    private boolean _isEditor = true;
    private boolean _isCancel = true;
    private boolean _isSave = false;
    private RptCommentTank comments = null;
    private RptCommentTank orignComments;
    private UserInfo defaultAuthor = SysContext.getSysContext().getCurrentUserInfo();
    private String defaultContent = BgNFCHelper.getMessageStr("comment");
    private Map<String, RptComment> commentsCacheMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboxSort.setEnabled(false);
        this.comboxSort.setVisible(false);
        this.tblComment.checkParsed();
        this.tblComment.getSelectManager().setSelectMode(2);
        this.tblComment.getColumn("date").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateTimeFormatString());
    }

    public void show() {
        if (this.getUIWindow() instanceof KDDialog && !((KDDialog)this.getUIWindow()).isVisible()) {
            this.initialize();
            int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
            this.txtComment.setText(this.getComments().getContent(activeRowIndex));
            this.getUIWindow().show();
        } else {
            super.show();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        if (OprtState.VIEW.equals(this.getOprtState())) {
            // empty if block
        }
    }

    protected void initialize() {
        if (this.getComments() != null && this.getComments().getSize() > 0) {
            this.tblComment.getSelectManager().select(0, 0);
        } else {
            this.txtComment.setText(this.getDefaultContent());
        }
        BgNFCHelper.setFocusTo((Component)this.txtComment);
    }

    protected void setContext(SpreadContext context) {
        this._context = context;
    }

    protected SpreadContext getContext() {
        return this._context;
    }

    protected int getMode() {
        return this._mode;
    }

    protected boolean isEditor() {
        return this._isEditor;
    }

    protected void setIsEditor(boolean isEditor) {
        this._isEditor = isEditor;
    }

    public void setIsSave(boolean isSave) {
        this._isSave = isSave;
    }

    protected boolean isCancel() {
        return this._isCancel;
    }

    protected void setIsCancel(boolean isCancel) {
        this._isCancel = isCancel;
    }

    protected void setComments(RptCommentTank comments) {
        int i;
        this.orignComments = comments;
        this.orignComments.setTable(null);
        this.comments = new RptCommentTank();
        ArrayList<RptComment> entries = new ArrayList<RptComment>();
        for (i = 0; i < this.orignComments.getSize(); ++i) {
            entries.add(this.orignComments.getEntry(i));
        }
        Collections.sort(entries, new Comparator<RptComment>(){

            @Override
            public int compare(RptComment o1, RptComment o2) {
                if (o2.getSource() == null || o2.getSource().getLastUpdateTime() == null) {
                    return 1;
                }
                if (o1.getSource() == null || o1.getSource().getLastUpdateTime() == null) {
                    return -1;
                }
                long result = o2.getSource().getLastUpdateTime().getTime() - o1.getSource().getLastUpdateTime().getTime();
                if (result > 0L) {
                    return -1;
                }
                if (result < 0L) {
                    return 1;
                }
                return 0;
            }
        });
        for (i = 0; i < entries.size(); ++i) {
            this.comments.addEntry((RptComment)entries.get(i));
        }
    }

    protected RptCommentTank getComments() {
        return this.comments;
    }

    protected UserInfo getDefaultAuthor() {
        return this.defaultAuthor;
    }

    protected String getDefaultContent() {
        return this.defaultContent;
    }

    protected Timestamp getCurrTime() {
        return new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public boolean prepare() {
        this._isSave = this._isSave && 0 == this.getMode();
        this.btnSave.setVisible(this._isSave);
        this.btnSubmit.setVisible(!this._isSave);
        this.getContext().getStateManager().stop();
        RptCommentTank _comments = null;
        if (this.getMode() == 2) {
            _comments = this.getComments(this.getContext().getBook());
        } else if (this.getMode() == 1) {
            _comments = this.getComments(this.getContext().getBook().getActiveSheet());
        } else if (this.getMode() == 0) {
            _comments = this.getComments(this.getContext().getBook().getActiveCellRange());
        }
        if (_comments == null) {
            _comments = new RptCommentTank();
        }
        this.setComments(_comments);
        this.getComments().setTable(this.tblComment);
        this.getComments().refresh();
        if (this.getComments().getSize() > 0) {
            this.commentsCacheMap = new HashMap<String, RptComment>();
            for (int i = 0; i < this.getComments().getSize(); ++i) {
                RptComment rptComment = this.getComments().getEntry(i);
                rptComment.getDate();
                this.commentsCacheMap.put(rptComment.getFullString(), rptComment);
            }
        } else {
            this.commentsCacheMap = new HashMap<String, RptComment>();
        }
        return true;
    }

    public void initComment(RptCommentTank comment) {
        if (comment != null) {
            this.setComments(comment);
        } else {
            RptCommentTank _comments = new RptCommentTank();
            this.setComments(_comments);
        }
        this.getComments().setTable(this.tblComment);
        this.getComments().refresh();
        if (this.getComments().getSize() > 0) {
            this.commentsCacheMap = new HashMap<String, RptComment>();
            for (int i = 0; i < this.getComments().getSize(); ++i) {
                RptComment rptComment = this.getComments().getEntry(i);
                rptComment.getDate();
                this.commentsCacheMap.put(rptComment.getFullString(), rptComment);
            }
        } else {
            this.commentsCacheMap = new HashMap<String, RptComment>();
        }
        this.initialize();
        int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
        this.txtComment.setText(this.getComments().getContent(activeRowIndex));
    }

    protected RptCommentTank getComments(Object obj) {
        if (obj == null) {
            return null;
        }
        Comment comment = null;
        if (obj.getClass().isAssignableFrom(Range.class)) {
            comment = ((Range)obj).getComment();
        } else if (obj.getClass().isAssignableFrom(Sheet.class)) {
            comment = ((Sheet)obj).getComment();
        } else if (obj.getClass().isAssignableFrom(Book.class)) {
            comment = ((Book)obj).getComment();
        }
        if (comment == null) {
            return null;
        }
        RptCommentTank ct = null;
        if (comment instanceof RptCommentTank) {
            ct = (RptCommentTank)comment;
        } else if (comment instanceof Comment) {
            ct = this.convertComment(comment);
        }
        return ct;
    }

    protected RptCommentTank convertComment(Comment comment) {
        if (comment == null) {
            return null;
        }
        RptCommentTank ct = new RptCommentTank();
        if (comment instanceof BgTemplateCommentTank) {
            BgTemplateComment temComment = null;
            for (int i = 0; i < ((BgTemplateCommentTank)comment).getSize(); ++i) {
                RptComment rptComment = new RptComment();
                temComment = ((BgTemplateCommentTank)comment).getEntry(i);
                rptComment.author = this.getDefaultAuthor();
                rptComment.setContent(temComment.getContent());
                rptComment.date = temComment.getDateTimeStamp();
                ct.addEntry(rptComment);
            }
        } else {
            RptComment rptComment = new RptComment();
            rptComment.author = this.getDefaultAuthor();
            rptComment.setContent(comment.getText());
            rptComment.date = this.getCurrTime();
            ct.addEntry(rptComment);
        }
        return ct;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public boolean isModal() {
        return true;
    }

    public void commit() {
        if (!this.isCancel()) {
            this.getContext().getStateManager().stop();
            RptCommentTank ct = this.getComments();
            if (ct == null || ct.getSize() <= 0) {
                ct = null;
            }
            if (this.getMode() == 2) {
                this.getContext().getBook().setComment((Comment)ct);
            } else if (this.getMode() == 1) {
                this.getContext().getBook().getActiveSheet().setComment((Comment)ct);
            } else if (this.getMode() == 0) {
                Cell cell = this.getActiveCell();
                cell.setComment((Comment)ct);
            }
        }
    }

    protected Cell getActiveCell() {
        Range range = this.getContext().getRangeManager().getSelectionRange();
        CellBlock cb = range.getBlock(0);
        Cell cell = this.getContext().getBook().getActiveSheet().getCell(cb.getRow(), cb.getCol(), true);
        return cell;
    }

    public static IWizzardComment createCommentUI(Object parent, SpreadContext context, boolean isSave) throws UIException {
        String oprtState = OprtState.ADDNEW;
        if (parent instanceof CoreUI && ((CoreUI)parent).getOprtState() != null) {
            oprtState = ((CoreUI)parent).getOprtState();
        }
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCommentEditUI.class.getName(), (Map)new UIContext(parent), null, oprtState);
        BgCommentEditUI ui = (BgCommentEditUI)window.getUIObject();
        ui.setIsSave(isSave);
        ui.setContext(context);
        return ui;
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        RptComment cmt = this.createComment();
        this.getComments().addEntry(cmt);
        this.tblComment.getSelectManager().select(this.getComments().indexOf(cmt), 1, 2);
        this.txtComment.setText(this.getDefaultContent());
        this.txtComment.requestFocus();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
        RptComment rc = this.getComments().getEntry(activeRowIndex);
        if (rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId())) {
            if (this.getComments().deletEntry(this.tblComment.getSelectManager().getActiveRowIndex())) {
                this.txtComment.setText("");
                this.tblComment.getSelectManager().select(0, 1, 2);
                if (this.tblComment.getExpandedRowCount() > 0) {
                    this.txtComment.setText(this.getComments().getContent(0));
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.remove"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.isEditor() && this.checkHasComment()) {
            this.submitComment();
        }
        this.orignComments.copyFrom(new RptCommentTank());
        for (int i = 0; i < this.getComments().getSize(); ++i) {
            this.orignComments.addEntry(this.getComments().getEntry(i));
        }
        this.disposeUIWindow();
        this.setIsCancel(false);
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.btnSubmit_actionPerformed(e);
        BgFormInfo bgFormInfo = null;
        Object ownerUi = this.getUIContext().get("Owner");
        if (ownerUi instanceof BgNFProcessUI) {
            bgFormInfo = ((BgNFProcessUI)ownerUi).getBgFormInfo();
        }
        BgCommentClientHelper.saveBgComments(this.getActiveCell(), this.getComments(), (IDimDataQuery)bgFormInfo);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setIsCancel(true);
        this.disposeUIWindow();
    }

    @Override
    protected void tblComment_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int preRowIndex = -1;
        int rowIndex = -1;
        if (e.getPrevSelectBlock() != null) {
            preRowIndex = e.getPrevSelectBlock().getBeginRow();
        }
        if (e.getSelectBlock() != null) {
            rowIndex = e.getSelectBlock().getBeginRow();
        }
        String text = this.txtComment.getText();
        if (preRowIndex >= 0 && rowIndex >= 0) {
            if (!StringUtils.isEmpty((String)text) && this.tblComment.getRow(preRowIndex) != null && this.tblComment.getRow(preRowIndex).getCell("comment.text") != null) {
                this.tblComment.getRow(preRowIndex).getCell("comment.text").setValue((Object)text);
                RptComment rc = this.getComments().getEntry(preRowIndex);
                String oldText = rc.getContent();
                rc.setContent(text);
                rc.getDate();
                if (!(this.commentsCacheMap == null || this.commentsCacheMap.containsKey(rc.getFullString()) || rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId()))) {
                    this.tblComment.getRow(preRowIndex).getCell("comment.text").setValue((Object)oldText);
                    rc.setContent(oldText);
                    this.txtComment.setText(this.getComments().getContent(rowIndex));
                    MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.edit"));
                    SysUtil.abort();
                }
            }
            this.txtComment.setText(this.getComments().getContent(rowIndex));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.tblComment.getRowCount() > 0 && StringUtils.isEmpty((String)this.txtComment.getText())) {
            BgNFCHelper.setFocusTo((Component)this.txtComment);
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.context"));
            SysUtil.abort();
        }
    }

    protected void submitComment() throws Exception {
        RptComment rc;
        this.checkSelected();
        if (this.commentsCacheMap != null && this.commentsCacheMap.size() > 0) {
            if (this.getComments().getSize() > 0) {
                for (int i = 0; i < this.getComments().getSize(); ++i) {
                    rc = this.getComments().getEntry(i);
                    rc.getDate();
                    if (this.commentsCacheMap.containsKey(rc.getFullString())) continue;
                    if (rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId())) {
                        this.getComments().setContent(this.tblComment.getSelectManager().getActiveRowIndex(), this.txtComment.getText());
                        continue;
                    }
                    MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.edit"));
                    SysUtil.abort();
                }
            } else {
                for (String key : this.commentsCacheMap.keySet()) {
                    RptComment rc2 = this.commentsCacheMap.get(key);
                    if (rc2.author != null && this.getDefaultAuthor().getId().equals((Object)rc2.author.getId())) {
                        this.getComments().setContent(this.tblComment.getSelectManager().getActiveRowIndex(), this.txtComment.getText());
                        continue;
                    }
                    MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.edit"));
                    SysUtil.abort();
                }
            }
        }
        int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
        rc = this.getComments().getEntry(activeRowIndex);
        if (rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId())) {
            rc.setContent(this.txtComment.getText());
        } else if (!rc.getContent().equals(this.txtComment.getText())) {
            this.txtComment.setText(rc.getContent());
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.edit"));
            SysUtil.abort();
        }
    }

    protected void checkSelected() {
        if (this.tblComment.getRowCount() == 0 || this.tblComment.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected boolean checkHasComment() {
        return this.tblComment.getRowCount() != 0;
    }

    protected RptComment createComment() {
        RptComment comment = new RptComment();
        comment.author = this.getDefaultAuthor();
        comment.content = this.getDefaultContent();
        comment.date = this.getCurrTime();
        return comment;
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        return re;
    }

    public void close() {
        this.setContext(null);
        this.comments = null;
    }

    @Override
    protected void txtComment_focusLost(FocusEvent e) throws Exception {
        int count = this.tblComment.getRowCount();
        if (count == 1) {
            int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
            RptComment rc = this.getComments().getEntry(activeRowIndex);
            if (rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId())) {
                this.getComments().setText(this.txtComment.getText());
            }
        }
    }
}

