/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.mbg.BgCourseFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgCourseFacade;
import com.kingdee.eas.ma.mbg.client.AbstractBgCoursePlanUI;
import com.kingdee.eas.ma.mbg.client.BgFormCourseListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgCoursePlanUI
extends AbstractBgCoursePlanUI {
    private static final long serialVersionUID = 3880302497483996808L;
    private static final Logger logger = CoreUIObject.getLogger(BgCoursePlanUI.class);
    private NumberExpendRender render = new NumberExpendRender(0);
    private boolean hasQueryType = true;
    private int sel_orgunit = 0;
    private int columns_count = 0;
    private BgFormCourseListUI ui = null;
    private BgOrgUnitInfo unitInfo = null;
    private String[] selOrgs = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.ui = (BgFormCourseListUI)((Object)this.getUIContext().get("Owner"));
        this.sel_orgunit = (Integer)this.getUIContext().get("SEL_ORGUNIT_TYPE");
        this.unitInfo = (BgOrgUnitInfo)this.getUIContext().get("SEL_ORGUNIT_INFO");
        this.selOrgs = (String[])this.getUIContext().get("SEL_ORGS");
        this.viewOrgUnit();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initShow();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgCoursePlanUI.this.tblMain_tableClicked(e);
                }
                catch (Exception ex) {
                    BgCoursePlanUI.this.handUIException(ex);
                }
            }
        });
    }

    protected IBgCourseFacade getInterface() throws Exception {
        return BgCourseFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuTool.setEnabled(false);
        this.menuTool.setVisible(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        JMenuItem jmi = this.btnPrint.addAssistMenuItem((Action)((Object)this.actionPrintPreview));
        jmi.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void initShow() {
        IUIWindow window = this.getUIWindow();
        if (window instanceof KDFrame) {
            ((KDFrame)window).setExtendedState(6);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    @Override
    public void actionViewPlan_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewPlan_actionPerformed(e);
        if (this.hasQueryType) {
            this.viewOrgUnit();
        } else {
            if (this.selOrgs == null || this.selOrgs.length == 0) {
                this.selOrgs = new String[this.getDisplayOrgIdList().size()];
                for (int i = 0; i < this.getDisplayOrgIdList().size(); ++i) {
                    this.selOrgs[i] = this.getDisplayOrgIdList().get(i).toString();
                }
            }
            this.viewScheme();
        }
    }

    protected void viewOrgUnit() throws Exception {
        this.hasQueryType = false;
        this.initOrgHead();
        this.initOrgExpendInfo();
        this.fillOrgData();
    }

    protected void viewScheme() throws Exception {
        this.hasQueryType = true;
        List<String> idList = this.getDisplayOrgIdList();
        this.initSchemeHead();
        this.fillSchemeData(idList);
    }

    private List<String> getDisplayOrgIdList() {
        int rowCount3 = this.tblMain.getRowCount3();
        if (rowCount3 <= 0) {
            return null;
        }
        Set<String> rootOrgIdList = this.ui.getRootOrgIdList();
        ArrayList<String> list = new ArrayList<String>();
        IRow row = null;
        for (int i = this.tblMain.getRowCount3() - 1; i >= 0; --i) {
            BgOrgUnitInfo bgOrgInfo;
            Object value;
            row = this.tblMain.getRow(i);
            if (row.getStyleAttributes().isHided() || !((value = row.getCell(0).getUserObject()) instanceof BgOrgUnitInfo) || (bgOrgInfo = (BgOrgUnitInfo)value).getOrgUnitID() == null || rootOrgIdList == null || rootOrgIdList.contains(bgOrgInfo.getOrgUnitID())) continue;
            list.add(bgOrgInfo.getOrgUnitID());
        }
        return list;
    }

    protected void initHead() throws Exception {
        IRow row = null;
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.columns_count = 22;
        this.tblMain.addColumns(this.columns_count);
        row = this.tblMain.addHeadRow();
        row.getCell(1).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_bgScheme"));
        row.getCell(2).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_bgPeriod"));
        row.getCell(3).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_currency"));
        row.getCell(4).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_version"));
        row.getCell(5).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_count"));
        row.getCell(6).setValue((Object)BgFormStateEnum.CANTEDIT.getAlias());
        row.getCell(8).setValue((Object)BgFormStateEnum.Edited.getAlias());
        row.getCell(10).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"courseSubmit"));
        row.getCell(12).setValue((Object)BgFormStateEnum.Approving.getAlias());
        row.getCell(14).setValue((Object)BgFormStateEnum.Report.getAlias());
        row.getCell(16).setValue((Object)BgFormStateEnum.Certificate.getAlias());
        row.getCell(18).setValue((Object)BgFormStateEnum.Back.getAlias());
        row.getCell(20).setValue((Object)BgFormStateEnum.Approved.getAlias());
        row = this.tblMain.addHeadRow();
        for (int i = 6; i < this.columns_count; ++i) {
            row.getCell(i).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_amount"));
            row.getCell(++i).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_rate"));
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 5, 1, 5);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 6, 0, 7);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 8, 0, 9);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 10, 0, 11);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 12, 0, 13);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 14, 0, 15);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 16, 0, 17);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 18, 0, 19);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 20, 0, 21);
        this.tblMain.getColumn(0).setRenderer((IBasicRender)this.render);
        this.tblMain.getColumn(0).setWidth(250);
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(6).setUserObject((Object)BgFormStateEnum.CANTEDIT);
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(7).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(8).setUserObject((Object)BgFormStateEnum.Edited);
        this.tblMain.getColumn(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(9).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(10).setUserObject((Object)BgFormStateEnum.REFERRING);
        this.tblMain.getColumn(10).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(11).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(11).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(12).setUserObject((Object)BgFormStateEnum.Approving);
        this.tblMain.getColumn(12).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(13).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(13).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(14).setUserObject((Object)BgFormStateEnum.Report);
        this.tblMain.getColumn(14).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(15).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(15).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(16).setUserObject((Object)BgFormStateEnum.Certificate);
        this.tblMain.getColumn(16).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(17).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(17).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(18).setUserObject((Object)BgFormStateEnum.Back);
        this.tblMain.getColumn(18).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(19).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(19).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(20).setUserObject((Object)BgFormStateEnum.Approved);
        this.tblMain.getColumn(20).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(21).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(21).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed(true);
    }

    protected void initOrgHead() throws Exception {
        this.initHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_orgUnit"));
    }

    protected void initSchemeHead() throws Exception {
        this.initHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "title_template"));
    }

    protected void initOrgExpendInfo() throws Exception {
        if (this.unitInfo == null) {
            return;
        }
        BgPeriodInfo[] bgPeriods = this.getBgPeriodArr();
        BgVersionInfo[] bgVersions = this.getBgVersionArr();
        if (bgPeriods == null || bgVersions == null) {
            return;
        }
        IRow row = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgVersionInfo bgVersionInfo = null;
        for (int p = 0; p < bgPeriods.length; ++p) {
            bgPeriodInfo = bgPeriods[p];
            for (int v = 0; v < bgVersions.length; ++v) {
                bgVersionInfo = bgVersions[v];
                if (this.sel_orgunit == 1) {
                    row = this.tblMain.addRow();
                    NumberExpandInfo _expend = new NumberExpandInfo();
                    _expend.setId(this.unitInfo.getId().toString());
                    _expend.setName(this.unitInfo.getName());
                    _expend.setNumber(this.unitInfo.getNumber());
                    _expend.setLongNumber(this.unitInfo.getLongNumber());
                    _expend.setLevel(this.unitInfo.getLevel());
                    _expend.setLeaf(true);
                    row.getCell(0).setValue((Object)_expend);
                    row.getCell(0).setUserObject((Object)this.unitInfo);
                    continue;
                }
                if (this.sel_orgunit == 2) {
                    this.createTreeModel(this.unitInfo.getLongNumber(), bgPeriodInfo, bgVersionInfo);
                    continue;
                }
                this.createTreeModel(bgPeriodInfo, bgVersionInfo);
            }
        }
        this.hideNotSelectedNode();
    }

    private void hideNotSelectedNode() {
        int rowCount3;
        int i;
        IRow row = null;
        BgOrgUnitInfo selectBgOrgUnitInfo = this.getSelectBgOrgUnitInfo();
        if (selectBgOrgUnitInfo == null) {
            return;
        }
        String selectLongNumber = selectBgOrgUnitInfo.getLongNumber();
        BgOrgUnitInfo[] bgOrgUnitInfo4Filter = this.getBgOrgUnitInfo4Filter();
        if (bgOrgUnitInfo4Filter == null || bgOrgUnitInfo4Filter.length == 0) {
            return;
        }
        HashSet<String> bgOrgUnitInfo4FilterSet = new HashSet<String>();
        if (bgOrgUnitInfo4Filter != null && bgOrgUnitInfo4Filter.length != 0) {
            for (i = 0; i < bgOrgUnitInfo4Filter.length; ++i) {
                BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitInfo4Filter[i];
                if (bgOrgUnitInfo == null || StringUtils.isEmpty((String)bgOrgUnitInfo.getLongNumber()) || !bgOrgUnitInfo.getLongNumber().startsWith(selectLongNumber)) continue;
                bgOrgUnitInfo4FilterSet.add(bgOrgUnitInfo.getLongNumber());
            }
        }
        if (bgOrgUnitInfo4FilterSet.isEmpty()) {
            for (i = this.tblMain.getRowCount3() - 1; i >= 0; --i) {
                row = this.tblMain.getRow(i);
                row.getStyleAttributes().setHided(true);
            }
        }
        if ((rowCount3 = this.tblMain.getRowCount3()) <= 0) {
            return;
        }
        for (int i2 = this.tblMain.getRowCount3() - 1; i2 >= 0; --i2) {
            NumberExpandInfo expend;
            String curLongNumber;
            row = this.tblMain.getRow(i2);
            Object value = row.getCell(0).getValue();
            if (!(value instanceof NumberExpandInfo) || StringUtils.isEmpty((String)(curLongNumber = (expend = (NumberExpandInfo)value).getLongNumber()))) continue;
            boolean isHide = true;
            for (String longNumber : bgOrgUnitInfo4FilterSet) {
                if (!longNumber.startsWith(curLongNumber) && !curLongNumber.equals(selectLongNumber)) continue;
                isHide = false;
            }
            if (!isHide) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    protected TreeModel getTreeModel() throws Exception {
        Object cu = null;
        Object model = null;
        return this.ui.getFullTreeModel();
    }

    protected void createTreeModel(String longnumber, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws Exception {
        if (longnumber == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel().getRoot();
        this.createTreeModel(longnumber, (BgOrgUnitInfo)root.getUserObject(), null, bgPeriodInfo, bgVersionInfo);
        this.dealTreeModel((DefaultKingdeeTreeNode)this.ui.orgTree.getLastSelectedPathComponent());
    }

    private void dealTreeModel(DefaultKingdeeTreeNode root) throws Exception {
        HashMap<String, BgOrgUnitInfo> orgMap = new HashMap<String, BgOrgUnitInfo>();
        this.fetchOrgIdFromTree(root, orgMap);
        this.filterAllOrgsByOrgRange(orgMap);
        this.filterOrgsBySelOrg(orgMap);
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null || row.getCell(0) == null || !(row.getCell(0).getUserObject() instanceof BgOrgUnitInfo) || orgMap.containsKey(((BgOrgUnitInfo)row.getCell(0).getUserObject()).getOrgUnitID())) continue;
            this.tblMain.removeRow(i);
        }
    }

    private static String getBgOrgUnitIdByOrgUnitId(String orgUnitId, String bgOrgViewId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
        evi.setFilter(filter);
        evi.getSelector().add("FID");
        BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        String id = null;
        if (!colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                id = colls.get(i).getId().toString();
            }
        }
        return id;
    }

    protected void createTreeModel(String longnumber, BgOrgUnitInfo unitInfo, NumberExpandInfo expend, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws Exception {
        int i;
        if (unitInfo == null) {
            return;
        }
        IRow row = null;
        DefaultKingdeeTreeNode _node = null;
        NumberExpandInfo _expend = null;
        if (expend == null) {
            expend = new NumberExpandInfo();
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel().getRoot();
        if (unitInfo.getOrgUnitID() != null) {
            if (unitInfo.getLongNumber().startsWith(longnumber + "!") || unitInfo.getLongNumber().equals(longnumber)) {
                int _length2;
                int _length1 = unitInfo.getLongNumber().split("!").length;
                if (_length1 - (_length2 = longnumber.split("!").length) <= 1) {
                    _expend = new NumberExpandInfo();
                    _expend.setId(unitInfo.getOrgUnitID().toString());
                    _expend.setName(unitInfo.getName());
                    _expend.setNumber(unitInfo.getNumber());
                    _expend.setLongNumber(unitInfo.getLongNumber());
                    _expend.setLevel(expend.getLevel() + 1);
                    if (!longnumber.equals(unitInfo.getLongNumber())) {
                        _expend.setLeaf(true);
                    }
                    _expend.setExpandStatus(true);
                    row = this.tblMain.addRow();
                    row.getCell(0).setValue((Object)_expend);
                    row.getCell(0).setUserObject((Object)unitInfo);
                    row.getCell(2).setUserObject((Object)bgPeriodInfo);
                    row.getCell(4).setUserObject((Object)bgVersionInfo);
                }
            } else if (!longnumber.startsWith(unitInfo.getLongNumber() + "!")) {
                return;
            }
        }
        HashSet<String> permissionOrgUnits = new HashSet<String>();
        BgOrgUnitCollection orgUnitColl = null;
        if (unitInfo.getOrgUnitID() != null) {
            orgUnitColl = BgCourseFacadeFactory.getRemoteInstance().getDirectOrgUnits(this.ui.getBgOrgViewId(), unitInfo, false, true);
        } else {
            orgUnitColl = new BgOrgUnitCollection();
            int in = root.getChildCount();
            for (i = 0; i < in; ++i) {
                _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!(_node.getUserObject() instanceof BgOrgUnitInfo)) continue;
                orgUnitColl.add((BgOrgUnitInfo)_node.getUserObject());
            }
        }
        if (orgUnitColl != null && !orgUnitColl.isEmpty()) {
            for (i = 0; i < orgUnitColl.size(); ++i) {
                permissionOrgUnits.add(orgUnitColl.get(i).getOrgUnitID().toString());
            }
        }
        BgOrgUnitInfo _unitInfo = null;
        if (orgUnitColl != null && !orgUnitColl.isEmpty()) {
            int in = orgUnitColl.size();
            for (int i2 = 0; i2 < in; ++i2) {
                _unitInfo = orgUnitColl.get(i2);
                if (_unitInfo.getId().equals((Object)unitInfo.getId()) || !permissionOrgUnits.contains(_unitInfo.getOrgUnitID().toString())) continue;
                this.createTreeModel(longnumber, _unitInfo, _expend, bgPeriodInfo, bgVersionInfo);
            }
        }
    }

    protected void createTreeModel(BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.ui.orgTree.getLastSelectedPathComponent();
        Object nodeTarget = null;
        this.createTreeModel(root, null, bgPeriodInfo, bgVersionInfo);
        this.dealTreeModel(root);
    }

    private void fetchOrgIdFromTree(DefaultKingdeeTreeNode root, Map<String, BgOrgUnitInfo> orgMap) throws Exception {
        BgOrgUnitInfo unitInfo;
        if (root != null && root.getUserObject() != null && root.getUserObject() instanceof BgOrgUnitInfo && (unitInfo = (BgOrgUnitInfo)root.getUserObject()).getLongNumber().indexOf("!") <= 0) {
            orgMap.put(unitInfo.getOrgUnitID(), unitInfo);
        }
        if (this.sel_orgunit == 2) {
            this.fetchDirectOrgs(root, orgMap);
        } else if (this.sel_orgunit == 3) {
            this.fetchAllOrgs(root, orgMap);
        }
    }

    private void fetchDirectOrgs(DefaultKingdeeTreeNode currNode, Map<String, BgOrgUnitInfo> orgMap) throws Exception {
        BgOrgUnitCollection orgUnitColl = BgCourseFacadeFactory.getRemoteInstance().getDirectOrgUnits(this.ui.getBgOrgViewId(), this.unitInfo, false, true);
        if (orgUnitColl.size() <= 0) {
            return;
        }
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            orgMap.put(orgUnitColl.get(i).getOrgUnitID(), orgUnitColl.get(i));
        }
    }

    private void fetchAllOrgs(DefaultKingdeeTreeNode currNode, Map<String, BgOrgUnitInfo> orgMap) throws Exception {
        BgOrgUnitCollection orgAllChildren = BgOrgUnitHelper.getOrgAllChildren(this.unitInfo.getLongNumber(), this.ui.getBgOrgViewId(), false);
        if (orgAllChildren.size() <= 0) {
            return;
        }
        for (int i = 0; i < orgAllChildren.size(); ++i) {
            orgMap.put(orgAllChildren.get(i).getOrgUnitID(), orgAllChildren.get(i));
        }
    }

    private void putNodeOrgToMap(DefaultKingdeeTreeNode childNode, Map<String, BgOrgUnitInfo> orgMap) {
        if (childNode.getUserObject() != null && childNode.getUserObject() instanceof BgOrgUnitInfo) {
            orgMap.put(((BgOrgUnitInfo)childNode.getUserObject()).getOrgUnitID(), (BgOrgUnitInfo)childNode.getUserObject());
        }
    }

    private void filterOrgIdByOrgRange(Set<String> queryOrgIds) {
        if (!BgNSHelper.isFilterByOrgRange()) {
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (ToolUtils.isNullList(queryOrgIds) || userId == null) {
            return;
        }
        OrgRangeCollection collection = null;
        try {
            collection = OrgRangeFactory.getRemoteInstance().findFullOrgCol(Arrays.asList(userId), new ArrayList<String>(queryOrgIds), OrgRangeType.BIZ_ORG_TYPE);
        }
        catch (Exception e) {
            logger.error((Object)"filterOrgIdByOrgRange error", (Throwable)e);
            return;
        }
        HashSet<String> inRangIdSet = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            inRangIdSet.add(collection.get(i).getOrg().getId().toString());
        }
        queryOrgIds.retainAll(inRangIdSet);
    }

    private void filterAllOrgsByOrgRange(Map<String, BgOrgUnitInfo> orgMap) {
        HashSet<String> orgIds = new HashSet<String>(orgMap.keySet());
        if (ToolUtils.isNullList(orgIds) || !BgNSHelper.isFilterByOrgRange()) {
            return;
        }
        orgIds.remove(null);
        HashSet<String> outRangeList = new HashSet<String>(orgIds);
        this.filterOrgIdByOrgRange(orgIds);
        if (ToolUtils.isNullList(orgIds)) {
            orgMap.clear();
            return;
        }
        outRangeList.removeAll(orgIds);
        for (String outRangeId : outRangeList) {
            if (outRangeId == null || this.hashChildInRange(outRangeId, orgIds, orgMap)) continue;
            orgMap.remove(outRangeId);
        }
    }

    private void filterOrgsBySelOrg(Map<String, BgOrgUnitInfo> orgMap) {
        if (this.selOrgs == null || this.selOrgs.length == 0) {
            return;
        }
        HashSet<String> orgIds = new HashSet<String>(orgMap.keySet());
        HashSet<String> selOrgIds = new HashSet<String>(Arrays.asList(this.selOrgs));
        for (String orgId : orgIds) {
            if (orgId == null || selOrgIds.contains(orgId) || this.hashChildInRange(orgId, selOrgIds, orgMap)) continue;
            orgMap.remove(orgId);
        }
    }

    private boolean hashChildInRange(String currOrgId, Set<String> orgIds, Map<String, BgOrgUnitInfo> orgMap) {
        BgOrgUnitInfo currInfo = orgMap.get(currOrgId);
        for (String orgId : orgIds) {
            BgOrgUnitInfo info = orgMap.get(orgId);
            if (currInfo == null || currInfo.getLongNumber() == null || info == null || info.getLongNumber() == null || !info.getLongNumber().contains(currInfo.getLongNumber().concat("!"))) continue;
            return true;
        }
        return false;
    }

    protected void createTreeModel(DefaultKingdeeTreeNode node, NumberExpandInfo expend, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws EASBizException, BOSException {
        if (node == null) {
            return;
        }
        IRow row = null;
        DefaultKingdeeTreeNode _node = null;
        NumberExpandInfo _expend = null;
        if (node.getChildCount() == 0) {
            BgOrgTreeHelper.addChildNode(node, this.ui.getBgOrgViewId(), false, false, true);
        }
        BgOrgUnitInfo unitInfo = (BgOrgUnitInfo)node.getUserObject();
        if (expend == null) {
            expend = new NumberExpandInfo();
        }
        if (unitInfo != null) {
            _expend = new NumberExpandInfo();
            _expend.setId(unitInfo.getOrgUnitID().toString());
            _expend.setName(unitInfo.getName());
            _expend.setNumber(unitInfo.getNumber());
            _expend.setLongNumber(unitInfo.getLongNumber());
            _expend.setLevel(expend.getLevel() + 1);
            if (node.getChildCount() <= 0) {
                _expend.setLeaf(true);
            }
            _expend.setExpandStatus(true);
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)_expend);
            row.getCell(0).setUserObject((Object)unitInfo);
            row.getCell(2).setUserObject((Object)bgPeriodInfo);
            row.getCell(4).setUserObject((Object)bgVersionInfo);
        }
        int in = node.getChildCount();
        for (int i = 0; i < in; ++i) {
            _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.createTreeModel(_node, _expend, bgPeriodInfo, bgVersionInfo);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            NumberExpandInfo _expend;
            Object _obj;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (colIndex == 0 && (_obj = this.tblMain.getCell(rowIndex, colIndex).getValue()) != null && _obj instanceof NumberExpandInfo && this.render.inRect(_expend = (NumberExpandInfo)_obj, e.getX(), e.getY())) {
                this.expendStyle(rowIndex, colIndex, _expend);
            }
        }
    }

    protected void expendStyle(int rowIndex, int colIndex, NumberExpandInfo expend) {
        IRow _row = null;
        String _longNumber = null;
        NumberExpandInfo _expand = null;
        String longnumber = expend.getLongNumber();
        boolean isExpandStatus = expend.isExpandStatus();
        int _rowCount = this.tblMain.getRowCount();
        expend.setExpandStatus(!isExpandStatus);
        for (int _rowIndex = rowIndex + 1; _rowIndex < _rowCount && (_longNumber = (_expand = (NumberExpandInfo)(_row = this.tblMain.getRow(_rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(longnumber + "!"); ++_rowIndex) {
            _row.getStyleAttributes().setHided(isExpandStatus);
            _expand.setExpandStatus(true);
        }
        this.hideNotSelectedNode();
    }

    protected void fillOrgData() throws Exception {
        Object[] _objs;
        this.btnViewPlan.setText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "btnViewTemplate"));
        IRow row = null;
        NumberExpandInfo expend = null;
        BgFormStateEnum state = null;
        BgSchemeInfo _bgSchemeInfo = null;
        BgPeriodInfo _bgPeriodInfo = null;
        CurrencyInfo _currencyInfo = null;
        BgVersionInfo _bgVersion = null;
        boolean _state = false;
        Object _obj = null;
        Integer _key = null;
        BigDecimal _value = null;
        BigDecimal _count = null;
        BigDecimal _sum = null;
        Object _cant = null;
        BigDecimal _tmpValue = null;
        BigDecimal _usedTemplateSum = null;
        BigDecimal _formSum = null;
        BigDecimal _allForm = null;
        Map _tmpMap = null;
        Object _entry = null;
        _obj = this.ui.getBgSchemeInfo();
        if (_obj != null) {
            if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = (BgSchemeInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgSchemeInfo = (BgSchemeInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getBgPeriodInfo()) != null) {
            if (_obj instanceof BgPeriodInfo) {
                _bgPeriodInfo = (BgPeriodInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgPeriodInfo = (BgPeriodInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getCurrencyInfo()) != null) {
            if (_obj instanceof CurrencyInfo) {
                _currencyInfo = (CurrencyInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _currencyInfo = (CurrencyInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getBgVersionInfo()) != null) {
            if (_obj instanceof BgVersionInfo) {
                _bgVersion = (BgVersionInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgVersion = (BgVersionInfo)_objs[0];
            }
        }
        BgPeriodInfo[] bgPeriods = this.getBgPeriodArr();
        BgVersionInfo[] bgVersions = this.getBgVersionArr();
        if (bgPeriods == null || bgVersions == null) {
            return;
        }
        Map _dataMap = this.getInterface().queryOrgInfo(this.ui.getQueryCourseMap());
        Object bgPeriodInfo = null;
        Object bgVersionInfo = null;
        String prefix = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            int j;
            int jn;
            row = this.tblMain.getRow(i);
            bgPeriodInfo = row.getCell(2).getUserObject() instanceof BgPeriodInfo ? row.getCell(2).getUserObject() : bgPeriods[0];
            bgVersionInfo = row.getCell(4).getUserObject() instanceof BgVersionInfo ? row.getCell(4).getUserObject() : bgVersions[0];
            prefix = bgPeriodInfo.getNumber().substring(0, 4);
            row.getCell(1).setValue((Object)_bgSchemeInfo);
            row.getCell(2).setValue((Object)(bgPeriodInfo.getName() + "(" + prefix + ")"));
            row.getCell(3).setValue((Object)_currencyInfo);
            row.getCell(4).setValue(bgVersionInfo);
            expend = (NumberExpandInfo)row.getCell(0).getValue();
            String orgUnitId = expend.getId();
            String bgPeriodId = bgPeriodInfo.getId().toString();
            String bgVersionId = bgVersionInfo.getId().toString();
            String org_period_version = orgUnitId + ";" + bgPeriodId + ";" + bgVersionId;
            if (_dataMap.containsKey(expend.getId())) {
                _tmpMap = (Map)_dataMap.get(expend.getId());
                _count = _tmpMap.containsKey(_key = new Integer(100)) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                if (_dataMap.containsKey(org_period_version)) {
                    _tmpMap = (Map)_dataMap.get(org_period_version);
                }
                _usedTemplateSum = _tmpMap.containsKey(_key = new Integer(10000)) ? new BigDecimal(((Set)_tmpMap.get(_key)).size()) : BgNConstants.ZERO;
                _key = new Integer(10001);
                _formSum = _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                _allForm = _count.subtract(_usedTemplateSum).add(_formSum);
                row.getCell(5).setValue((Object)_allForm);
                jn = this.tblMain.getColumnCount();
                for (j = 8; j < jn; j += 2) {
                    state = (BgFormStateEnum)((Object)this.tblMain.getColumn(j).getUserObject());
                    _key = new Integer(state.getValue());
                    _value = BgNConstants.ZERO;
                    if (_tmpMap.containsKey(_key)) {
                        _value = (BigDecimal)_tmpMap.get(_key);
                    }
                    if (state.getValue() == 1) {
                        _key = new Integer(30);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    } else if (state.getValue() == 2) {
                        _key = new Integer(20);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(43))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(50))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(51))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(4))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(35))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(6))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(12))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    }
                    row.getCell(j).setValue((Object)_value);
                    if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                        row.getCell(j + 1).setValue((Object)_value.divide(_allForm, 8, 4));
                        continue;
                    }
                    row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
                }
                _sum = BgNConstants.ZERO;
                row.getCell(6).setValue((Object)_count.subtract(_usedTemplateSum));
                if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                    row.getCell(7).setValue((Object)_count.subtract(_usedTemplateSum).divide(_allForm, 8, 4));
                    continue;
                }
                row.getCell(7).setValue((Object)BgNConstants.ZERO);
                continue;
            }
            row.getCell(5).setValue((Object)BgNConstants.ZERO);
            jn = this.tblMain.getColumnCount();
            for (j = 6; j < jn; j += 2) {
                row.getCell(j).setValue((Object)BgNConstants.ZERO);
                row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
            }
        }
    }

    protected void fillSchemeData(List<String> idList) throws Exception {
        Object[] _objs;
        this.btnViewPlan.setText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "btnViewOrgUnit"));
        IRow row = null;
        BgFormStateEnum state = null;
        BgSchemeInfo _bgSchemeInfo = null;
        BgPeriodInfo _bgPeriodInfo = null;
        CurrencyInfo _currencyInfo = null;
        BgVersionInfo _bgVersion = null;
        boolean _state = false;
        String _name = null;
        Map.Entry _entry2 = null;
        Object _obj = null;
        Integer _key = null;
        BigDecimal _value = null;
        BigDecimal _count = null;
        Object _sum = null;
        Object _cant = null;
        BigDecimal _tmpValue = null;
        BigDecimal _usedOrUnitIdSum = null;
        BigDecimal _formSum = null;
        BigDecimal _allForm = null;
        Map _tmpMap = null;
        this.tblMain.removeRows();
        Map<String, Object> queryCourseMap = this.ui.getQueryCourseMap();
        if (idList != null && !idList.isEmpty()) {
            queryCourseMap.put("SEL_ORGS", idList.toArray(new String[0]));
        } else {
            queryCourseMap.remove("SEL_ORGS");
        }
        Map _dataMap = this.getInterface().querySchemeInfo(queryCourseMap);
        if (_dataMap == null) {
            return;
        }
        Map _bgTemplateMap = (Map)_dataMap.get("BGTEMPLATE_INFO");
        _obj = this.ui.getBgSchemeInfo();
        if (_obj != null) {
            if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = (BgSchemeInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgSchemeInfo = (BgSchemeInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getBgPeriodInfo()) != null) {
            if (_obj instanceof BgPeriodInfo) {
                _bgPeriodInfo = (BgPeriodInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgPeriodInfo = (BgPeriodInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getCurrencyInfo()) != null) {
            if (_obj instanceof CurrencyInfo) {
                _currencyInfo = (CurrencyInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _currencyInfo = (CurrencyInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getBgVersionInfo()) != null) {
            if (_obj instanceof BgVersionInfo) {
                _bgVersion = (BgVersionInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgVersion = (BgVersionInfo)_objs[0];
            }
        }
        BgPeriodInfo[] bgPeriods = this.getBgPeriodArr();
        BgVersionInfo[] bgVersions = this.getBgVersionArr();
        if (bgPeriods == null || bgVersions == null) {
            return;
        }
        if (_bgTemplateMap != null) {
            String pvKey = null;
            String prefix = null;
            for (int p = 0; p < bgPeriods.length; ++p) {
                _bgPeriodInfo = bgPeriods[p];
                for (int v = 0; v < bgVersions.length; ++v) {
                    _bgVersion = bgVersions[v];
                    for (Map.Entry _entry2 : _bgTemplateMap.entrySet()) {
                        String _rootId = (String)_entry2.getKey();
                        _name = (String)_entry2.getValue();
                        prefix = _bgPeriodInfo.getNumber().substring(0, 4);
                        if (!_dataMap.containsKey(_rootId)) continue;
                        _tmpMap = (Map)_dataMap.get(_rootId);
                        row = this.tblMain.addRow();
                        row.getCell(0).setValue((Object)_name);
                        row.getCell(1).setValue((Object)_bgSchemeInfo);
                        row.getCell(2).setValue((Object)(_bgPeriodInfo.getName() + "(" + prefix + ")"));
                        row.getCell(3).setValue((Object)_currencyInfo);
                        row.getCell(4).setValue((Object)_bgVersion);
                        pvKey = _rootId + ";" + _bgPeriodInfo.getId().toString() + ";" + _bgVersion.getId().toString();
                        _key = new Integer(100);
                        _count = _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                        if (_dataMap.containsKey(pvKey)) {
                            _tmpMap = (Map)_dataMap.get(pvKey);
                        }
                        BigDecimal tempCount = new BigDecimal("0");
                        if (this.ui.getTempCountMap() != null && this.ui.getTempCountMap().containsKey(_rootId)) {
                            tempCount = (BigDecimal)this.ui.getTempCountMap().get(_rootId);
                        }
                        _count = _count.add(tempCount);
                        _key = new Integer(10000);
                        _usedOrUnitIdSum = _tmpMap.containsKey(_key) ? new BigDecimal(((Set)_tmpMap.get(_key)).size()) : BgNConstants.ZERO;
                        _key = new Integer(10001);
                        _formSum = _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                        _allForm = _count.subtract(_usedOrUnitIdSum).add(_formSum);
                        row.getCell(5).setValue((Object)_allForm);
                        int jn = this.tblMain.getColumnCount();
                        for (int j = 8; j < jn; j += 2) {
                            state = (BgFormStateEnum)((Object)this.tblMain.getColumn(j).getUserObject());
                            _key = new Integer(state.getValue());
                            _value = BgNConstants.ZERO;
                            if (_tmpMap.containsKey(_key)) {
                                _value = (BigDecimal)_tmpMap.get(_key);
                            }
                            if (state.getValue() == 1) {
                                _key = new Integer(30);
                                if (_tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                            } else if (state.getValue() == 2) {
                                _key = new Integer(20);
                                if (_tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(43))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(50))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(51))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(4))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(35))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(6))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                if (_tmpMap.containsKey(_key = new Integer(12))) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                            }
                            row.getCell(j).setValue((Object)_value);
                            if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                                row.getCell(j + 1).setValue((Object)_value.divide(_allForm, 8, 4));
                                continue;
                            }
                            row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
                        }
                        row.getCell(6).setValue((Object)_count.subtract(_usedOrUnitIdSum));
                        if (_count.compareTo(BgNConstants.ZERO) != 0) {
                            row.getCell(7).setValue((Object)_count.subtract(_usedOrUnitIdSum).divide(_allForm, 8, 4));
                            continue;
                        }
                        row.getCell(7).setValue((Object)BgNConstants.ZERO);
                    }
                }
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList;
        super.actionRefresh_actionPerformed(e);
        List<Object> list = idList = this.selOrgs == null ? new ArrayList() : Arrays.asList(this.selOrgs);
        if (this.hasQueryType) {
            this.fillSchemeData(idList);
        } else {
            this.fillOrgData();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgNFCHelper.exportKDTableToExcel((Component)((Object)this), this.tblMain, EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"bgCourseForm"), false);
    }

    private BgPeriodInfo[] getBgPeriodArr() {
        BgPeriodInfo[] periodArr = null;
        Object _obj = this.ui.getBgPeriodInfo();
        if (_obj != null) {
            Object[] _objs;
            if (_obj instanceof BgPeriodInfo) {
                periodArr = new BgPeriodInfo[]{(BgPeriodInfo)_obj};
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0) {
                periodArr = new BgPeriodInfo[_objs.length];
                periodArr = (BgPeriodInfo[])_objs;
            }
        }
        return periodArr;
    }

    private BgOrgUnitInfo[] getBgOrgUnitInfo4Filter() {
        Object _obj = this.ui.getBgOrgUnitInfo4Filter();
        ArrayList<BgOrgUnitInfo> orgUnitList = new ArrayList<BgOrgUnitInfo>();
        if (_obj instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] _objs = (BgOrgUnitInfo[])_obj;
            int in = _objs.length;
            for (int i = 0; i < in; ++i) {
                if (!(_objs[i] instanceof BgOrgUnitInfo)) continue;
                orgUnitList.add(_objs[i]);
            }
        }
        return orgUnitList.toArray(new BgOrgUnitInfo[0]);
    }

    private BgOrgUnitInfo getSelectBgOrgUnitInfo() {
        return this.ui.getSelectBgOrgUnitInfo();
    }

    private BgVersionInfo[] getBgVersionArr() {
        int i;
        ArrayList<BgVersionInfo> bgVersions = new ArrayList<BgVersionInfo>();
        Object _obj = this.ui.getBgVersionInfo();
        if (_obj != null) {
            Object[] _objs;
            if (_obj instanceof BgVersionInfo) {
                bgVersions.add((BgVersionInfo)_obj);
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0) {
                for (i = 0; i < _objs.length; ++i) {
                    if (bgVersions.contains(_objs[i])) continue;
                    bgVersions.add((BgVersionInfo)_objs[i]);
                }
            }
        }
        Collections.sort(bgVersions, new Comparator<BgVersionInfo>(){

            @Override
            public int compare(BgVersionInfo o1, BgVersionInfo o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        BgVersionInfo[] bgVersionArr = null;
        if (!bgVersions.isEmpty()) {
            bgVersionArr = new BgVersionInfo[bgVersions.size()];
            for (i = 0; i < bgVersions.size(); ++i) {
                bgVersionArr[i] = (BgVersionInfo)bgVersions.get(i);
            }
        }
        return bgVersionArr;
    }
}

