/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgDataExportUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgExportHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgDataExportUI
extends AbstractBgDataExportUI {
    private static final long serialVersionUID = -167565192499068542L;
    private static final Logger logger = CoreUIObject.getLogger((String)BgDataExportUI.class.getName());
    private UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
    private boolean isRelease = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initDataInfo();
        BgSchemeInfo obj = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        BgNFCHelper.isMutex((Component)((Object)this), obj.getId().toString(), this.user.getId().toString());
        this.isRelease = true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectFilepath.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)BgDataExportUI.this.prmtBgScheme.getData();
                BgPeriodInfo _bgPeriodInfo = (BgPeriodInfo)BgDataExportUI.this.prmtBgPeriod.getData();
                CurrencyInfo _currencyInfo = (CurrencyInfo)BgDataExportUI.this.comCurrency.getSelectedItem();
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "bgScheme_export"), (BOSObjectType)_bgSchemeInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(_bgSchemeInfo.getId()), (String)(_bgSchemeInfo.getNumber() + " - " + _bgSchemeInfo.getName()), (String)"bgScheme_export");
                BgExportHelper.exportFile(BgDataExportUI.this.txtFilepath.getText(), _bgSchemeInfo, _bgPeriodInfo, _currencyInfo);
                LogUtil.afterLog(null, (IObjectPK)pk);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnSelectFilepath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilepath.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
        }
    }

    protected void initDataInfo() throws Exception {
        this.initBgSchemeInfo();
        this.initBgPeriodInfo();
        this.initCurrencyInfo();
        this.initFilepath();
    }

    protected void initBgSchemeInfo() throws Exception {
        this.prmtBgScheme.setEnabled(false);
        Object obj = this.getUIContext().get("BGSCHEME_INFO");
        if (obj != null && obj instanceof BgSchemeInfo) {
            this.prmtBgScheme.setData(obj);
        }
    }

    protected void initBgPeriodInfo() throws Exception {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
    }

    protected void initCurrencyInfo() throws Exception {
        BgSchemeInfo obj = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        BgNFCHelper.setCurrency(this.comCurrency, obj.getOrgUnit().getId(), true);
    }

    protected void initFilepath() throws Exception {
        this.txtFilepath.setEditable(true);
    }

    protected void verifyInput() throws Exception {
        if (this.prmtBgScheme.getData() == null || !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectOutBgScheme"));
            SysUtil.abort();
        }
        if (this.prmtBgPeriod.getData() == null || !(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
            this.prmtBgPeriod.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectOutBgPeriod"));
            SysUtil.abort();
        }
        if (this.comCurrency.getSelectedItem() == null || !(this.comCurrency.getSelectedItem() instanceof CurrencyInfo)) {
            this.comCurrency.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectOutCurrency"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    protected boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease) {
            BgSchemeInfo obj = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            BgNFCHelper.releaseMutexService(obj.getId().toString());
        }
        return bclose;
    }
}

