/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgDataUpdateListUI;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDataUpdateListUI
extends AbstractBgDataUpdateListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgDataUpdateListUI.class);
    private int uiWidth = 800;
    private int uiHeigth = 500;

    public BgDataUpdateListUI() throws Exception {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.getWidth() > 850.0) {
            this.uiWidth = screenSize.width - 50;
            if (this.uiWidth > 1100) {
                this.uiWidth = 1100;
            }
        }
        if (screenSize.getWidth() > 600.0) {
            this.uiHeigth = screenSize.height - 50;
            if (this.uiHeigth > 700) {
                this.uiHeigth = 700;
            }
        }
        this.setPreferredSize(new Dimension(this.uiWidth, this.uiHeigth));
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getStyleAttributes().setLocked(true);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        Set orgNumbers = (Set)this.getUIContext().get("ORG_NUMBERS");
        String bgVersionNumber = (String)this.getUIContext().get("BGVERSION_NUMBER");
        Date dateFrom = (Date)this.getUIContext().get("DATE_FROM");
        Date dateEnd = (Date)this.getUIContext().get("DATE_END");
        List data = BgFinalizedFacadeFactory.getRemoteInstance().queryDataUpdate(bgSchemeInfo.getId().toString(), orgNumbers, bgVersionNumber, dateFrom, dateEnd);
        this.fillData(data);
    }

    protected void fillData(List data) {
        if (data == null || data.isEmpty() || !(data.get(0) instanceof List)) {
            return;
        }
        List headLst = (List)data.get(0);
        if (headLst != null && !headLst.isEmpty()) {
            IRow head = this.tblMain.addHeadRow();
            for (int i = 0; i < headLst.size(); ++i) {
                IColumn column = this.tblMain.addColumn();
                column.setKey((String)headLst.get(i));
                head.getCell(column.getColumnIndex()).setValue(headLst.get(i));
            }
        }
        for (int i = 1; i < data.size(); ++i) {
            if (!(data.get(i) instanceof Map)) continue;
            Map valueMap = (Map)data.get(i);
            IRow row = this.tblMain.addRow();
            for (String key : valueMap.keySet()) {
                row.getCell(key).setValue(valueMap.get(key));
            }
        }
        this.tblMain.getColumn(BgNFSHelper.getHardCodeRes("org")).setGroup(true);
        this.tblMain.getColumn(BgNFSHelper.getHardCodeRes("updator")).setGroup(true);
        this.tblMain.getColumn(BgNFSHelper.getHardCodeRes("updateTime")).setGroup(true);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
    }
}

