/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgDataUpdateUI;
import com.kingdee.eas.ma.mbg.client.BgDataUpdateListUI;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDataUpdateUI
extends AbstractBgDataUpdateUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgDataUpdateUI.class);
    public static final String ORG_NUMBERS = "ORG_NUMBERS";
    public static final String DATE_FROM = "DATE_FROM";
    public static final String DATE_END = "DATE_END";
    public static final String BGVERSION_NUMBER = "BGVERSION_NUMBER";
    private BgSchemeInfo bgSchemeInfo = null;
    protected BgSchemeDimensionHelper helper = null;

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.helper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
            this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        }
        if (this.bgSchemeInfo != null) {
            this.helper = new BgSchemeDimensionHelper(this.bgSchemeInfo.getId().toString());
        }
        this.initOrgPrmt();
        this.initPrmt();
        this.fillDefaultMember();
    }

    private void initOrgPrmt() throws EASBizException, BOSException, UuidException {
        BgViewOrgDimensionF7 orgView = new BgViewOrgDimensionF7((IUIObject)this);
        orgView.setBgOrgViewId(this.getSchemeHelper().getBgOrgViewId());
        orgView.setMultipleSelect(true);
        orgView.setShowVirtualOrg(false);
        orgView.setOnlyLeaf(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setDataNoNotify(null);
    }

    private void initPrmt() throws EASBizException, BOSException {
        NewDimensionMemberSelectDialog dimDialog = new NewDimensionMemberSelectDialog((Component)((Object)this), this.getBgSchemeInfo().getId().toString(), this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_VERSION_NUMBER), null, false, false);
        this.prmtBgVersion.setSelector((KDPromptSelector)dimDialog);
        this.prmtBgVersion.setDisplayFormatter(new IFormatter(){

            public String valueToString(Object o) {
                BgDimensionMember member = null;
                if (o instanceof List && ((List)o).size() == 1 && ((List)o).get(0) instanceof BgDimensionMember) {
                    member = (BgDimensionMember)((List)o).get(0);
                    if (member != null) {
                        return member.getName();
                    }
                } else if (o instanceof MbgViewListResultData) {
                    List members = ((MbgViewListResultData)o).getMembers();
                    member = (BgDimensionMember)members.get(0);
                    return member.getName();
                }
                if (o != null) {
                    return o.toString();
                }
                return null;
            }

            public void applyPattern(String pattern) {
            }
        });
        this.prmtBgVersion.setEditFormatter(new IFormatter(){

            public String valueToString(Object o) {
                BgDimensionMember member = null;
                if (o instanceof List && ((List)o).size() == 1 && ((List)o).get(0) instanceof BgDimensionMember) {
                    member = (BgDimensionMember)((List)o).get(0);
                    if (member != null) {
                        return member.getName();
                    }
                } else if (o instanceof MbgViewListResultData) {
                    List members = ((MbgViewListResultData)o).getMembers();
                    member = (BgDimensionMember)members.get(0);
                    return member.getName();
                }
                if (o != null) {
                    return o.toString();
                }
                return null;
            }

            public void applyPattern(String pattern) {
            }
        });
    }

    private void fillDefaultMember() {
        Map defaultMember = this.getSchemeHelper().getDefaultMember();
        if (defaultMember != null && !defaultMember.isEmpty()) {
            BgVersionInfo versionInfo;
            MbgViewListResultData data = null;
            if (defaultMember.get(DimensionBaseConstants.DEF_VERSION_NUMBER) != null && (versionInfo = (BgVersionInfo)defaultMember.get(DimensionBaseConstants.DEF_VERSION_NUMBER)) != null) {
                data = new MbgViewListResultData();
                data.setMemberType(BgMemberSelectTypeEnum.Member);
                ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
                BgDimensionMember dimMember = new BgDimensionMember(DimensionBaseConstants.DEF_VERSION_NUMBER, DimensionBaseConstants.DEF_VERSION_FIELD, versionInfo.getName(), versionInfo.getNumber());
                members.add(dimMember);
                data.setMembers(members);
                this.prmtBgVersion.setData((Object)data);
            }
        }
    }

    protected Set<String> getOrgNumbers() {
        HashSet<String> orgNumbers;
        block3: {
            block4: {
                block2: {
                    orgNumbers = new HashSet<String>();
                    if (!(this.prmtOrgUnit.getData() instanceof MbgViewListResultData)) break block2;
                    List members = ((MbgViewListResultData)this.prmtOrgUnit.getData()).getMembers();
                    for (BgDimensionMember member : members) {
                        orgNumbers.add(member.getNumber());
                    }
                    break block3;
                }
                if (!(this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo)) break block4;
                orgNumbers.add(((BgOrgUnitInfo)this.prmtOrgUnit.getData()).getNumber());
                break block3;
            }
            if (!(this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo[])) break block3;
            BgOrgUnitInfo[] bgs = (BgOrgUnitInfo[])this.prmtOrgUnit.getData();
            for (int i = 0; i < bgs.length; ++i) {
                orgNumbers.add(bgs[i].getNumber());
            }
        }
        return orgNumbers;
    }

    protected String getBgVersionNumber() {
        String bgVersionNumber = null;
        if (this.prmtBgVersion.getData() instanceof MbgViewListResultData) {
            List members = ((MbgViewListResultData)this.prmtBgVersion.getData()).getMembers();
            bgVersionNumber = ((BgDimensionMember)members.get(0)).getNumber();
        } else if (this.prmtBgVersion.getData() instanceof List) {
            List members = (List)this.prmtBgVersion.getData();
            bgVersionNumber = ((BgDimensionMember)members.get(0)).getNumber();
        }
        return bgVersionNumber;
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        Set<String> orgNumbers = this.getOrgNumbers();
        String bgVersionNumber = this.getBgVersionNumber();
        Date dateFrom = (Date)this.pkDateFrom.getValue();
        Date dateEnd = (Date)this.pkDateEnd.getValue();
        if (StringUtils.isEmpty((String)bgVersionNumber)) {
            MsgBox.showInfo((Component)((Object)this), (String)BgNFSHelper.getHardCodeRes("versionIsNull"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        uiContext.put((Object)ORG_NUMBERS, orgNumbers);
        uiContext.put((Object)BGVERSION_NUMBER, (Object)bgVersionNumber);
        uiContext.put((Object)DATE_FROM, (Object)dateFrom);
        uiContext.put((Object)DATE_END, (Object)dateEnd);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow uiWindow = uiFactory.create(BgDataUpdateListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancle_actionPerformed(e);
        this.destroyWindow();
    }
}

