/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.client.UnionCombinDataF7;
import com.kingdee.eas.ma.biz.client.utils.BizCalcClientHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDynIndexEntryInfo;
import com.kingdee.eas.ma.mbg.BgDynIndexFactory;
import com.kingdee.eas.ma.mbg.BgDynIndexInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DynIndexBgOrgTypeEnum;
import com.kingdee.eas.ma.mbg.DynIndexCslDataEnum;
import com.kingdee.eas.ma.mbg.DynIndexCslOrgTypeEnum;
import com.kingdee.eas.ma.mbg.DynIndexRankEnum;
import com.kingdee.eas.ma.mbg.DynIndexSortEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgDynIndexEditUI;
import com.kingdee.eas.ma.mbg.client.BgDynCalcSetUI;
import com.kingdee.eas.ma.mbg.client.BgDynMembersUI;
import com.kingdee.eas.ma.mbg.client.NewDimensionSelectDialog;
import com.kingdee.eas.ma.mbg.client.analysisReport.BgFetchIndexClientHelper;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.ExprParseHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.LeftBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.OperatorExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RightBracket;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgDynIndexEditUI
extends AbstractBgDynIndexEditUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = -7424858138827484332L;
    private static final Logger logger = CoreUIObject.getLogger(BgDynIndexEditUI.class);
    private MeasureUnitCollection muCol2 = null;
    private int muIndex = 0;
    private Map<String, String> formulaMap = new LinkedHashMap<String, String>();
    private OrgUnitInfo costCenter = null;
    private Map orgRefMap = null;
    private FilterInfo filterInfo;
    private String filterInfoDesc = null;
    private boolean isModifySave = false;
    protected BgSchemeDimensionHelper helper = null;
    private BgSchemeInfo bgSchemeInfo = null;
    private Map<String, Set<String>> refDataName = new HashMap<String, Set<String>>();
    private boolean isRelease = false;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddRow.setEnabled(true);
        this.btnDelRow.setEnabled(true);
        this.btnClearRow.setEnabled(true);
        this.moveUpRowButton.setEnabled(true);
        this.moveDownRowButton.setEnabled(true);
        this.btnDimSet.setEnabled(true);
        this.btnCalSet.setEnabled(true);
        this.btnMoveUp.setEnabled(true);
        this.btnMoveDown.setEnabled(true);
        this.btnDeleteRow.setEnabled(true);
        this.prmtBgOrgSelect.setEnabled(false);
        this.prmtCslOrgSelect.setEnabled(false);
        this.prmtRowDim.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.setButtonEnabled();
    }

    private void setButtonEnabled() {
        boolean isEnabled = false;
        isEnabled = !OprtState.VIEW.equals(this.getOprtState());
        this.btnDimSet.setEnabled(isEnabled);
        this.btnCalSet.setEnabled(isEnabled);
        this.btnMoveUp.setEnabled(isEnabled);
        this.btnMoveDown.setEnabled(isEnabled);
        this.btnDeleteRow.setEnabled(isEnabled);
        this.btnAddRow.setEnabled(isEnabled);
        this.btnDelRow.setEnabled(isEnabled);
        this.btnClearRow.setEnabled(isEnabled);
        this.moveUpRowButton.setEnabled(isEnabled);
        this.moveDownRowButton.setEnabled(isEnabled);
        this.btnCollect.setEnabled(isEnabled);
        this.btnMerge.setEnabled(isEnabled);
    }

    public void onLoad() throws Exception {
        IMeasureUnit iM = MeasureUnitFactory.getRemoteInstance();
        EntityViewInfo muView2 = new EntityViewInfo();
        FilterInfo muFilter2 = new FilterInfo();
        muFilter2.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muFilter2.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        muView2.setFilter(muFilter2);
        muView2.getSorter().add(new SorterItemInfo("number"));
        this.muCol2 = iM.getMeasureUnitCollection(muView2);
        for (int i = 0; i < this.muCol2.size(); ++i) {
            MeasureUnitInfo info = this.muCol2.get(i);
            if (!info.isIsBaseUnit()) continue;
            this.muIndex = i;
        }
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        this.setBgSchemeInfo(bgScheme);
        OrgUnitInfo costCenter = (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        this.setCostCenter(costCenter);
        Map refMap = (Map)this.getUIContext().get("refMap");
        super.onLoad();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.comboBgOrgType.setSelectedIndex(2);
            this.comboCslOrgType.setSelectedIndex(3);
        } else {
            this.txtNumber.setEditable(false);
            if (refMap.containsKey(this.editData.getId().toString())) {
                this.txtName.setEditable(false);
            } else {
                this.txtName.setEditable(true);
            }
        }
        this.initData();
        BgCommHelper.removeEditHelper((KDTable)this.tblCondition);
    }

    public OrgUnitInfo getCostCenter() {
        return this.costCenter;
    }

    public void setCostCenter(OrgUnitInfo costCenter) {
        this.costCenter = costCenter;
    }

    private void initData() throws Exception {
        this.initRowData();
        this.initCslData();
        this.initOrg();
        this.initEntity();
        this.initConditionData();
    }

    private void initRowData() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgDimSettings.*");
        BgSchemeInfo bgschemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(this.getBgSchemeInfo().getId()), sic);
        BgDimSettingsInfo settingInfo = null;
        if (!bgschemeInfo.getBgDimSettings().isEmpty()) {
            BgDimSettingsCollection settingColls = bgschemeInfo.getBgDimSettings();
            settingColls.sort("seq");
            int size = settingColls.size();
            for (int i = 0; i < size; ++i) {
                BgDimSettingsInfo setting = settingColls.get(i);
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(setting.getDimNumber())) continue;
                settingInfo = setting;
                break;
            }
        }
        NewDimensionSelectDialog dialog = this.initDimensionCombF7();
        this.prmtRowDim.addDataChangeListener((DataChangeListener)dialog);
        this.prmtRowDim.setEditable(false);
        this.prmtRowDim.setSelector((KDPromptSelector)dialog);
        this.prmtRowDim.setData(settingInfo);
        this.prmtRowDim.setDisplayFormat("$dimName$");
        this.prmtRowDim.setEnabled(false);
    }

    protected NewDimensionSelectDialog initDimensionCombF7() throws EASBizException, BOSException {
        NewDimensionSelectDialog dialog = new NewDimensionSelectDialog((CoreUI)this, false);
        dialog.setCsl(this.getSchemeHelper().isBgCsl());
        if (this.getBgSchemeInfo() != null) {
            dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        }
        return dialog;
    }

    private void initCslData() {
        this.txtCount.setMinimumNumber((Number)BigDecimal.ONE);
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData != null) {
            this.txtCount.setText(this.editData.getCount());
            if (this.editData.getCslData().getValue() == 1) {
                this.btnMerge.setSelected(true);
                this.btnCollect.setSelected(false);
            } else {
                this.btnMerge.setSelected(false);
                this.btnCollect.setSelected(true);
            }
        }
    }

    private void initOrg() throws Exception {
        this.setOrgUnitFilter();
        this.setCslOrgUnitFilter();
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData != null) {
            this.orgRefMap = BgDynIndexFactory.getRemoteInstance().getOrgMap(this.editData.getId().toString());
            BgOrgUnitInfo[] bgOrg = null;
            OrgUnitInfo[] cslOrg = null;
            if (this.orgRefMap.containsKey("bgOrg")) {
                List bgOrgs = (List)this.orgRefMap.get("bgOrg");
                bgOrg = bgOrgs.toArray(new BgOrgUnitInfo[bgOrgs.size()]);
            }
            if (this.orgRefMap.containsKey("cslOrg")) {
                List cslOrgs = (List)this.orgRefMap.get("cslOrg");
                cslOrg = cslOrgs.toArray(new OrgUnitInfo[cslOrgs.size()]);
            }
            if (this.editData.getBgOrgType().getValue() == 5) {
                this.prmtBgOrgSelect.setEnabled(true);
                this.prmtBgOrgSelect.setDataNoNotify((Object)bgOrg);
            } else {
                this.prmtBgOrgSelect.setEnabled(false);
                this.prmtBgOrgSelect.setValue(null);
            }
            if (this.editData.getCslOrgType().getValue() == 5) {
                this.prmtCslOrgSelect.setDataNoNotify((Object)cslOrg);
                this.prmtCslOrgSelect.setEnabled(true);
            } else {
                this.prmtCslOrgSelect.setEnabled(false);
                this.prmtCslOrgSelect.setValue(null);
            }
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.prmtBgOrgSelect.setEnabled(false);
                this.prmtCslOrgSelect.setEnabled(false);
            }
        }
    }

    private void setCslOrgUnitFilter() throws Exception {
        OrgTreeInfo orgTreeInfo = BgElimContextHelper.getBgElimContext().getCurOrgBound();
        UnionCombinDataF7 oldf7 = (UnionCombinDataF7)this.prmtCslOrgSelect.getSelector();
        UnionCombinDataF7 f7 = new UnionCombinDataF7((IUIObject)this, 3);
        if (!(orgTreeInfo == null || oldf7 != null && orgTreeInfo.getId().toString().equals(oldf7.getTreeID()))) {
            f7.setTreeID(orgTreeInfo.getId().toString());
        } else if (oldf7 != null) {
            f7 = oldf7;
        }
        f7.setDynBuild(true);
        f7.setMultiSelect(true);
        f7.setShowLeaf(true);
        f7.setHelper(this.getSchemeHelper());
        this.prmtCslOrgSelect.setSelector((KDPromptSelector)f7);
    }

    protected void setOrgUnitFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getBgSchemeInfo();
        if (bgScheme == null) {
            return;
        }
        bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, number, name, orgUnit.id where id = '" + bgScheme.getId().toString() + "'");
        BgViewOrgDimensionF7 orgDialog = new BgViewOrgDimensionF7((IUIObject)this);
        orgDialog.setPermissionFilter(true);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScheme.getId().toString());
        orgDialog.setBgOrgViewId(schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
        orgDialog.setOrgUnitId(bgScheme.getOrgUnit().getId().toString());
        orgDialog.setShowVirtualOrg(false);
        orgDialog.setOnlyNoLeaf(false);
        orgDialog.setOnlyLeaf(false);
        orgDialog.setMultipleSelect(true);
        this.prmtBgOrgSelect.setSelector((KDPromptSelector)orgDialog);
    }

    private void setDefaultOrgUnit(String bgOrgViewId) throws EASBizException, BOSException {
        if (DimensionCommonHelper.isEmpty(this.getCostCenter())) {
            return;
        }
        String costOrgId = this.getCostCenter().getId().toString();
        String selectOrgUnitId = null;
        if (this.prmtBgOrgSelect.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo o = (BgOrgUnitInfo)this.prmtBgOrgSelect.getData();
            if (StringUtils.isEmpty((String)o.getOrgUnitID())) {
                o = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId where id = '" + o.getId() + "'");
            }
            selectOrgUnitId = o.getOrgUnitID();
        } else if (this.prmtBgOrgSelect.getData() instanceof OrgUnitInfo) {
            selectOrgUnitId = ((OrgUnitInfo)this.prmtBgOrgSelect.getData()).getId().toString();
        }
        if (selectOrgUnitId == null) {
            selectOrgUnitId = "000000000000000000000000000=";
        }
        BgOrgUnitCollection defaultOrg = null;
        defaultOrg = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select * where isVirtual = 0  and viewId = '" + bgOrgViewId + "' and (orgUnitId = '" + costOrgId + "' or orgUnitId = '" + selectOrgUnitId + "')");
        if (defaultOrg == null || defaultOrg.size() == 0) {
            this.prmtBgOrgSelect.setData(null);
        } else if (defaultOrg.size() == 1) {
            this.prmtBgOrgSelect.setData((Object)defaultOrg.get(0));
        } else {
            for (int i = 0; i < defaultOrg.size(); ++i) {
                if (!costOrgId.equals(defaultOrg.get(i).getOrgUnitID())) continue;
                this.prmtBgOrgSelect.setData((Object)defaultOrg.get(i));
                break;
            }
        }
    }

    private void initEntity() {
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData != null && this.editData.getEntity() != null) {
            this.formulaMap.clear();
            this.refDataName.clear();
            for (int i = 0; i < this.editData.getEntity().size(); ++i) {
                this.formulaMap.put(this.editData.getEntity().get(i).getDataName(), this.editData.getEntity().get(i).getFormula());
                if (!this.editData.getEntity().get(i).isCalc()) continue;
                String formula = this.editData.getEntity().get(i).getNameFormula();
                this.addRefDataName(formula, this.editData.getEntity().get(i).getDataName());
            }
            HashMap<String, MeasureUnitInfo> map = new HashMap<String, MeasureUnitInfo>();
            for (int i = 0; i < this.muCol2.size(); ++i) {
                map.put(this.muCol2.get(i).getId().toString(), this.muCol2.get(i));
            }
            IRow row = null;
            for (int i = 0; i < this.kdtEntity.getRowCount(); ++i) {
                String unitID;
                row = this.kdtEntity.getRow(i);
                if (!(row.getCell("unit").getValue() instanceof String) || !map.containsKey(unitID = row.getCell("unit.id").getValue().toString())) continue;
                row.getCell("unit").setValue(map.get(unitID));
            }
        }
    }

    private void initConditionData() throws Exception {
        this.formateCondition();
        this.formateCompareValue();
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData != null) {
            this.tblCondition.removeRows();
            if (this.editData.getCondition() != null) {
                this.filterInfo = new FilterInfo(this.editData.getCondition(), true);
                if (this.editData.getMaskString() != null) {
                    this.filterInfo.setMaskString(this.editData.getMaskString());
                }
                if (this.filterInfo != null && !this.filterInfo.getFilterItems().isEmpty()) {
                    this.fillFilterTableBody();
                }
            }
        }
    }

    protected void fillFilterTableBody() throws BaseCommonQueryClientException {
        if (this.filterInfo != null && !this.filterInfo.getFilterItems().isEmpty()) {
            String express = this.filterInfo.getMaskString();
            if (express == null && this.filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < this.filterInfo.getFilterItems().size(); ++i) {
                    express = i == 0 ? "#" + i : express + " AND #" + i;
                }
            }
            int filterSize = this.filterInfo.getFilterItems().size();
            List<Map<String, String>> brachets = this.analysisEpress(express);
            if (filterSize > 0) {
                ArrayList rowInfos = BgEntityUtil.getRowInfos((FilterInfo)this.filterInfo);
                for (int i = 0; i < filterSize; ++i) {
                    RowObject rowObject = (RowObject)rowInfos.get(i);
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    this.tblCondition.addRow(i);
                    rowObject.setLeftBracket(rowObject.getLeftBracket());
                    rowObject.setCondition(filterItemInfo.getPropertyName());
                    if (filterItemInfo.getCompareValue() != null) {
                        rowObject.setCompare(filterItemInfo.getCompareType().getName());
                        rowObject.setCompareValue(filterItemInfo.getCompareValue());
                    } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                        String compare = filterItemInfo.getCompareType().getName();
                        if (compare.equalsIgnoreCase("=")) {
                            compare = "IS";
                        }
                        if (compare.equalsIgnoreCase("<>")) {
                            compare = "IS NOT";
                        }
                        rowObject.setCompare(compare);
                        rowObject.setCompareValue(null);
                    }
                    rowObject.setRightBracket(brachets.get(i).get(")"));
                    rowObject.setLeftBracket(brachets.get(i).get("("));
                    rowObject.setLogic(rowObject.getLogic());
                    this.loadFilter(i, rowObject);
                }
            }
        }
    }

    protected List<Map<String, String>> analysisEpress(String express) {
        if (express == null) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<String> logicSet = new ArrayList<String>();
        logicSet.add("AND");
        logicSet.add("OR");
        String upperExp = express.toUpperCase();
        ArrayList<String> expressList = new ArrayList<String>();
        expressList.add(upperExp);
        List<String> expressItems = null;
        for (int i = 0; i < logicSet.size(); ++i) {
            String logic = (String)logicSet.get(i);
            if (logic == null) continue;
            expressItems = this.parseExpress(expressList, logic);
        }
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>();
        if (expressItems == null || expressItems.isEmpty()) {
            return returnList;
        }
        for (int i = 0; i < expressItems.size(); ++i) {
            StringBuilder right = new StringBuilder();
            StringBuilder left = new StringBuilder();
            String expressItem = expressItems.get(i).trim();
            ArrayList<String> list = new ArrayList<String>();
            char[] chars = expressItem.toCharArray();
            for (int k = 0; k < chars.length; ++k) {
                list.add(String.valueOf(chars[k]));
            }
            for (String s : list) {
                if (s.contains(")")) {
                    right.insert(0, s);
                    continue;
                }
                if (!s.contains("(")) continue;
                left.insert(0, s);
            }
            HashMap<String, String> bracketItemMap = new HashMap<String, String>();
            bracketItemMap.put(")", right.toString());
            bracketItemMap.put("(", left.toString());
            returnList.add(bracketItemMap);
        }
        return returnList;
    }

    protected List<String> parseExpress(List<String> expressList, String logic) {
        if (expressList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)expressList.get(0))) {
            return null;
        }
        if (StringUtils.isEmpty((String)logic)) {
            return expressList;
        }
        String expressItem = null;
        String[] splitItems = null;
        ArrayList arrayListTmp = null;
        for (int i = 0; i < expressList.size(); ++i) {
            expressItem = expressList.get(i);
            if (expressItem == null || expressItem.indexOf(logic) == -1) continue;
            splitItems = expressItem.split(logic);
            arrayListTmp = new ArrayList(splitItems.length);
            Collections.addAll(arrayListTmp, splitItems);
            expressList.remove(i);
            expressList.addAll(i, arrayListTmp);
            --i;
        }
        return expressList;
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = BgFetchIndexClientHelper.FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    protected void setNullSignLocked(int rowIndex) {
        ICell iCell = this.tblCondition.getRow(rowIndex).getCell(3);
        if (this.tblCondition.getRow(rowIndex).getCell(2).getValue() != null) {
            String filter_compare_sign = this.tblCondition.getRow(rowIndex).getCell(2).getValue().toString();
            if (filter_compare_sign.equals(CompareSignDateEnum.NULLSIGN.toString()) || filter_compare_sign.equals(CompareSignDateEnum.NOTNULLSIGN.toString())) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else {
                iCell.getStyleAttributes().setLocked(false);
            }
        }
    }

    protected void loadCompareValue(int rowIndex, RowObject rowObject) {
        this.setNullSignLocked(rowIndex);
        this.tblCondition.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        if (this.isNullSign(rowObject.getCompare())) {
            this.tblCondition.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
    }

    protected boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    protected void loadLeftBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.tblCondition, (int)rowIndex, (int)0, (String)LeftBracketSignEnum.class.getName(), (String)rowObject.getLeftBracket());
    }

    protected void loadCondition(int rowIndex, RowObject rowObject) {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            if (strCondition.indexOf("%") != -1) {
                this.tblCondition.getRow(rowIndex).getCell(1).setValue((Object)strCondition);
            } else {
                this.tblCondition.getRow(rowIndex).getCell(1).setValue((Object)strCondition);
            }
        }
    }

    protected void loadCompareSign(int rowIndex, RowObject rowObject) {
        String targetProperty = BgEntityUtil.getPropertyName((String)rowObject.getCondition());
        String compare = rowObject.getCompare();
        if (compare.equalsIgnoreCase(CompareType.NOTLIKE.toString())) {
            if (!rowObject.getCompareValue().toString().startsWith("%") && rowObject.getCompareValue().toString().endsWith("%")) {
                compare = "NOT LEFT LIKE";
            }
        } else if (compare.equalsIgnoreCase(CompareType.LIKE.toString())) {
            if (rowObject.getCompareValue().toString().startsWith("%") && !rowObject.getCompareValue().toString().endsWith("%")) {
                compare = "RIGHT LIKE";
            } else if (!rowObject.getCompareValue().toString().startsWith("%") && rowObject.getCompareValue().toString().endsWith("%")) {
                compare = "LEFT LIKE";
            }
        }
        KDComboBox comboBox = BgEntityUtil.setEnumComboBoxField((KDTable)this.tblCondition, (int)rowIndex, (int)2, (String)CompareSignEnum.class.getName(), (String)compare);
        comboBox.removeItem((Object)"");
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
        this.removeFieldCompare(comboBox);
    }

    protected void removeFieldCompare(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTRIGHTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NULLSIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTNULLSIGN);
    }

    protected void loadRightBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.tblCondition, (int)rowIndex, (int)4, (String)RightBracketSignEnum.class.getName(), (String)rowObject.getRightBracket());
    }

    protected void loadLogicSign(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.tblCondition, (int)rowIndex, (int)5, (String)LogicSignEnum.class.getName(), (String)rowObject.getLogic());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("cslData");
        sic.add("condition");
        sic.add("conditionAlias");
        sic.add("maskString");
        sic.add("count");
        return sic;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.setCurrentFilterInfo();
        }
        catch (BgControlException e) {
            e.printStackTrace();
        }
        if (this.editData != null) {
            this.editData.setCslData(this.btnMerge.isSelected() ? DynIndexCslDataEnum.merge : DynIndexCslDataEnum.collect);
            IRow row = null;
            for (int i = 0; i < this.kdtEntity.getRowCount(); ++i) {
                row = this.kdtEntity.getRow(i);
                if (!(row.getCell("unit").getValue() instanceof MeasureUnitInfo)) continue;
                MeasureUnitInfo meaInfo = (MeasureUnitInfo)row.getCell("unit").getValue();
                row.getCell("unit.id").setValue((Object)meaInfo.getId().toString());
                if (!(row.getUserObject() instanceof BgDynIndexEntryInfo)) continue;
                BgDynIndexEntryInfo entryInfo = (BgDynIndexEntryInfo)row.getUserObject();
                entryInfo.setUnit(meaInfo);
            }
            this.editData.setCondition(this.filterInfo != null ? this.filterInfo.toString() : null);
            this.editData.setConditionAlias(this.filterInfoDesc);
            this.editData.setMaskString(this.filterInfo != null ? this.filterInfo.getMaskString() : null);
            this.editData.setCount(this.txtCount.getText());
            CostCenterOrgUnitInfo org = new CostCenterOrgUnitInfo();
            org.setId(BOSUuid.read((String)this.txtOrgid.getText()));
            this.editData.setOrgUnit(org);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo unitinfo;
        Object unitinfo2;
        this.kdtEntity.getEditManager().editingStopped();
        this.virfyInput();
        if (this.txtCount.getText() != null && !StringUtils.isEmpty((String)this.txtCount.getText()) && Integer.valueOf(this.txtCount.getText()) == 0) {
            this.txtCount.setValue(null);
        }
        this.storeData();
        HashSet<String> orgids = new HashSet<String>();
        if (this.prmtBgOrgSelect.getData() instanceof BgOrgUnitInfo[]) {
            unitinfo2 = (BgOrgUnitInfo[])this.prmtBgOrgSelect.getData();
            for (int i = 0; i < ((BgOrgUnitInfo[])unitinfo2).length; ++i) {
                orgids.add(unitinfo2[i].getId().toString());
            }
        } else if (this.prmtBgOrgSelect.getData() instanceof BgOrgUnitInfo) {
            unitinfo2 = (BgOrgUnitInfo)this.prmtBgOrgSelect.getData();
            orgids.add(unitinfo2.getId().toString());
        }
        HashSet<String> orgidss = new HashSet<String>();
        String treeId = null;
        if (this.prmtCslOrgSelect.getData() instanceof OrgUnitInfo[]) {
            unitinfo = (OrgUnitInfo)this.prmtCslOrgSelect.getData();
            for (int i = 0; i < ((OrgUnitInfo)unitinfo).length; ++i) {
                orgidss.add(unitinfo[i].getId().toString());
            }
            treeId = unitinfo[0].getString("uionID");
        } else if (this.prmtCslOrgSelect.getData() instanceof OrgUnitInfo) {
            unitinfo = (OrgUnitInfo)this.prmtCslOrgSelect.getData();
            orgidss.add(unitinfo.getId().toString());
            treeId = unitinfo.getString("uionID");
        }
        super.actionSubmit_actionPerformed(e);
        BgDynIndexFactory.getRemoteInstance().deleteOrgRef(this.getUIContext().get("ID").toString());
        BgDynIndexInfo info = (BgDynIndexInfo)this.getValue((IObjectPK)new ObjectUuidPK(this.getUIContext().get("ID").toString()));
        if (info.getBgOrgType().getValue() == 5) {
            BgDynIndexFactory.getRemoteInstance().saveOrgRef(this.getUIContext().get("ID").toString(), orgids, null, 0);
        }
        if (info.getCslOrgType().getValue() == 5) {
            BgDynIndexFactory.getRemoteInstance().saveOrgRef(this.getUIContext().get("ID").toString(), orgidss, treeId, 1);
        }
        this.initOrg();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtCslOrgSelect.setData(null);
            this.prmtBgOrgSelect.setData(null);
            this.comboBgOrgType.setSelectedIndex(2);
            this.comboCslOrgType.setSelectedIndex(3);
            this.btnMerge.setSelected(true);
            this.tblCondition.removeRows();
            this.txtCount.setValue(null);
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(true);
        }
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    public void beforeActionPerformed(ActionEvent e) {
        if (this.txtCount.getText() == null || StringUtils.isEmpty((String)this.txtCount.getText())) {
            this.txtCount.setValue(null);
        }
        super.beforeActionPerformed(e);
    }

    public boolean isModify() {
        if (this.getOprtState().equals(OprtState.COPYADDNEW)) {
            return false;
        }
        boolean isModify = super.isModify();
        if (!isModify && this.orgRefMap != null) {
            int i;
            HashSet<String> orgids;
            if (this.orgRefMap.containsKey("bgOrg")) {
                Object unitinfo;
                List bgOrgs = (List)this.orgRefMap.get("bgOrg");
                if (bgOrgs.size() > 0 && this.prmtBgOrgSelect.getData() == null) {
                    return true;
                }
                orgids = new HashSet<String>();
                if (this.prmtBgOrgSelect.getData() instanceof BgOrgUnitInfo[]) {
                    unitinfo = (BgOrgUnitInfo[])this.prmtBgOrgSelect.getData();
                    for (i = 0; i < ((BgOrgUnitInfo[])unitinfo).length; ++i) {
                        orgids.add(unitinfo[i].getId().toString());
                    }
                } else if (this.prmtBgOrgSelect.getData() instanceof BgOrgUnitInfo) {
                    unitinfo = (BgOrgUnitInfo)this.prmtBgOrgSelect.getData();
                    orgids.add(unitinfo.getId().toString());
                }
                if (orgids.size() != bgOrgs.size()) {
                    return true;
                }
                for (int i2 = 0; i2 < bgOrgs.size(); ++i2) {
                    if (orgids.contains(((BgOrgUnitInfo)bgOrgs.get(i2)).getId().toString())) continue;
                    return true;
                }
            }
            if (this.orgRefMap.containsKey("cslOrg")) {
                List cslOrgs = (List)this.orgRefMap.get("cslOrg");
                if (cslOrgs.size() > 0 && this.prmtCslOrgSelect.getData() == null) {
                    return true;
                }
                orgids = new HashSet();
                if (this.prmtCslOrgSelect.getData() instanceof OrgUnitInfo[]) {
                    OrgUnitInfo[] unitinfo = (OrgUnitInfo[])this.prmtCslOrgSelect.getData();
                    for (i = 0; i < unitinfo.length; ++i) {
                        orgids.add(unitinfo[i].getId().toString());
                    }
                } else if (this.prmtCslOrgSelect.getData() instanceof OrgUnitInfo) {
                    OrgUnitInfo unitinfo = (OrgUnitInfo)this.prmtCslOrgSelect.getData();
                    orgids.add(unitinfo.getId().toString());
                }
                if (orgids.size() != cslOrgs.size()) {
                    return true;
                }
                for (int i3 = 0; i3 < cslOrgs.size(); ++i3) {
                    if (orgids.contains(((OrgUnitInfo)cslOrgs.get(i3)).getId().toString())) continue;
                    return true;
                }
            }
        }
        return isModify;
    }

    private boolean comboBgOrgSelect() {
        DynIndexBgOrgTypeEnum type;
        return this.comboBgOrgType.getSelectedItem() instanceof DynIndexBgOrgTypeEnum && (type = (DynIndexBgOrgTypeEnum)((Object)this.comboBgOrgType.getSelectedItem())).getValue() == 5;
    }

    private boolean comboCslOrgSelect() {
        DynIndexCslOrgTypeEnum type;
        return this.comboCslOrgType.getSelectedItem() instanceof DynIndexCslOrgTypeEnum && (type = (DynIndexCslOrgTypeEnum)((Object)this.comboCslOrgType.getSelectedItem())).getValue() == 5;
    }

    private void virfyInput() throws Exception {
        if (this.txtNumber == null || StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"requiredDimIsNull", (Object[])new Object[]{this.contNumber.getBoundLabelText()}));
            SysUtil.abort();
        }
        if (this.txtName == null || StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"requiredDimIsNull", (Object[])new Object[]{this.contName.getBoundLabelText()}));
            SysUtil.abort();
        }
        if (this.comboBgOrgSelect() && this.prmtBgOrgSelect.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"bgOrgUnitIsNull"));
            SysUtil.abort();
        }
        if (this.comboCslOrgSelect() && this.prmtCslOrgSelect.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"cslOrgUnitIsNull"));
            SysUtil.abort();
        }
        if (this.kdtEntity.getRowCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"tableIsNull"));
            SysUtil.abort();
        }
        IRow row = null;
        int count = 0;
        int hCount = 0;
        HashSet<Integer> rankSet = new HashSet<Integer>();
        for (int i = 0; i < this.kdtEntity.getRowCount(); ++i) {
            boolean isShow;
            row = this.kdtEntity.getRow(i);
            if (row.getCell("show").getValue() instanceof Boolean && (isShow = ((Boolean)row.getCell("show").getValue()).booleanValue())) {
                ++count;
                if (row.getCell("rank").getValue() instanceof DynIndexRankEnum) {
                    DynIndexRankEnum rank = (DynIndexRankEnum)((Object)row.getCell("rank").getValue());
                    if (rank.getValue() == 1) {
                        ++hCount;
                    }
                    rankSet.add(rank.getValue());
                }
            }
            if (count <= true) continue;
            if (rankSet.size() > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"rankIsMutil"));
                SysUtil.abort();
                continue;
            }
            if (hCount <= true) continue;
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"rankIsMutil"));
            SysUtil.abort();
        }
        this.verifyData();
        this.verifyConditionData();
    }

    protected void setCurrentFilterInfo() throws BgControlException {
        this.tblCondition.getEditManager().stopEditing();
        int rowCount = this.tblCondition.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                CompareSignEnum compareSignEnum;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.tblCondition.getRow(i);
                String leftBracket = BgEntityUtil.getValue((Object)iRow.getCell(0).getValue()).toString();
                String condition = (String)iRow.getCell(1).getValue();
                String compare = BgEntityUtil.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
                String compareValue = (String)BgEntityUtil.getValue((Object)iRow.getCell(3).getValue());
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NULLSIGN) {
                    compareValue = null;
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NOTNULLSIGN) {
                    compareValue = null;
                }
                String rightBracket = BgEntityUtil.getValue((Object)iRow.getCell(4).getValue()).toString();
                String logic = BgEntityUtil.getValue((Object)iRow.getCell(5).getValue()).toString().toLowerCase();
                if (!StringUtils.isEmpty((String)logic) || i != rowCount - 1) {
                    // empty if block
                }
                if ((compareSignEnum = CompareSignEnum.getEnum((String)compare)) == null) continue;
                if (compareValue != null && BgEntityUtil.isIncludeCompare((CompareSignEnum)compareSignEnum)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)BgEntityUtil.processIncludeValue((String)compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                } else if (condition != null && !"".equals(condition.trim().toString())) {
                    FilterItemInfo filterItemInfo = null;
                    if (CompareType.LIKE.toString().equalsIgnoreCase(compare) || CompareType.NOTLIKE.toString().equalsIgnoreCase(compare)) {
                        if (null != compareValue) {
                            compareValue = "%" + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                        }
                    } else if ("LEFT LIKE".equalsIgnoreCase(compare)) {
                        if (null != compareValue) {
                            compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                            compare = CompareType.LIKE.toString();
                        }
                    } else if ("RIGHT LIKE".equalsIgnoreCase(compare)) {
                        if (null != compareValue) {
                            compareValue = "%" + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "");
                            compare = CompareType.LIKE.toString();
                        }
                    } else if ("NOT LEFT LIKE".equalsIgnoreCase(compare)) {
                        if (null != compareValue) {
                            compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                            compare = CompareType.NOTLIKE.toString();
                        }
                    } else if (compare.equalsIgnoreCase("IS")) {
                        compareValue = null;
                        compare = "=";
                    } else if (compare.equalsIgnoreCase("IS NOT")) {
                        compareValue = null;
                        compare = "<>";
                    }
                    filterItemInfo = new FilterItemInfo(condition, (Object)compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                }
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
        this.setCurrentFilterInfoDesc();
    }

    protected void setCurrentFilterInfoDesc() {
        int rowCount = this.tblCondition.getRowCount();
        StringBuffer filterDesc = new StringBuffer();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.tblCondition.getRow(i);
                String leftBracket = iRow.getCell(0).getValue() != null ? iRow.getCell(0).getValue().toString() : "";
                String condition = iRow.getCell(1).getValue() != null ? iRow.getCell(1).getValue().toString() + " " : "";
                String compare = iRow.getCell(2).getValue() != null ? iRow.getCell(2).getValue().toString() + " " : "";
                String compareValue = iRow.getCell(3).getValue() != null ? iRow.getCell(3).getValue().toString() + " " : "";
                String rightBracket = iRow.getCell(4).getValue() != null ? iRow.getCell(4).getValue().toString() : "";
                String logic = iRow.getCell(5).getValue() != null ? iRow.getCell(5).getValue().toString() : "";
                filterDesc.append(leftBracket).append(condition).append(compare).append(compareValue).append(rightBracket).append(logic);
            }
        }
        this.filterInfoDesc = filterDesc.toString();
    }

    public void verifyData() throws Exception {
        super.verifyData();
        for (int i = this.tblCondition.getRowCount() - 1; i >= 0; --i) {
            if (!this.isBlankRow(i)) continue;
            this.tblCondition.removeRow(i);
        }
        int rowCount = this.tblCondition.getRowCount();
        IRow row = null;
        int loginsignCount = 0;
        int leftsignCount = 0;
        int rightsignCount = 0;
        int nullCount = 0;
        HashMap compareMsg = new HashMap();
        String leftTmp = null;
        String rightTmp = null;
        int emptyRowCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblCondition.getRow(i);
            if (row.getCell("condition").getValue() == null && row.getCell("compareSign").getValue() == null && row.getCell("compareValue").getValue() == null) {
                ++emptyRowCount;
                continue;
            }
            if (row.getCell("loginSign").getValue() != null && row.getCell("loginSign").getValue() instanceof LogicSignEnum && row.getCell("loginSign").getValue() != null || row.getCell("loginSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("loginSign").getValue().toString())) {
                ++loginsignCount;
            }
            if (row.getCell("leftBracketSign").getValue() != null && row.getCell("leftBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("leftBracketSign").getValue().toString()) || row.getCell("leftBracketSign").getValue() instanceof LeftBracketSignEnum && !StringUtils.isEmpty((String)((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue())) {
                leftTmp = ((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue();
                leftsignCount += this.countToWord(leftTmp, "(");
            }
            if (row.getCell("rightBracketSign").getValue() != null && row.getCell("rightBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("rightBracketSign").getValue().toString()) || row.getCell("rightBracketSign").getValue() instanceof RightBracketSignEnum && !StringUtils.isEmpty((String)((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue())) {
                rightTmp = ((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue();
                rightsignCount += this.countToWord(rightTmp, ")");
            }
            if (row.getCell("condition").getValue() == null) {
                ++nullCount;
            }
            if (row.getCell("compareSign").getValue() == null) {
                ++nullCount;
            }
            if (row.getCell("compareValue").getValue() != null || CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) || CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) continue;
            ++nullCount;
        }
        if (rowCount > 0) {
            if (rowCount - emptyRowCount - 1 != loginsignCount) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"logicSignException"));
                SysUtil.abort();
            }
            if (rightsignCount != leftsignCount) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"bracketNotFit"));
                SysUtil.abort();
            }
            if (nullCount != 0 && !CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) && !CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"filterQuestion"));
                SysUtil.abort();
            }
        }
    }

    protected int countToWord(String str, String key) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(key, index)) != -1) {
            index += key.length();
            ++count;
        }
        return count;
    }

    private void verifyConditionData() {
        int rowCount = this.tblCondition.getRowCount();
        IRow row = null;
        String leftTmp = null;
        String rightTmp = null;
        Stack stack = new Stack();
        String condition = null;
        String compareVal = null;
        StringBuffer bracket = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            DataObject dao;
            row = this.tblCondition.getRow(i);
            if (row.getCell("condition").getValue() == null && row.getCell("compareSign").getValue() == null && row.getCell("compareValue").getValue() == null) continue;
            if (row.getCell("condition").getValue() == null || row.getCell("compareSign").getValue() == null || row.getCell("compareValue").getValue() == null && !CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) && !CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"conditionCompareNull", (Object[])new Object[]{new Integer(i + 1)}));
                SysUtil.abort();
            }
            condition = (String)row.getCell("condition").getValue();
            compareVal = (String)row.getCell("compareValue").getValue();
            if (!this.formulaMap.containsKey(condition)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"condNotExists", (Object[])new Object[]{new Integer(i + 1), condition}));
                SysUtil.abort();
            } else if (!this.formulaMap.containsKey(compareVal)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"compValNotExists", (Object[])new Object[]{new Integer(i + 1), compareVal}));
                SysUtil.abort();
            }
            if (condition.equals(compareVal)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"condEqualsComp", (Object[])new Object[]{new Integer(i + 1)}));
                SysUtil.abort();
            }
            if (row.getCell("leftBracketSign").getValue() != null && row.getCell("leftBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("leftBracketSign").getValue().toString()) || row.getCell("leftBracketSign").getValue() instanceof LeftBracketSignEnum && !StringUtils.isEmpty((String)((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue())) {
                leftTmp = ((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue();
                bracket.append(leftTmp);
            }
            if (row.getCell("rightBracketSign").getValue() != null && row.getCell("rightBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("rightBracketSign").getValue().toString()) || row.getCell("rightBracketSign").getValue() instanceof RightBracketSignEnum && !StringUtils.isEmpty((String)((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue())) {
                rightTmp = ((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue();
                bracket.append(rightTmp);
            }
            if (row.getCell("compareValue").getValue() != null && row.getCell("compareValue").getUserObject() != null && row.getCell("compareValue").getUserObject() instanceof DataObject && (dao = (DataObject)row.getCell("compareValue").getUserObject()).getName().equalsIgnoreCase("bigDecimal")) {
                BigDecimal value = new BigDecimal(row.getCell("compareValue").getValue().toString());
                int compareValue = value.compareTo(BgNConstants.ZERO);
                if (compareValue > 0) {
                    if (BgNFSHelper.checkHasOverstepMax(value)) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"dataMax", (Object[])new Object[]{new Integer(i + 1)}));
                        SysUtil.abort();
                    }
                } else if (compareValue < 0 && BgNFSHelper.checkHasOverstepMin(value)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"dataMin", (Object[])new Object[]{new Integer(i + 1)}));
                    SysUtil.abort();
                }
            }
            if (i == rowCount - 1) {
                if (row.getCell(5).getValue() == null || row.getCell(5).getValue().toString().isEmpty()) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"logicSignException", (Object[])new Object[]{new Integer(i + 1)}));
                SysUtil.abort();
                continue;
            }
            if (row.getCell(5).getValue() != null && !row.getCell(5).getValue().toString().isEmpty()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"logicSignException", (Object[])new Object[]{new Integer(i + 1)}));
            SysUtil.abort();
        }
        if (rowCount > 0 && !this.isValid(bracket.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"bracketNotFit"));
            SysUtil.abort();
        }
    }

    public boolean isValid(String s) {
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '(') {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (stack.isEmpty()) {
                return false;
            }
            char topChar = ((Character)stack.pop()).charValue();
            if (c != ')' || topChar == '(') continue;
            return false;
        }
        return stack.isEmpty();
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = BgFetchIndexClientHelper.FILTER_COLUMN_CODEs.length;
        if (this.tblCondition.getRow(rowIndex).getCell(1).getValue() == null) {
            return true;
        }
        for (int i = 0; i < columnSize; ++i) {
            if (BgEntityUtil.getValue((Object)this.tblCondition.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private void storeData() {
        this.storeFields();
        this.editData.setCslData(this.btnMerge.isSelected() ? DynIndexCslDataEnum.merge : DynIndexCslDataEnum.collect);
        this.editData.setDimSrc(((BgDimSettingsInfo)this.prmtRowDim.getData()).getDimNumber());
        IRow row = null;
        for (int i = 0; i < this.kdtEntity.getRowCount(); ++i) {
            row = this.kdtEntity.getRow(i);
            if (!(row.getCell("unit").getValue() instanceof MeasureUnitInfo)) continue;
            MeasureUnitInfo meaInfo = (MeasureUnitInfo)row.getCell("unit").getValue();
            row.getCell("unit.id").setValue((Object)meaInfo.getId().toString());
            if (!(row.getUserObject() instanceof BgDynIndexEntryInfo)) continue;
            BgDynIndexEntryInfo entryInfo = (BgDynIndexEntryInfo)row.getUserObject();
            entryInfo.setUnit(meaInfo);
        }
        this.editData.setCondition(this.filterInfo.toString());
        this.editData.setConditionAlias(this.filterInfoDesc);
        this.editData.setMaskString(this.filterInfo.getMaskString());
        this.editData.setCount(this.txtCount.getText());
        CostCenterOrgUnitInfo org = new CostCenterOrgUnitInfo();
        org.setId(BOSUuid.read((String)this.txtOrgid.getText()));
        this.editData.setOrgUnit(org);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.prmtBgOrgSelect.setEnabled(false);
        this.prmtCslOrgSelect.setEnabled(false);
        super.actionFirst_actionPerformed(e);
        this.initOrg();
        this.initEntity();
        this.initCslData();
        this.initConditionData();
        this.setButtonEnabled();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.prmtBgOrgSelect.setEnabled(false);
        this.prmtCslOrgSelect.setEnabled(false);
        super.actionPre_actionPerformed(e);
        this.initOrg();
        this.initEntity();
        this.initCslData();
        this.initConditionData();
        this.setButtonEnabled();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.prmtBgOrgSelect.setEnabled(false);
        this.prmtCslOrgSelect.setEnabled(false);
        super.actionNext_actionPerformed(e);
        this.initOrg();
        this.initEntity();
        this.initCslData();
        this.initConditionData();
        this.setButtonEnabled();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.prmtBgOrgSelect.setEnabled(false);
        this.prmtCslOrgSelect.setEnabled(false);
        super.actionLast_actionPerformed(e);
        this.initOrg();
        this.initEntity();
        this.initCslData();
        this.initConditionData();
        this.setButtonEnabled();
    }

    private void checkOrgUnit(String key) throws Exception {
        OrgUnitInfo orgUnitInfo = this.getCostCenter();
        if (!this.editData.getOrgUnit().getId().equals((Object)orgUnitInfo.getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)key));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getCostCenter(), (String)"mbg_dynIndex01_addNew");
        this.checkFilled();
        this.isModifySave = true;
        super.actionAddNew_actionPerformed(e);
        this.isModifySave = false;
        this.prmtBgOrgSelect.setData(null);
        this.prmtCslOrgSelect.setData(null);
        this.comboBgOrgType.setSelectedIndex(2);
        this.comboCslOrgType.setSelectedIndex(3);
        this.txtNumber.setEditable(true);
        this.txtName.setEditable(true);
        this.txtCount.setText(null);
        this.tblCondition.removeRows();
        this.btnMerge.setSelected(true);
        this.setButtonEnabled();
    }

    protected void checkFilled() throws EASBizException, BOSException {
        BgSchemeInfo scheme = this.getBgSchemeInfo();
        if (scheme != null) {
            BgSchemeFactory.getRemoteInstance().checkFilling(scheme.getId().toString());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getCostCenter(), (String)"mbg_dynIndex03_edit");
        this.checkFilled();
        this.checkOrgUnit("cantEdit");
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEditable(false);
        Map refMap = (Map)this.getUIContext().get("refMap");
        if (refMap.containsKey(this.editData.getId().toString())) {
            this.txtName.setEditable(false);
        } else {
            this.txtName.setEditable(true);
        }
        this.txtCount.setText(this.editData != null ? this.editData.getCount() : null);
        if (this.editData.getBgOrgType().getValue() == 5) {
            this.prmtBgOrgSelect.setEnabled(true);
        } else {
            this.prmtBgOrgSelect.setEnabled(false);
            this.prmtBgOrgSelect.setValue(null);
        }
        if (this.editData.getCslOrgType().getValue() == 5) {
            this.prmtCslOrgSelect.setEnabled(true);
        } else {
            this.prmtCslOrgSelect.setEnabled(false);
            this.prmtCslOrgSelect.setValue(null);
        }
        this.setButtonEnabled();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getCostCenter(), (String)"mbg_dynIndex02_delete");
        this.checkFilled();
        this.checkOrgUnit("cantRemove");
        Map refMap = (Map)this.getUIContext().get("refMap");
        if (refMap.containsKey(this.editData.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"isExistRef", (Object[])new Object[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    protected boolean isModifySave() {
        return this.isModifySave;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getCostCenter(), (String)"mbg_dynIndex01_addNew");
        this.checkFilled();
        this.isModifySave = true;
        super.actionCopy_actionPerformed(e);
        this.editData.copyNewToOld();
        this.isModifySave = false;
        this.txtNumber.setEditable(true);
        this.txtName.setEditable(true);
        this.txtCount.setText(this.editData != null ? this.editData.getCount() : null);
        if (this.editData.getBgOrgType().getValue() == 5) {
            this.prmtBgOrgSelect.setEnabled(true);
        } else {
            this.prmtBgOrgSelect.setEnabled(false);
            this.prmtBgOrgSelect.setValue(null);
        }
        if (this.editData.getCslOrgType().getValue() == 5) {
            this.prmtCslOrgSelect.setEnabled(true);
        } else {
            this.prmtCslOrgSelect.setEnabled(false);
            this.prmtCslOrgSelect.setValue(null);
        }
        this.txtOrgid.setText(this.getCostCenter().getId().toString());
        this.setButtonEnabled();
    }

    protected void checkPermission(String orgUnitId, ItemAction action) throws Exception {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgUnitId), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)action);
    }

    protected IObjectValue createNewData() {
        BgDynIndexInfo info = new BgDynIndexInfo();
        info.setBgScheme(this.getBgSchemeInfo());
        CostCenterOrgUnitInfo unit = new CostCenterOrgUnitInfo();
        unit.setId(this.getCostCenter().getId());
        info.setOrgUnit(unit);
        info.setCslData(DynIndexCslDataEnum.merge);
        info.setCslOrgType(DynIndexCslOrgTypeEnum.AllSubordinate);
        info.setBgOrgType(DynIndexBgOrgTypeEnum.IncludeDirectSub);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDynIndexFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof IUIWindow) {
            ((UIModelDialog)this.getUIWindow()).setSize(new Dimension(650, 700));
        }
        this.getUIMenuBar().removeAll();
    }

    @Override
    public void initUIMenuBarLayout() {
    }

    @Override
    public void actionDimSet_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", null);
        ctx.put((Object)"bgScheme", this.getUIContext().get("bgScheme"));
        ctx.put((Object)BgBaseConstants.ORGUNIT_ID, this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
        ctx.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
        ctx.put((Object)"allDimensions", this.helper.getAllDimensions());
        ctx.put((Object)"formulaMap", this.formulaMap);
        ctx.put((Object)"isRef", (Object)false);
        ctx.put((Object)"OprtState", (Object)this.getOprtState());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getMembersUI(), (Map)ctx, null, OprtState.ADDNEW);
        window.show();
        BgDynMembersUI ui = (BgDynMembersUI)window.getUIObject();
        if (ui.isCancel()) {
            return;
        }
        IRow row = null;
        if (!StringUtils.isEmpty((String)ui.getName()) && !StringUtils.isEmpty((String)ui.getFormula())) {
            row = this.kdtEntity.addRow();
            row.getCell("dataName").setValue((Object)ui.getName());
            row.getCell("formulas").setValue((Object)ui.getFormula());
            row.getCell("unit").setValue((Object)this.muCol2.get(this.muIndex));
            row.getCell("point").setValue((Object)2);
            row.getCell("thousand").setValue((Object)true);
            row.getCell("persent").setValue((Object)false);
            row.getCell("show").setValue((Object)true);
            row.getCell("sort").setValue((Object)DynIndexSortEnum.empty);
            row.getCell("rank").setValue((Object)DynIndexRankEnum.Vertical);
            row.getCell("calc").setValue((Object)false);
            this.formulaMap.put(ui.getName(), ui.getFormula());
            this.formateCondition();
            this.formateCompareValue();
        }
    }

    public String getMembersUI() {
        return BgDynMembersUI.class.getName();
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.helper == null) {
            try {
                this.helper = new BgSchemeDimensionHelper(this.getBgSchemeInfo().getId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)"getSchemeHelper error:", (Throwable)ex);
                this.handUIExceptionAndAbort(ex);
            }
        }
        return this.helper;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    @Override
    public void actionCalSet_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", null);
        ctx.put((Object)"bgScheme", this.getUIContext().get("bgScheme"));
        ctx.put((Object)BgBaseConstants.ORGUNIT_ID, this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
        ctx.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
        ctx.put((Object)"allDimensions", this.helper.getAllDimensions());
        ctx.put((Object)"formulaMap", this.formulaMap);
        ctx.put((Object)"isRef", (Object)false);
        ctx.put((Object)"OprtState", (Object)this.getOprtState());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getCalcSetUI(), (Map)ctx, null, OprtState.ADDNEW);
        window.show();
        BgDynCalcSetUI ui = (BgDynCalcSetUI)window.getUIObject();
        if (ui.isCancel()) {
            return;
        }
        IRow row = null;
        if (!StringUtils.isEmpty((String)ui.getName()) && !StringUtils.isEmpty((String)ui.getFormula())) {
            row = this.kdtEntity.addRow();
            row.getCell("dataName").setValue((Object)ui.getName());
            row.getCell("nameFormula").setValue((Object)ui.getFormula());
            row.getCell("unit").setValue((Object)this.muCol2.get(this.muIndex));
            row.getCell("point").setValue((Object)2);
            row.getCell("thousand").setValue((Object)true);
            row.getCell("persent").setValue((Object)false);
            row.getCell("show").setValue((Object)true);
            row.getCell("sort").setValue((Object)DynIndexSortEnum.empty);
            row.getCell("rank").setValue((Object)DynIndexRankEnum.Vertical);
            row.getCell("calc").setValue((Object)true);
            this.formulaMap.put(ui.getName(), ui.getFormula());
            this.addRefDataName(ui.getFormula(), ui.getName());
            this.formateCondition();
            this.formateCompareValue();
        }
    }

    private void addRefDataName(String formula, String dataName) {
        List<IExpr> exprs = ExprParseHelper.parse(formula);
        for (int i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) instanceof LeftBracket || exprs.get(i) instanceof RightBracket || exprs.get(i) instanceof OperatorExpr) continue;
            if (this.refDataName.containsKey(exprs.get(i).getSource())) {
                this.refDataName.get(exprs.get(i).getSource()).add(dataName);
                continue;
            }
            HashSet<String> refNameSet = new HashSet<String>();
            refNameSet.add(dataName);
            this.refDataName.put(exprs.get(i).getSource(), refNameSet);
        }
    }

    public String getCalcSetUI() {
        return BgDynCalcSetUI.class.getName();
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        boolean flag = false;
        int selectedRowIndex = this.kdtEntity.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtEntity.getSelectManager().getActiveColumnIndex();
        flag = this.kdtEntity.exchangeRow(selectedRowIndex, selectedRowIndex - 1);
        if (flag) {
            this.kdtEntity.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        boolean flag = false;
        int selectedRowIndex = this.kdtEntity.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtEntity.getSelectManager().getActiveColumnIndex();
        flag = this.kdtEntity.exchangeRow(selectedRowIndex, selectedRowIndex + 1);
        if (flag) {
            this.kdtEntity.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        KDTSelectManager selectManager = this.kdtEntity.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (this.kdtEntity.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            for (int i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        StringBuffer msg = new StringBuffer();
        int count = 0;
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            String dataName = (String)this.kdtEntity.getCell(rowIndex, "dataName").getValue();
            if (this.refDataName.containsKey(dataName)) {
                msg.append(MessageFormat.format(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"refDataName"), dataName, this.refDataName.get(dataName).toString())).append("\n");
                continue;
            }
            this.formulaMap.remove(dataName);
            Iterator<Map.Entry<String, Set<String>>> iterator = this.refDataName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Set<String>> entry = iterator.next();
                if (entry.getValue().contains(dataName)) {
                    entry.getValue().remove(dataName);
                }
                if (entry.getValue().size() >= 1) continue;
                iterator.remove();
            }
            this.kdtEntity.removeRow(rowIndex);
            ++count;
        }
        int sCount = indexArr.length - count;
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"partDelFail", (Object[])new Object[]{indexArr.length, count, sCount}), (String)msg.toString(), (int)1);
        }
        this.formateCondition();
        this.formateCompareValue();
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.tblCondition.addRow();
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteRow_actionPerformed(e);
        KDTSelectManager selectManager = this.tblCondition.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (this.tblCondition.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            for (int i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            this.tblCondition.removeRow(rowIndex);
        }
    }

    @Override
    public void actionClearRow_actionPerformed(ActionEvent e) throws Exception {
        this.tblCondition.removeRows();
    }

    @Override
    public void actionMoveUpRow_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = false;
        int selectedRowIndex = this.tblCondition.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tblCondition.getSelectManager().getActiveColumnIndex();
        flag = this.tblCondition.exchangeRow(selectedRowIndex, selectedRowIndex - 1);
        if (flag) {
            this.tblCondition.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    @Override
    public void actionMoveDownRow_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = false;
        int selectedRowIndex = this.tblCondition.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tblCondition.getSelectManager().getActiveColumnIndex();
        flag = this.tblCondition.exchangeRow(selectedRowIndex, selectedRowIndex + 1);
        if (flag) {
            this.tblCondition.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblCondition.checkParsed();
        this.kdtEntity.checkParsed();
        this.initKdtEntity();
        this.initCondition();
    }

    private void initCondition() {
        this.formateLeftSign();
        this.formateCompareSing();
        this.formateRightSign();
        this.formateLoginSing();
    }

    private void formateLeftSign() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = LeftBracketSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.tblCondition.getColumn("leftBracketSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    private void formateCondition() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String key : this.formulaMap.keySet()) {
            model.addElement(key);
        }
        this.tblCondition.getColumn("condition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    private void formateCompareValue() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String key : this.formulaMap.keySet()) {
            model.addElement(key);
        }
        this.tblCondition.getColumn("compareValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    protected void formateRightSign() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = RightBracketSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.tblCondition.getColumn("rightBracketSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    protected void formateLoginSing() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = LogicSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.tblCondition.getColumn("loginSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    private void formateCompareSing() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator it = CompareSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        KDComboBox comboBox = new KDComboBox(model);
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTRIGHTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NULLSIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTNULLSIGN);
        this.tblCondition.getColumn("compareSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    private void initKdtEntity() {
        this.kdtEntity.getSelectManager().setSelectMode(15);
        this.kdtEntity.getStyleAttributes().setLocked(false);
        this.kdtEntity.getColumn("dataName").getStyleAttributes().setLocked(true);
        this.kdtEntity.getColumn("dataName").getStyleAttributes().setFontColor(Color.blue);
        KDComboBox cbx = new KDComboBox();
        BgFetchIndexClientHelper.initMeasureUnit(cbx, this.muCol2);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)cbx);
        this.kdtEntity.getColumn("unit").setEditor((ICellEditor)cellEditor);
        cbx = new KDComboBox();
        BgFetchIndexClientHelper.initDecimal(cbx);
        cellEditor = new KDTDefaultCellEditor((JComboBox)cbx);
        this.kdtEntity.getColumn("point").setEditor((ICellEditor)cellEditor);
        KDCheckBox chk = new KDCheckBox();
        cellEditor = new KDTDefaultCellEditor((JCheckBox)chk);
        this.kdtEntity.getColumn("thousand").setEditor((ICellEditor)cellEditor);
        chk = new KDCheckBox();
        cellEditor = new KDTDefaultCellEditor((JCheckBox)chk);
        this.kdtEntity.getColumn("persent").setEditor((ICellEditor)cellEditor);
        chk = new KDCheckBox();
        cellEditor = new KDTDefaultCellEditor((JCheckBox)chk);
        this.kdtEntity.getColumn("show").setEditor((ICellEditor)cellEditor);
        cbx = new KDComboBox();
        cbx.addItems(DynIndexSortEnum.getEnumList().toArray());
        cbx.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DynIndexSortEnum _value;
                Object value;
                int index = BgDynIndexEditUI.this.kdtEntity.getSelectManager().getActiveRowIndex();
                if (index >= 0 && (value = BgDynIndexEditUI.this.kdtEntity.getCell(index, "sort").getValue()) instanceof DynIndexSortEnum && (_value = (DynIndexSortEnum)((Object)value)).getValue() != 0) {
                    for (int i = 0; i < BgDynIndexEditUI.this.kdtEntity.getRowCount(); ++i) {
                        IRow row = BgDynIndexEditUI.this.kdtEntity.getRow(i);
                        if (index == i) continue;
                        row.getCell("sort").setValue((Object)DynIndexSortEnum.empty);
                    }
                }
            }
        });
        this.kdtEntity.getColumn("sort").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbx));
        cbx = new KDComboBox();
        cbx.addItems(DynIndexRankEnum.getEnumList().toArray());
        this.kdtEntity.getColumn("rank").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbx));
    }

    @Override
    protected void kdtEntity_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ICell cell;
            if (e.getColIndex() == 1 && (cell = this.kdtEntity.getCell(e.getRowIndex(), e.getColIndex())) != null && cell.getValue() != null) {
                String dataName = cell.getValue().toString();
                boolean calc = false;
                ICell ccell = this.kdtEntity.getCell(e.getRowIndex(), "calc");
                if (ccell != null && ccell.getValue() != null) {
                    calc = (Boolean)ccell.getValue();
                }
                ICell cellFormula = null;
                cellFormula = !calc ? this.kdtEntity.getCell(e.getRowIndex(), "formulas") : this.kdtEntity.getCell(e.getRowIndex(), "nameFormula");
                String formula = cellFormula.getValue().toString();
                Map memberMap = null;
                if (!calc) {
                    UIContext ctx = new UIContext();
                    memberMap = BizCalcClientHelper.parseMBRMember((BgSchemeDimensionHelper)this.getSchemeHelper(), (String)"MBR", (String)formula, null);
                    ctx.put((Object)"ID", null);
                    ctx.put((Object)"bgScheme", this.getUIContext().get("bgScheme"));
                    ctx.put((Object)BgBaseConstants.ORGUNIT_ID, this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ctx.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
                    ctx.put((Object)"allDimensions", this.helper.getAllDimensions());
                    ctx.put((Object)"formulaMap", this.formulaMap);
                    ctx.put((Object)"dataName", (Object)dataName);
                    ctx.put((Object)"memberMap", (Object)memberMap);
                    ctx.put((Object)"formulaName", (Object)"MBR");
                    ctx.put((Object)"isHiddenPartCsldim", (Object)true);
                    ctx.put((Object)"isRef", (Object)this.refDataName.containsKey(dataName));
                    ctx.put((Object)"OprtState", (Object)this.getOprtState());
                    IUIWindow window = UIFactory.createUIFactory().create(this.getMembersUI(), (Map)ctx, null, OprtState.EDIT);
                    window.show();
                    BgDynMembersUI ui = (BgDynMembersUI)window.getUIObject();
                    if (!ui.isCancel()) {
                        if (!ui.getName().equals(dataName)) {
                            this.kdtEntity.getCell(e.getRowIndex(), "dataName").setValue((Object)ui.getName());
                            this.formulaMap.remove(dataName);
                            dataName = ui.getName();
                        }
                        if (!ui.getFormula().equals(formula)) {
                            this.kdtEntity.getCell(e.getRowIndex(), "formulas").setValue((Object)ui.getFormula());
                        }
                        this.formulaMap.put(dataName, ui.getFormula());
                    }
                } else {
                    UIContext ctx = new UIContext((Object)this);
                    ctx.put((Object)"ID", null);
                    ctx.put((Object)"bgScheme", this.getUIContext().get("bgScheme"));
                    ctx.put((Object)BgBaseConstants.ORGUNIT_ID, this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ctx.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
                    ctx.put((Object)"allDimensions", this.helper.getAllDimensions());
                    ctx.put((Object)"formulaMap", this.formulaMap);
                    ctx.put((Object)"dataName", (Object)dataName);
                    ctx.put((Object)"formulaName", (Object)formula);
                    ctx.put((Object)"isRef", (Object)this.refDataName.containsKey(dataName));
                    ctx.put((Object)"OprtState", (Object)this.getOprtState());
                    IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getCalcSetUI(), (Map)ctx, null, OprtState.ADDNEW);
                    window.show();
                    BgDynCalcSetUI ui = (BgDynCalcSetUI)window.getUIObject();
                    if (ui.isCancel()) {
                        return;
                    }
                    if (!ui.getName().equals(dataName)) {
                        this.kdtEntity.getCell(e.getRowIndex(), "dataName").setValue((Object)ui.getName());
                        this.formulaMap.remove(dataName);
                        dataName = ui.getName();
                    }
                    if (!ui.getFormula().equals(formula)) {
                        this.kdtEntity.getCell(e.getRowIndex(), "nameFormula").setValue((Object)ui.getFormula());
                    }
                    this.formulaMap.put(dataName, ui.getFormula());
                    this.dealRefDataName(ui.getFormula(), formula, dataName);
                }
                this.formateCondition();
                this.formateCompareValue();
            }
        } else {
            super.kdtEntity_tableClicked(e);
        }
    }

    private void dealRefDataName(String newFormula, String oldFormula, String dataName) {
        List<IExpr> newexprs = ExprParseHelper.parse(newFormula);
        List<IExpr> oldexprs = ExprParseHelper.parse(oldFormula);
        HashSet<String> newSet = new HashSet<String>();
        for (int i = 0; i < newexprs.size(); ++i) {
            if (newexprs.get(i) instanceof LeftBracket || newexprs.get(i) instanceof RightBracket || newexprs.get(i) instanceof OperatorExpr) continue;
            newSet.add(newexprs.get(i).getSource());
        }
        HashSet<String> oldSet = new HashSet<String>();
        for (int i = 0; i < oldexprs.size(); ++i) {
            if (oldexprs.get(i) instanceof LeftBracket || oldexprs.get(i) instanceof RightBracket || oldexprs.get(i) instanceof OperatorExpr) continue;
            oldSet.add(oldexprs.get(i).getSource());
        }
        Map<String, Set<String>> map = BgNFSHelper.getIncrementAndDecrementSet(newSet, oldSet);
        Set<String> incrementSet = map.get(BgNFSHelper.INCREMENT_SET);
        for (String name : incrementSet) {
            if (this.refDataName.containsKey(name)) {
                this.refDataName.get(name).add(dataName);
                continue;
            }
            HashSet<String> refNameSet = new HashSet<String>();
            refNameSet.add(dataName);
            this.refDataName.put(name, refNameSet);
        }
        Set<String> decrementSet = map.get(BgNFSHelper.DECREMENT_SET);
        for (String name : decrementSet) {
            if (!this.refDataName.containsKey(name)) continue;
            this.refDataName.get(name).remove(dataName);
            if (this.refDataName.get(name).size() >= 1) continue;
            this.refDataName.remove(name);
        }
    }

    @Override
    protected void comboBgOrgType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgOrgType_itemStateChanged(e);
        if (e.getItem() instanceof DynIndexBgOrgTypeEnum) {
            DynIndexBgOrgTypeEnum type = (DynIndexBgOrgTypeEnum)((Object)e.getItem());
            if (type.getValue() == 5) {
                this.prmtBgOrgSelect.setEnabled(true);
                this.prmtBgOrgSelect.setRequired(true);
                this.prmtBgOrgSelect.setEditable(false);
            } else {
                this.prmtBgOrgSelect.setEnabled(false);
                this.prmtBgOrgSelect.setRequired(false);
                this.prmtBgOrgSelect.setData(null);
            }
        }
    }

    @Override
    protected void comboCslOrgType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCslOrgType_itemStateChanged(e);
        if (e.getItem() instanceof DynIndexCslOrgTypeEnum) {
            DynIndexCslOrgTypeEnum type = (DynIndexCslOrgTypeEnum)((Object)e.getItem());
            if (type.getValue() == 5) {
                this.prmtCslOrgSelect.setEnabled(true);
                this.prmtCslOrgSelect.setRequired(true);
                this.prmtCslOrgSelect.setEditable(false);
            } else {
                this.prmtCslOrgSelect.setEnabled(false);
                this.prmtCslOrgSelect.setRequired(false);
                this.prmtCslOrgSelect.setData(null);
            }
        }
    }

    @Override
    protected void txtCount_focusLost(FocusEvent e) throws Exception {
        super.txtCount_focusLost(e);
        if (this.txtCount.getText() == null || StringUtils.isEmpty((String)this.txtCount.getText())) {
            this.txtCount.setValue(null);
        } else if (Integer.valueOf(this.txtCount.getText()) == 0) {
            this.txtCount.setValue(null);
        }
    }

    @Override
    protected void prmtCslOrgSelect_willShow(SelectorEvent e) throws Exception {
        super.prmtCslOrgSelect_willShow(e);
        OrgTreeCollection org = BgEliminationHelper.getOrgTreeCollection();
        if (org != null && org.size() > 0) {
            if (this.getSchemeHelper() != null) {
                int i;
                BgDimSettingsInfo setinfo = this.getSchemeHelper().getDimSettingMap().get(DimensionConstants.DEF_ORGUNIT_NUMBER);
                HashSet<String> schemeTreeIds = new HashSet<String>();
                if (setinfo.getMembers() != null && setinfo.getMembers().size() > 0) {
                    BgDimSettingsMemberCollection colls = setinfo.getMembers();
                    for (i = 0; i < colls.size(); ++i) {
                        if (colls.get(i).getType().getValue() != 3) continue;
                        schemeTreeIds.add(colls.get(i).getMemberID().toString());
                    }
                }
                OrgTreeCollection newColls = new OrgTreeCollection();
                for (i = 0; i < org.size(); ++i) {
                    if (!schemeTreeIds.contains(org.get(i).getId().toString())) continue;
                    newColls.add(org.get(i));
                }
                if (newColls.isEmpty()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"schemeNotTree"));
                    this.prmtCslOrgSelect.setSelector(null);
                    SysUtil.abort();
                }
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"noTree"));
            this.prmtCslOrgSelect.setSelector(null);
            SysUtil.abort();
        }
    }

    public boolean checkBeforeWindowClosing() {
        BgDynIndexInfo obj;
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease && (obj = (BgDynIndexInfo)this.getDataObject()).getId() != null) {
            BgAccountHelper.releaseMutexService((String)obj.getId().toString());
        }
        return bclose;
    }
}

