/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.BgDynIndexFactory;
import com.kingdee.eas.ma.mbg.BgDynIndexInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgDynIndexList;
import com.kingdee.eas.ma.mbg.client.BgDynIndexEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDynIndexList
extends AbstractBgDynIndexList {
    private static final long serialVersionUID = -3302263463787835932L;
    private static final Logger logger = CoreUIObject.getLogger(BgDynIndexList.class);
    private CostCenterOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, Object> refMap = new HashMap<String, Object>();

    public CostCenterOrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(CostCenterOrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void onLoad() throws Exception {
        this.initCostCenter();
        super.onLoad();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec;
        if ((viewInfo = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone()).getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        FilterInfo filter = viewInfo.getFilter();
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
        FilterItemInfo filterItem = new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "" : bgScheme.getId().toString()), CompareType.EQUALS);
        if (BgNFCHelper.findFilterItem(filter, "bgScheme.id") != null) {
            BgNFCHelper.removeFilterItems(filter, filterItem);
            filter.getFilterItems().add(filterItem);
        } else {
            filter.getFilterItems().add(filterItem);
            if (filter.getMaskString() == null) {
                filter.setMaskString("#" + (filter.getFilterItems().size() - 1));
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") AND #" + (filter.getFilterItems().size() - 1));
            }
        }
        String filterText = this.txtFieldSearch.getText();
        this.txtFieldSearch.setUserObject((Object)filterText);
        if (!StringUtils.isEmpty((String)filterText)) {
            int filterSize = viewInfo.getFilter().getFilterItems().size();
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("description", (Object)("%" + filterText + "%"), CompareType.LIKE));
            if (filterSize == 0) {
                viewInfo.getFilter().setMaskString("( #0 OR #1 OR #2)");
            } else {
                viewInfo.getFilter().setMaskString(viewInfo.getFilter().getMaskString() + " AND ((#" + filterSize + " OR #" + (filterSize + 1) + " ) OR #" + (filterSize + 2) + " ))");
            }
            this.txtFieldSearch.setSelectAllOnFocus(true);
        }
        if ((exec = super.getQueryExecutor(queryPK, viewInfo)) != null && exec.option() != null) {
            exec.option().isAutoIgnoreZero = false;
        }
        return exec;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getUnitInfo(), (String)"mbg_dynIndex04_view");
        this.checkSelectBgScheme(false);
        super.actionView_actionPerformed(e);
    }

    private CostCenterOrgUnitInfo getSelectOrgUnit() {
        return (CostCenterOrgUnitInfo)this.prmtOrgUnit.getData();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void initCostCenter() {
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setUIAction((IUIObject)this, (ItemAction)this.actionOnLoad);
        f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
        this.prmtOrgUnit.setEditable(false);
    }

    public void refreshList() throws Exception {
        super.refreshList();
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
        BgNFCHelper.setSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtOrgUnit.getData(), false, this.getSourceType(), false, false);
        FilterInfo filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.checkOrgSelector(e);
        super.prmtOrgUnit_dataChanged(e);
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            OrgUnitInfo fullOrgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData();
            this.checkPermission(fullOrgUnitInfo.getId().toString(), (ItemAction)this.actionOnLoad);
            this.readOrgUnitInfo(fullOrgUnitInfo.getId());
        }
        this.setSchemeViewOnOrgUnitChange();
    }

    protected void checkOrgSelector(DataChangeEvent e) {
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
            this.prmtOrgUnit.setValue(e.getOldValue());
            return;
        }
    }

    protected void checkPermission(String orgUnitId, ItemAction action) throws Exception {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgUnitId), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)action);
    }

    protected void readOrgUnitInfo(BOSUuid id) throws EASBizException, BOSException {
        CostCenterOrgUnitInfo ccouinfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        if (ccouinfo != null) {
            this.setUnitInfo(ccouinfo);
        }
    }

    protected void setSchemeViewOnOrgUnitChange() throws Exception {
        BgNFCHelper.setSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.getUnitInfo(), false, this.getSourceType(), false, false);
        FilterInfo filter = this.prmtBgScheme.getEntityViewInfo().getFilter();
        filter = MbgPermissionHelper.addBgSchemePermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter);
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
        BgSchemeInfo oldScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), (OrgUnitInfo)this.getUnitInfo());
        if (oldScheme != null && BgCommCHelper.isEqualsPK((IObjectValue)oldScheme, (IObjectValue)((BgSchemeInfo)this.prmtBgScheme.getData()))) {
            this.refreshList();
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = this.createSchemeHelper(((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
        }
        return this.schemeHelper;
    }

    protected BgSchemeDimensionHelper createSchemeHelper(String bgSchemeId) throws EASBizException, BOSException {
        return new BgSchemeDimensionHelper(null, bgSchemeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        try {
            if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
                this.showSchemeNullMsg();
                this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            } else if (newInfo != null && !BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
                this.schemeHelper = this.createSchemeHelper(newInfo.getId().toString());
                this.refMap = BgAnalysRptTemplateFactory.getRemoteInstance().queryRef(newInfo.getId().toString(), "BC4CE35B");
            }
        }
        finally {
            this.prmtBgScheme.setUserObject(null);
        }
        this.refreshList();
    }

    protected void showSchemeNullMsg() {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtBgScheme.setEditable(false);
    }

    protected String getEditUIName() {
        return BgDynIndexEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDynIndexFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getUnitInfo(), (String)"mbg_dynIndex01_addNew");
        this.checkSelectBgScheme(true);
        super.actionAddNew_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
        uiContext.put((Object)BgBaseConstants.USER_INFO, (Object)SysContext.getSysContext().getCurrentUserInfo());
        uiContext.put((Object)"refMap", this.refMap);
    }

    private void checkOrgUnit(String key) throws Exception {
        CostCenterOrgUnitInfo orgUnitInfo = this.getUnitInfo();
        BgDynIndexInfo value = (BgDynIndexInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (!value.getOrgUnit().getId().equals((Object)orgUnitInfo.getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)key));
            SysUtil.abort();
        }
    }

    private BgSchemeInfo getBgSchme() {
        return this.prmtBgScheme.getData() instanceof BgSchemeInfo ? (BgSchemeInfo)this.prmtBgScheme.getData() : null;
    }

    protected void checkSelectBgScheme(boolean isFiling) throws EASBizException, BOSException {
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"please.choose.scheme"));
            SysUtil.abort();
        }
        if (isFiling) {
            this.isBgSchemeIsFiling("bgScheme_isFiling");
        }
    }

    protected void isBgSchemeIsFiling(String message) throws EASBizException, BOSException {
        if (this.getBgSchme() instanceof BgSchemeInfo) {
            BgSchemeFactory.getRemoteInstance().checkFilling(this.getBgSchme().getId().toString());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getUnitInfo(), (String)"mbg_dynIndex03_edit");
        this.checkSelectBgScheme(true);
        int activeRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRow < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        this.checkOrgUnit("cantEdit");
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getUnitInfo(), (String)"mbg_dynIndex02_delete");
        this.checkSelectBgScheme(true);
        int activeRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRow < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        if (e == null || this.confirmRemove()) {
            ArrayList ids = this.getSelectedIdValues();
            this.deleteMutexIndexIds(ids);
            KDTSelectManager selectManager = this.tblMain.getSelectManager();
            int size = selectManager.size();
            if (size <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                return;
            }
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.tblMain.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            StringBuffer msg = new StringBuffer();
            int count = 0;
            ArrayList<Object> delete_list = new ArrayList<Object>();
            for (int i = indexArr.length - 1; i >= 0; --i) {
                String number;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                if (!this.tblMain.getRow(rowIndex).getCell("orgunit.id").getValue().equals(this.getUnitInfo().getId().toString())) {
                    number = this.tblMain.getRow(rowIndex).getCell("number").getValue().toString();
                    msg.append(MessageFormat.format(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"notCostCenter"), number)).append("\n");
                    continue;
                }
                if (this.refMap.containsKey(this.tblMain.getRow(rowIndex).getCell("id").getValue())) {
                    number = this.tblMain.getRow(rowIndex).getCell("number").getValue().toString();
                    msg.append(MessageFormat.format(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"isExistRef"), number)).append("\n");
                    continue;
                }
                if (!EmptyUtil.isEmpty((Object)this.tblMain.getRow(rowIndex).getCell(DimensionConstants.DIMENSION_ID).getValue())) {
                    delete_list.add(this.tblMain.getRow(rowIndex).getCell(DimensionConstants.DIMENSION_ID).getValue());
                    this.tblMain.removeRow(rowIndex);
                    this.isModify = true;
                } else {
                    this.tblMain.removeRow(rowIndex);
                }
                ++count;
            }
            int sCount = indexArr.length - count;
            if (msg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"partDelFail", (Object[])new Object[]{indexArr.length, count, sCount}), (String)msg.toString(), (int)1);
            }
            if (delete_list.size() > 0) {
                IObjectPK[] objectPk = new IObjectPK[delete_list.size()];
                for (int i = 0; i < delete_list.size(); ++i) {
                    objectPk[i] = new ObjectStringPK(delete_list.get(i).toString());
                }
                this.getBizInterface().deleteBatchData(objectPk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMutexIndexIds(ArrayList ids) throws BgAccountException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        HashMap<String, EASBizException> exceptionMap = new HashMap<String, EASBizException>();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                exceptionMap.put(id, mutexException);
                lt.remove();
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        if (!exceptionMap.isEmpty()) {
            throw new BgAccountException(BgAccountException.LOCK);
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.refreshList();
    }

    @Override
    protected void txtFieldSearch_focusLost(FocusEvent e) throws Exception {
        super.txtFieldSearch_focusLost(e);
        String oldText = (String)this.txtFieldSearch.getUserObject();
        if (!StringUtils.equals((String)oldText, (String)this.txtFieldSearch.getText())) {
            this.refreshList();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }
}

