/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.biz.utils.RefBgTemplateRender;
import com.kingdee.eas.ma.mbg.BgExamRefBgTempHistCollection;
import com.kingdee.eas.ma.mbg.BgExamRefBgTempHistFactory;
import com.kingdee.eas.ma.mbg.BgExamRefBgTempHistInfo;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineHistFactory;
import com.kingdee.eas.ma.mbg.BgExamineHistInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgExamineHistListUI;
import com.kingdee.eas.ma.mbg.client.BgExamineHistMainUI;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExamineHistListUI
extends AbstractBgExamineHistListUI
implements ISimpleQuickQueryHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgExamineHistListUI.class);
    protected static String ID = "id";
    protected static String NUMBER = "number";
    protected static String NAME = "name";
    protected static String VERSION = "version";
    protected static String BGTEMPLATE = "bgTemplate";
    protected static String ENABLEUSER = "enableUser";
    protected static String ENABLETIME = "enableTime";
    protected static String DELETEUSER = "deleterUser";
    protected static String DELETETIME = "deleterTime";
    protected static String SOURCEBGEXAMINEID = "sourceBgExamineId";
    protected SimpleQuickQueryHandler quickQuery = null;
    private String model = "HISTVERSION";
    public static final String IS_BGCSL = "IS_BGCSL";
    public boolean isBgCsl = false;
    private List selectIds = null;
    private BgSchemeInfo bgSchemeInfo = null;
    private Map<String, String> compareVersions = new HashMap<String, String>();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnShow_actionPerformed(ActionEvent e) throws Exception {
        this.showUI();
    }

    @Override
    protected void btncancle_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.showUI();
            return;
        }
        super.tblMain_tableClicked(e);
    }

    private BgExamineHistInfo getBgExamineHistInfo(String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("version"));
        selector.add(new SelectorItemInfo("enableUser.name"));
        selector.add(new SelectorItemInfo("enableTime"));
        selector.add(new SelectorItemInfo("disableUser.name"));
        selector.add(new SelectorItemInfo("disableTime"));
        selector.add(new SelectorItemInfo("deleteUser.name"));
        selector.add(new SelectorItemInfo("deleteTime"));
        selector.add(new SelectorItemInfo("bgScheme.id"));
        selector.add(new SelectorItemInfo("orgTree.id"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("noPass"));
        selector.add(new SelectorItemInfo("srcNumbers"));
        selector.add("bgExamineSubset.*");
        selector.add("bgExamineSubset.bgScope.*");
        selector.add("bgExamineGroup.id");
        selector.add("bgExamineGroup.number");
        selector.add("bgExamineGroup.name");
        BgExamineHistInfo bgExamineHistInfo = BgExamineHistFactory.getRemoteInstance().getBgExamineHistInfo((IObjectPK)new ObjectStringPK(id), selector);
        return bgExamineHistInfo;
    }

    private void showUI() throws UIException {
        IUIWindow window;
        this.checkSelected();
        int selectIndex = -1;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        BgExamineHistInfo bgExamineHistInfo = null;
        try {
            bgExamineHistInfo = this.getBgExamineHistInfo(this.tblMain.getCell(selectIndex, ID).getValue().toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        UIContext ctx = new UIContext((Object)this);
        this.putUIContext(ctx);
        ctx.put((Object)"BgExamineInfo", (Object)bgExamineHistInfo.convert());
        ctx.put((Object)"ID", (Object)bgExamineHistInfo.getId().toString());
        ctx.put((Object)"bgScheme", (Object)this.bgSchemeInfo);
        if (this.bgSchemeInfo.getOrgUnit() != null) {
            ctx.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.bgSchemeInfo.getOrgUnit().getId().toString());
        }
        if ((window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getHistMainUI(), (Map)ctx, null, OprtState.VIEW)) instanceof UINewFrame) {
            UINewFrame frame = (UINewFrame)window;
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)screensize.getWidth();
            int height = (int)screensize.getHeight();
            width = Math.min(width, 1013);
            height = Math.min(height, 800);
            frame.setSize(width, height);
            window.show();
            frame.setExtendedState(6);
        } else {
            BgBaseHelper.setMaxDialog((IUIWindow)window);
            window.show();
        }
    }

    protected void putUIContext(UIContext ctx) {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgExamineHistFactory.getRemoteInstance();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.filterVersion(e);
        this.fillTemplateList(e);
    }

    private void filterVersion(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        for (int i = firstRow; i <= lastRow; ++i) {
            String sVersion;
            String hisVersion;
            String id = (String)this.tblMain.getRow(i).getCell(SOURCEBGEXAMINEID).getValue();
            if (this.compareVersions.get(id) == null || !(hisVersion = (String)this.tblMain.getRow(i).getCell(VERSION).getValue()).equals(sVersion = this.compareVersions.get(id))) continue;
            this.tblMain.getRow(i).getStyleAttributes().setHided(true);
        }
    }

    protected void fillTemplateList(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = firstRow; i <= lastRow; ++i) {
            String id = (String)this.tblMain.getRow(i).getCell(ID).getValue();
            idSet.add(id);
        }
        if (idSet.size() > 0) {
            Map<String, List<BgTemplateInfo>> templateMap = null;
            try {
                templateMap = this.getRefTemplate(idSet);
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
                ExceptionHandler.handle((Throwable)e1);
            }
            for (int i = firstRow; i <= lastRow; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = (String)row.getCell(ID).getValue();
                if (templateMap == null || !templateMap.containsKey(id)) continue;
                List<BgTemplateInfo> templates = templateMap.get(id);
                row.getCell(BGTEMPLATE).setValue(templates);
            }
        }
    }

    protected Map<String, List<BgTemplateInfo>> getRefTemplate(Set<String> ids) throws BOSException {
        HashMap<String, List<BgTemplateInfo>> templateMap = new HashMap<String, List<BgTemplateInfo>>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("bgExamine.id"));
        evi.getSelector().add(new SelectorItemInfo("bgTemplate.id"));
        evi.getSelector().add(new SelectorItemInfo("bgTemplate.number"));
        evi.getSelector().add(new SelectorItemInfo("bgTemplate.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgExamine.id", ids, CompareType.INCLUDE));
        evi.setFilter(filter);
        BgExamRefBgTempHistCollection ref = BgExamRefBgTempHistFactory.getRemoteInstance().getBgExamRefBgTempHistCollection(evi);
        if (ref == null || ref.isEmpty()) {
            return templateMap;
        }
        int in = ref.size();
        for (int i = 0; i < in; ++i) {
            BgExamRefBgTempHistInfo info = ref.get(i);
            if (!templateMap.containsKey(info.getBgExamine().getId().toString())) {
                ArrayList templates = new ArrayList();
                templateMap.put(info.getBgExamine().getId().toString(), templates);
            }
            ((List)templateMap.get(info.getBgExamine().getId().toString())).add(info.getBgTemplate());
        }
        return templateMap;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initData();
        super.onLoad();
        this.quickQuery = new SimpleQuickQueryHandler(this.txtQuery, (ISimpleQuickQueryHandler)this);
        this.tblMain.getColumn(BGTEMPLATE).setRenderer((IBasicRender)new RefBgTemplateRender());
        String title = this.getUITitle();
        if ("DELHIST".equals(this.model)) {
            title = EASResource.getString((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"DELHIST");
        }
        this.setUITitle(title);
    }

    public void onShow() throws Exception {
        super.onShow();
        if ("HISTVERSION".equals(this.model)) {
            this.tblMain.getColumn(DELETEUSER).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(DELETETIME).getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn(DELETEUSER).getStyleAttributes().setHided(false);
            this.tblMain.getColumn(DELETETIME).getStyleAttributes().setHided(false);
        }
        this.tblMain.getColumn(SOURCEBGEXAMINEID).getStyleAttributes().setHided(true);
    }

    private void initData() throws BOSException {
        if (this.getUIContext().get("IDList") != null) {
            this.selectIds = (ArrayList)this.getUIContext().get("IDList");
        }
        if (this.getUIContext().get("MODEL") != null) {
            this.model = (String)this.getUIContext().get("MODEL");
        }
        if (this.getUIContext().get("bgScheme") != null) {
            this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("bgScheme");
        }
        if (this.getUIContext().get(IS_BGCSL) != null) {
            this.isBgCsl = (Boolean)this.getUIContext().get(IS_BGCSL);
        }
        if (this.selectIds == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("version");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(this.selectIds), CompareType.INCLUDE));
        view.setFilter(filter);
        BgExamineCollection col = BgExamineFactory.getRemoteInstance().getBgExamineCollection(view);
        if (col == null || col.isEmpty()) {
            return;
        }
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            this.compareVersions.put(col.get(i).getId().toString(), col.get(i).getVersion());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if ((viewInfo = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone()).getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        FilterInfo filter = new FilterInfo();
        if (this.selectIds != null) {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("sourceBgExamineId", new HashSet(this.selectIds), CompareType.INCLUDE));
        }
        if (this.bgSchemeInfo != null) {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgScheme.id", (Object)this.bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.isBgCsl) {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("orgTree.id", null, CompareType.NOTEQUALS));
        } else {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("orgTree.id", null));
        }
        if ("DELHIST".equals(this.model)) {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("isDelete", (Object)true, CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        String filterString = this.quickQuery.getFilterString();
        if (!StringUtils.isEmpty((String)filterString)) {
            FilterItemInfo filterItemInfo1 = new FilterItemInfo("number", (Object)("%" + filterString + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItemInfo1);
            filter.setMaskString(filter.getMaskString() + " AND ( #" + (filter.getFilterItems().size() - 1));
            FilterItemInfo filterItemInfo2 = new FilterItemInfo("name", (Object)("%" + filterString + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItemInfo2);
            filter.setMaskString(filter.getMaskString() + " OR  #" + (filter.getFilterItems().size() - 1));
            FilterItemInfo filterItemInfo3 = new FilterItemInfo("version", (Object)("%" + filterString + "%"), CompareType.LIKE);
            filter.getFilterItems().add(filterItemInfo3);
            filter.setMaskString(filter.getMaskString() + " OR  #" + (filter.getFilterItems().size() - 1) + ")");
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected String getEditUIName() {
        return null;
    }

    public void doQuickQuery() {
        this.execQuery();
    }

    protected String getHistMainUI() {
        return BgExamineHistMainUI.class.getName();
    }
}

