/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.BizCalcDimensionMemberSelectDialog;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgExamineMemberUI;
import com.kingdee.eas.ma.mbg.client.common.BgExamineOrgDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgPeriodFunctionDialog;
import com.kingdee.eas.ma.mbg.client.utils.OrientableFlowLayout;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class BgExamineMemberUI
extends AbstractBgExamineMemberUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = -7319361907148575957L;
    private static final Logger logger = CoreUIObject.getLogger(BgExamineMemberUI.class);
    private String formula;
    protected boolean isBgSchemeChange = false;
    private BgSchemeInfo initBgSchemeInfo = null;
    private Map<String, KDBizPromptBox> compMap = new HashMap<String, KDBizPromptBox>();
    private List<KDBizPromptBox> compList = new ArrayList<KDBizPromptBox>();
    private BgSchemeDimensionHelper schemeHelper = null;
    private BgSchemeInfo bgSchemeInfo = null;

    public String getFormula() {
        return this.formula;
    }

    protected void setFormula(String formula) {
        this.formula = formula;
    }

    public List<KDBizPromptBox> getCompList() {
        return this.compList;
    }

    public Map<String, KDBizPromptBox> getCompMap() {
        return this.compMap;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        if (this.bgSchemeInfo == null) {
            this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("crossBgScheme") != null ? (BgSchemeInfo)this.getUIContext().get("crossBgScheme") : (BgSchemeInfo)this.getUIContext().get("bgScheme");
            this.initBgSchemeInfo = this.bgSchemeInfo;
        }
        return this.bgSchemeInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBgScheme.setQueryInfo("com.kingdee.eas.ma.mbg.BgSchemeF7AllQuery");
        this.prmtBgScheme.setEditable(false);
        if ((BgSchemeInfo)this.getUIContext().get("crossBgScheme") != null) {
            this.prmtBgScheme.setData((Object)this.getBgSchemeInfo());
        } else {
            this.initPanel();
        }
    }

    protected void initPanel() throws Exception {
        List<BgDimensionInfo> allDimension = this.getSchemeHelper().getAllDimensions();
        Map memberMap = (Map)this.getUIContext().get("memberMap");
        this.getCompList().clear();
        if (allDimension != null) {
            int x = 10;
            int y = 10;
            int width = 380;
            int height = 19;
            int yCompGap = 3;
            int xCompGap = 20;
            boolean page = true;
            int yindex = 0;
            int bottom = 80;
            this.dimMemberPane.removeAll();
            this.dimMemberPane.repaint();
            this.dimMemberPane.setLayout((LayoutManager)new OrientableFlowLayout(1, 0, 0));
            JScrollBar bar = this.kDScrollPane1.getVerticalScrollBar();
            bar.setUnitIncrement(10);
            int i = 0;
            while (i < allDimension.size()) {
                BgDimensionInfo dim = allDimension.get(i);
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + dim.getNumber());
                container.setBoundLabelText(dim.getName());
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + yindex * (height + yCompGap), width, height));
                container.setPreferredSize(new Dimension(365, height));
                this.dimMemberPane.add((Component)container);
                Object dialog = null;
                if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    dialog = new BgPeriodFunctionDialog((CoreUIObject)this, false, false);
                    ((BgPeriodFunctionDialog)((Object)dialog)).setBgSchemeID(this.schemeHelper.getBgSchemeId());
                    ((BgPeriodFunctionDialog)((Object)dialog)).setOrgId((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BgPeriodFunctionDialog)((Object)dialog)).setDimension(this.getSchemeHelper().getDimension(dim.getNumber()));
                    ((BgPeriodFunctionDialog)((Object)dialog)).setCanSelectUserPeriod(true);
                    Set numSet = BizFacadeFactory.getRemoteInstance().queryPeriodType(this.schemeHelper.getBgSchemeId());
                    ((BgPeriodFunctionDialog)((Object)dialog)).setBgPeriodTypeNumbers(numSet);
                } else if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) && this.isNeedProcessType()) {
                    dialog = new BgExamineOrgDialog();
                    ((BgExamineOrgDialog)((Object)dialog)).setBgOrgViewId(this.getSchemeHelper().getBgOrgViewId());
                } else {
                    dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dim.getNumber()), (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BizCalcDimensionMemberSelectDialog)dialog).setMulti(false);
                    if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                        ((BizCalcDimensionMemberSelectDialog)dialog).setSchemeHelper(this.getSchemeHelper());
                    } else {
                        ((BizCalcDimensionMemberSelectDialog)dialog).setSchemeHelper(this.getSchemeHelperForF7());
                    }
                }
                KDBizPromptBox prmt = new KDBizPromptBox();
                prmt.setName("prmt" + dim.getNumber());
                prmt.setSelector((KDPromptSelector)dialog);
                container.setBoundEditor((JComponent)prmt);
                prmt.setEditFormatter((IFormatter)new CalcMemDispFormatter());
                prmt.setDisplayFormatter((IFormatter)new CalcMemDispFormatter());
                prmt.setSize(800, height);
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                    if (dialog instanceof BgExamineOrgDialog) {
                        prmt.addDataChangeListener((DataChangeListener)((BgExamineOrgDialog)((Object)dialog)));
                    } else {
                        prmt.addDataChangeListener(new DataChangeListener(){

                            public void dataChanged(DataChangeEvent eventObj) {
                                if (eventObj.getNewValue() != null && !(eventObj.getNewValue() instanceof BgDimensionMember) || eventObj.getOldValue() != null && !(eventObj.getOldValue() instanceof BgDimensionMember)) {
                                    return;
                                }
                                BgDimensionMember orgNMember = (BgDimensionMember)eventObj.getNewValue();
                                BgDimensionMember orgOMember = (BgDimensionMember)eventObj.getOldValue();
                                if (orgOMember == null) {
                                    if (orgNMember == null) {
                                        BgExamineMemberUI.this.resetDimDialog((String)BgExamineMemberUI.this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                                    } else {
                                        BgExamineMemberUI.this.resetDimDialog(orgNMember.getNumber());
                                    }
                                } else if (orgNMember == null) {
                                    BgExamineMemberUI.this.resetDimDialog((String)BgExamineMemberUI.this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                                } else {
                                    BgExamineMemberUI.this.resetDimDialog(orgNMember.getNumber());
                                }
                            }
                        });
                    }
                }
                if (memberMap != null && memberMap.containsKey(dim.getNumber()) && !this.isBgSchemeChange) {
                    prmt.setData(memberMap.get(dim.getNumber()));
                }
                this.compList.add(prmt);
                ++i;
                ++yindex;
            }
            if (this.isNeedProcessType()) {
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundLabelText(BgProcessHelper.DEF_PROCESS_NAME);
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + yindex * (height + yCompGap), width, height));
                container.setPreferredSize(new Dimension(365, height));
                this.dimMemberPane.add((Component)container);
                KDBizPromptBox prmtBgProcess = BgExamineHelper.getBgProcessPrmBox(this, false);
                prmtBgProcess.setName("prmt" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundEditor((JComponent)prmtBgProcess);
                if (memberMap != null && memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER) && !this.isBgSchemeChange) {
                    if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof BgDimensionMember) {
                        prmtBgProcess.setData((Object)BgProcessHelper.memberToEnum((BgDimensionMember)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)));
                    } else if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof Set) {
                        prmtBgProcess.setData(BgProcessHelper.membersToEnums((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)));
                    }
                }
                this.compList.add(prmtBgProcess);
            }
        }
    }

    protected BgSchemeDimensionHelper getSchemeHelperForF7() throws EASBizException, BOSException {
        return this.getSchemeHelper();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.getUIContext().get("BGSCHEME_HELPER") != null) {
            this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        }
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getBgSchemeInfo().getId().toString());
        }
        return this.schemeHelper;
    }

    protected String generateFormula() {
        int memberSize = 0;
        StringBuffer forStr = new StringBuffer();
        BgSchemeInfo curSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgSchemeInfo defaultSchemeInfo = (BgSchemeInfo)this.getUIContext().get("bgScheme");
        forStr.append("MBR").append(":").append("[");
        for (KDBizPromptBox prmt : this.compList) {
            BgDimensionMember dim = null;
            if (prmt.getData() != null) {
                Object p;
                if (prmt.getData() instanceof BgDimensionMember) {
                    dim = (BgDimensionMember)prmt.getData();
                } else if (prmt.getData() instanceof BgPeriodInfo) {
                    p = (BgPeriodInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                } else if (prmt.getData() instanceof List) {
                    List periodVar = (List)prmt.getData();
                    if (!periodVar.isEmpty()) {
                        dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, (String)periodVar.get(0), (String)periodVar.get(0));
                        dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                    }
                } else if (prmt.getData() instanceof StringBuffer) {
                    String str = ((StringBuffer)prmt.getData()).toString();
                    if (!StringUtils.isEmpty((String)str)) {
                        if (str.indexOf("@Lead") >= 0) {
                            dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, prmt.getData().toString(), prmt.getData().toString());
                        } else if (str.indexOf("@Parent") >= 0) {
                            dim = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.DEF_ORGUNIT_FIELD, prmt.getData().toString(), prmt.getData().toString());
                        }
                    }
                } else if (prmt.getData() instanceof BgProcessEnum) {
                    BgProcessEnum bEnum = (BgProcessEnum)((Object)prmt.getData());
                    dim = BgProcessHelper.getMember(bEnum.getName());
                } else if (prmt.getData() instanceof BgOrgUnitInfo) {
                    p = (BgOrgUnitInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.DEF_ORGUNIT_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                }
            }
            if (dim == null) continue;
            if (DimensionConstants.DEF_CSL_NUMBER.equals(dim.getType())) {
                dim.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
            }
            if (curSchemeInfo != null && memberSize == 0) {
                forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(DimensionConstants.DEF_SCHEME_SRCNUMBER).append(BgBaseConstants.SEP_FOUR_STR).append(curSchemeInfo.getNumber()).append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR);
            if (dim.getSrcNumber() != null) {
                forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
            } else {
                forStr.append(dim.getNumber());
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            ++memberSize;
        }
        if (this.compList.size() > 0) {
            forStr.delete(forStr.length() - 1, forStr.length()).append("]");
        }
        if (memberSize == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizAtLeastOneDim"));
            SysUtil.abort();
        }
        return forStr.toString();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.formula = this.generateFormula();
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (e.getNewValue() != null) {
            if (e.getOldValue() != null && e.getNewValue() != null && ((BgSchemeInfo)e.getOldValue()).getId().toString().equals(((BgSchemeInfo)e.getNewValue()).getId().toString())) {
                return;
            }
            BgSchemeInfo bgScheme = (BgSchemeInfo)e.getNewValue();
            this.setBgSchemeInfo(bgScheme);
            this.schemeHelper = new BgSchemeDimensionHelper(bgScheme.getId().toString());
            this.isBgSchemeChange = true;
            if (this.bgSchemeInfo.equals(this.initBgSchemeInfo)) {
                this.isBgSchemeChange = false;
            }
            this.initPanel();
        }
    }

    protected void setBgSchemeView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    protected void resetDimDialog(String number) {
        BizCalcDimensionMemberSelectDialog dialog = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("orgUnitId");
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        BgOrgUnitCollection orgCol = null;
        String orgUnitId = null;
        try {
            orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)("getBgOrgUnitCollection error" + e.getMessage()));
        }
        if (orgCol != null && !orgCol.isEmpty()) {
            orgUnitId = orgCol.get(0).getOrgUnitID();
        }
        for (KDBizPromptBox prmt : this.compList) {
            String dimNumber = prmt.getName().substring(4);
            if (DimensionBaseConstants.necessary.contains(dimNumber)) continue;
            try {
                dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dimNumber), orgUnitId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ((BizCalcDimensionMemberSelectDialog)dialog).setMulti(false);
            prmt.setSelector(dialog);
        }
    }

    protected boolean isNeedProcessType() {
        return true;
    }

    protected class CalcMemDispFormatter
    implements IFormatter {
        protected CalcMemDispFormatter() {
        }

        public String valueToString(Object o) {
            if (o instanceof BgPeriodInfo) {
                BgPeriodInfo p = (BgPeriodInfo)o;
                if (p.getName() != null) {
                    return "[" + p.getNumber() + "]" + p.getName();
                }
                return "[" + p.getNumber() + "]";
            }
            if (o instanceof BgDimensionMember && ((BgDimensionMember)o).getName() == null) {
                return ((BgDimensionMember)o).getNumber();
            }
            return o.toString();
        }

        public void applyPattern(String pattern) {
        }
    }
}

