/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.BizCalcDimensionMemberSelectDialog;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgExaminePtoMemberUI;
import com.kingdee.eas.ma.mbg.client.BgExamineMemberUI;
import com.kingdee.eas.ma.mbg.client.common.BgExamineOrgDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgPeriodFunctionDialog;
import com.kingdee.eas.ma.mbg.client.utils.OrientableFlowLayout;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class BgExaminePtoMemberUI
extends AbstractBgExaminePtoMemberUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgExaminePtoMemberUI.class);
    public static final String PERIOD_BEGIN = BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"begin_period");
    public static final String PERIOD_END = BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"end_period");

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected List<BgDimensionInfo> getPtoAllDimensions(List<BgDimensionInfo> allDimension) {
        ArrayList<BgDimensionInfo> dimensions = new ArrayList<BgDimensionInfo>();
        BgDimensionInfo dim = null;
        BgDimensionInfo beginPeriodDim = null;
        BgDimensionInfo endPeriodDim = null;
        for (int i = 0; i < allDimension.size(); ++i) {
            dim = allDimension.get(i);
            if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                beginPeriodDim = dim.clone();
                beginPeriodDim.setNumber("BG_Period1");
                beginPeriodDim.setName(PERIOD_BEGIN);
                dimensions.add(beginPeriodDim);
                endPeriodDim = dim.clone();
                endPeriodDim.setNumber("BG_Period2");
                endPeriodDim.setName(PERIOD_END);
                dimensions.add(endPeriodDim);
                continue;
            }
            dimensions.add(dim);
        }
        return dimensions;
    }

    @Override
    protected void initPanel() throws Exception {
        List<BgDimensionInfo> allDimension = this.getSchemeHelper().getAllDimensions();
        allDimension = this.getPtoAllDimensions(allDimension);
        Map memberMap = (Map)this.getUIContext().get("memberMap");
        this.getCompList().clear();
        if (allDimension != null) {
            int x = 10;
            int y = 10;
            int width = 380;
            int height = 19;
            int yCompGap = 3;
            int xCompGap = 20;
            boolean page = true;
            int yindex = 0;
            int bottom = 80;
            this.dimMemberPane.removeAll();
            this.dimMemberPane.repaint();
            this.dimMemberPane.setLayout((LayoutManager)new OrientableFlowLayout(1, 0, 0));
            JScrollBar bar = this.kDScrollPane1.getVerticalScrollBar();
            bar.setUnitIncrement(10);
            int i = 0;
            while (i < allDimension.size()) {
                BgDimensionInfo dim = allDimension.get(i);
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + dim.getNumber());
                container.setBoundLabelText(dim.getName());
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + yindex * (height + yCompGap), width, height));
                container.setPreferredSize(new Dimension(365, height));
                this.dimMemberPane.add((Component)container);
                Object dialog = null;
                if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dim.getNumber().equals("BG_Period1") || dim.getNumber().equals("BG_Period2")) {
                    dialog = new BgPeriodFunctionDialog((CoreUIObject)this, false, false);
                    ((BgPeriodFunctionDialog)((Object)dialog)).setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
                    ((BgPeriodFunctionDialog)((Object)dialog)).setOrgId((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BgPeriodFunctionDialog)((Object)dialog)).setDimension(this.getSchemeHelper().getDimension(DimensionConstants.DEF_PERIOD_NUMBER));
                    ((BgPeriodFunctionDialog)((Object)dialog)).setCanSelectUserPeriod(true);
                    Set numSet = BizFacadeFactory.getRemoteInstance().queryPeriodType(this.getSchemeHelper().getBgSchemeId());
                    ((BgPeriodFunctionDialog)((Object)dialog)).setBgPeriodTypeNumbers(numSet);
                    ((BgPeriodFunctionDialog)((Object)dialog)).setNeedFunctionType(false);
                } else if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) && this.isNeedProcessType()) {
                    dialog = new BgExamineOrgDialog();
                    ((BgExamineOrgDialog)((Object)dialog)).setBgOrgViewId(this.getSchemeHelper().getBgOrgViewId());
                } else {
                    dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dim.getNumber()), (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BizCalcDimensionMemberSelectDialog)dialog).setMulti(false);
                    if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                        ((BizCalcDimensionMemberSelectDialog)dialog).setSchemeHelper(this.getSchemeHelper());
                    } else {
                        ((BizCalcDimensionMemberSelectDialog)dialog).setSchemeHelper(this.getSchemeHelperForF7());
                    }
                }
                KDBizPromptBox prmt = new KDBizPromptBox();
                prmt.setUserObject((Object)dim);
                prmt.setName("prmt" + dim.getNumber());
                prmt.setSelector((KDPromptSelector)dialog);
                container.setBoundEditor((JComponent)prmt);
                prmt.setEditFormatter((IFormatter)new BgExamineMemberUI.CalcMemDispFormatter());
                prmt.setDisplayFormatter((IFormatter)new BgExamineMemberUI.CalcMemDispFormatter());
                prmt.setSize(800, height);
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                    if (dialog instanceof BgExamineOrgDialog) {
                        prmt.addDataChangeListener((DataChangeListener)((BgExamineOrgDialog)((Object)dialog)));
                    } else {
                        prmt.addDataChangeListener(new DataChangeListener(){

                            public void dataChanged(DataChangeEvent eventObj) {
                                if (eventObj.getNewValue() != null && !(eventObj.getNewValue() instanceof BgDimensionMember) || eventObj.getOldValue() != null && !(eventObj.getOldValue() instanceof BgDimensionMember)) {
                                    return;
                                }
                                BgDimensionMember orgNMember = (BgDimensionMember)eventObj.getNewValue();
                                BgDimensionMember orgOMember = (BgDimensionMember)eventObj.getOldValue();
                                if (orgOMember == null) {
                                    if (orgNMember == null) {
                                        BgExaminePtoMemberUI.this.resetDimDialog((String)BgExaminePtoMemberUI.this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                                    } else {
                                        BgExaminePtoMemberUI.this.resetDimDialog(orgNMember.getNumber());
                                    }
                                } else if (orgNMember == null) {
                                    BgExaminePtoMemberUI.this.resetDimDialog((String)BgExaminePtoMemberUI.this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                                } else {
                                    BgExaminePtoMemberUI.this.resetDimDialog(orgNMember.getNumber());
                                }
                            }
                        });
                    }
                }
                if (memberMap != null && memberMap.containsKey(dim.getNumber()) && !this.isBgSchemeChange) {
                    prmt.setData(memberMap.get(dim.getNumber()));
                }
                this.getCompList().add(prmt);
                ++i;
                ++yindex;
            }
            if (this.isNeedProcessType()) {
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundLabelText(BgProcessHelper.DEF_PROCESS_NAME);
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + yindex * (height + yCompGap), width, height));
                container.setPreferredSize(new Dimension(365, height));
                this.dimMemberPane.add((Component)container);
                KDBizPromptBox prmtBgProcess = BgExamineHelper.getBgProcessPrmBox(this, false);
                prmtBgProcess.setName("prmt" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundEditor((JComponent)prmtBgProcess);
                if (memberMap != null && memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER) && !this.isBgSchemeChange) {
                    if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof BgDimensionMember) {
                        prmtBgProcess.setData((Object)BgProcessHelper.memberToEnum((BgDimensionMember)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)));
                    } else if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof Set) {
                        prmtBgProcess.setData(BgProcessHelper.membersToEnums((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)));
                    }
                }
                this.getCompList().add(prmtBgProcess);
            }
        }
    }

    @Override
    protected String generateFormula() {
        int memberSize = 0;
        StringBuffer forStr = new StringBuffer();
        String beginPeriodStr = "";
        String endPeriodStr = "";
        BgSchemeInfo curSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgSchemeInfo defaultSchemeInfo = (BgSchemeInfo)this.getUIContext().get("bgScheme");
        forStr.append("PTO").append(":").append("[");
        for (KDBizPromptBox prmt : this.getCompList()) {
            BgDimensionMember dim = null;
            if (prmt.getData() != null) {
                Object p;
                if (prmt.getData() instanceof BgDimensionMember) {
                    dim = (BgDimensionMember)prmt.getData();
                } else if (prmt.getData() instanceof BgPeriodInfo) {
                    p = (BgPeriodInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                } else if (prmt.getData() instanceof List) {
                    List periodVar = (List)prmt.getData();
                    if (!periodVar.isEmpty()) {
                        dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, (String)periodVar.get(0), (String)periodVar.get(0));
                        dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                    }
                } else if (prmt.getData() instanceof StringBuffer) {
                    String str = ((StringBuffer)prmt.getData()).toString();
                    if (!StringUtils.isEmpty((String)str)) {
                        if (str.indexOf("@Lead") >= 0) {
                            dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, prmt.getData().toString(), prmt.getData().toString());
                        } else if (str.indexOf("@Parent") >= 0) {
                            dim = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.DEF_ORGUNIT_FIELD, prmt.getData().toString(), prmt.getData().toString());
                        }
                    }
                } else if (prmt.getData() instanceof BgProcessEnum) {
                    BgProcessEnum bEnum = (BgProcessEnum)((Object)prmt.getData());
                    dim = BgProcessHelper.getMember(bEnum.getName());
                } else if (prmt.getData() instanceof BgOrgUnitInfo) {
                    p = (BgOrgUnitInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.DEF_ORGUNIT_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                }
            }
            if (dim == null) continue;
            if (DimensionConstants.DEF_CSL_NUMBER.equals(dim.getType())) {
                dim.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
            }
            if (curSchemeInfo != null && memberSize == 0) {
                forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(DimensionConstants.DEF_SCHEME_SRCNUMBER).append(BgBaseConstants.SEP_FOUR_STR).append(curSchemeInfo.getNumber()).append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR);
            if (dim.getSrcNumber() != null) {
                if (dim.getSrcNumber().equals(DimensionConstants.DEF_PERIOD_SRCNUMBER)) {
                    Object userObject = prmt.getUserObject();
                    if (userObject instanceof BgDimensionInfo && ((BgDimensionInfo)userObject).getName().equals(PERIOD_BEGIN)) {
                        forStr.append("BgP1").append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                        beginPeriodStr = dim.getNumber();
                    } else if (userObject instanceof BgDimensionInfo && ((BgDimensionInfo)userObject).getName().equals(PERIOD_END)) {
                        forStr.append("BgP2").append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                        endPeriodStr = dim.getNumber();
                    } else {
                        forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                    }
                } else {
                    forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                }
            } else {
                forStr.append(dim.getNumber());
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            ++memberSize;
        }
        if (this.getCompList().size() > 0) {
            forStr.delete(forStr.length() - 1, forStr.length()).append("]");
        }
        if (memberSize == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizAtLeastOneDim"));
            SysUtil.abort();
        }
        if (!BizPtoUtils.checkBeginAndEndPeriodType((String)beginPeriodStr, (String)endPeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"periodTypeNotEqual"));
            SysUtil.abort();
        }
        if (!BizPtoUtils.checkBeginPeriodBeforeEndPeriod((String)beginPeriodStr, (String)endPeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"periodCompare"));
            SysUtil.abort();
        }
        return forStr.toString();
    }
}

