/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.AbstractBgExamineViewUI;
import com.kingdee.eas.ma.mbg.client.BgNFProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.ExcelFile;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgExamineViewUI
extends AbstractBgExamineViewUI {
    private static final long serialVersionUID = 4908846028205630134L;
    private static final Logger logger = CoreUIObject.getLogger(BgExamineViewUI.class);
    private static final String DEFAULT_STR = "com.kingdee.eas.ma.mbg.client.BgExamineCheckResource";
    private Map bgExamineCheckMap = null;
    private Map uiMap = null;
    private NumberExpendRender expendRender = null;
    private String formulaStr = null;
    private String formId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.uiMap = new HashMap();
        this.initTable();
        this.loadBgExamineCheckData();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    protected void initUserConfig() {
        super.initUserConfig();
        PopupMenuManager mgr = this.createPopupMenuManager((JComponent)this.tblMain);
        mgr.removeMenuSection("export");
        mgr.removeMenuSection("table");
        mgr.removeMenuSection("tableSetting");
        mgr.removeMenuSection("saveSetting");
    }

    protected void initTable() {
        int rowCount = 7;
        int colCount = 4;
        this.tblMain.setRefresh(false);
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.addRows(rowCount);
        this.tblMain.addColumns(colCount);
        IRow row = this.tblMain.addHeadRow();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            row.getCell(colIndex, true).setValue((Object)TableToolkit.int2pos((int)colIndex));
        }
        this.tblMain.getColumn(0).setWidth(35);
        this.tblMain.getColumn(1).setWidth(500);
        this.tblMain.getColumn(2).setWidth(150);
        this.tblMain.getColumn(3).setWidth(150);
        this.tblMain.setRefresh(true);
        this.tblMain.checkParsed(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                BgExamineViewUI.this.table_tableClicked(e);
            }
        });
    }

    protected void loadBgExamineCheckData() {
        if (this.getUIContext().get("EXAMINE_DATA") != null && this.getUIContext().get("EXAMINE_DATA") instanceof Map) {
            this.bgExamineCheckMap = (Map)this.getUIContext().get("EXAMINE_DATA");
            Boolean isPass = (Boolean)this.bgExamineCheckMap.get("BgExamineChecked");
            String encode = (String)this.bgExamineCheckMap.get("BgExamineCheckResult");
            this.bgExamineCheckMap = (Map)BgAnalyseHelper.decodeObject(encode);
            if (this.getUIContext().get("BGFORM_ID") != null) {
                this.formId = this.getUIContext().get("BGFORM_ID").toString();
            }
            if (this.bgExamineCheckMap != null && !this.bgExamineCheckMap.isEmpty()) {
                this.initBgExamineCheckData(isPass, this.bgExamineCheckMap);
            }
        }
    }

    protected void initBgExamineCheckData(boolean isPass, Map bgExamineCheck) {
        int i;
        int n;
        String bgExamineKey2 = null;
        Iterator pass = null;
        Iterator noPass = null;
        Iterator passSet = null;
        Iterator formula = null;
        Map bgExamineMap = null;
        Map examineItems = null;
        Map formulaMap = null;
        HashSet<String> numberSet = new HashSet<String>();
        List bgExamineList = null;
        int beginNumberAlias = 1;
        Integer bgExamCiaSize = null;
        String formulaString = null;
        String key2 = null;
        String examineNumber = null;
        IRow row = null;
        NumberExpandInfo expand = null;
        Map passMap = (Map)bgExamineCheck.get("EXAMINE_PASS");
        Map passSetMap = (Map)bgExamineCheck.get("EXAMINE_PASS_SET");
        Map noPassMap = (Map)bgExamineCheck.get("EXAMINE_NOPASS");
        int noPassSize = 0;
        for (String bgExamineKey2 : noPassMap.keySet()) {
            bgExamineMap = (Map)noPassMap.get(bgExamineKey2);
            examineNumber = (String)bgExamineMap.get("EXAMINE_NAME");
            if (numberSet.contains(examineNumber)) continue;
            numberSet.add(examineNumber);
            ++noPassSize;
        }
        int passSetSize = 0;
        for (String bgExamineKey2 : passSetMap.keySet()) {
            bgExamineMap = (Map)passSetMap.get(bgExamineKey2);
            examineNumber = (String)bgExamineMap.get("EXAMINE_NAME");
            if (numberSet.contains(examineNumber)) continue;
            numberSet.add(examineNumber);
            ++passSetSize;
        }
        int passSize = 0;
        for (String bgExamineKey2 : passMap.keySet()) {
            bgExamineMap = (Map)passMap.get(bgExamineKey2);
            examineNumber = (String)bgExamineMap.get("EXAMINE_NAME");
            if (numberSet.contains(examineNumber)) continue;
            numberSet.add(examineNumber);
            ++passSize;
        }
        numberSet.clear();
        int checkSize = passSize + passSetSize + noPassSize;
        this.tblMain.getCell(0, 1).setValue((Object)this.showMessage("title"));
        this.tblMain.getCell(1, 1).setValue((Object)(this.showMessage("time") + BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date())));
        this.tblMain.getCell(2, 1).setValue((Object)(this.showMessage("user") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        this.tblMain.getCell(3, 1).setValue((Object)(this.showMessage("orgUnit") + SysContext.getSysContext().getCurrentFIUnit().getName()));
        this.tblMain.getCell(4, 1).setValue((Object)(MessageFormat.format(this.showMessage("checkMessage"), String.valueOf(checkSize)) + MessageFormat.format(this.showMessage("checkMessagePass"), String.valueOf(passSize + passSetSize)) + MessageFormat.format(this.showMessage("checkMessageNoPass"), String.valueOf(noPassSize))));
        if (isPass) {
            this.tblMain.getCell(5, 0).setValue((Object)this.showMessage("resultPass"));
        } else {
            this.tblMain.getCell(5, 0).setValue((Object)this.showMessage("resultNoPass"));
        }
        this.tblMain.getMergeManager().mergeBlock(0, 0, 0, 1);
        this.tblMain.getMergeManager().mergeBlock(1, 0, 1, 1);
        this.tblMain.getMergeManager().mergeBlock(2, 0, 2, 1);
        this.tblMain.getMergeManager().mergeBlock(3, 0, 3, 1);
        this.tblMain.getMergeManager().mergeBlock(4, 0, 4, 1);
        this.tblMain.getMergeManager().mergeBlock(5, 0, 5, 1);
        this.tblMain.getMergeManager().mergeBlock(6, 0, 6, 1);
        this.expendRender = new NumberExpendRender(1);
        this.tblMain.getColumn(0).setRenderer((IBasicRender)this.expendRender);
        for (String bgExamineKey2 : passSetMap.keySet()) {
            bgExamineMap = (Map)passSetMap.get(bgExamineKey2);
            row = this.tblMain.addRow();
            expand = new NumberExpandInfo();
            expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString());
            expand.setName(" ");
            expand.setLevel(0);
            expand.setLeaf(false);
            expand.setExpandStatus(false);
            row.getCell(0).setValue((Object)expand);
            row.getCell(1).setValue((Object)(String.valueOf(beginNumberAlias++) + "." + this.showMessage("number") + bgExamineMap.get("EXAMINE_NUMBER") + " " + this.showMessage("name") + bgExamineMap.get("EXAMINE_NAME") + " " + this.showMessage("hint") + bgExamineMap.get("EXAMINE_EXPLAIN")));
            row = this.tblMain.addRow();
            expand = new NumberExpandInfo();
            expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString());
            expand.setName(" ");
            expand.setLevel(0);
            expand.setLeaf(true);
            row.getCell(0).setValue((Object)expand);
            row.getCell(1).setValue(bgExamineMap.get("EXAMINE_FORMULA_ALIAS"));
            row.getCell(1).getStyleAttributes().setWrapText(true);
            row.setHeight((row.getHeight() <= 0 ? 20 : row.getHeight()) * 3);
            row.getStyleAttributes().setHided(true);
            bgExamCiaSize = (Integer)bgExamineMap.get("EXAMINE_CITATION_SIZE");
            examineItems = (Map)bgExamineMap.get("EXAMINE_CITATION");
            bgExamineList = (List)bgExamineMap.get("EXAMINE_CIAATION_FORMULA");
            for (String key2 : bgExamineList) {
                formulaString = key2.substring(key2.indexOf("_") + 1);
                if (!examineItems.containsKey(key2)) continue;
                formulaMap = (Map)examineItems.get(key2);
                row = this.tblMain.addRow();
                expand = new NumberExpandInfo();
                expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString);
                expand.setName(" ");
                expand.setLevel(1);
                expand.setLeaf(false);
                expand.setExpandStatus(false);
                row.getCell(0).setValue((Object)expand);
                row.getCell(1).setValue((Object)formulaString.replaceAll(",\"BgData\",true", ""));
                row.getCell(1).getStyleAttributes().setWrapText(true);
                row.setHeight((row.getHeight() <= 0 ? 20 : row.getHeight()) * 3);
                row.getStyleAttributes().setHided(true);
                row = this.tblMain.addRow();
                expand = new NumberExpandInfo();
                expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString + "VALUE");
                expand.setName(" ");
                expand.setLevel(2);
                expand.setLeaf(true);
                row.getCell(0).setValue((Object)expand);
                row.getCell(1).setValue(formulaMap.get("EXAMINE_FORMULA_VALUE"));
                row.getStyleAttributes().setHided(true);
                n = bgExamCiaSize;
                for (i = 1; i <= n; ++i) {
                    row = this.tblMain.addRow();
                    row.setUserObject((Object)formulaMap.get("EXAMINE_CIAATION_FORMULA" + i).toString());
                    expand = new NumberExpandInfo();
                    expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString + "VALUE" + i);
                    expand.setName(" ");
                    expand.setLevel(3);
                    expand.setLeaf(true);
                    row.getCell(0).setValue((Object)expand);
                    row.getCell(1).setValue((Object)(formulaMap.get("EXAMINE_CIAATION_FORMULA" + i).toString().replaceAll(",\"BgData\",true", "") + " = " + formulaMap.get("EXAMINE_CITATION_VALUE" + i)));
                    row.getCell(1).setUserObject(formulaMap.get("EXAMINE_CITATION_SCHEME" + i));
                    row.getCell(2).setValue(formulaMap.get("EXAMINE_CITATION_FORM_NAME" + i));
                    row.getCell(2).setUserObject(formulaMap.get("EXAMINE_CITATION_FORM" + i));
                    row.getCell(3).setValue(formulaMap.get("EXAMINE_CITATION_ORGUNIT_NAME" + i));
                    row.getCell(3).setUserObject(formulaMap.get("EXAMINE_CITATION_ORGUNIT" + i));
                    row.getStyleAttributes().setHided(true);
                }
                n = bgExamCiaSize;
                for (i = 1; i <= n; ++i) {
                    if (!formulaMap.containsKey("EXAMINE_CITATION_POSTIAL" + i)) continue;
                    row = this.tblMain.addRow();
                    expand = new NumberExpandInfo();
                    expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString + "VALUE" + i);
                    expand.setName(" ");
                    expand.setLevel(3);
                    expand.setLeaf(true);
                    row.getCell(0).setValue((Object)expand);
                    row.getCell(1).setValue((Object)(this.showMessage("postil") + formulaMap.get("EXAMINE_CITATION_POSTIAL" + i)));
                    row.getStyleAttributes().setHided(true);
                }
                row = this.tblMain.addRow();
                row.getStyleAttributes().setHided(true);
            }
            row = this.tblMain.addRow();
            row.getStyleAttributes().setHided(true);
        }
        for (String bgExamineKey2 : noPassMap.keySet()) {
            bgExamineMap = (Map)noPassMap.get(bgExamineKey2);
            row = this.tblMain.addRow();
            expand = new NumberExpandInfo();
            expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString());
            expand.setName(" ");
            expand.setLevel(0);
            expand.setLeaf(false);
            expand.setExpandStatus(false);
            row.getCell(0).setValue((Object)expand);
            row.getCell(1).setValue((Object)(String.valueOf(beginNumberAlias++) + "." + this.showMessage("number") + bgExamineMap.get("EXAMINE_NUMBER") + " " + this.showMessage("name") + bgExamineMap.get("EXAMINE_NAME") + " " + this.showMessage("hint") + bgExamineMap.get("EXAMINE_EXPLAIN")));
            row = this.tblMain.addRow();
            expand = new NumberExpandInfo();
            expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString());
            expand.setName(" ");
            expand.setLevel(0);
            expand.setLeaf(true);
            row.getCell(0).setValue((Object)expand);
            row.getCell(1).setValue(bgExamineMap.get("EXAMINE_FORMULA_ALIAS"));
            row.getCell(1).getStyleAttributes().setWrapText(true);
            row.setHeight((row.getHeight() <= 0 ? 20 : row.getHeight()) * 3);
            row.getStyleAttributes().setHided(true);
            bgExamCiaSize = (Integer)bgExamineMap.get("EXAMINE_CITATION_SIZE");
            examineItems = (Map)bgExamineMap.get("EXAMINE_CITATION");
            bgExamineList = (List)bgExamineMap.get("EXAMINE_CIAATION_FORMULA");
            for (String key2 : bgExamineList) {
                formulaString = key2.substring(key2.indexOf("_") + 1);
                if (!examineItems.containsKey(key2)) continue;
                formulaMap = (Map)examineItems.get(key2);
                row = this.tblMain.addRow();
                expand = new NumberExpandInfo();
                expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString);
                expand.setName(" ");
                expand.setLevel(1);
                expand.setLeaf(false);
                expand.setExpandStatus(false);
                row.getCell(0).setValue((Object)expand);
                row.getCell(1).setValue((Object)formulaString.replaceAll(",\"BgData\",true", ""));
                row.getCell(1).getStyleAttributes().setWrapText(true);
                row.setHeight((row.getHeight() <= 0 ? 20 : row.getHeight()) * 3);
                row.getStyleAttributes().setHided(true);
                row = this.tblMain.addRow();
                expand = new NumberExpandInfo();
                expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString + "VALUE");
                expand.setName(" ");
                expand.setLevel(2);
                expand.setLeaf(true);
                row.getCell(0).setValue((Object)expand);
                row.getCell(1).setValue(formulaMap.get("EXAMINE_FORMULA_VALUE"));
                row.getStyleAttributes().setHided(true);
                n = bgExamCiaSize;
                for (i = 1; i <= n; ++i) {
                    row = this.tblMain.addRow();
                    row.setUserObject((Object)formulaMap.get("EXAMINE_CIAATION_FORMULA" + i).toString());
                    expand = new NumberExpandInfo();
                    expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString + "VALUE" + i);
                    expand.setName(" ");
                    expand.setLevel(3);
                    expand.setLeaf(true);
                    row.getCell(0).setValue((Object)expand);
                    row.getCell(1).setValue((Object)(formulaMap.get("EXAMINE_CIAATION_FORMULA" + i).toString().replaceAll(",\"BgData\",true", "") + " = " + formulaMap.get("EXAMINE_CITATION_VALUE" + i)));
                    row.getCell(1).setUserObject(formulaMap.get("EXAMINE_CITATION_SCHEME" + i));
                    if (formulaMap.get("EXAMINE_CIAATION_FORMULA" + i).toString().indexOf("BgItem") == 0) {
                        row.getCell(2).setValue(formulaMap.get("EXAMINE_CITATION_FORM_NAME" + i));
                        row.getCell(2).setUserObject(formulaMap.get("EXAMINE_CITATION_FORM" + i));
                    } else {
                        row.getCell(2).setValue(null);
                        row.getCell(2).setUserObject(null);
                    }
                    row.getCell(3).setValue(formulaMap.get("EXAMINE_CITATION_ORGUNIT_NAME" + i));
                    row.getCell(3).setUserObject(formulaMap.get("EXAMINE_CITATION_ORGUNIT" + i));
                    row.getStyleAttributes().setHided(true);
                }
                n = bgExamCiaSize;
                for (i = 1; i <= n; ++i) {
                    if (!formulaMap.containsKey("EXAMINE_CITATION_POSTIAL" + i)) continue;
                    row = this.tblMain.addRow();
                    expand = new NumberExpandInfo();
                    expand.setNumber(bgExamineMap.get("EXAMINE_NUMBER").toString() + formulaString + "VALUE" + i);
                    expand.setName(" ");
                    expand.setLevel(3);
                    expand.setLeaf(true);
                    row.getCell(0).setValue((Object)expand);
                    row.getCell(1).setValue((Object)(this.showMessage("postil") + formulaMap.get("EXAMINE_CITATION_POSTIAL" + i)));
                    row.getStyleAttributes().setHided(true);
                }
                row = this.tblMain.addRow();
                row.getStyleAttributes().setHided(true);
            }
            row = this.tblMain.addRow();
            row.getStyleAttributes().setHided(true);
        }
    }

    protected String showMessage(String key) {
        return EASResource.getString((String)DEFAULT_STR, (String)key);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        super.actionExport_actionPerformed(e);
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fc = bgFileUtil.getFileChooserForExp((Object)this);
        fc.setDialogTitle(this.showMessage("export"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFile());
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                if (!file.delete()) {
                    MsgBox.showError((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)DEFAULT_STR, (String)"cantEditByFile"));
                    return;
                }
            }
            try {
                this.exportBookContent(file);
                bgFileUtil.storeDefaultPathForEXP((Object)file.getPath(), (Object)this);
            }
            catch (Exception ex) {
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    private void exportBookContent(File file) throws Exception {
        if (file == null) {
            return;
        }
        KDSBook kdsBook = new KDSBook(file.getPath());
        KDSSheet kdsSheet = this.tblMain.getIOManager().saveToKDSSheet(kdsBook, false, false, "Sheet1");
        kdsBook.addSheet(null, kdsSheet);
        ExportManager em = new ExportManager();
        em.exportToExcel(kdsBook, file.getPath() + ".xls");
    }

    protected void table_tableClicked(KDTMouseEvent e) {
        ICell cell;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (e.getClickCount() == 1) {
            NumberExpandInfo expandInfo;
            KDTable table = (KDTable)e.getSource();
            if (table.getCell(rowIndex, colIndex) != null && table.getCell(rowIndex, colIndex).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)table.getCell(rowIndex, colIndex).getValue()) != null && this.expendRender.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(table, table.getRow(rowIndex), expandInfo, e.getColIndex());
            }
        } else if (e.getClickCount() == 2 && (cell = this.tblMain.getCell(rowIndex, 2)) != null && cell.getUserObject() != null) {
            String bgFormId = cell.getUserObject().toString();
            this.formulaStr = "=" + this.tblMain.getRow(e.getRowIndex()).getUserObject().toString();
            this.openReportSheet(bgFormId);
        }
    }

    protected void openReportSheet(String bgFormId) {
        String _tmpBgFormId = null;
        BgNProcessUI ui = null;
        BgFormInfo bgFormInfo = null;
        try {
            bgFormInfo = this.getInterface().getValue(BOSUuid.read((String)bgFormId), false);
            if (bgFormInfo.getState().getValue() == 1) {
                ui = this.getSelectOfUI(bgFormInfo.getId());
                this.editReport(bgFormInfo);
            } else if (bgFormInfo.getState().getValue() == 2) {
                ui = this.getSelectOfUI(_tmpBgFormId);
                this.viewReport(_tmpBgFormId);
            } else {
                ui = this.getSelectOfUI(bgFormId);
                this.viewReport(bgFormId);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIExceptionAndAbort(ex);
        }
        if (ui != null) {
            ui.showFormula(this.getSelectOfFormula());
        }
    }

    private void setTreeDisplayStyle(KDTable table, IRow row, NumberExpandInfo expandInfo, int colIndex) {
        table.setRefresh(false);
        this.expandTable(table, row, expandInfo, colIndex);
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    protected void expandTable(KDTable table, IRow row, NumberExpandInfo parentExpandInfo, int colIndex) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        NumberExpandInfo expandInfo = null;
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = table.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = table.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell(colIndex).getValue();
                if (expandInfo != null) {
                    if (parentExpandInfo.getLevel() == 0) {
                        if (expandInfo.getLevel() > parentExpandInfo.getLevel()) {
                            child.getStyleAttributes().setHided(true);
                            if (expandInfo.isLeaf()) continue;
                            expandInfo.setExpandStatus(false);
                            continue;
                        }
                        if (rowIndex == row.getRowIndex() + 1) {
                            child.getStyleAttributes().setHided(true);
                            continue;
                        }
                    } else if (expandInfo.getLevel() > parentExpandInfo.getLevel()) {
                        child.getStyleAttributes().setHided(true);
                        continue;
                    }
                } else if (parentExpandInfo.getLevel() == 0) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = table.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = table.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell(colIndex).getValue();
                if (expandInfo != null) {
                    if (parentExpandInfo.getLevel() == 0) {
                        if (expandInfo.getLevel() > parentExpandInfo.getLevel()) {
                            if (expandInfo.getLevel() != parentExpandInfo.getLevel() + 1) continue;
                            child.getStyleAttributes().setHided(false);
                            if (expandInfo.isLeaf()) continue;
                            expandInfo.setExpandStatus(false);
                            continue;
                        }
                        if (rowIndex == row.getRowIndex() + 1) {
                            child.getStyleAttributes().setHided(false);
                            continue;
                        }
                    } else if (expandInfo.getLevel() > parentExpandInfo.getLevel()) {
                        child.getStyleAttributes().setHided(false);
                        continue;
                    }
                    break;
                }
                child.getStyleAttributes().setHided(false);
            }
        }
    }

    protected IBgForm getInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected void viewReport(String bgFormId) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgFormId);
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReportState", (Object)OprtState.VIEW);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"bgFormType", (Object)"budgetEditType");
        uiContext.put((Object)"OPEN_FORMULA", (Object)Boolean.TRUE);
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Dialog) {
            uiContext.put((Object)"OpenReportModal", (Object)Boolean.TRUE);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgNFormProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void editReport(BgFormInfo bgFormInfo) throws Exception {
        if (!this.getPermInterface().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(bgFormInfo.getOrgUnit().getId()), "mbg_form04_update")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"cantEdit"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgFormInfo.getId().toString());
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"bgFormType", (Object)"budgetEditType");
        uiContext.put((Object)"OPEN_FORMULA", (Object)Boolean.TRUE);
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Dialog) {
            uiContext.put((Object)"OpenReportModal", (Object)Boolean.TRUE);
        }
        String state = OprtState.EDIT;
        if (this.formId != null && bgFormInfo.getId().toString().equals(this.formId)) {
            state = OprtState.VIEW;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgNFormProcessUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
    }

    public String getSelectOfFormula() {
        return this.formulaStr;
    }

    public void putSelectOfUI(BOSUuid bgFormId, BgNProcessUI obj) {
        if (bgFormId == null || obj == null) {
            return;
        }
        if (this.uiMap == null) {
            return;
        }
        this.uiMap.put(bgFormId, obj);
    }

    public void removeSelectOfUI(BOSUuid bgFormId) {
        if (bgFormId == null) {
            return;
        }
        if (this.uiMap == null) {
            return;
        }
        this.uiMap.remove(bgFormId);
    }

    protected BgNFProcessUI getSelectOfUI(String bgFormId) {
        if (bgFormId == null) {
            return null;
        }
        return this.getSelectOfUI(BOSUuid.read((String)bgFormId));
    }

    protected BgNFProcessUI getSelectOfUI(BOSUuid bgFormId) {
        if (bgFormId == null) {
            return null;
        }
        if (this.uiMap == null) {
            return null;
        }
        if (this.uiMap.containsKey(bgFormId)) {
            return (BgNFProcessUI)this.uiMap.get(bgFormId);
        }
        return null;
    }

    protected IPermission getPermInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.removeNotify();
        }
        return re;
    }
}

