/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.client.AbstractBgExcuteAnalysisScenUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExcuteAnalysisScenUI
extends AbstractBgExcuteAnalysisScenUI {
    private static final long serialVersionUID = -3063165775595440097L;
    private static final Logger logger = CoreUIObject.getLogger(BgExcuteAnalysisScenUI.class);
    private String schemeID = null;
    private Map<Integer, BgDimensionMember> returnMap = new HashMap<Integer, BgDimensionMember>();
    private Map<String, BgScenarioInfo> scenarioMap = new HashMap<String, BgScenarioInfo>();
    private boolean isCancel = true;
    protected BgSchemeDimensionHelper schemeHelper = null;

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    private Map<String, BgScenarioInfo> getScenarioMap() throws BOSException {
        if (this.scenarioMap.isEmpty()) {
            this.scenarioMap = BgScenarioHelper.getScenariooObjMap();
        }
        return this.scenarioMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.schemeID = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        this.initBgDataScenario();
        this.initActDataScenario();
        this.initDefultValue();
        this.kDTextArea.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBgAnalyseResource", (String)"scenText"));
        this.kDTextArea.setEditable(false);
    }

    protected void initDefultValue() throws Exception {
        Set senarioNum = (Set)this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO);
        Iterator iterNum = senarioNum.iterator();
        String number = null;
        BgScenarioInfo info = null;
        BgScenarioInfo actInfo = null;
        BgScenarioInfo bgInfo = null;
        int actCount = 0;
        int bgCount = 0;
        while (iterNum.hasNext()) {
            number = (String)iterNum.next();
            if (this.getScenarioMap().keySet().contains(number)) {
                info = this.getScenarioMap().get(number);
                if (BgScenarioType.BudgetData.equals((Object)info.getType())) {
                    bgInfo = info;
                    ++bgCount;
                } else if (BgScenarioType.ActualData.equals((Object)info.getType())) {
                    actInfo = info;
                    ++actCount;
                }
            }
            if (bgCount <= true || actCount <= true) continue;
        }
        if (bgCount == 1) {
            this.kDBizBgDataF7.setData(bgInfo);
        }
        if (actCount == 1) {
            this.kDBizActDataF7.setData(actInfo);
        }
    }

    protected void initBgDataScenario() throws Exception {
        this.kDBizBgDataF7.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        this.kDBizBgDataF7.setDisplayFormat("$name$");
        this.kDBizBgDataF7.setCommitFormat("$number$");
        this.kDBizBgDataF7.setEditFormat("$number$");
        this.kDBizBgDataF7.setEnabledMultiSelection(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, false), CompareType.INCLUDE));
        view.setFilter(filter);
        this.kDBizBgDataF7.setEntityViewInfo(view);
    }

    protected void initActDataScenario() throws Exception {
        this.kDBizActDataF7.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        this.kDBizActDataF7.setDisplayFormat("$name$");
        this.kDBizActDataF7.setCommitFormat("$number$");
        this.kDBizActDataF7.setEditFormat("$number$");
        this.kDBizActDataF7.setEnabledMultiSelection(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, false), CompareType.INCLUDE));
        view.setFilter(filter);
        this.kDBizActDataF7.setEntityViewInfo(view);
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnSave_actionPerformed(e);
        if (this.verify()) {
            this.setCancel(false);
            this.returnMap.clear();
            BgScenarioInfo bgScenario = (BgScenarioInfo)this.kDBizBgDataF7.getData();
            BgScenarioInfo actScenario = (BgScenarioInfo)this.kDBizActDataF7.getData();
            List list = this.getSchemeHelper().getDimension(DimensionConstants.DEF_SCENARIO_NUMBER).getMember();
            BgDimensionMember member = null;
            for (int i = 0; i < list.size(); ++i) {
                member = (BgDimensionMember)list.get(i);
                if (member.getNumber().equals(bgScenario.getNumber())) {
                    this.returnMap.put(0, member);
                }
                if (!member.getNumber().equals(actScenario.getNumber())) continue;
                this.returnMap.put(1, member);
            }
            this.getUIWindow().close();
        }
    }

    public Map returnMap() {
        return this.returnMap;
    }

    public boolean verify() {
        if (this.kDBizBgDataF7.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"selectBgDataName"));
            return false;
        }
        if (this.kDBizActDataF7.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"selectActDataName"));
            return false;
        }
        return true;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null) {
            try {
                this.schemeHelper = new BgSchemeDimensionHelper(this.schemeID);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.schemeHelper;
    }
}

