/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgCtrlTypeEnum;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeUI;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.query.ExeFilterParam;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgDimensionExtFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisFactory;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgFormExcuteAnalysis;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgExcuteAnalysisUI;
import com.kingdee.eas.ma.mbg.client.BgFormExcuteAnalysisListUI;
import com.kingdee.eas.ma.mbg.client.BgTransitBudgetDetailViewUI;
import com.kingdee.eas.ma.mbg.client.common.BookDimensionClientParse;
import com.kingdee.eas.ma.mbg.client.utils.BgAnalyseTableHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.IProviderUI;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormExportProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgExcuteAnalysisHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.data.BgExcuteAnalysisParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgExcuteAnalysisUI
extends AbstractBgExcuteAnalysisUI
implements IProviderUI {
    private static final long serialVersionUID = 7181874349796635297L;
    private static final Logger logger = CoreUIObject.getLogger(BgExcuteAnalysisUI.class);
    private String schemeID = null;
    BudgetDisplayValueProvider displayProvider = null;
    private int NORMAL_COL_WIDTH = 125;
    private boolean isLoadTransitBudget;
    protected NumberExpendRender render = new NumberExpendRender(0);
    private DecimalFormat decFormat = null;
    private Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    private Set<String> bgPeriodNums = new HashSet<String>();
    private Set<String> showBgPeriodNums = new HashSet<String>();
    private Map<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
    private BgFormInfo info = null;
    private Map<String, String[]> formulaMap = new HashMap<String, String[]>();
    private Set<String> dimSet = new LinkedHashSet<String>();
    private Map<String, BgScenarioInfo> scenarioMap = new HashMap<String, BgScenarioInfo>();
    private Map<String, String> mdxNumMap = new HashMap<String, String>();
    private Map<String, IMember> dimMemberMap = new HashMap<String, IMember>();
    private Map<String, Integer> dimIndexMap = new HashMap<String, Integer>();
    private String orgViewId = null;
    private Map<Integer, BgDimensionMember> saveScenarioMap = new HashMap<Integer, BgDimensionMember>();
    private boolean isCreate = false;
    private BgFormExcuteAnalysisInfo analysisInfo = null;
    private String accountViewId = null;
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    private List<BgDimensionBaseInfo> rowDims = new ArrayList<BgDimensionBaseInfo>();
    private List<BgDimensionBaseInfo> viewDims = new ArrayList<BgDimensionBaseInfo>();
    private Set<String> formulas = new HashSet<String>();
    private Map<String, Map<String, String>> queryLongNumbers = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, BgNViewDataInfo>> dataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
    private Map<String, BgControlParam> balanceMap = new HashMap<String, BgControlParam>();
    private List<IBgDimensionManagerBase> dimManager = new ArrayList<IBgDimensionManagerBase>();
    protected BgSchemeDimensionHelper schemeHelper = null;

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void setDecFormat(DecimalFormat decFormat) {
        this.decFormat = decFormat;
    }

    public DecimalFormat getDecFormat() {
        return this.decFormat;
    }

    public Map<String, CurrencyInfo> getCurrencyMap() {
        return this.currencyMap;
    }

    public Set<String> getBgPeriodNums() {
        return this.bgPeriodNums;
    }

    public Set<String> getShowBgPeriodNums() {
        return this.showBgPeriodNums;
    }

    private Map<String, BgPeriodInfo> getPeriodMap() {
        return this.periodMap;
    }

    public BgFormInfo getInfo() {
        return this.info;
    }

    public void setInfo(BgFormInfo info) {
        this.info = info;
    }

    public Map<String, String[]> getFormulaMap() {
        return this.formulaMap;
    }

    public Set<String> getDimSet() {
        return this.dimSet;
    }

    private Map<String, BgScenarioInfo> getScenarioMap() throws BOSException {
        if (this.scenarioMap.isEmpty()) {
            this.scenarioMap = BgScenarioHelper.getScenariooObjMap();
        }
        return this.scenarioMap;
    }

    public Map<String, String> getMdxNumMap() {
        return this.mdxNumMap;
    }

    public Map<String, IMember> getDimMemberMap() {
        return this.dimMemberMap;
    }

    public Map<String, Integer> getDimIndexMap() {
        return this.dimIndexMap;
    }

    public void setOrgViewId(String orgViewId) {
        this.orgViewId = orgViewId;
    }

    public String getOrgViewId() {
        return this.orgViewId;
    }

    private Map<Integer, BgDimensionMember> getSaveScenarioMap() {
        return this.saveScenarioMap;
    }

    public BgFormExcuteAnalysisInfo getAnalysisInfo() {
        return this.analysisInfo;
    }

    public void setAnalysisInfo(BgFormExcuteAnalysisInfo analysisInfo) {
        this.analysisInfo = analysisInfo;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    private void checkParsed() {
        this.dimTable.checkParsed();
        this.dimTable.getColumn("bgTransitData").getStyleAttributes().setHided(!this.isLoadTransitBudget);
    }

    public void onLoad() throws Exception {
        this.isLoadTransitBudget = BgParamCHelper.isLoadTransitBudget();
        super.onLoad();
        this.checkParsed();
        this.dimTable.getScriptManager().setAutoRun(false);
        this.dimTable.getStyleAttributes().setLocked(true);
        this.dimTable.getStyleAttributes().setWrapText(true);
        this.dimTable.setUserCellDisplayParser((IUserCellDisplayParser)new CellDisplayParser());
        CurrencyCollection colls = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        if (colls != null) {
            CurrencyInfo currency = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                currency = colls.get(i);
                this.getCurrencyMap().put(currency.getNumber(), currency);
            }
        }
        this.analysisInfo = (BgFormExcuteAnalysisInfo)this.getUIContext().get("BGFORM_IDS");
        this.saveScenarioMap = (Map)this.getUIContext().get(DimensionConstants.SCENARIO_DIM_NAME);
        this.info = (BgFormInfo)this.getUIContext().get("BGFORM_INFO");
        if (this.info.getSourceType().getValue() == 68) {
            this.setUITitle(RptSrcTypeEnum.FY_BUDGET_REPORT.getAlias() + this.getUITitle().substring(2));
        } else if (this.info.getSourceType().getValue() == 67) {
            this.setUITitle(RptSrcTypeEnum.ZJ_BUDGET_REPORT.getAlias() + this.getUITitle().substring(2));
        }
        this.schemeID = this.info.getBgScheme().getId().toString();
        this.isCreate = (Boolean)this.getUIContext().get("OPEN_STATE");
        if (this.saveScenarioMap == null) {
            List list = this.getSchemeHelper().getDimension(DimensionConstants.DEF_SCENARIO_NUMBER).getMember();
            this.saveScenarioMap = new HashMap<Integer, BgDimensionMember>();
            BgDimensionMember member = null;
            for (int i = 0; i < list.size(); ++i) {
                member = (BgDimensionMember)list.get(i);
                if (member.getNumber().equals(this.analysisInfo.getBgDataScenario())) {
                    this.saveScenarioMap.put(0, member);
                }
                if (!member.getNumber().equals(this.analysisInfo.getActDataScenario())) continue;
                this.saveScenarioMap.put(1, member);
            }
        }
        this.dataMap = BgFormExcuteAnalysisFactory.getRemoteInstance().queryAllBookBgData((IObjectValue)this.info, this.saveScenarioMap);
        LinkedHashMap<String, BgFormInfo> bgFormInfoMap = new LinkedHashMap<String, BgFormInfo>();
        bgFormInfoMap.put(this.info.getId().toString(), this.info);
        Book book = null;
        if (this.info.getBgTemplate().getFormType().getValue() == 0 || this.info.getBgTemplate().getFormType().getValue() == 8) {
            book = this.info.getBook();
        } else if (this.info.getBgTemplate().getFormType().getValue() == 2) {
            MBGViewListFormExportProvider viewlistExportProcessor = new MBGViewListFormExportProvider(bgFormInfoMap, (CoreUIObject)this, true, null);
            book = viewlistExportProcessor.getBook(this.info.getId().toString());
        } else if (this.info.getBgTemplate().getFormType().getValue() == 4) {
            MBGFormExportProvider mbgFormExportProvider = new MBGFormExportProvider(bgFormInfoMap, (CoreUIObject)this, true, null);
            book = mbgFormExportProvider.getBookMap().get(this.info.getId().toString());
        }
        this.formulas = BgExcuteAnalysisHelper.getFormulaListOfBook(book, this.info.getBgVersion().getNumber());
        this.getCellHelper().init();
        this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme(this.info.getBgScheme());
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal) {
            if (this.getDecFormat() == null && this.prmtCurrency.getData() != null) {
                CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
                DecimalFormat decFormat = new DecimalFormat(BgNationalFormatUIUtil.getNumberFormat((int)currency.getPrecision()));
                this.setDecFormat(decFormat);
            }
            value = this.decFormat.format(value);
        }
        return value;
    }

    protected IBgFormExcuteAnalysis getBizInterface() throws Exception {
        return BgFormExcuteAnalysisFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.dealDimManager();
        List<BgDimensionBaseInfo> dims = this.getDimLstByDimManager();
        this.dealDimTableParam(dims);
        this.dealDimTable(this.rowDims);
        this.dealDimView();
        this.setDataFormat();
        this.loadData();
        this.showData();
        this.dimTable.setRefresh(true);
        this.dimTable.reLayoutAndPaint();
        this.chkHideDimensionChange(this.chkHideDimension.isSelected());
    }

    private void setDataFormat() {
        this.dimTable.getColumn(BgExcuteAnalysisHelper.BGDATA).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getColumn("bgTransitData").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getColumn(BgExcuteAnalysisHelper.ACTDATA).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getColumn(BgExcuteAnalysisHelper.BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getColumn(BgExcuteAnalysisHelper.EXCUTEPROGRESS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getColumn(BgExcuteAnalysisHelper.EXCUTEDIFF).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getColumn(BgExcuteAnalysisHelper.EXCUTEDIFFSCALE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.dimTable.getHeadRow(0).getCell(BgExcuteAnalysisHelper.BGDATA).setValue((Object)this.saveScenarioMap.get(0).getName());
        this.dimTable.getHeadRow(0).getCell(BgExcuteAnalysisHelper.ACTDATA).setValue((Object)this.saveScenarioMap.get(1).getName());
    }

    private Map<String, Map<String, BgNViewDataInfo>> getDataMap() throws BOSException {
        return this.dataMap;
    }

    private Map<String, BgControlParam> getBalanceMap() throws BOSException {
        return this.balanceMap;
    }

    private void loadData() throws Exception {
        if (this.dataMap != null && !this.dataMap.isEmpty()) {
            String[] params = null;
            Map<String, BgNViewDataInfo> dataMaps = this.getDataMap().get(this.info.getOrgUnit().getId().toString());
            HashSet<String> formulaList = new HashSet<String>();
            for (String formulaKey : dataMaps.keySet()) {
                if (!this.formulas.contains(formulaKey)) continue;
                params = BgNFSHelper.parseFormulaPara(formulaKey);
                this.getBgPeriodNums().add(params[1]);
                if (params[3].equals(this.saveScenarioMap.get(0).getNumber())) {
                    formulaList.add(formulaKey.split("_")[0] + "_" + this.saveScenarioMap.get(1).getNumber());
                }
                if (!params[3].equals(this.saveScenarioMap.get(1).getNumber())) continue;
                params[3] = this.saveScenarioMap.get(0).getNumber();
                formulaList.add(BgNFSHelper.getFormulaFromParam(params) + "_" + this.saveScenarioMap.get(1).getNumber());
            }
            this.initShowBgPeriod();
            this.queryLongNumberToMap();
            IBudgetBalance balance = BgControlFacadeFactory.getRemoteInstance().queryBalance(this.info.getBgScheme().getId(), this.info.getBizOrgUnit().getId(), new ArrayList(formulaList), true);
            BgControlParam data = null;
            String newKey = null;
            if (balance != null) {
                for (int i = 0; i < balance.getBalance().size(); ++i) {
                    data = (BgControlParam)balance.getBalance().get(i);
                    if (data.getControlSetting() == null || BgCtrlTypeEnum.NoCtrl.equals((Object)data.getControlSetting().getCtrlType())) continue;
                    params = BgNFSHelper.parseFormulaPara(data.getFormula());
                    newKey = params[0] + "_" + params[1] + "_" + params[2] + "_" + params[5];
                    this.getBalanceMap().put(newKey, data);
                }
            }
        }
    }

    private void initShowBgPeriod() throws BOSException {
        if (this.getBgPeriodNums().isEmpty()) {
            return;
        }
        this.getShowBgPeriodNums().addAll(this.getBgPeriodNums());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", this.getShowBgPeriodNums(), CompareType.INCLUDE));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        BgPeriodDispCollection col = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(view);
        String[] lns = null;
        boolean existsParent = false;
        for (int i = 0; i < col.size(); ++i) {
            BgPeriodDispInfo bgPeriodDispInfo = col.get(i);
            this.addToMap(DimensionConstants.DEF_PERIOD_SRCNUMBER, bgPeriodDispInfo.getNumber(), bgPeriodDispInfo.getLongNumber());
            existsParent = false;
            lns = bgPeriodDispInfo.getLongNumber().split("!");
            for (int l = 0; l < lns.length; ++l) {
                if (existsParent) {
                    this.getShowBgPeriodNums().remove(lns[l]);
                    continue;
                }
                if (!this.getBgPeriodNums().contains(lns[l])) continue;
                existsParent = true;
            }
        }
        EntityViewInfo views = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", this.getShowBgPeriodNums(), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isLeaf");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.DESCEND);
        view.getSorter().add(sore);
        BgPeriodCollection coll = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(views);
        for (int i = 0; i < coll.size(); ++i) {
            this.getPeriodMap().put(coll.get(i).getNumber(), coll.get(i));
        }
    }

    private void addToMap(String pKey, String sKey, String value) {
        if (this.queryLongNumbers.containsKey(pKey)) {
            this.queryLongNumbers.get(pKey).put(sKey, value);
        } else {
            this.queryLongNumbers.put(pKey, new HashMap());
            this.queryLongNumbers.get(pKey).put(sKey, value);
        }
    }

    private void showData() throws Exception {
        if (this.dataMap != null && !this.dataMap.isEmpty()) {
            this.dimTable.removeRows();
            String[] params = null;
            BgNViewDataInfo[] object = null;
            HashMap<String, BgNViewDataInfo[]> newMap = new HashMap<String, BgNViewDataInfo[]>();
            Map<String, BgNViewDataInfo> dataMap = this.getDataMap().get(this.info.getOrgUnit().getId().toString());
            String newKey = null;
            String scenario = null;
            boolean isTrueScen = true;
            for (String formulaKey : dataMap.keySet()) {
                boolean isActScen;
                if (!this.formulas.contains(formulaKey)) {
                    params = BgNFSHelper.parseFormulaPara(formulaKey);
                    newKey = params[0] + "_" + params[1] + "_" + params[2] + "_" + params[5];
                    scenario = params[3];
                    boolean bl = isTrueScen = scenario.equals(this.saveScenarioMap.get(0).getNumber()) || scenario.equals(this.saveScenarioMap.get(1).getNumber());
                    if (isTrueScen && this.seachFlag(params) && (isActScen = this.getScenarioMap().get(scenario).getType().equals((Object)BgScenarioType.ActualData))) {
                        params[3] = this.saveScenarioMap.get(0).getNumber();
                        String bgformulaKey = BgNFSHelper.getFormulaFromParam(params);
                        if (this.formulas.contains(bgformulaKey = bgformulaKey + "_" + formulaKey.split("_")[1])) {
                            this.formulas.add(formulaKey);
                        }
                    }
                }
                if (!this.formulas.contains(formulaKey)) continue;
                params = BgNFSHelper.parseFormulaPara(formulaKey);
                newKey = params[0] + "_" + params[1] + "_" + params[2] + "_" + params[5];
                scenario = params[3];
                isTrueScen = scenario.equals(this.saveScenarioMap.get(0).getNumber()) || scenario.equals(this.saveScenarioMap.get(1).getNumber());
                if (!isTrueScen || !this.seachFlag(params)) continue;
                isActScen = this.getScenarioMap().get(scenario).getType().equals((Object)BgScenarioType.ActualData);
                if (newMap.containsKey(newKey)) {
                    object = (BgNViewDataInfo[])newMap.get(newKey);
                    if (isActScen) {
                        object[1] = dataMap.get(formulaKey);
                        continue;
                    }
                    object[0] = dataMap.get(formulaKey);
                    continue;
                }
                object = new BgNViewDataInfo[2];
                if (isActScen) {
                    object[0] = null;
                    object[1] = dataMap.get(formulaKey);
                } else {
                    object[0] = dataMap.get(formulaKey);
                    object[1] = null;
                }
                newMap.put(newKey, object);
            }
            int count = 0;
            if (newMap != null) {
                HashMap map = new HashMap();
                ArrayList<Integer> listMerge = null;
                Set entey = newMap.keySet();
                ArrayList list = new ArrayList(entey);
                final Map<String, Map<String, String>> refLongNumbers = this.queryLongNumbers;
                if (!this.queryLongNumbers.isEmpty()) {
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            String[] split = o1.split("_");
                            String[] split1 = o2.split("_");
                            String[] dimNumbers = split[0].split(",");
                            String[] dimNumbers1 = split1[0].split(",");
                            int in = dimNumbers.length;
                            for (int i = 0; i < in; ++i) {
                                String dimNumber = dimNumbers[i];
                                String dimNumber1 = dimNumbers1[i];
                                String[] srcNumbers = dimNumber.split(":");
                                String number = srcNumbers[1];
                                String number1 = dimNumber1.split(":")[1];
                                Map longNumbers = (Map)refLongNumbers.get(srcNumbers[0]);
                                if (number.equals(number1)) continue;
                                return ((String)longNumbers.get(number)).compareTo((String)longNumbers.get(number1));
                            }
                            String periodNumber = split[1];
                            String periodNumber1 = split1[1];
                            Map longNumbers = (Map)refLongNumbers.get(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                            if (!periodNumber.equals(periodNumber1)) {
                                return ((String)longNumbers.get(periodNumber)).compareTo((String)longNumbers.get(periodNumber1));
                            }
                            return o1.compareTo(o2);
                        }
                    });
                }
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (String key : list) {
                    linkedHashMap.put(key, newMap.get(key));
                }
                IRow row = null;
                String[] dimNums = null;
                String[] tmpStrs = null;
                String dimNumber = null;
                String srcNumber = null;
                String keyMerge = null;
                String pnumber = null;
                String pname = null;
                String prefix = null;
                IMember member = null;
                BgNViewDataInfo bgdata = null;
                BgNViewDataInfo actdata = null;
                BigDecimal bgvalue = null;
                BigDecimal actvalue = null;
                BigDecimal bgTransitValue = null;
                BgControlParam ctrlParam = null;
                for (String key : linkedHashMap.keySet()) {
                    bgdata = ((BgNViewDataInfo[])newMap.get(key))[0];
                    actdata = ((BgNViewDataInfo[])newMap.get(key))[1];
                    if ((bgdata == null || bgdata.getBudgetValue().compareTo(BigDecimal.ZERO) == 0) && (actdata == null || actdata.getBizActual().compareTo(BigDecimal.ZERO) == 0)) continue;
                    this.dimTable.addRow();
                    row = this.dimTable.getRow(count);
                    dimNums = key.split("_")[0].split(",");
                    if (dimNums != null) {
                        int in = dimNums.length;
                        for (int j = 0; j < in; ++j) {
                            dimNumber = dimNums[j];
                            tmpStrs = dimNumber.split(":");
                            if (tmpStrs == null) continue;
                            srcNumber = tmpStrs[0];
                            member = this.getDimMemberMap().get(dimNumber);
                            int index = this.getDimIndexMap().get(srcNumber);
                            this.dimTable.getRow(count).getCell(index).setValue((Object)this.getCellHelper().getIndexDisplayName(j == 0 ? this.accountViewId : null, member.getDimNumber(), member.getName()));
                            this.dimTable.getRow(count).getCell(index).setUserObject((Object)member);
                        }
                    }
                    if (!map.containsKey(keyMerge = key.split("_")[0])) {
                        listMerge = new ArrayList<Integer>();
                        listMerge.add(count);
                        map.put(keyMerge, listMerge);
                    } else {
                        ((List)map.get(keyMerge)).add(count);
                    }
                    if (this.getPeriodMap().get(key.split("_")[1]) != null) {
                        pnumber = this.getPeriodMap().get(key.split("_")[1]).getNumber();
                        pname = this.getPeriodMap().get(key.split("_")[1]).getName();
                        if (!StringUtils.isEmpty((String)pnumber)) {
                            prefix = pnumber.substring(0, 4);
                            pname = pname + " (" + prefix + ")";
                        }
                    }
                    row.getCell(BgExcuteAnalysisHelper.BGPERIOD).setValue(pname);
                    if (bgdata != null) {
                        row.getCell(BgExcuteAnalysisHelper.BGDATA).setValue((Object)bgdata.getBudgetValueNoDef());
                        row.getCell(BgExcuteAnalysisHelper.FORMULA).setValue((Object)bgdata.getFormula());
                        bgvalue = bgdata.getBudgetValue();
                        bgTransitValue = bgdata.getTransitBudget();
                        if (bgTransitValue != null && BigDecimal.ZERO.compareTo(bgTransitValue) != 0) {
                            row.getCell("bgTransitData").setValue((Object)bgTransitValue);
                        }
                        row.getCell("bgTransitData").setUserObject((Object)bgdata.getFormula());
                    } else {
                        bgvalue = BigDecimal.ZERO;
                        bgTransitValue = BigDecimal.ZERO;
                    }
                    if (actdata != null) {
                        row.getCell(BgExcuteAnalysisHelper.ACTDATA).setValue((Object)actdata.getBizActualNoDef());
                        row.getCell(BgExcuteAnalysisHelper.FORMULA).setValue((Object)actdata.getFormula());
                        actvalue = actdata.getBizActual();
                    } else {
                        actvalue = BigDecimal.ZERO;
                    }
                    BigDecimal subtract = bgvalue.subtract(bgTransitValue);
                    if (subtract.compareTo(BigDecimal.ZERO) == 0) {
                        row.getCell(BgExcuteAnalysisHelper.EXCUTEPROGRESS).setValue(null);
                        row.getCell(BgExcuteAnalysisHelper.EXCUTEDIFFSCALE).setValue(null);
                    } else {
                        row.getCell(BgExcuteAnalysisHelper.EXCUTEPROGRESS).setValue((Object)(actvalue.multiply(BgNConstants.HUNDRED).divide(subtract, 2, 4) + "%"));
                        row.getCell(BgExcuteAnalysisHelper.EXCUTEDIFFSCALE).setValue((Object)(bgvalue.subtract(actvalue).subtract(bgTransitValue).multiply(BgNConstants.HUNDRED).divide(subtract, 2, 4) + "%"));
                    }
                    row.getCell(BgExcuteAnalysisHelper.EXCUTEDIFF).setValue((Object)bgvalue.subtract(actvalue).subtract(bgTransitValue));
                    if (this.getBalanceMap().containsKey(key)) {
                        ctrlParam = this.getBalanceMap().get(key);
                        if (ctrlParam.getControlSetting().isIsGroupCtrl()) {
                            row.getCell(BgExcuteAnalysisHelper.BALANCE).setValue((Object)ctrlParam.getOrignExtBalance());
                        } else {
                            row.getCell(BgExcuteAnalysisHelper.BALANCE).setValue((Object)ctrlParam.getOrignBalance());
                        }
                    } else {
                        row.getCell(BgExcuteAnalysisHelper.BALANCE).setValue((Object)bgvalue.subtract(actvalue).subtract(bgTransitValue));
                    }
                    ++count;
                }
                for (String keys : map.keySet()) {
                    int topIndex = (Integer)Collections.min((Collection)map.get(keys));
                    int botIndex = (Integer)Collections.max((Collection)map.get(keys));
                    for (int i = 0; i < keys.split(",").length; ++i) {
                        this.dimTable.getMergeManager().mergeBlock(topIndex, i, botIndex, i);
                    }
                }
            }
        }
    }

    private void queryLongNumberToMap() throws BOSException, EASBizException {
        Map<String, BgNViewDataInfo> dataMap = this.getDataMap().get(this.info.getOrgUnit().getId().toString());
        Map<String, BgDimensionInfo> dimensionBySrcNumber = this.getSchemeHelper().getDimensionBySrcNumber();
        HashMap temps = new HashMap();
        for (String string : dataMap.keySet()) {
            String formula = string.split("_")[0];
            String[] params = BgNFSHelper.parseFormulaPara(formula);
            String dimItem = params[0];
            String[] dimNumbers = dimItem.split(",");
            for (int i = 0; i < dimNumbers.length; ++i) {
                String[] srcNumbers = dimNumbers[i].split(":");
                String srcNumber = srcNumbers[0];
                if (!temps.containsKey(srcNumber)) {
                    temps.put(srcNumber, new HashSet());
                }
                ((Set)temps.get(srcNumber)).add(srcNumbers[1]);
            }
        }
        for (Map.Entry entry : temps.entrySet()) {
            String srcNumber = (String)entry.getKey();
            Set numbers = (Set)entry.getValue();
            Map queryMembers = DimensionFormulaFacadeFactory.getRemoteInstance().queryMembers(this.info.getOrgUnit().getId().toString(), this.getSchemeHelper().getBgSchemeId(), dimensionBySrcNumber.get(srcNumber).getNumber(), numbers);
            for (BgDimensionMember dimensionMember : queryMembers.values()) {
                this.addToMap(srcNumber, dimensionMember.getNumber(), dimensionMember.getSortValue().toString());
            }
        }
    }

    private boolean seachFlag(String[] params) {
        boolean ind;
        String index = null;
        String currency = null;
        String element = null;
        String period = null;
        Object objEle = this.prmtElement.getData();
        BgElementInfo eleInfo = null;
        if (objEle != null && objEle instanceof BgElementInfo) {
            eleInfo = (BgElementInfo)objEle;
        }
        Object objCur = this.prmtCurrency.getData();
        CurrencyInfo curInfo = null;
        if (objCur != null && objCur instanceof CurrencyInfo) {
            curInfo = (CurrencyInfo)objCur;
        }
        List<String> bgAccountList = this.getIndexList();
        List<String> periodList = this.getPeriodList();
        period = params[1];
        index = params[0].split(",")[0].split(":")[1];
        currency = params[5];
        element = params[2];
        boolean cur = curInfo != null && curInfo.getNumber().equals(currency);
        boolean ele = eleInfo != null && eleInfo.getNumber().equals(element);
        boolean per = periodList != null && periodList.contains(period);
        boolean bl = ind = bgAccountList != null && bgAccountList.contains(index);
        return (curInfo == null && eleInfo == null || curInfo == null && ele || eleInfo == null && cur || cur && ele) && ((bgAccountList == null || bgAccountList.isEmpty()) && (periodList == null || periodList.isEmpty()) || (bgAccountList == null || bgAccountList.isEmpty()) && per || (periodList == null || periodList.isEmpty()) && ind || per && ind);
    }

    private List<String> getPeriodList() {
        Object objPeriod = this.prmtPeriod.getData();
        ArrayList<String> periodList = null;
        if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
            BgPeriodInfo periodInfo = (BgPeriodInfo)objPeriod;
            periodList = new ArrayList();
            periodList.add(periodInfo.getNumber());
        } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
            periodList = new ArrayList<String>();
            BgPeriodInfo[] periodArray = (BgPeriodInfo[])objPeriod;
            for (int i = 0; i < periodArray.length; ++i) {
                periodList.add(periodArray[i].getNumber());
            }
        }
        return periodList;
    }

    private List<String> getIndexList() {
        ArrayList<String> bgAccountList;
        block3: {
            Object objIndex;
            block4: {
                block2: {
                    objIndex = this.prmtIndex.getData();
                    bgAccountList = null;
                    if (objIndex == null || !(objIndex instanceof BgAccountInfo)) break block2;
                    BgAccountInfo accountInfo = (BgAccountInfo)objIndex;
                    bgAccountList = new ArrayList();
                    bgAccountList.add(accountInfo.getNumber());
                    break block3;
                }
                if (objIndex == null || !(objIndex instanceof Object[])) break block4;
                bgAccountList = new ArrayList<String>();
                Object[] bgAccountArray = (Object[])objIndex;
                for (int i = 0; i < bgAccountArray.length; ++i) {
                    if (bgAccountArray[i] == null) continue;
                    bgAccountList.add(((BgAccountInfo)bgAccountArray[i]).getNumber());
                }
                break block3;
            }
            if (objIndex == null || !(objIndex instanceof List)) break block3;
            List listIndex = (List)objIndex;
            bgAccountList = new ArrayList();
            for (int i = 0; i < listIndex.size(); ++i) {
                bgAccountList.add(((BgDimensionMember)listIndex.get(i)).getNumber());
            }
        }
        return bgAccountList;
    }

    protected void dealDimManager() {
        block4: {
            IMbgViewBase view;
            block5: {
                MbgViewListManager dimManagers;
                block3: {
                    IMbgViewManager imbgViewManager = null;
                    dimManagers = null;
                    view = null;
                    this.dimManager.clear();
                    if (!(this.getUIContext().get(DimensionConstants.DIMENSION) instanceof IMbgViewManager)) break block3;
                    imbgViewManager = (IMbgViewManager)this.getUIContext().get(DimensionConstants.DIMENSION);
                    for (int i = 0; i < imbgViewManager.getSheetManagers().size(); ++i) {
                        this.dimManager.add(imbgViewManager.getSheetManagers().get(i).getDimensionManager());
                    }
                    break block4;
                }
                if (!(this.getUIContext().get(DimensionConstants.DIMENSION) instanceof MbgViewListManager)) break block5;
                dimManagers = (MbgViewListManager)this.getUIContext().get(DimensionConstants.DIMENSION);
                for (int i = 0; i < dimManagers.getSheetManagers().size(); ++i) {
                    this.dimManager.add(((MbgViewListSheetManager)dimManagers.getSheetManagers().get(i)).getDimensionManager());
                }
                break block4;
            }
            if (!(this.getUIContext().get(DimensionConstants.DIMENSION) instanceof IMbgViewBase)) break block4;
            view = (IMbgViewBase)this.getUIContext().get(DimensionConstants.DIMENSION);
            for (int i = 0; i < view.getSheetManagers().size(); ++i) {
                this.dimManager.add(view.getSheetManagers().get(i).getDimensionManager());
            }
        }
    }

    protected void dealDimTableParam(List<BgDimensionBaseInfo> dims) throws EASBizException, BOSException, UuidException {
        IMember member = null;
        BgDimensionMember bgMember = null;
        this.setOrgViewId((String)this.getUIContext().get("BGORGVIEW_ID"));
        this.mdxNumMap = BgDimensionExtFacadeFactory.getRemoteInstance().queryMember(this.info.getBgScheme().getId(), BOSUuid.read((String)this.orgViewId), dims);
        for (BgDimensionBaseInfo _dimension : dims) {
            if (!DimUtils.checkBaseDimension(_dimension)) {
                int count = 0;
                for (int i = 0; i < this.rowDims.size(); ++i) {
                    if (!this.rowDims.get(i).getNumber().equals(_dimension.getNumber())) continue;
                    ++count;
                    break;
                }
                int in = _dimension.getMember().size();
                for (int j = 0; j < in; ++j) {
                    bgMember = (BgDimensionMember)_dimension.getMember().get(j);
                    member = DimUtils.transDimMember(bgMember);
                    member.setMdxNumber(bgMember.getSortValue().toString());
                    this.getDimMemberMap().put(member.getDimNumber(), member);
                }
                if (count > 0) continue;
                this.rowDims.add(_dimension);
                continue;
            }
            this.viewDims.add(_dimension);
        }
        this.sortRowDims();
        int colCount = this.rowDims.size();
        for (int i = 0; i < colCount; ++i) {
            this.dimTable.addColumn(i);
        }
        int pos = 0;
        int index = 0;
        int count = this.rowDims.size();
        while (index < count) {
            this.dimTable.getColumn(pos).setWidth(this.NORMAL_COL_WIDTH);
            ++index;
            ++pos;
        }
    }

    private void sortRowDims() {
        if (this.rowDims.isEmpty()) {
            return;
        }
        Collections.sort(this.rowDims, new Comparator<BgDimensionBaseInfo>(){

            @Override
            public int compare(BgDimensionBaseInfo o1, BgDimensionBaseInfo o2) {
                if (o1 instanceof BgDimensionBaseInfo && o2 instanceof BgDimensionBaseInfo) {
                    Integer v1 = DimensionCommonHelper.getField(o1.getRefField());
                    Integer v2 = DimensionCommonHelper.getField(o2.getRefField());
                    return v1.compareTo(v2);
                }
                return 0;
            }
        });
    }

    protected boolean dealDimTable(List<BgDimensionBaseInfo> rowDims) {
        if (rowDims == null) {
            return false;
        }
        IRow row = null;
        IColumn column = null;
        BgDimensionBaseInfo dimension = null;
        BgDimensionMember bgMember = null;
        this.dimTable.getHeadRow(0).setRenderer((IBasicRender)this.getRender());
        int in = rowDims.size();
        for (int i = 0; i < in; ++i) {
            dimension = rowDims.get(i);
            row = this.dimTable.getHeadRow(0);
            row.getCell(i, true).setValue((Object)dimension.getName());
            column = this.dimTable.getColumn(i);
            column.setUserObject((Object)dimension);
            column.setRenderer((IBasicRender)this.getRender());
            int jn = dimension.getMember().size();
            for (int j = 0; j < jn; ++j) {
                bgMember = (BgDimensionMember)dimension.getMember().get(j);
                this.getDimIndexMap().put(bgMember.getSrcNumber(), i);
            }
        }
        return true;
    }

    protected void dealDimView() throws EASBizException, BOSException {
        this.initBgOrgDialog();
        this.initBgElementDialog();
        this.initCurrencyDialog();
        this.initBgIndexDialog();
        this.initBgPeriodDialog();
        this.setDefualtMember();
    }

    protected void setDefualtMember() throws EASBizException, BOSException {
        if (this.isCreate) {
            EntityViewInfo eleview = new EntityViewInfo();
            FilterInfo elefilter = new FilterInfo();
            elefilter.getFilterItems().add(new FilterItemInfo("number", this.getViewNumber(DimensionConstants.DEF_ELEMENT_NUMBER), CompareType.INCLUDE));
            eleview.setFilter(elefilter);
            eleview.setSorter(null);
            eleview.setSorter(new SorterItemCollection());
            SorterItemInfo sort = new SorterItemInfo("number");
            sort.setSortType(SortType.ASCEND);
            eleview.getSorter().add(sort);
            this.prmtElement.setData((Object)BgElementFactory.getRemoteInstance().getBgElementCollection(eleview).get(0));
            EntityViewInfo currview = new EntityViewInfo();
            FilterInfo currfilter = new FilterInfo();
            currfilter.getFilterItems().add(new FilterItemInfo("number", this.getViewNumber(DimensionConstants.DEF_CURRENCY_NUMBER), CompareType.INCLUDE));
            currview.setFilter(currfilter);
            currview.setSorter(new SorterItemCollection());
            currview.getSorter().add(sort);
            this.prmtCurrency.setData((Object)CurrencyFactory.getRemoteInstance().getCurrencyCollection(currview).get(0));
        } else {
            this.prmtCurrency.setData((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.analysisInfo.getCurrencyID())));
            this.prmtElement.setData((Object)BgElementFactory.getRemoteInstance().getBgElementInfo((IObjectPK)new ObjectUuidPK(this.analysisInfo.getElementID())));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)this.info.getOrgUnit().getId(), CompareType.EQUALS));
        BgCommHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgScheme.number", (Object)this.info.getBgScheme().getNumber(), CompareType.EQUALS));
        BgCommHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgForm.bgTemplate.number", (Object)this.info.getBgTemplate().getNumber(), CompareType.EQUALS));
        BgNFCHelper.addBgPeriodFilter4Decompose(this.prmtPeriod, filter);
        if (this.prmtPeriod != null && this.prmtPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
            bgPeriodDialog.setBgPeriodBeginDate(this.info.getBgScheme().getDateFrom());
            bgPeriodDialog.setBgPeriodEndDate(this.info.getBgScheme().getDateTo());
            bgPeriodDialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
            bgPeriodDialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        }
        if (!this.isCreate && this.analysisInfo.getAnalysisParam() != null) {
            BgExcuteAnalysisParam param = (BgExcuteAnalysisParam)BgAnalyseHelper.getObject(this.analysisInfo.getAnalysisParam());
            this.chkHideDimension.setSelected(param.isHideDim());
            this.prmtIndex.setData(param.getAccountList());
            this.prmtPeriod.setData(param.getPeriodArray());
        }
    }

    protected void initBgOrgDialog() {
        this.prmtOrg.setDisplayFormat("$name$");
        this.prmtOrg.setCommitFormat("$number$");
        this.prmtOrg.setEditFormat("$number$");
        this.prmtOrg.setEnabledMultiSelection(false);
        this.prmtOrg.setData((Object)this.info.getOrgUnit());
        this.prmtOrg.setEnabled(false);
    }

    protected void initBgIndexDialog() {
        BgDimensionInfo accDimension = new BgDimensionInfo(null);
        accDimension.setType(DimensionConstants.DEF_ACCOUNT_NUMBER);
        accDimension.setNumber(DimensionConstants.DEF_ACCOUNT_NUMBER);
        accDimension.setName(DimensionConstants.DEF_ACCOUNT_MAME);
        accDimension.setAlias(DimensionConstants.DEF_ACCOUNT_MAME);
        NewDimensionMemberDialog bgIndexDialog = new NewDimensionMemberDialog((CoreUI)this, accDimension, this.info.getOrgUnit().getId().toString(), true);
        bgIndexDialog.setCanFillType(false);
        bgIndexDialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        this.prmtIndex.setSelector((KDPromptSelector)bgIndexDialog);
        this.prmtIndex.setEditable(false);
        this.prmtIndex.setData(null);
        this.prmtIndex.addDataChangeListener((DataChangeListener)new MemberDataChangeListener(bgIndexDialog));
    }

    protected void initCurrencyDialog() {
        this.prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.prmtCurrency.setDisplayFormat("$name$");
        this.prmtCurrency.setCommitFormat("$number$");
        this.prmtCurrency.setEditFormat("$number$");
        this.prmtCurrency.setEnabledMultiSelection(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", this.getViewNumber(DimensionConstants.DEF_CURRENCY_NUMBER), CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCurrency.setEntityViewInfo(view);
    }

    protected void initBgElementDialog() {
        this.prmtElement.setQueryInfo("com.kingdee.eas.ma.base.BgElementQuery");
        this.prmtElement.setDisplayFormat("$name$");
        this.prmtElement.setCommitFormat("$number$");
        this.prmtElement.setEditFormat("$number$");
        this.prmtElement.setEnabledMultiSelection(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", this.getViewNumber(DimensionConstants.DEF_ELEMENT_NUMBER), CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtElement.setEntityViewInfo(view);
    }

    protected void initBgPeriodDialog() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, true);
        bgPeriodDialog.setAllowSort(false);
        this.prmtPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtPeriod.setEditable(false);
        this.prmtPeriod.setEnabledMultiSelection(true);
        this.prmtPeriod.setHistoryRecordEnabled(false);
    }

    @Override
    protected void prmtPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPeriod_dataChanged(e);
        if (this.prmtPeriod != null && this.prmtPeriod.getSelector() instanceof BgPeriodDialog && this.prmtPeriod.getData() == null) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
            bgPeriodDialog.setBgPeriods(null);
        }
        this.showData();
    }

    @Override
    protected void prmtPeriod_willShow(SelectorEvent e) throws Exception {
        if (this.prmtPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
            BgPeriodInfo periodInfo = null;
            Object objPeriod = this.prmtPeriod.getData();
            if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                periodInfo = (BgPeriodInfo)objPeriod;
                BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                bgPeriodDialog.setBgPeriods(periodArray);
            } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
                bgPeriodDialog.setBgPeriods((BgPeriodInfo[])objPeriod);
            } else {
                bgPeriodDialog.setBgPeriods(null);
            }
        }
        super.prmtPeriod_willShow(e);
    }

    @Override
    protected void prmtElement_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtElement_dataChanged(e);
        this.showData();
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        this.showData();
    }

    @Override
    protected void prmtIndex_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtIndex_dataChanged(e);
        this.showData();
        this.chkHideDimensionChange(this.chkHideDimension.isSelected());
    }

    @Override
    protected void prmtIndex_willShow(SelectorEvent e) throws Exception {
        super.prmtIndex_willShow(e);
        this.showData();
    }

    protected Set<String> getViewNumber(String dimensionNumber) {
        HashSet<String> numberSet = new HashSet<String>();
        List<BgDimensionBaseInfo> list = this.getDimLstByDimManager();
        if (!list.isEmpty()) {
            BgDimensionBaseInfo dim = null;
            for (int index = 0; index < list.size(); ++index) {
                dim = list.get(index);
                if (!dimensionNumber.equals(dim.getNumber())) continue;
                int in = dim.getMember().size();
                for (int i = 0; i < in; ++i) {
                    BgDimensionMember _bgMember = (BgDimensionMember)dim.getMember().get(i);
                    numberSet.add(_bgMember.getNumber());
                }
            }
        }
        return numberSet;
    }

    protected BgDimensionBaseInfo getDimByNumber(List<BgDimensionBaseInfo> dims, String dimNumber) {
        if (dims == null || dims.isEmpty() || dimNumber == null) {
            return null;
        }
        BgDimensionBaseInfo dim = null;
        for (int index = 0; index < dims.size(); ++index) {
            dim = dims.get(index);
            if (!dimNumber.equals(dim.getNumber())) continue;
            return dim;
        }
        return null;
    }

    protected List<BgDimensionBaseInfo> getDimLstByDimManager() {
        ArrayList<BgDimensionBaseInfo> list = new ArrayList<BgDimensionBaseInfo>();
        for (int i = 0; i < this.dimManager.size(); ++i) {
            list.addAll(BgExcuteAnalysisHelper.getDimLstByDimManager(this.dimManager.get(i)));
        }
        return list;
    }

    @Override
    protected void dimTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.dimTable_tableClicked(e);
    }

    public boolean destroyWindow() {
        if (this.checkModify()) {
            int results = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (results == 0) {
                try {
                    if (!this.saveData()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (results == 2 || results == -1) {
                return false;
            }
        }
        boolean re = super.destroyWindow();
        BgFormExcuteAnalysisListUI listui = (BgFormExcuteAnalysisListUI)((Object)this.getUIContext().get("MainUI"));
        try {
            listui.refreshList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return re;
    }

    private boolean checkModify() {
        if (this.isCreate) {
            return true;
        }
        if (this.prmtCurrency.getQueryInfo() != null && !this.prmtCurrency.getQueryInfo().isEmpty()) {
            if (this.prmtCurrency.getData() == null) {
                return true;
            }
            if (this.prmtElement.getData() == null) {
                return true;
            }
            CurrencyInfo curInfo = (CurrencyInfo)this.prmtCurrency.getData();
            if (this.analysisInfo != null && !curInfo.getId().equals((Object)this.analysisInfo.getCurrencyID())) {
                return true;
            }
            BgElementInfo eleInfo = (BgElementInfo)this.prmtElement.getData();
            if (this.analysisInfo != null && !eleInfo.getId().equals((Object)this.analysisInfo.getElementID())) {
                return true;
            }
            Object indexObject = this.prmtIndex.getData();
            Object[] periodObject = (Object[])this.prmtPeriod.getData();
            boolean isSelect = this.chkHideDimension.isSelected();
            if (this.analysisInfo != null && this.analysisInfo.getAnalysisParam() != null) {
                boolean isPeriod;
                BgExcuteAnalysisParam oldParam = (BgExcuteAnalysisParam)BgAnalyseHelper.getObject(this.analysisInfo.getAnalysisParam());
                if (oldParam == null) {
                    return true;
                }
                Object[] periodObjectOld = (Object[])oldParam.getPeriodArray();
                boolean isIndex = indexObject != null && oldParam.getAccountList() == null || indexObject == null && oldParam.getAccountList() != null || indexObject != null && oldParam.getAccountList() != null && !indexObject.equals(oldParam.getAccountList());
                boolean bl = isPeriod = periodObject != null && periodObjectOld == null || periodObject == null && periodObjectOld != null || !Arrays.equals(periodObject, periodObjectOld);
                if (isIndex || isPeriod || isSelect != oldParam.isHideDim()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean verify() {
        if (this.prmtCurrency.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"msgSelectCurr"));
            return false;
        }
        if (this.prmtElement.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"msgSelectEle"));
            return false;
        }
        return true;
    }

    private boolean saveData() throws Exception {
        if (this.verify()) {
            BgElementInfo eleInfo = (BgElementInfo)this.prmtElement.getData();
            CurrencyInfo curInfo = (CurrencyInfo)this.prmtCurrency.getData();
            BgExcuteAnalysisParam param = new BgExcuteAnalysisParam();
            param.setAccountList(this.prmtIndex.getData());
            param.setPeriodArray(this.prmtPeriod.getData());
            param.setHideDim(this.chkHideDimension.isSelected());
            if (this.analysisInfo != null && !this.isCreate) {
                Timestamp _time = new Timestamp(System.currentTimeMillis());
                UserInfo userinfo = SysContext.getSysContext().getCurrentUserInfo();
                this.analysisInfo.setCurrencyID(curInfo.getId());
                this.analysisInfo.setElementID(eleInfo.getId());
                this.analysisInfo.setAnalysisTime(_time);
                this.analysisInfo.setLastUpdateTime(_time);
                this.analysisInfo.setAnalysisUser(userinfo);
                this.analysisInfo.setLastUpdateUser(userinfo);
                this.analysisInfo.setAnalysisParam(BgAnalyseHelper.getBytes(param));
                this.getBizInterface().save((CoreBaseInfo)this.analysisInfo);
            } else {
                BgFormExcuteAnalysisInfo bgExcuteAnalysisInfo = new BgFormExcuteAnalysisInfo();
                bgExcuteAnalysisInfo.setElementID(eleInfo.getId());
                bgExcuteAnalysisInfo.setCurrencyID(curInfo.getId());
                bgExcuteAnalysisInfo.setAnalysisParam(BgAnalyseHelper.getBytes(param));
                this.getBizInterface().saveAnalysis((IObjectValue)this.info, this.getSaveScenarioMap(), bgExcuteAnalysisInfo);
            }
            return true;
        }
        return false;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.saveData()) {
            this.isCreate = false;
            this.showSuccessMsg(DesignerResource.getString((String)"saveOK"));
        }
    }

    public void showSuccessMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void actionSearchAct_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearchAct_actionPerformed(e);
        this.checkSelected();
        if (this.verify()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"InitDataObject", (Object)this.getExeFilterParam());
            uiContext.put((Object)"isShowAllTotal", (Object)true);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getAnalyseUI(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }

    @Override
    public void actionSearchTransit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.verify()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"processType", (Object)BgProcessEnum.C01);
            BgSchemeInfo scheme = this.getExeFilterParam().getBgScheme();
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(scheme.getId().toString());
            uiContext.put((Object)"schemeHelper", (Object)schemeHelper);
            IRow row = this.dimTable.getRow(this.dimTable.getSelectManager().getActiveRowIndex());
            String formula = (String)row.getCell("bgTransitData").getUserObject();
            List detailData = new ArrayList();
            if (!StringUtils.isEmpty((String)formula)) {
                detailData = this.getTransitBudgetDetailData(formula, schemeHelper);
            }
            uiContext.put((Object)"data", detailData);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTransitBudgetDetailViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    private List getTransitBudgetDetailData(String formula, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        FullOrgUnitInfo orgUnit = this.info.getOrgUnit();
        BgVersionInfo bgVersion = this.info.getBgVersion();
        HashSet<String> formulas = new HashSet<String>(1);
        formulas.add(formula);
        return BgAdjustFacadaFactory.getRemoteInstance().transitDataView(formulas, (OrgUnitInfo)orgUnit, bgVersion, schemeHelper);
    }

    protected String getAnalyseUI() {
        return MBgAnalyseExeUI.class.getName();
    }

    public void checkSelected() {
        if (this.dimTable.getRowCount() == 0 || this.dimTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private ExeFilterParam getExeFilterParam() throws Exception {
        IRow row = this.dimTable.getRow(this.dimTable.getSelectManager().getActiveRowIndex());
        String formula = (String)row.getCell(BgExcuteAnalysisHelper.FORMULA).getValue();
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        String periodNum = params[1];
        String dimNumber = params[0];
        CurrencyInfo cur = (CurrencyInfo)this.prmtCurrency.getData();
        BgElementInfo ele = (BgElementInfo)this.prmtElement.getData();
        ExeFilterParam _filterParam = new ExeFilterParam();
        FullOrgUnitInfo orgUnit = this.info.getOrgUnit();
        _filterParam.getOrgUnits().add(orgUnit);
        _filterParam.setBgScheme(new BgSchemeInfo());
        _filterParam.getBgScheme().setId(BOSUuid.read((String)this.schemeID));
        ArrayList<AnalyseMember> memberList = new ArrayList<AnalyseMember>();
        AnalyseMember members = new AnalyseMember();
        BgAnalyseTableHelper.dealDimAndIndexMember(members, dimNumber, this.schemeID);
        memberList.add(members);
        _filterParam.getMembers().addAll(memberList);
        _filterParam.setShowDetailOfEmptyMember(true);
        _filterParam.setShowDetailOfQuery(true);
        _filterParam.setBgExcuteAnalysis(true);
        BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[]{this.getPeriodMap().get(periodNum)};
        _filterParam.setBgPeriods(bgPeriodInfos);
        _filterParam.setBeginPeriod(null);
        _filterParam.setEndPeriod(null);
        _filterParam.setCurrency(new CurrencyInfo());
        _filterParam.getCurrency().setId(cur.getId());
        _filterParam.setBgElement(new BgElementInfo());
        _filterParam.getBgElement().setId(ele.getId());
        _filterParam.setBgScenario(new BgScenarioInfo());
        _filterParam.getBgScenario().setId(this.getScenarioMap().get(this.saveScenarioMap.get(1).getNumber()).getId());
        return _filterParam;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null) {
            try {
                this.schemeHelper = new BgSchemeDimensionHelper(this.schemeID);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.schemeHelper;
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
    }

    @Override
    protected void chkHideDimension_stateChanged(ChangeEvent e) throws Exception {
        super.chkHideDimension_stateChanged(e);
        boolean isSelect = false;
        if (e.getSource() instanceof KDCheckBox) {
            KDCheckBox box = (KDCheckBox)e.getSource();
            isSelect = box.isSelected();
        }
        this.chkHideDimensionChange(isSelect);
    }

    private void chkHideDimensionChange(boolean isSelect) {
        int i;
        IMember member = null;
        HashMap map = new HashMap();
        for (i = 1; i < this.getDimIndexMap().keySet().size(); ++i) {
            HashSet<String> set = new HashSet<String>();
            for (int j = 0; j < this.dimTable.getRowCount(); ++j) {
                member = (IMember)this.dimTable.getCell(j, i).getUserObject();
                set.add(member.getNumber());
            }
            map.put(i, set);
        }
        for (i = 1; i < this.getDimIndexMap().keySet().size(); ++i) {
            if (((Set)map.get(i)).size() < 2 && this.dimTable.getRowCount() > 0) {
                if (isSelect) {
                    this.dimTable.getColumn(i).getStyleAttributes().setHided(isSelect);
                    continue;
                }
                this.dimTable.getColumn(i).getStyleAttributes().setHided(isSelect);
                continue;
            }
            this.dimTable.getColumn(i).getStyleAttributes().setHided(false);
        }
    }

    @Override
    public IBookDimensionParse getBookDimensionParse() {
        return new BookDimensionClientParse();
    }

    @Override
    public String getOrgPermission() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.isLoadTransitBudget) {
            this.btnSearchTransit.setVisible(true);
            this.btnSearchTransit.setEnabled(true);
            this.menuItemSearchTransit.setVisible(true);
            this.menuItemSearchTransit.setEnabled(true);
        } else {
            this.btnSearchTransit.setVisible(false);
            this.btnSearchTransit.setEnabled(false);
            this.menuItemSearchTransit.setVisible(false);
            this.menuItemSearchTransit.setEnabled(false);
        }
    }

    class MemberDataChangeListener
    implements DataChangeListener {
        NewDimensionMemberDialog dialog = null;

        MemberDataChangeListener(NewDimensionMemberDialog dialog) {
            this.dialog = dialog;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            this.dialog.dataChanged(eventObj);
        }
    }

    private final class CellDisplayParser
    implements IUserCellDisplayParser {
        private CellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgExcuteAnalysisUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

