/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.AbstractBgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultCollection;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.IBgFinalizedResult;
import com.kingdee.eas.ma.mbg.client.AbstractBgFinalizedCourseProgressUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.MyMsgBox;
import com.kingdee.eas.ma.mbg.client.utils.BgFormAuditClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgCHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFinalizedCourseProgressUI
extends AbstractBgFinalizedCourseProgressUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgFinalizedCourseProgressUI.class);
    private boolean isClose = false;
    public static final String BILLIDS = "BILLIDS";
    public static final String AUDITPARAMS = "AUDITPARAMS";
    public static final String BGORGVIEWID = "BGORGVIEWID";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.progBar.setStringPainted(true);
        List billIds = (List)this.getUIContext().get(BILLIDS);
        Map auditParams = (Map)this.getUIContext().get(AUDITPARAMS);
        BOSUuid bgOrgViewId = (BOSUuid)this.getUIContext().get(BGORGVIEWID);
        BgFinalizedResultInfo resultInfo = this.getResult();
        Map resultMap = this.startExecuteFinalzeThread(billIds, auditParams, resultInfo);
        this.startShowResultThread(resultInfo, billIds, auditParams, bgOrgViewId, resultMap);
    }

    protected void startShowResultThread(final BgFinalizedResultInfo resultInfo, final List<String> billIds, final Map<String, String> auditParams, final BOSUuid bgOrgViewId, final Map resultMap) {
        Thread result = new Thread(){

            @Override
            public void run() {
                if (UserMonitorClientTool.getRegistryInfo() != null) {
                    UserMonitorClientTool.getRegistryInfo().setFinished(false);
                }
                try {
                    BgFinalizedCourseProgressUI.this.showResult(resultInfo, billIds, auditParams, bgOrgViewId, resultMap);
                }
                finally {
                    if (UserMonitorClientTool.getRegistryInfo() != null) {
                        UserMonitorClientTool.getRegistryInfo().setFinished(true);
                    }
                }
            }
        };
        result.start();
    }

    protected BgFinalizedResultInfo getResult() throws BOSException, EASBizException {
        BgFinalizedResultInfo result = null;
        IBgFinalizedResult iBgFinalizedResult = BgFinalizedResultFactory.getRemoteInstance();
        result = new BgFinalizedResultInfo();
        result.setId(BOSUuid.create((BOSObjectType)result.getBOSType()));
        result.setState(BgFinalizedResultEnum.run);
        result.setResult("\u64cd\u4f5c\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026");
        result.setCurrentIndex(0);
        result.setTotalCount(0);
        iBgFinalizedResult.save(result);
        return result;
    }

    protected Map startExecuteFinalzeThread(final List<String> billIds, final Map<String, String> auditParams, final BgFinalizedResultInfo resultInfo) {
        final HashMap resultMap = new HashMap();
        Thread executor = new Thread(){

            @Override
            public void run() {
                resultMap.putAll(BgFinalizedCourseProgressUI.this.execute(billIds, auditParams, resultInfo));
            }
        };
        executor.start();
        return resultMap;
    }

    protected Map execute(List<String> billIds, Map<String, String> auditParams, BgFinalizedResultInfo resultInfo) {
        Map resultMap = null;
        try {
            resultMap = BgFinalizedFacadeFactory.getRemoteInstance().calcSchemeCourse(billIds, auditParams, resultInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.destroyWindow();
        return resultMap;
    }

    @Override
    protected void btnBackStage_actionPerformed(ActionEvent e) throws Exception {
        super.btnBackStage_actionPerformed(e);
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        this.isClose = true;
        return super.destroyWindow();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuBar.setVisible(false);
        if (this.statusBar != null) {
            this.statusBar.setVisible(false);
        }
    }

    private void showResult(BgFinalizedResultInfo resultInfo, List<String> billIds, Map<String, String> auditParams, BOSUuid bgOrgViewId, Map resultMap) {
        long startTime = System.currentTimeMillis();
        long maxTimeout = 6000000L;
        ObjectUuidPK pk = new ObjectUuidPK(resultInfo.getId());
        boolean isFirst = true;
        while (!this.isClose) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                AbstractBgFinalizedResultInfo r = null;
                BgFinalizedResultCollection col = BgFinalizedResultFactory.getRemoteInstance().getBgFinalizedResultCollection("where id = '" + pk + "'");
                if (col != null && !col.isEmpty()) {
                    r = col.get(0);
                    if (isFirst) {
                        isFirst = false;
                    }
                }
                if (r == null) {
                    if (System.currentTimeMillis() - startTime <= maxTimeout) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)"\u9884\u7b97\u8868\u4e0a\u62a5\u8d85\u65f6");
                    this.destroyWindow();
                    return;
                }
                if (BgFinalizedResultEnum.courseFinish.equals((Object)r.getState())) {
                    this.isClose = true;
                    BgFormAuditClientHelper.showCourseResult((Component)((Object)this), bgOrgViewId, billIds, resultMap, auditParams);
                    if (this.getUIContext().get("Owner") instanceof BgNFormListUI) {
                        BgNFormListUI ui = (BgNFormListUI)((Object)this.getUIContext().get("Owner"));
                        MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)ui);
                    }
                    return;
                }
                if (BgFinalizedResultEnum.exception.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.showException((BgFinalizedResultInfo)r);
                    return;
                }
                if (BgFinalizedResultEnum.courseCalc.equals((Object)r.getState())) {
                    this.progBar.setMaximum(r.getTotalCount());
                    this.progBar.setValue(r.getCurrentIndex());
                    this.lblState.setText(r.getResult());
                    this.progBar.setString(r.getCurrentIndex() + "/" + r.getTotalCount());
                    this.updateUI();
                    continue;
                }
                if (!BgFinalizedResultEnum.course.equals((Object)r.getState())) continue;
                this.progBar.setMaximum(billIds.size());
                this.progBar.setValue(billIds.size());
                this.lblState.setText(r.getResult());
                this.progBar.setString(billIds.size() + "/" + billIds.size());
                this.updateUI();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                if (BgFinalizedCourseProgressUI.isSessionClosedException(e)) {
                    if (MyMsgBox.showSessionError((Component)((Object)this), e) == 99) continue;
                    this.isClose = true;
                    continue;
                }
                this.isClose = true;
                this.handUIExceptionAndAbort(e);
            }
        }
        this.destroyWindow();
    }

    private static boolean isSessionClosedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            int errorCode = Utils.getRPCErrorCode((Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && (errorCode == 1002 || errorCode == 1001) || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private void showException(BgFinalizedResultInfo r) {
        MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u9884\u7b97\u8868\u4e0a\u62a5\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8ba9\u5b9e\u65bd\u6536\u96c6\u65e5\u5fd7\u540e\u53cd\u9988\u5206\u6790\uff01", (String)r.getException(), (int)1);
    }
}

