/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.AbstractBgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedResultCollection;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.IBgFinalizedResult;
import com.kingdee.eas.ma.mbg.client.AbstractBgFinalizedProgressUI;
import com.kingdee.eas.ma.mbg.client.MyMsgBox;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgFinalizedProgressUI
extends AbstractBgFinalizedProgressUI {
    private static final long serialVersionUID = -4533866304501298626L;
    private static final Logger logger = CoreUIObject.getLogger(BgFinalizedProgressUI.class);
    private boolean isClose = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.progBar.setStringPainted(true);
        BgFinalizedInfo bgFinalizedInfo = (BgFinalizedInfo)this.getUIContext().get("InitDataObject");
        BgFinalizedResultInfo resultInfo = this.getResult(bgFinalizedInfo);
        this.startExecuteFinalzeThread(bgFinalizedInfo);
        this.startShowResultThread(resultInfo);
    }

    protected void startShowResultThread(final BgFinalizedResultInfo resultInfo) {
        Thread result = new Thread(){

            @Override
            public void run() {
                if (UserMonitorClientTool.getRegistryInfo() != null) {
                    UserMonitorClientTool.getRegistryInfo().setFinished(false);
                }
                try {
                    BgFinalizedProgressUI.this.showResult(resultInfo);
                }
                finally {
                    if (UserMonitorClientTool.getRegistryInfo() != null) {
                        UserMonitorClientTool.getRegistryInfo().setFinished(true);
                    }
                }
            }
        };
        result.start();
    }

    protected BgFinalizedResultInfo getResult(BgFinalizedInfo bgFinalizedInfo) throws BOSException, EASBizException {
        BgFinalizedResultInfo result = null;
        IBgFinalizedResult iBgFinalizedResult = BgFinalizedResultFactory.getRemoteInstance();
        BgFinalizedResultCollection resultColls = iBgFinalizedResult.getBgFinalizedResultCollection("where operateID = '" + bgFinalizedInfo.getId().toString() + "'");
        if (resultColls != null && !resultColls.isEmpty()) {
            result = resultColls.get(0);
            return result;
        }
        result = new BgFinalizedResultInfo();
        result.setId(BOSUuid.create((BOSObjectType)result.getBOSType()));
        result.setOperateID(bgFinalizedInfo.getId().toString());
        result.setState(BgFinalizedResultEnum.run);
        result.setResult("\u9884\u7b97\u5b9a\u7a3f\u64cd\u4f5c\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026");
        result.setCurrentIndex(0);
        result.setTotalCount(0);
        iBgFinalizedResult.save(result);
        return result;
    }

    protected void startExecuteFinalzeThread(final BgFinalizedInfo info) {
        Thread executor = new Thread(){

            @Override
            public void run() {
                BgFinalizedProgressUI.this.execute(info);
            }
        };
        executor.start();
    }

    protected void execute(BgFinalizedInfo info) {
        try {
            BgFinalizedFacadeFactory.getRemoteInstance().startFinalized(info);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.destroyWindow();
    }

    @Override
    protected void btnBackStage_actionPerformed(ActionEvent e) throws Exception {
        super.btnBackStage_actionPerformed(e);
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        this.isClose = true;
        return super.destroyWindow();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuBar.setVisible(false);
        if (this.statusBar != null) {
            this.statusBar.setVisible(false);
        }
    }

    private void showResult(BgFinalizedResultInfo resultInfo) {
        long startTime = System.currentTimeMillis();
        long maxTimeout = 6000000L;
        ObjectUuidPK pk = new ObjectUuidPK(resultInfo.getId());
        boolean isFirst = true;
        while (!this.isClose) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                AbstractBgFinalizedResultInfo r = null;
                BgFinalizedResultCollection col = BgFinalizedResultFactory.getRemoteInstance().getBgFinalizedResultCollection("where id = '" + pk + "'");
                if (col != null && !col.isEmpty()) {
                    r = col.get(0);
                    if (isFirst) {
                        isFirst = false;
                    }
                }
                if (r == null) {
                    if (System.currentTimeMillis() - startTime <= maxTimeout) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)"\u9884\u7b97\u5b9a\u7a3f\u8d85\u65f6");
                    this.destroyWindow();
                    return;
                }
                if (BgFinalizedResultEnum.success.equals((Object)r.getState())) {
                    this.isClose = true;
                    MsgBox.showInfo((Component)((Object)this), (String)"\u9884\u7b97\u5b9a\u7a3f\u6210\u529f\uff01");
                    return;
                }
                if (BgFinalizedResultEnum.exception.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.showException((BgFinalizedResultInfo)r);
                    return;
                }
                if (!BgFinalizedResultEnum.run.equals((Object)r.getState())) continue;
                this.progBar.setMaximum(r.getTotalCount());
                this.progBar.setValue(r.getCurrentIndex());
                this.lblState.setText(r.getResult());
                this.progBar.setString(r.getCurrentIndex() + "/" + r.getTotalCount());
                this.updateUI();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                if (BgFinalizedProgressUI.isSessionClosedException(e)) {
                    if (MyMsgBox.showSessionError((Component)((Object)this), e) == 99) continue;
                    this.isClose = true;
                    continue;
                }
                this.isClose = true;
                this.handUIExceptionAndAbort(e);
            }
        }
        this.destroyWindow();
    }

    private static boolean isSessionClosedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            int errorCode = Utils.getRPCErrorCode((Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && (errorCode == 1002 || errorCode == 1001) || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private void showException(BgFinalizedResultInfo r) {
        MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u9884\u7b97\u5b9a\u7a3f\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8ba9\u5b9e\u65bd\u6536\u96c6\u65e5\u5fd7\u540e\u53cd\u9988\u5206\u6790\uff01", (String)r.getException(), (int)1);
    }
}

