/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.client.BgFormAuditIdeaEditUI;
import com.kingdee.eas.ma.mbg.client.BgViewFormAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormAdjustProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormAdjustAuditIdeaEditUI
extends BgFormAuditIdeaEditUI {
    private static final long serialVersionUID = -3143043471806637458L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormAdjustAuditIdeaEditUI.class);

    @Override
    public void actionSubmitIdea_actionPerformed(ActionEvent e) throws Exception {
        this.submitAuditIdea();
        if (this.kDRadioButtonNoPass.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("passNotPass"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("pass"));
        }
        this.setCancel(false);
        this.getUIWindow().close();
    }

    private String getMessageStr(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)key);
    }

    @Override
    protected boolean submitAuditIdea() throws Exception {
        String message = this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString();
        BgFormInfo bgFormInfo = null;
        if (this.getComponent() instanceof BgViewFormAdjustProcessUI) {
            bgFormInfo = ((BgViewFormAdjustProcessUI)((Object)this.getComponent())).getEditData();
        } else if (this.getComponent() instanceof MbgViewListFormAdjustProcessUI) {
            bgFormInfo = ((MbgViewListFormAdjustProcessUI)((Object)this.getComponent())).getEditData();
        } else {
            return false;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        BgFormStateEnum bgFormStateEnum = bgFormInfo.getState();
        try {
            if (this.kDRadioButtonPass.isSelected()) {
                Map rs = BgAdjustFacadaFactory.getRemoteInstance().audit(bgFormInfo.getId().toString());
                this.getFacadeInterface().submitAuditIdea(bgFormInfo.getAdjust().getId(), userInfo.getId(), bgFormStateEnum.getValue() == 6 ? BgAuditIdeaEnum.ROLLPASS : BgAuditIdeaEnum.ADJUSTPASS, message);
            } else if (this.kDRadioButtonNoPass.isSelected()) {
                this.getFacadeInterface().submitAuditIdea(bgFormInfo.getAdjust().getId(), userInfo.getId(), bgFormStateEnum.getValue() == 6 ? BgAuditIdeaEnum.ROLLNOPASS : BgAuditIdeaEnum.ADJUSTNOPASS, message);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw ex;
        }
        return false;
    }
}

