/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgFormAuditViewStateUI;
import com.kingdee.eas.ma.mbg.client.BgFormAuditIdeaListUI;
import com.kingdee.eas.ma.mbg.client.BgFormViewStateFilterUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgAuditStateFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgFormWorkFlowInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgFormAuditViewStateUI
extends AbstractBgFormAuditViewStateUI {
    private static final Logger logger = Logger.getLogger(BgFormAuditViewStateUI.class);
    private static final long serialVersionUID = 2961074701565430245L;
    private IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.base", "BgFormListQuery");
    private BgFormViewStateFilterUI defFilterUI = null;
    private FilterParam defFilterParam = null;
    private CommonQueryDialog dialog = null;
    private boolean hasQuery = false;
    private List queryInfo = null;

    protected IPermissionServiceProvider getPermissInterface() throws Exception {
        return PermissionServiceProviderFactory.getRemoteInstance();
    }

    protected IQuerySolutionFacade getSolutionInterface() throws Exception {
        return QuerySolutionFacadeFactory.getRemoteInstance();
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp != null) {
            this.setFilterParam((FilterParam)this.getFilterUI().getFilterObject(cp));
        }
    }

    public void setFilterParam(FilterParam filterParam) {
        if (filterParam == null) {
            filterParam = new BgAuditStateFilterParam();
        }
        this.defFilterParam = filterParam;
        if (this.getFilterParam() instanceof BgAuditStateFilterParam) {
            BgAuditStateFilterParam _filter = (BgAuditStateFilterParam)this.defFilterParam;
            this.hasQuery = false;
            this.prmtBgScheme.setData((Object)_filter.getBgSchemeInfo());
            this.prmtBgPeriod.setData((Object)_filter.getBgPeriodInfo());
            this.prmtCurrency.setData((Object)_filter.getCurrencyInfo());
            this.hasQuery = true;
        }
    }

    public FilterParam getFilterParam() {
        return this.defFilterParam;
    }

    private String getQueryMainName() {
        return BgFormAuditViewStateUI.class.getName();
    }

    @Override
    public void onLoad() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.onLoad();
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.loadScheme();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewIdea.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.menuFile.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuView.setVisible(false);
        this.menuTools.setVisible(false);
        this.menuHelp.setVisible(false);
        this.btnView.setVisible(false);
        this.btnLocate.setVisible(false);
    }

    protected void loadScheme() throws Exception {
        this.hasQuery = true;
        boolean hasDefaultQuery = this.getDefaultFilterParam();
        if (hasDefaultQuery) {
            this.execQuery();
        } else {
            this.dialog = this.getCommonQueryDialog();
            if (this.dialog.show()) {
                this.setFilterParam(this.getFilterUI().getCustomerParams());
                this.execQuery();
            } else {
                SysUtil.abort();
            }
        }
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        QuerySolutionInfo ds = this.getSolutionInterface().getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            this.setFilterParam(cp);
        }
        return this.getFilterParam() != null;
    }

    protected BgFormViewStateFilterUI getFilterUI() {
        if (this.defFilterUI == null) {
            try {
                this.defFilterUI = new BgFormViewStateFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defFilterUI;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        this.dialog.setTitle(this.getFilterUI().getUITitle());
        this.dialog.setWidth(290);
        this.dialog.setHeight(325);
        this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_ID) == null) {
            this.getFilterUI().getUIContext().put(BgBaseConstants.ORGUNIT_ID, this.getOrgUnitId(false));
        } else {
            String orgUnitId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
            this.getFilterUI().getUIContext().put(BgBaseConstants.ORGUNIT_ID, orgUnitId);
            this.getUIContext().remove(BgBaseConstants.ORGUNIT_ID);
        }
        this.getFilterUI().getUIContext().put("PERMISSIONORG", this.getPermissionOrg());
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            if (this.getFilterParam() instanceof BgAuditStateFilterParam) {
                ((BgAuditStateFilterParam)this.getFilterParam()).setBgSchemeInfo((BgSchemeInfo)this.prmtBgScheme.getData());
            }
            this.execQuery();
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
            if (this.getFilterParam() instanceof BgAuditStateFilterParam) {
                ((BgAuditStateFilterParam)this.getFilterParam()).setBgPeriodInfo((BgPeriodInfo)this.prmtBgPeriod.getData());
            }
            this.execQuery();
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
            if (this.getFilterParam() instanceof BgAuditStateFilterParam) {
                ((BgAuditStateFilterParam)this.getFilterParam()).setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getData());
            }
            this.execQuery();
        }
    }

    @Override
    protected void rbCurrOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbCurrOrgUnit.isSelected()) {
            this.execQuery();
        }
    }

    @Override
    protected void rbImmOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbImmOrgUnit.isSelected()) {
            this.execQuery();
        }
    }

    @Override
    protected void rbAllOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbAllOrgUnit.isSelected()) {
            this.execQuery();
        }
    }

    protected boolean verify() {
        if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            this.prmtBgScheme.requestFocus();
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "selectBgScheme"));
            return false;
        }
        if (!(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
            this.prmtBgPeriod.requestFocus();
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "selectBgPeriod"));
            return false;
        }
        if (!(this.prmtCurrency.getData() instanceof CurrencyInfo)) {
            this.prmtCurrency.requestFocus();
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "selectCurrency"));
            return false;
        }
        return true;
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (orgUnitInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0");
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
    }

    protected void execQuery() {
        if (this.hasQuery && this.verify()) {
            this.tblMain.removeRows();
            try {
                this.queryInfo = this.getNFacadeInterface().queryBgFormWorkFlowInfo(this.getQueryParam());
                this.fillData(this.queryInfo);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    protected void fillData(List query) throws Exception {
        if (query == null || query.isEmpty()) {
            return;
        }
        IRow row = null;
        BgFormWorkFlowInfo workFlowInfo = null;
        this.tblMain.setRefresh(false);
        int in = query.size();
        for (int i = 0; i < in; ++i) {
            workFlowInfo = (BgFormWorkFlowInfo)query.get(i);
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)workFlowInfo.getId());
            row.getCell("orgUnit.name").setValue((Object)workFlowInfo.getOrgUnitName());
            row.getCell("bgScheme.name").setValue((Object)workFlowInfo.getBgSchemeName());
            row.getCell("number").setValue((Object)workFlowInfo.getNumber());
            row.getCell("name").setValue((Object)workFlowInfo.getName());
            row.getCell("state").setValue((Object)BgFormStateEnum.getEnum(workFlowInfo.getState()));
            row.getCell("user.name").setValue((Object)workFlowInfo.getUserName());
            row.getCell("audit.state").setValue((Object)workFlowInfo.getTask());
            row.getCell("adjust.id").setValue((Object)workFlowInfo.getAdjustId());
        }
        this.tblMain.setRowCount(query.size());
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    public Map getQueryParam() throws Exception {
        int i;
        int in;
        Object _obj = null;
        Object[] _objs = null;
        String[] ids = null;
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        OrgUnitInfo unitInfo = this.getOrgUnitInfo();
        if (unitInfo == null) {
            return parameter;
        }
        parameter.put("CURR_USER_ID", this.getUserInfo().getId().toString());
        parameter.put("CURR_CTRLORGUNIT_ID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        parameter.put("SEL_ORGUNIT_ID", unitInfo.getId().toString());
        if (this.rbCurrOrgUnit.isSelected()) {
            parameter.put("SEL_ORGUNIT_TYPE", new Integer(1));
        } else if (this.rbImmOrgUnit.isSelected()) {
            parameter.put("SEL_ORGUNIT_TYPE", new Integer(2));
        } else if (this.rbAllOrgUnit.isSelected()) {
            parameter.put("SEL_ORGUNIT_TYPE", new Integer(3));
        } else {
            parameter.put("SEL_ORGUNIT_TYPE", new Integer(-1));
        }
        _obj = this.prmtBgScheme.getData();
        if (_obj instanceof Object[]) {
            _objs = (Object[])_obj;
            ids = new String[_objs.length];
            in = _objs.length;
            for (i = 0; i < in; ++i) {
                if (_objs[i] == null) continue;
                ids[i] = ((BgSchemeInfo)_objs[i]).getId().toString();
            }
        } else if (_obj instanceof BgSchemeInfo) {
            ids = new String[]{((BgSchemeInfo)_obj).getId().toString()};
        }
        parameter.put("SEL_BGSCHEME_IDS", ids);
        _obj = this.prmtBgPeriod.getData();
        if (_obj instanceof BgPeriodInfo[]) {
            _objs = (Object[])_obj;
            ids = new String[_objs.length];
            in = _objs.length;
            for (i = 0; i < in; ++i) {
                if (_objs[i] == null) continue;
                ids[i] = ((BgPeriodInfo)_objs[i]).getId().toString();
            }
        } else if (_obj instanceof BgPeriodInfo) {
            ids = new String[]{((BgPeriodInfo)_obj).getId().toString()};
        }
        parameter.put("SEL_BGPERIOD_IDS", ids);
        _obj = this.prmtCurrency.getData();
        if (_obj instanceof Object[]) {
            _objs = (Object[])_obj;
            ids = new String[_objs.length];
            in = _objs.length;
            for (i = 0; i < in; ++i) {
                if (_objs[i] == null) continue;
                ids[i] = ((CurrencyInfo)_objs[i]).getId().toString();
            }
        } else if (_obj instanceof CurrencyInfo) {
            ids = new String[]{((CurrencyInfo)_obj).getId().toString()};
        }
        parameter.put("SEL_CURRENCY_IDS", ids);
        if (this.getFilterParam() instanceof BgAuditStateFilterParam) {
            parameter.put("QUERY_INFO", ((BgAuditStateFilterParam)this.getFilterParam()).getQueryInfo());
        }
        parameter.put("SHOW_INFO", ((BgAuditStateFilterParam)this.getFilterParam()).getHasShowWorkFlow());
        return parameter;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isFirstDefaultQuery()) {
            if (this.dialog == null) {
                this.dialog = this.getCommonQueryDialog();
            }
            this.loadFilterInfo();
            if (this.dialog.show()) {
                this.setFilterParam(this.getFilterUI().getCustomerParams());
                this.execQuery();
            }
        }
    }

    protected void loadFilterInfo() throws Exception {
        if (this.dialog.getUserPanels().isEmpty()) {
            return;
        }
        KDPanel _panel = this.dialog.getUserPanel(0);
        Method method = null;
        try {
            method = _panel.getClass().getMethod("loadFilterInfo", null);
            if (method != null) {
                method.invoke((Object)_panel, null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionViewIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewIdea_actionPerformed(e);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell cell = this.tblMain.getCell(rowIndex, "adjust.id");
        String selectedKeyValue = null;
        if (cell != null && cell.getValue() != null) {
            selectedKeyValue = cell.getValue().toString();
        }
        if (StringUtils.isEmpty(selectedKeyValue)) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_ID", (Object)selectedKeyValue);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgFormAuditIdeaListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }
}

