/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisFactory;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgFormExcuteAnalysisListUI;
import com.kingdee.eas.ma.mbg.client.BgBatchExcuteAnalysisSetUI;
import com.kingdee.eas.ma.mbg.client.BgExcuteAnalysisSetUI;
import com.kingdee.eas.ma.mbg.client.BgExcuteAnalysisUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgExcuteAnalysisExportUtils;
import com.kingdee.eas.ma.mbg.utils.BgExcuteAnalysisHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgFormExcuteAnalysisListUI
extends AbstractBgFormExcuteAnalysisListUI {
    private static final long serialVersionUID = 5697937641407764021L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormExcuteAnalysisListUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tblMain.getColumn("analysisTime") != null) {
            this.tblMain.getColumn("analysisTime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        }
        if (this.tblMain.getColumn("createTime") != null) {
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        }
        if (this.tblMain.getColumn("lastUpdateTime") != null) {
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        }
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBatchCreateAnalys.setEnabled(true);
        this.kDBatchCreateAnalysis.setEnabled(true);
        this.btnExport.setEnabled(true);
        this.menuItemExportAnalysis.setEnabled(true);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if ((viewInfo = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone()).getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        if (this.prmtBgScheme.getData() == null) {
            viewInfo.getFilter().getFilterItems().clear();
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
            viewInfo.getFilter().setMaskString("#0");
            return super.getQueryExecutor(queryPK, viewInfo);
        }
        BgNFCHelper.replaceFilterItems(viewInfo.getFilter(), new FilterItemInfo("bgScheme.number", (Object)((BgSchemeInfo)this.prmtBgScheme.getData()).getNumber()));
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        SorterItemCollection sortCol = new SorterItemCollection();
        if (!viewInfo.getSorter().isEmpty()) {
            sortCol.addObjectCollection((IObjectCollection)viewInfo.getSorter());
        }
        if (this.rbImmOrgUnit.isSelected()) {
            filter = this.getImmSelectedQueryFilterInfo(viewInfo);
        } else if (this.rbAllOrgUnit.isSelected()) {
            filter = this.getSelectedQueryFilterInfo(viewInfo);
        } else {
            filter = this.getUnSelectedQueryFilterInfo(viewInfo);
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        this.refreshFilter(filter);
        if (!sortCol.isEmpty()) {
            viewInfo.getSorter().clear();
            viewInfo.getSorter().addObjectCollection((IObjectCollection)sortCol);
        } else if (viewInfo.getSorter().isEmpty()) {
            viewInfo.getSorter().add(new SorterItemInfo("orgunit.longNumber"));
        }
        try {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    public String getPermissionNum() {
        return "mbg_bgExcuteAnalyse00_listUI";
    }

    @Override
    protected String getTemplateField() {
        return "bgForm.bgtemplate.id";
    }

    @Override
    protected void tblMain_afterDataFill(KDTDataRequestEvent e) {
        super.tblMain_afterDataFill(e);
        try {
            BgExcuteAnalysisHelper analysisHelper = new BgExcuteAnalysisHelper();
            if (this.schemeHelper != null) {
                analysisHelper.dealScenarioAndMerge(this.tblMain, e, this.schemeHelper);
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        this.afterDataFill(e);
    }

    @Override
    protected void bgSchemeChanged(BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        super.bgSchemeChanged(bgSchemeInfo);
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null) {
            this.initBgPeriodDialog();
            BgSchemeUtils.setDefualtMembers(this.getSchemeHelper(), null, (JComponent)this.prmtBgPeriod, null, false, false);
            if (this.prmtBgPeriod != null && this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
                BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
                bgPeriodDialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
                bgPeriodDialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
                bgPeriodDialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
                bgPeriodDialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
                BgPeriodInfo periodInfo = null;
                Object objPeriod = this.prmtBgPeriod.getData();
                if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                    periodInfo = (BgPeriodInfo)objPeriod;
                    BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                    bgPeriodDialog.setBgPeriods(periodArray);
                } else {
                    bgPeriodDialog.setBgPeriods(null);
                }
            }
            this.refreshTable();
        }
    }

    @Override
    protected void refreshFilter(FilterInfo filter) {
        int i;
        if (filter == null) {
            return;
        }
        Object obj = this.prmtBgScheme.getData();
        if (obj != null) {
            if (obj instanceof BgSchemeInfo) {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
                BgCommHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
            } else if (obj instanceof String) {
                String _name = (String)obj;
                BgCommHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgScheme.number", (Object)_name, CompareType.EQUALS));
            }
        }
        if (this.prmtBgTemplate.getData() != null) {
            Object[] bgTemplats = (Object[])this.prmtBgTemplate.getData();
            HashSet<String> bgTemplateNumberSet = new HashSet<String>();
            for (i = 0; i < bgTemplats.length; ++i) {
                if (!(bgTemplats[i] instanceof BgTemplateInfo)) continue;
                bgTemplateNumberSet.add(((BgTemplateInfo)bgTemplats[i]).getNumber());
            }
            if (bgTemplateNumberSet.size() > 0) {
                BgCommHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgForm.bgTemplate.number", bgTemplateNumberSet, CompareType.INCLUDE));
            }
        }
        if (this.prmtOrgUnit.getData() != null) {
            Object[] bgOrgUnits = (Object[])this.prmtOrgUnit.getData();
            HashSet<String> bgOrgUnitNumbers = new HashSet<String>();
            for (i = 0; i < bgOrgUnits.length; ++i) {
                if (!(bgOrgUnits[i] instanceof BgOrgUnitInfo)) continue;
                bgOrgUnitNumbers.add(((BgOrgUnitInfo)bgOrgUnits[i]).getNumber());
            }
            if (bgOrgUnitNumbers.size() > 0) {
                BgCommHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("orgUnit.number", bgOrgUnitNumbers, CompareType.INCLUDE));
            }
        }
        BgNFCHelper.addBgPeriodFilter4Decompose(this.prmtBgPeriod, filter);
    }

    @Override
    protected void refreshTable() {
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    protected void initBgPeriodDialog() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, true);
        bgPeriodDialog.setAllowSort(false);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
        this.prmtBgPeriod.setHistoryRecordEnabled(false);
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        if (this.prmtBgPeriod != null && this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog && this.prmtBgPeriod.getData() == null) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
            bgPeriodDialog.setBgPeriods(null);
        }
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
            BgPeriodDialog bgPeriodDialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
            BgPeriodInfo periodInfo = null;
            Object objPeriod = this.prmtBgPeriod.getData();
            if (objPeriod != null && objPeriod instanceof BgPeriodInfo) {
                periodInfo = (BgPeriodInfo)objPeriod;
                BgPeriodInfo[] periodArray = new BgPeriodInfo[]{periodInfo};
                bgPeriodDialog.setBgPeriods(periodArray);
            } else if (objPeriod != null && objPeriod instanceof BgPeriodInfo[]) {
                bgPeriodDialog.setBgPeriods((BgPeriodInfo[])objPeriod);
            } else {
                bgPeriodDialog.setBgPeriods(null);
            }
        }
        super.prmtBgPeriod_willShow(e);
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            e.setCanceled(true);
        }
    }

    @Override
    public boolean isOnlyNoLeaf() {
        return false;
    }

    protected int getActiveTempFormType() {
        return this.getTempFormType(BgCommCHelper.getSelectedRowIndex((KDTable)this.tblMain));
    }

    protected int getTempFormType(int rowIndex) {
        return BgNFCHelper.getFormType(this.tblMain, rowIndex, "bgTemplate.FormType");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgFormExcuteAnalysisFactory.getRemoteInstance();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"bgTemplate.formType", "bgPeriod.name", "currency.name", "bgVersion.name", "bgForm.state", "bgDataScenario", "actDataScenario", "analysisUser.name", "analysisTime"};
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)node.getUserObject();
            if (bgOrgUnitInfo.isIsVirtual()) {
                this.btnCreateAnalys.setEnabled(false);
                this.btnBatchCreateAnalys.setEnabled(false);
                this.kDBatchCreateAnalysis.setEnabled(false);
                this.kDCreateAnalysis.setEnabled(false);
            } else {
                this.btnCreateAnalys.setEnabled(true);
                this.btnBatchCreateAnalys.setEnabled(true);
                this.kDBatchCreateAnalysis.setEnabled(true);
                this.kDCreateAnalysis.setEnabled(true);
            }
        }
    }

    @Override
    public void actionCreatAnalys_actionPerformed(ActionEvent e) throws Exception {
        this.checkFilled();
        super.actionCreatAnalys_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getValue();
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getBgOrgUnit().getOrgUnitID().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_IDS, (Object)this.getBgOrgUnit());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)bgSchemeInfo.getId().toString());
        uiContext.put((Object)"isShowVirtualOrg", (Object)Boolean.FALSE);
        uiContext.put((Object)"permissionItem", (Object)this.getCreatePermissionNum());
        uiContext.put((Object)"MainUI", (Object)this);
        uiContext.put((Object)"schemeHelper", (Object)this.schemeHelper);
        uiContext.put((Object)"orgViewId", (Object)this.getSchemeHelper().getBgOrgViewId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getExcuteAnalysisSetUI(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getExcuteAnalysisSetUI() {
        return BgExcuteAnalysisSetUI.class.getName();
    }

    public String getCreatePermissionNum() {
        return "mbg_bgExcuteAnalyse01_create";
    }

    @Override
    public void actionAnalys_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnalys_actionPerformed(e);
        this.checkSelected();
        String analysisID = this.getSelectedKeyValue();
        BgFormExcuteAnalysisInfo analysisInfo = BgFormExcuteAnalysisFactory.getRemoteInstance().getBgFormExcuteAnalysisInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)analysisID)), BgExcuteAnalysisHelper.getSelector());
        BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(analysisInfo.getBgForm().getId()), BgNFSHelper.getSelectors());
        HashSet<String> senarioNum = new HashSet<String>();
        ArrayList listFormula = new ArrayList();
        Object object = BgExcuteAnalysisHelper.initSenarioNum(bgForm, senarioNum, this.schemeHelper, listFormula);
        if (listFormula.size() < 1 && object == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBgAnalyseResource", (String)"noFormula"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_INFO", (Object)bgForm);
        uiContext.put((Object)"BGFORM_IDS", (Object)analysisInfo);
        uiContext.put((Object)"OPEN_STATE", (Object)false);
        uiContext.put((Object)DimensionConstants.SCENARIO_DIM_NAME, null);
        uiContext.put((Object)DimensionConstants.DIMENSION, object);
        uiContext.put((Object)"BGORGVIEW_ID", (Object)this.getSchemeHelper().getBgOrgViewId());
        uiContext.put((Object)"MainUI", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getExcuteAnalysisUI(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected String getExcuteAnalysisUI() {
        return BgExcuteAnalysisUI.class.getName();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionAnalys_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int re;
        this.checkSelected();
        this.checkFilled();
        this.checkOrgUnitDisable();
        int rowBegin = 0;
        int rowEnd = 0;
        int size = 0;
        IRow row = null;
        KDTSelectBlock block = null;
        String bgFormId = null;
        String orgID = null;
        String bgFormNumber = null;
        String _bgFormId = null;
        StringBuffer message = new StringBuffer();
        ArrayList<String> bgFormIds = new ArrayList<String>();
        HashMap<String, String> bgFormOrgMap = new HashMap<String, String>();
        HashMap<String, String> bgFormIdMap = new HashMap<String, String>();
        Set hasNoRemoveItemPerm = null;
        HashSet<String> ctrlSet = new HashSet<String>();
        HashSet<String> orgIdSets = new HashSet<String>();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            size = range.size();
            for (int i = 0; i < size; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    row = this.tblMain.getRow(j);
                    if (row == null) continue;
                    bgFormId = row.getCell("id").getValue().toString();
                    orgID = row.getCell("orgUnit.id").getValue() == null ? this.getOrgUnitId() : row.getCell("orgUnit.id").getValue().toString();
                    bgFormNumber = row.getCell("bgForm.number").getValue() == null ? "" : row.getCell("bgForm.number").getValue().toString();
                    bgFormIds.add(bgFormId);
                    bgFormIdMap.put(bgFormId, bgFormNumber);
                    bgFormOrgMap.put(bgFormId, row.getCell("orgUnit.name").getValue().toString());
                    orgIdSets.add(orgID);
                    orgMap.put(bgFormId, orgID);
                }
            }
        }
        if ((re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.MBgAnalyseResource", "deleteExeAnalysis"))) == 1 || re == 2) {
            return;
        }
        HashMap<String, HashSet<String>> noPerMap = this.checkHasRemovePermission(bgFormIds, orgIdSets, orgMap);
        Set<String> lockSet = MBgCheckHelper.requestMutex(null, bgFormIds, true);
        Iterator it = bgFormIds.iterator();
        while (it.hasNext()) {
            _bgFormId = (String)it.next();
            if (lockSet == null || !lockSet.contains(_bgFormId)) continue;
            it.remove();
            ctrlSet.add(_bgFormId);
        }
        hasNoRemoveItemPerm = noPerMap.get("hasNoRemoveItemPerm");
        if (bgFormIds != null && bgFormIds.size() != 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[bgFormIds.size()];
            for (int i = 0; i < bgFormIds.size(); ++i) {
                pks[i] = new ObjectUuidPK(BOSUuid.read((String)((String)bgFormIds.get(i))));
            }
            BgFormExcuteAnalysisFactory.getRemoteInstance().delete((IObjectPK[])pks);
        }
        this.processDeleteMsg(hasNoRemoveItemPerm, bgFormOrgMap, bgFormIdMap, BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.MBgAnalyseResource", "hasNoRemoveItemPerm"), message);
        this.processDeleteMsg(ctrlSet, bgFormOrgMap, bgFormIdMap, BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.MBgAnalyseResource", "deleteHint"), message);
        if (hasNoRemoveItemPerm != null && !hasNoRemoveItemPerm.isEmpty() || !ctrlSet.isEmpty()) {
            String msgKey = null;
            msgKey = !bgFormIds.isEmpty() ? "bgExcuteAnalyDeletePartialSuccess" : "bgExcuteAnalyDeleteFail";
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBgAnalyseResource", (String)msgKey), (String)message.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBgAnalyseResource", (String)"bgExcuteAnalyDeleteSuccess"));
        }
        if (bgFormIds != null && !bgFormIds.isEmpty()) {
            MBgCheckHelper.releaseMutex(null, bgFormIds);
        }
        this.refreshList();
    }

    protected HashMap<String, HashSet<String>> checkHasRemovePermission(List<String> bgFormIds, HashSet<String> orgIdSet, HashMap<String, String> _orgMap) throws EASBizException, BOSException, Exception {
        HashMap<String, HashSet<String>> noPermissionMap = new HashMap<String, HashSet<String>>();
        if (bgFormIds.isEmpty() || _orgMap.isEmpty()) {
            return noPermissionMap;
        }
        HashSet<String> removeItemPerm = new HashSet<String>();
        ArrayList<String> lst = new ArrayList<String>(orgIdSet);
        IObjectPK[] orgIdpks = new IObjectPK[orgIdSet.size()];
        for (int i = 0; i < lst.size(); ++i) {
            orgIdpks[i] = new ObjectUuidPK(lst.get(i));
        }
        HashSet<String> hasRemovePerm = this.getRemoveFunPermOrgIds(orgIdpks);
        String bgFormId2 = null;
        for (String bgFormId2 : _orgMap.keySet()) {
            if (hasRemovePerm.contains(_orgMap.get(bgFormId2).toString())) continue;
            removeItemPerm.add(bgFormId2);
            bgFormIds.remove(bgFormId2);
        }
        if (!removeItemPerm.isEmpty()) {
            noPermissionMap.put("hasNoRemoveItemPerm", removeItemPerm);
        }
        return noPermissionMap;
    }

    protected HashSet<String> getRemoveFunPermOrgIds(IObjectPK[] orgIdpks) throws EASBizException, BOSException, Exception {
        return (HashSet)this.getPermissionInterface().checkBatchPermission(this.getUserPk(), orgIdpks, this.getRemovePermission());
    }

    private void processDeleteMsg(Set ids, Map bgFormOrgMap, Map bgFormIdMap, String msg, StringBuffer result) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (String bgFormId : ids) {
            if (result.length() > 1) {
                result.append("\r\n");
            }
            result.append(MessageFormat.format(msg, bgFormOrgMap.get(bgFormId), bgFormIdMap.get(bgFormId)));
        }
    }

    public String getRemovePermission() {
        return "mbg_bgExcuteAnalyse03_remove";
    }

    @Override
    public void actionBatchCreatAnalys_actionPerformed(ActionEvent e) throws Exception {
        this.checkFilled();
        super.actionBatchCreatAnalys_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getValue();
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)bgSchemeInfo);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_IDS, (Object)this.getBgOrgUnit());
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)bgSchemeInfo.getId().toString());
        uiContext.put((Object)"isShowVirtualOrg", (Object)Boolean.FALSE);
        uiContext.put((Object)"permissionItem", (Object)this.getCreatePermissionNum());
        uiContext.put((Object)"MainUI", (Object)this);
        uiContext.put((Object)"schemeHelper", (Object)this.schemeHelper);
        uiContext.put((Object)"orgViewId", (Object)this.getSchemeHelper().getBgOrgViewId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getBatchExcuteAnalysisSetUI(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getBatchExcuteAnalysisSetUI() {
        return BgBatchExcuteAnalysisSetUI.class.getName();
    }

    @Override
    public void actionExportAnalysis_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        Map bgFormIdsMap = this.getExportBgFormMap();
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForExp((Object)this);
        BgExcuteAnalysisExportUtils.exportAnalysis((CoreUI)this, bgFormIdsMap, this.getSelectOrgView(), this.getSelectBgScheme(), this.getSchemeHelper(), this.getBgOrgUnit(), fileChooser);
    }

    protected Map getExportBgFormMap() {
        String _bgFormId = null;
        String _number = null;
        String _name = null;
        String _orgUnitId = null;
        String[] _bgFormInfo = null;
        HashMap _orgUnitMap = new HashMap();
        Map<String, String[]> _tmpMap = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                int rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row == null) continue;
                    _bgFormId = row.getCell("id").getValue().toString();
                    _number = row.getCell("bgForm.number").getValue().toString();
                    _name = row.getCell("bgForm.name").getValue().toString();
                    _orgUnitId = row.getCell("orgUnit.id").getValue().toString();
                    if (_orgUnitMap.containsKey(_orgUnitId)) {
                        _tmpMap = (Map)_orgUnitMap.get(_orgUnitId);
                    } else {
                        _tmpMap = new LinkedHashMap();
                        _orgUnitMap.put(_orgUnitId, _tmpMap);
                    }
                    _bgFormInfo = new String[]{_bgFormId, _number, _name};
                    if (_tmpMap == null) continue;
                    _tmpMap.put(_bgFormId, _bgFormInfo);
                }
            }
        }
        return _orgUnitMap;
    }
}

