/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormPropertyExportEnum;
import com.kingdee.eas.ma.mbg.BgFormPropertyExportInfo;
import com.kingdee.eas.ma.mbg.BgIEException;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.AbstractBgFormExportUI;
import com.kingdee.eas.ma.mbg.client.BgExportResultUI;
import com.kingdee.eas.ma.mbg.client.BgFormSelfDefineListUI;
import com.kingdee.eas.ma.mbg.client.common.BookDimensionClientParse;
import com.kingdee.eas.ma.mbg.client.utils.BgFormExportUtils;
import com.kingdee.eas.ma.mbg.client.utils.BgFormPropertyExportDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.IProviderUI;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormExportProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.utils.BgFinalizedUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgFormExportUI
extends AbstractBgFormExportUI
implements IProviderUI {
    private static final long serialVersionUID = 8147605701319048218L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormExportUI.class);
    private boolean isMoveDimension = false;
    private Map bgFormIdsMap = null;
    private DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);
    private String fileFormat = ".xlsx";

    public void setMoveDimension(boolean isMoveDimension) {
        this.isMoveDimension = isMoveDimension;
    }

    public boolean isMoveDimension() {
        return this.isMoveDimension;
    }

    protected static IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbExcel.isSelected();
        this.rbKDF.setEnabled(false);
        this.rbKDF.setVisible(false);
        BgFileUtil bgFileUtil = new BgFileUtil();
        this.txtFilepath.setText(bgFileUtil.getDefualtPathForEXP((Object)this.getUIContext()));
        this.bgFormIdsMap = (Map)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        BgFormPropertyExportInfo bgFormPropertyExportInfo = this.loadBgFormPropertyInfo(bgFileUtil);
        this.prmtProperty.setSelector((KDPromptSelector)new BgFormPropertyExportDialog(this, bgFormPropertyExportInfo));
        this.prmtProperty.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BgFormPropertyExportInfo newInfo = (BgFormPropertyExportInfo)e.getNewValue();
                if (newInfo == null) {
                    BgFormExportUI.this.prmtProperty.setDataNoNotify(e.getOldValue());
                    return;
                }
            }
        });
        this.prmtProperty.setData((Object)bgFormPropertyExportInfo);
    }

    private void storeBgFormPropertyInfo(BgFileUtil bgFileUtil, BgFormPropertyExportInfo bgFormPropertyExportInfo) throws BOSException {
        for (BgFormPropertyExportInfo.Property next : bgFormPropertyExportInfo.getResult()) {
            String value = next.getOrder() + "," + next.isSelected();
            bgFileUtil.storeDefaultValueForSelf((Object)value, (Object)this, next.getP().getName());
        }
    }

    private BgFormPropertyExportInfo loadBgFormPropertyInfo(BgFileUtil bgFileUtil) throws BOSException {
        BgFormPropertyExportInfo bgFormPropertyExportInfo = new BgFormPropertyExportInfo().defaultValue();
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_Organization, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_Scheme, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_Form_Number, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_Form_Name, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_Template, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_BgType, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_SpecialDim, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.Bg_Period, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.BG_Currency, bgFormPropertyExportInfo);
        this.loadBgFormPropertyInfo(bgFileUtil, BgFormPropertyExportEnum.Bg_Version, bgFormPropertyExportInfo);
        return bgFormPropertyExportInfo;
    }

    private void loadBgFormPropertyInfo(BgFileUtil bgFileUtil, BgFormPropertyExportEnum exportEnum, BgFormPropertyExportInfo bgFormPropertyExportInfo) throws BOSException {
        String value = bgFileUtil.getDefualtStringValueForSelf((Object)this, exportEnum.getName());
        if (!StringUtils.isEmpty((String)value) && value.contains(",")) {
            String[] defaultValue = value.split(",");
            int order = Integer.parseInt(defaultValue[0]);
            bgFormPropertyExportInfo.getResult().set(order, new BgFormPropertyExportInfo.Property(exportEnum, order, Boolean.parseBoolean(defaultValue[1])));
        }
    }

    protected void verify() throws Exception {
        BgFormExportUtils.verify(this, this.txtFilepath);
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new BgFileUtil().getFileChooserForExp((Object)this.getUIContext());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFile());
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
            FileFilter fileFilter = fc.getFileFilter();
            if (fileFilter instanceof ExcelFileFilter || fileFilter instanceof ExcelFile) {
                this.fileFormat = ".xls";
            }
            if (fileFilter instanceof Excel2007FileFilter) {
                this.fileFormat = ".xlsx";
            }
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (BOSObjectType)new BgFormInfo().getBOSType(), null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (String)"bgScheme_export");
                List reList = BgFormExportUI.this.exportFile(BgFormExportUI.this.txtFilepath.getText(), BgFormExportUI.this.bgFormIdsMap);
                BgFileUtil bgFileUtil = new BgFileUtil();
                bgFileUtil.storeDefaultPathForEXP((Object)BgFormExportUI.this.txtFilepath, (Object)BgFormExportUI.this.getUIContext());
                BgFormExportUI.this.storeBgFormPropertyInfo(bgFileUtil, (BgFormPropertyExportInfo)BgFormExportUI.this.prmtProperty.getValue());
                LogUtil.afterLog(null, (IObjectPK)pk);
                return reList;
            }

            public void afterExec(Object result) throws Exception {
                UIContext uiContext = new UIContext((Object)BgFormExportUI.this);
                uiContext.put((Object)"EXAMINE_DATA", result);
                uiContext.put((Object)"UI_TITLE", (Object)BgFormExportUI.this.exportTitle());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)BgFormExportUI.this.getModel()).create(BgExportResultUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected String exportTitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"title_export_bgForm");
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re) {
            // empty if block
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List exportFile(String filepath, Map bgFormIdsMap) throws Exception {
        ArrayList _exportInfoList;
        block11: {
            _exportInfoList = new ArrayList();
            HashSet<BOSUuid> _orgPermissionSet = new HashSet<BOSUuid>();
            HashSet<String> _viewPermissionSet = new HashSet<String>();
            FullOrgUnitCollection _fullOrgColl = null;
            String orgUnitId = (String)this.getUIContext().get("ORGUNIT_COST");
            String orgViewId = (String)this.getUIContext().get("BGORGVIEW_ID");
            BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
            UserInfo _userInfo = SysContext.getSysContext().getCurrentUserInfo();
            TreeModel model = null;
            DefaultKingdeeTreeNode root = null;
            FullOrgUnitCollection orgColPer = BgFacadeFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(_userInfo.getId()), OrgType.CostCenter, null, this.getViewPermission());
            try {
                int i;
                if (bgOrgUnitInfo != null && bgOrgUnitInfo.getId() != null) {
                    int i2;
                    model = BgOrgUnitFactory.getRemoteInstance().getFullBgOrgModel(orgViewId, bgOrgUnitInfo.getId().toString(), true, false, true, true, false);
                    root = (DefaultKingdeeTreeNode)model.getRoot();
                    _fullOrgColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(_userInfo.getId()));
                    for (i2 = 0; i2 < _fullOrgColl.size(); ++i2) {
                        _orgPermissionSet.add(_fullOrgColl.get(i2).getId());
                    }
                    for (i2 = 0; i2 < orgColPer.size(); ++i2) {
                        _viewPermissionSet.add(orgColPer.get(i2).getId().toString());
                    }
                    if (root != null && root.getUserObject() instanceof BgOrgUnitInfo) {
                        int rootCount = root.getChildCount();
                        DefaultKingdeeTreeNode _root = null;
                        for (int rc = 0; rc < rootCount; ++rc) {
                            _root = (DefaultKingdeeTreeNode)root.getChildAt(rc);
                            this.exportOrgUnitFile(_viewPermissionSet, _root, _orgPermissionSet, _exportInfoList, filepath, bgFormIdsMap);
                        }
                    }
                    break block11;
                }
                model = BgOrgUnitFactory.getRemoteInstance().getFullOrgModel(orgUnitId, orgViewId);
                root = (DefaultKingdeeTreeNode)model.getRoot();
                _fullOrgColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(_userInfo.getId()));
                for (i = 0; i < _fullOrgColl.size(); ++i) {
                    _orgPermissionSet.add(_fullOrgColl.get(i).getId());
                }
                for (i = 0; i < orgColPer.size(); ++i) {
                    _viewPermissionSet.add(orgColPer.get(i).getId().toString());
                }
                this.exportOrgUnitFile(_viewPermissionSet, root, _orgPermissionSet, _exportInfoList, filepath, bgFormIdsMap);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return _exportInfoList;
    }

    protected String getViewPermission() {
        return "mbg_form05_view";
    }

    protected void exportOrgUnitFile(Set<String> _viewPermissionSet, DefaultKingdeeTreeNode root, Set<BOSUuid> permissionSet, List exportInfoList, String filepath, Map bgFormIdsMap) {
        block5: {
            BgOrgUnitInfo _orgUnitInfo;
            String[] _tmpbgFormInfo;
            String[] _exportInfo;
            String _tmpOrgUnitId;
            block4: {
                if (root == null) {
                    return;
                }
                String _tmpFilepath = null;
                _tmpOrgUnitId = null;
                String _tmpbgFormId = null;
                _exportInfo = null;
                _tmpbgFormInfo = null;
                _orgUnitInfo = (BgOrgUnitInfo)root.getUserObject();
                DefaultKingdeeTreeNode _node = null;
                _tmpOrgUnitId = _orgUnitInfo.getOrgUnitID();
                if (!permissionSet.contains(BOSUuid.read((String)_tmpOrgUnitId))) break block4;
                if (bgFormIdsMap.containsKey(_tmpOrgUnitId)) {
                    this.exportDirectory(filepath, _orgUnitInfo);
                    this.exportExcelFile(_viewPermissionSet, _orgUnitInfo, filepath, bgFormIdsMap, exportInfoList);
                }
                _tmpFilepath = filepath + File.separator + _orgUnitInfo.getName().replaceAll(" ", "");
                int in = root.getChildCount();
                for (int i = 0; i < in; ++i) {
                    _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    this.exportOrgUnitFile(_viewPermissionSet, _node, permissionSet, exportInfoList, _tmpFilepath, bgFormIdsMap);
                }
                break block5;
            }
            if (!bgFormIdsMap.containsKey(_tmpOrgUnitId)) break block5;
            Map _tmpBgFormIdsMap = (Map)bgFormIdsMap.get(_tmpOrgUnitId);
            for (String _tmpbgFormId : _tmpBgFormIdsMap.keySet()) {
                _tmpbgFormInfo = (String[])_tmpBgFormIdsMap.get(_tmpbgFormId);
                _exportInfo = new String[]{_orgUnitInfo.getName(), _tmpbgFormInfo[1] + " - " + _tmpbgFormInfo[2], com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorPermission")};
                exportInfoList.add(_exportInfo);
            }
        }
    }

    protected void exportDirectory(String filepath, BgOrgUnitInfo orgUnitInfo) {
        if (StringUtils.isEmpty((String)filepath) || orgUnitInfo == null) {
            return;
        }
        File _file = new File(filepath + File.separator + orgUnitInfo.getName().replaceAll(" ", ""));
        if (!_file.exists()) {
            _file.mkdirs();
        }
    }

    protected KDSBook exportFixExcelFile(BgFormInfo _bgFormInfo, BgOrgUnitInfo orgUnitInfo) throws Exception {
        return BgFormExportUtils.exportFixExcelFile(null, _bgFormInfo);
    }

    private String getFileName(BgFormInfo _bgFormInfo, BgOrgUnitInfo orgUnitInfo) {
        StringBuilder filename = new StringBuilder();
        BgFormPropertyExportInfo exportInfo = (BgFormPropertyExportInfo)this.prmtProperty.getData();
        for (BgFormPropertyExportInfo.Property next : exportInfo.getResult()) {
            if (!next.isSelected()) continue;
            switch (next.getP().getValue()) {
                case 1: {
                    filename.append(orgUnitInfo.getName().trim());
                    filename.append("_");
                    break;
                }
                case 2: {
                    filename.append(_bgFormInfo.getBgScheme().getName().trim());
                    filename.append("_");
                    break;
                }
                case 3: {
                    filename.append(_bgFormInfo.getNumber().trim());
                    filename.append("_");
                    break;
                }
                case 5: {
                    filename.append(_bgFormInfo.getName().trim());
                    filename.append("_");
                    break;
                }
                case 4: {
                    filename.append(_bgFormInfo.getBgTemplate().getName().trim());
                    filename.append("_");
                    break;
                }
                case 6: {
                    if (_bgFormInfo.getBgTemplate().getBgType() == null) break;
                    filename.append(_bgFormInfo.getBgTemplate().getBgType().getName().trim());
                    filename.append("_");
                    break;
                }
                case 7: {
                    if (_bgFormInfo.getBgTemplate().getFormType().getValue() != 8) break;
                    String str = _bgFormInfo.getBgSpecialItems().get(0).getMemberName().replaceAll(DimensionConstants.TICK_SEPARATOR, "_");
                    filename.append(str.trim());
                    filename.append("_");
                    break;
                }
                case 8: {
                    filename.append(_bgFormInfo.getBgPeriod().getName().trim());
                    filename.append("_");
                    break;
                }
                case 9: {
                    filename.append(_bgFormInfo.getCurrency().getName().trim());
                    filename.append("_");
                    break;
                }
                case 10: {
                    filename.append(_bgFormInfo.getBgVersion().getName().trim());
                    filename.append("_");
                    break;
                }
            }
        }
        if (!BgProcessEnum.C01.equals((Object)_bgFormInfo.getProcessType())) {
            filename.append(_bgFormInfo.getProcessType().getAlias());
            filename.append("_");
        }
        filename = filename.deleteCharAt(filename.length() - 1);
        filename.append(this.fileFormat);
        return filename.toString();
    }

    private LinkedHashMap<String, BgFormInfo> getBgFormMap(Map _tmpBgFormIdsMap) {
        return BgFormExportUtils.getBgFormMap(null, _tmpBgFormIdsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcelFile(Set<String> _viewPermissionSet, BgOrgUnitInfo orgUnitInfo, String filepath, Map bgFormIdsMap, List exportInfoList) {
        if (orgUnitInfo == null || StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String _bgFormId2 = null;
        BgFormInfo _bgFormInfo = null;
        ExportManager em = null;
        KDSBook _kdsBook = null;
        Book _book = null;
        String[] _exportInfo = null;
        if (_viewPermissionSet.contains(orgUnitInfo.getOrgUnitID())) {
            Map _tmpBgFormIdsMap = (Map)bgFormIdsMap.get(orgUnitInfo.getOrgUnitID());
            LinkedHashMap<String, BgFormInfo> bgFormInfoMap = this.getBgFormMap(_tmpBgFormIdsMap);
            if (bgFormInfoMap.isEmpty()) {
                return;
            }
            Iterator<String> ite = bgFormInfoMap.keySet().iterator();
            while (ite.hasNext()) {
                BgFinalizedUtils.setFormFinalized(this.getUIContext(), (IObjectValue)bgFormInfoMap.get(ite.next()));
            }
            long ct = System.currentTimeMillis();
            logger.info((Object)("start new MBGViewListFormExportProcessor : " + ct));
            MBGViewListFormExportProvider viewlistExportProcessor = new MBGViewListFormExportProvider(bgFormInfoMap, (CoreUIObject)this, this.isMoveDimension(), null);
            logger.info((Object)("end new MBGViewListFormExportProcessor : " + (System.currentTimeMillis() - ct) + "ms"));
            MBGFormExportProvider mbgFormExportProvider = new MBGFormExportProvider(bgFormInfoMap, (CoreUIObject)this, this.isMoveDimension(), null);
            for (String _bgFormId2 : bgFormInfoMap.keySet()) {
                try {
                    _bgFormInfo = bgFormInfoMap.get(_bgFormId2);
                    boolean isOver = false;
                    String fileName = this.getFileName(_bgFormInfo, orgUnitInfo);
                    if (fileName.length() > 255) {
                        throw new BgIEException(BgIEException.EXCELLIMITSIZE, new Throwable(BgIEException.EXCELLIMITSIZE.getName()));
                    }
                    String regex = "[\\ / : * ? \u201c < > |,]";
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(fileName);
                    if (matcher.find()) {
                        throw new BgIEException(BgIEException.SPECIALCHARSEQUENCE, new Throwable(BgIEException.SPECIALCHARSEQUENCE.getName()));
                    }
                    if (".xlsx".equals(this.fileFormat)) {
                        String fileStr;
                        SXSSFExportWrapper booksc;
                        block49: {
                            if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                                _book = BgFormExportUtils.exportFixExcelFile2007(null, _bgFormInfo, null);
                            } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                                _book = BgFormExportUtils.exportViewListExcelFile2007(_bgFormInfo, viewlistExportProcessor);
                            } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                                _book = BgFormExportUtils.exportMbgExcelFile2007(_bgFormInfo, mbgFormExportProvider);
                            }
                            BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                            bookDataWrapper.setExportHideCols(true);
                            bookDataWrapper.setExportHideRows(true);
                            if (this.rbDataANDExpression.isSelected()) {
                                bookDataWrapper.setExportFormula(true);
                                bookDataWrapper.setExportCustomerFomulas(true);
                                bookDataWrapper.setShowValue(true);
                            } else if (this.rbDataANDExcelExpression.isSelected()) {
                                bookDataWrapper.setExportFormula(true);
                                bookDataWrapper.setExportCustomerFomulas(false);
                            } else if (this.rbData.isSelected()) {
                                bookDataWrapper.setExportFormula(false);
                                bookDataWrapper.setExportCustomerFomulas(false);
                            }
                            booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                            fileStr = filepath + ("/" + orgUnitInfo.getName() + "/" + this.getFileName(_bgFormInfo, orgUnitInfo)).replaceAll(" ", "");
                            File file = new File(fileStr);
                            if (!file.exists()) break block49;
                            if (file.delete()) {
                                file = new File(fileStr);
                                break block49;
                            }
                            _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                            exportInfoList.add(_exportInfo);
                            continue;
                        }
                        try {
                            booksc.write(fileStr);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    } else {
                        if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                            _kdsBook = this.exportFixExcelFile(_bgFormInfo, orgUnitInfo);
                        } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                            _kdsBook = this.exportViewListExcelFile(_bgFormInfo, orgUnitInfo, viewlistExportProcessor);
                        } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                            _kdsBook = BgFormExportUtils.exportMbgExcelFile(_bgFormInfo, mbgFormExportProvider);
                        }
                        em = new ExportManager();
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                        if (this.rbDataANDExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                        } else if (this.rbData.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                        }
                        long ct1 = System.currentTimeMillis();
                        int Excel2003_MaxColCount = 256;
                        KDSSheet srcSheet = null;
                        if (_kdsBook != null) {
                            for (int i = 0; i < _kdsBook.getSheetCount(); ++i) {
                                srcSheet = _kdsBook.getSheet((Object)i);
                                if (srcSheet.getColumnCount() <= 256) continue;
                                isOver = true;
                                break;
                            }
                        }
                        if (!isOver) {
                            String fileStr = filepath + ("/" + orgUnitInfo.getName() + "/" + this.getFileName(_bgFormInfo, orgUnitInfo)).replaceAll(" ", "");
                            File file = new File(fileStr);
                            if (file.exists()) {
                                if (file.delete()) {
                                    file = new File(fileStr);
                                } else {
                                    _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                    exportInfoList.add(_exportInfo);
                                    continue;
                                }
                            }
                            em.exportToExcel(_kdsBook, fileStr);
                        }
                        logger.info((Object)("end exportToExcel : " + (System.currentTimeMillis() - ct1) + "ms"));
                    }
                    _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), isOver ? com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper") : com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                    exportInfoList.add(_exportInfo);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                    if (ex instanceof BgIEException && BgIEException.SPECIALCHARSEQUENCE.getName().equals(ex.getCause().getMessage())) {
                        if (_bgFormInfo == null) continue;
                        _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"specialCharSequence")};
                        exportInfoList.add(_exportInfo);
                        continue;
                    }
                    if (ex instanceof BgIEException && BgIEException.EXCELLIMITSIZE.getName().equals(ex.getCause().getMessage())) {
                        if (_bgFormInfo == null) continue;
                        _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"excelLimitSize")};
                        exportInfoList.add(_exportInfo);
                        continue;
                    }
                    if (_bgFormInfo == null) continue;
                    _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                    exportInfoList.add(_exportInfo);
                }
                finally {
                    _kdsBook = null;
                }
            }
        } else {
            _exportInfo = new String[]{this.getMessageStr("bgNtemplaetExportOrgs"), orgUnitInfo.getName(), this.getMessageStr("ExportBgNActualRecordOrgNoSheetPer")};
            exportInfoList.add(_exportInfo);
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re && this.bgFormIdsMap != null) {
            this.bgFormIdsMap.clear();
        }
        return re;
    }

    protected KDSBook exportViewListExcelFile(BgFormInfo _bgFormInfo, BgOrgUnitInfo orgUnitInfo, MBGViewListFormExportProvider viewlistExportProcessor) throws Exception {
        return BgFormExportUtils.exportViewListExcelFile(_bgFormInfo, viewlistExportProcessor);
    }

    @Override
    protected void rdExport_actionPerformed(ActionEvent e) throws Exception {
        super.rdExport_actionPerformed(e);
        if (this.rdExport.isSelected()) {
            this.setMoveDimension(true);
        }
    }

    @Override
    protected void rdExportNot_actionPerformed(ActionEvent e) throws Exception {
        super.rdExportNot_actionPerformed(e);
        if (this.rdExportNot.isSelected()) {
            this.setMoveDimension(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("Owner") instanceof BgFormSelfDefineListUI) {
            this.rdExport.setEnabled(false);
            this.rdExportNot.setEnabled(false);
        }
    }

    @Override
    public IBookDimensionParse getBookDimensionParse() {
        return new BookDimensionClientParse();
    }

    @Override
    public String getOrgPermission() {
        return null;
    }
}

