/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.AbstractBgFormMergeExportUI;
import com.kingdee.eas.ma.mbg.client.BgExportResultUI;
import com.kingdee.eas.ma.mbg.client.BgFormSelfDefineListUI;
import com.kingdee.eas.ma.mbg.client.common.BookDimensionClientParse;
import com.kingdee.eas.ma.mbg.client.utils.BgFormExportUtils;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.provider.IProviderUI;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormExportProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.utils.BgFinalizedUtils;
import com.kingdee.eas.ma.mbg.utils.MbgExportThreadProcessor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgFormMergeExportUI
extends AbstractBgFormMergeExportUI
implements IProviderUI {
    private static final long serialVersionUID = 2676935513047792756L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormMergeExportUI.class);
    private static final Object Map = null;
    private String SEP_STR = "_";
    private String EXCEL_NAME = null;
    private int MAX_RANDOM_VALUE = 99999;
    private Map bgFormIdsMap = null;
    private String fileFormat = ".xlsx";
    private boolean isMoveDimension = false;
    private Map<String, String> pageViewNumbers = null;

    public boolean isMoveDimension() {
        return this.isMoveDimension;
    }

    public void setMoveDimension(boolean isMoveDimension) {
        this.isMoveDimension = isMoveDimension;
    }

    protected static IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SysContext.getSysContext().getCurrentCostUnit();
        this.txtFilepath.setText(new BgFileUtil().getDefualtPathForEXP((Object)this.getUIContext(), this.getSelfSuffix()));
        this.bgFormIdsMap = (Map)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.loadRadioAndCheckBoxSelected();
        if (this.getUIContext().get(BgFormExportUtils.isMoveDimension) != null && this.getUIContext().get(BgFormExportUtils.isMoveDimension) instanceof Boolean) {
            this.setMoveDimension((Boolean)this.getUIContext().get(BgFormExportUtils.isMoveDimension));
        }
        if (this.rdExprotPage.isSelected()) {
            this.setMoveDimension(Boolean.TRUE);
        } else {
            this.setMoveDimension(Boolean.FALSE);
        }
        this.pageViewNumbers = (Map)this.getUIContext().get(BgFormExportUtils.pageViewNumbers);
    }

    private void loadRadioAndCheckBoxSelected() throws BOSException {
        BgFileUtil bgFileUtil = new BgFileUtil();
        bgFileUtil.setCacheQuery(true);
        try {
            this.loadRadioDefaultValue(bgFileUtil, this.kDExpGroup);
            this.loadRadioDefaultValue(bgFileUtil, this.groupType);
            this.loadCheckBoxDefaultValue(bgFileUtil, this.kDPanel2);
            this.loadRadioDefaultValue(bgFileUtil, this.kDExportGroup);
            this.loadRadioDefaultValue(bgFileUtil, this.kDButtonGroup1);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            bgFileUtil.clearBatchCache();
        }
    }

    protected void verify() throws Exception {
        BgFormExportUtils.verify(this, this.txtFilepath);
        this.checkPostfix();
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new BgFileUtil().getFileChooserForExp((Object)this.getUIContext(), this.getSelfSuffix());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFile());
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
            FileFilter fileFilter = fc.getFileFilter();
            if (fileFilter instanceof ExcelFileFilter || fileFilter instanceof ExcelFile) {
                this.fileFormat = ".xls";
            }
            if (fileFilter instanceof Excel2007FileFilter) {
                this.fileFormat = ".xlsx";
            }
        }
    }

    protected String getSelfSuffix() {
        return "MERGE";
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgFileUtil bgFileUtil = new BgFileUtil();
                bgFileUtil.setAutoCommit(false);
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (BOSObjectType)new BgFormInfo().getBOSType(), null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (String)BgFormMergeExportUI.this.getExportPermission());
                List reList = BgFormMergeExportUI.this.exportFile(BgFormMergeExportUI.this.txtFilepath.getText(), BgFormMergeExportUI.this.bgFormIdsMap);
                bgFileUtil.storeDefaultPathForEXP((Object)BgFormMergeExportUI.this.txtFilepath, (Object)BgFormMergeExportUI.this.getUIContext(), "MERGE");
                BgFormMergeExportUI.this.storeRadioAndCheckBox(bgFileUtil);
                bgFileUtil.commit();
                LogUtil.afterLog(null, (IObjectPK)pk);
                if (reList != null && !reList.isEmpty()) {
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"EXAMINE_DATA", (Object)reList);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)BgFormMergeExportUI.this.getModel()).create(BgExportResultUI.class.getName(), (Map)uiContext);
                    uiWindow.show();
                }
                return reList;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    private void storeRadioAndCheckBox(BgFileUtil bgFileUtil) throws BOSException {
        if (bgFileUtil == null) {
            bgFileUtil = new BgFileUtil();
        }
        ButtonModel kDExpGroupSelection = this.kDExpGroup.getSelection();
        if (this.kDSplitExp.getModel().equals(kDExpGroupSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.kDSplitExp, this.kDExpGroup);
        } else if (this.kDMergeExp.getModel().equals(kDExpGroupSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.kDMergeExp, this.kDExpGroup);
        }
        ButtonModel groupTypeSelection = this.groupType.getSelection();
        if (this.rbSheetName.getModel().equals(groupTypeSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rbSheetName, this.groupType);
        } else if (this.rbPostfix.getModel().equals(groupTypeSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rbPostfix, this.groupType);
        } else if (this.rdTemplate.getModel().equals(groupTypeSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rdTemplate, this.groupType);
        } else if (this.rdTemplatePlusAfter.getModel().equals(groupTypeSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rdTemplatePlusAfter, this.groupType);
        }
        this.storeCheckBoxDefaultValue(bgFileUtil, this.kDPanel2);
        ButtonModel kDExportGroupSelection = this.kDExportGroup.getSelection();
        if (this.rdExprotPage.getModel().equals(kDExportGroupSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rdExprotPage, this.kDExportGroup);
        } else if (this.rdNotExprotPage.getModel().equals(kDExportGroupSelection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rdNotExprotPage, this.kDExportGroup);
        }
        ButtonModel kDButtonGroup1Selection = this.kDButtonGroup1.getSelection();
        if (this.rbData.getModel().equals(kDButtonGroup1Selection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rbData, this.kDButtonGroup1);
        } else if (this.rbDataANDExcelExpression.getModel().equals(kDButtonGroup1Selection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rbDataANDExcelExpression, this.kDButtonGroup1);
        } else if (this.rbDataANDExpression.getModel().equals(kDButtonGroup1Selection)) {
            this.storeRadioDefaultValue(bgFileUtil, (AbstractButton)this.rbDataANDExpression, this.kDButtonGroup1);
        }
    }

    private void storeRadioDefaultValue(BgFileUtil bgFileUtil, AbstractButton button, KDButtonGroup group) throws BOSException {
        Enumeration elements = group.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)elements.nextElement();
            bgFileUtil.storeDefaultValueForSelf((Object)abstractButton.getName().equals(button.getName()), (Object)this, abstractButton.getName());
        }
    }

    private void loadRadioDefaultValue(BgFileUtil bgFileUtil, KDButtonGroup group) throws BOSException {
        Enumeration elements = group.getElements();
        boolean isSelected = false;
        AbstractButton abstractButton = null;
        while (elements.hasMoreElements()) {
            abstractButton = (AbstractButton)elements.nextElement();
            isSelected = bgFileUtil.getDefualtBooleanValueForSelf((Object)this, abstractButton.getName());
            if (!bgFileUtil.exists((Object)this, abstractButton.getName())) continue;
            abstractButton.setSelected(isSelected);
        }
    }

    private void storeCheckBoxDefaultValue(BgFileUtil bgFileUtil, KDPanel kDPanel) throws BOSException {
        Component[] components = kDPanel.getComponents();
        KDCheckBox checkBox = null;
        for (Component component : components) {
            if (!(component instanceof KDCheckBox)) continue;
            checkBox = (KDCheckBox)component;
            bgFileUtil.storeDefaultValueForSelf((Object)checkBox.isSelected(), (Object)this, checkBox.getName());
        }
    }

    private void loadCheckBoxDefaultValue(BgFileUtil bgFileUtil, KDPanel kDPanel) throws BOSException {
        boolean isSelected = false;
        Component[] components = kDPanel.getComponents();
        KDCheckBox checkBox = null;
        for (Component component : components) {
            if (!(component instanceof KDCheckBox)) continue;
            checkBox = (KDCheckBox)component;
            isSelected = bgFileUtil.getDefualtBooleanValueForSelf((Object)this, checkBox.getName());
            if (!bgFileUtil.exists((Object)this, checkBox.getName())) continue;
            checkBox.setSelected(isSelected);
        }
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re) {
            // empty if block
        }
        return re;
    }

    protected List exportFile(String filepath, Map bgFormIdsMap) throws Exception {
        long st = System.currentTimeMillis();
        logger.error((Object)"************** start exportFile");
        LinkedHashMap<BgFormInfo, Object> exportBookMap = new LinkedHashMap<BgFormInfo, Object>();
        ArrayList exportInfoList = new ArrayList();
        HashSet<String> orgPermissionSet = new HashSet<String>();
        HashMap<String, FullOrgUnitInfo> orgPermissionMap = new HashMap<String, FullOrgUnitInfo>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection fullOrgColl = BgFacadeFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.CostCenter, null, this.getExportPermission());
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgPermissionSet.add(fullOrgColl.get(i).getId().toString());
            orgPermissionMap.put(fullOrgColl.get(i).getId().toString(), fullOrgColl.get(i));
        }
        this.exportOrgUnitFile(orgPermissionMap, exportInfoList, bgFormIdsMap, exportBookMap);
        logger.error((Object)("************** end exportOrgUnitFile: " + (System.currentTimeMillis() - st) + " ms"));
        this.export(filepath, exportBookMap, exportInfoList);
        logger.error((Object)("************** end exportFile: " + (System.currentTimeMillis() - st) + " ms"));
        return exportInfoList;
    }

    protected void exportOrgUnitFile(Map<String, FullOrgUnitInfo> orgPermissionMap, List exportInfoList, Map bgFormIdsMap, Map<BgFormInfo, Object> exportBookMap) throws BOSException {
        int i;
        String _tmpOrgUnitId = null;
        String _tmpbgFormId2 = null;
        String[] _exportInfo = null;
        String[] _tmpbgFormInfo = null;
        FullOrgUnitInfo _orgUnitInfo = null;
        ArrayList<String> orgIdList = new ArrayList<String>();
        HashSet orgIds = new HashSet();
        orgIds.addAll(bgFormIdsMap.keySet());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("number");
        viewInfo.getSelector().add("name");
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longNumber"));
        viewInfo.setSorter(sort);
        FullOrgUnitCollection colls = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(viewInfo);
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        for (i = 0; i < colls.size(); ++i) {
            orgMap.put(colls.get(i).getId().toString(), colls.get(i));
            orgIdList.add(colls.get(i).getId().toString());
        }
        for (i = 0; i < orgIdList.size(); ++i) {
            _tmpOrgUnitId = (String)orgIdList.get(i);
            _orgUnitInfo = (FullOrgUnitInfo)orgMap.get(_tmpOrgUnitId);
            if (orgPermissionMap.keySet().contains(_tmpOrgUnitId)) {
                this.exportExcelFile(orgPermissionMap.keySet(), _orgUnitInfo, bgFormIdsMap, exportInfoList, exportBookMap);
                continue;
            }
            if (!bgFormIdsMap.containsKey(_tmpOrgUnitId)) continue;
            Map _tmpBgFormIdsMap = (Map)bgFormIdsMap.get(_tmpOrgUnitId);
            for (String _tmpbgFormId2 : _tmpBgFormIdsMap.keySet()) {
                _tmpbgFormInfo = (String[])_tmpBgFormIdsMap.get(_tmpbgFormId2);
                _exportInfo = new String[]{_orgUnitInfo.getName(), _tmpbgFormInfo[1] + " - " + _tmpbgFormInfo[2], EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorPermission")};
                exportInfoList.add(_exportInfo);
            }
        }
    }

    protected void export(String filepath, Map exportBookMap, List exportInfoList) throws Exception {
        Object mergerObject = null;
        if (".xlsx".equals(this.fileFormat)) {
            mergerObject = this.mergerBook(exportBookMap, exportInfoList);
            this.export2007(filepath, mergerObject);
        } else if (".xls".equals(this.fileFormat)) {
            mergerObject = this.mergerKDSBook(exportBookMap, exportInfoList);
            this.export2003(filepath, mergerObject);
        }
    }

    private void export2003(String filepath, Object mergerObject) {
        if (mergerObject instanceof KDSBook) {
            this.exportMergeKDSBook(filepath, (KDSBook)mergerObject, null);
        } else if (mergerObject instanceof Map) {
            Map kdsBookMap = (Map)mergerObject;
            for (Object keyName : kdsBookMap.keySet()) {
                this.exportMergeKDSBook(filepath, (KDSBook)kdsBookMap.get(keyName.toString()), (String)keyName);
            }
        }
    }

    private void export2007(String filepath, Object mergerObject) {
        if (mergerObject instanceof Book) {
            this.exportMergeBook(filepath, (Book)mergerObject, null);
        } else if (mergerObject instanceof Map) {
            Map bookMap = (Map)mergerObject;
            for (Object keyName : bookMap.keySet()) {
                this.exportMergeBook(filepath, (Book)bookMap.get(keyName), (String)keyName);
            }
        }
    }

    private boolean isSplitOrgExport() {
        return this.kDSplitExp.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Book sortSheet(Book book) {
        try {
            book.startGroup();
            ArrayList<String> nameLst = new ArrayList<String>();
            HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>();
            Sheet sheet = null;
            for (int i = book.getSheetCount() - 1; i >= 0; --i) {
                sheet = book.getSheet(i);
                nameLst.add(sheet.getSheetName());
                sheetMap.put(sheet.getSheetName(), sheet);
                book.removeSheet(sheet);
            }
            Collections.sort(nameLst);
            for (String name : nameLst) {
                book.addSheet((Sheet)sheetMap.get(name));
            }
        }
        finally {
            book.endGroup();
        }
        return book;
    }

    protected KDSBook sortSheet(KDSBook book) throws Exception {
        ArrayList<String> nameLst = new ArrayList<String>();
        HashMap<String, KDSSheet> sheetMap = new HashMap<String, KDSSheet>();
        KDSSheet sheet = null;
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            sheet = book.getSheet((Object)i);
            nameLst.add(sheet.getName());
            sheetMap.put(sheet.getName(), sheet);
            book.remove((Object)i);
        }
        Collections.sort(nameLst);
        for (String name : nameLst) {
            book.addSheet(null, (KDSSheet)sheetMap.get(name));
        }
        return book;
    }

    protected Object mergerKDSBook(Map<BgFormInfo, Object> exportBookMap, List exportInfoList) throws Exception {
        if (exportBookMap == null || exportBookMap.isEmpty()) {
            return null;
        }
        Map<String, BgOrgUnitInfo> bgOrgUnitMap = this.getBgOrgUnits(exportBookMap);
        if (this.isSplitOrgExport()) {
            return this.processMergeKDSBookWithOrg(exportBookMap, bgOrgUnitMap);
        }
        return this.processMergeKDSBook(exportBookMap, bgOrgUnitMap);
    }

    private Map processMergeKDSBookWithOrg(Map<BgFormInfo, Object> exportBookMap, Map<String, BgOrgUnitInfo> bgOrgUnitMap) throws Exception {
        LinkedHashMap<String, KDSBook> mergeBookMap = new LinkedHashMap<String, KDSBook>();
        LinkedHashMap orgExportBookMap = new LinkedHashMap();
        String keyName2 = null;
        Map formBookMap = null;
        for (BgFormInfo bgFormInfo : exportBookMap.keySet()) {
            keyName2 = this.getKeyName(bgFormInfo);
            if (!orgExportBookMap.containsKey(keyName2)) {
                orgExportBookMap.put(keyName2, new LinkedHashMap());
            }
            ((LinkedHashMap)orgExportBookMap.get(keyName2)).put(bgFormInfo, exportBookMap.get(bgFormInfo));
        }
        for (String keyName2 : orgExportBookMap.keySet()) {
            KDSBook mergeBook;
            if (keyName2 == null || (mergeBook = this.processMergeKDSBook(formBookMap = (Map)orgExportBookMap.get(keyName2), bgOrgUnitMap)) == null) continue;
            mergeBookMap.put(keyName2, mergeBook);
        }
        return mergeBookMap;
    }

    private KDSBook processMergeKDSBook(Map<BgFormInfo, Object> exportBookMap, Map<String, BgOrgUnitInfo> bgOrgUnitMap) throws Exception {
        ArrayList<String> sheetNames = new ArrayList<String>();
        BgFormInfo bgFormInfo2 = null;
        BgFormInfo orderBgFormInfo2 = null;
        KDSBook kdsBook = null;
        KDSSheet kdsSheet = null;
        KDSBook mergeBook = new KDSBook(this.getExcelName());
        TreeMap orderMap = new TreeMap();
        for (BgFormInfo bgFormInfo2 : exportBookMap.keySet()) {
            HashMap<BgFormInfo, Object> newMap = new HashMap<BgFormInfo, Object>();
            newMap.put(bgFormInfo2, exportBookMap.get(bgFormInfo2));
            orderMap.put(bgFormInfo2.getOrgUnit().getNumber() + "_" + bgFormInfo2.getNumber(), newMap);
        }
        for (String number : orderMap.keySet()) {
            HashMap newMap = (HashMap)orderMap.get(number);
            for (BgFormInfo orderBgFormInfo2 : newMap.keySet()) {
                if (!(newMap.get(orderBgFormInfo2) instanceof KDSBook)) continue;
                kdsBook = (KDSBook)newMap.get(orderBgFormInfo2);
                for (int i = 0; i < kdsBook.getSheetCount(); ++i) {
                    kdsSheet = kdsBook.getSheet((Object)i);
                    kdsSheet.rename(this.getKDSSheetName(orderBgFormInfo2, mergeBook, kdsSheet, sheetNames, bgOrgUnitMap));
                    mergeBook.addSheet(null, kdsSheet);
                }
            }
        }
        return mergeBook;
    }

    protected Map<String, BgOrgUnitInfo> getBgOrgUnits(Map<BgFormInfo, Object> exportBookMap) throws BOSException {
        HashMap<String, BgOrgUnitInfo> map = new HashMap<String, BgOrgUnitInfo>();
        if (exportBookMap == null || exportBookMap.isEmpty()) {
            return map;
        }
        String orgViewId = (String)this.getUIContext().get("BGORGVIEW_ID");
        HashSet<String> orgUnitIds = new HashSet<String>();
        Iterator<BgFormInfo> ite = exportBookMap.keySet().iterator();
        while (ite.hasNext()) {
            orgUnitIds.add(ite.next().getOrgUnit().getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", orgUnitIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)orgViewId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)false));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("simpleName");
        BgOrgUnitCollection orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        if (orgCol != null && !orgCol.isEmpty()) {
            for (int i = 0; i < orgCol.size(); ++i) {
                map.put(orgCol.get(i).getNumber(), orgCol.get(i));
            }
        }
        return map;
    }

    protected String getKDSSheetName(BgFormInfo bgFormInfo, KDSBook kdsBook, KDSSheet kdsSheet, List<String> sheetNames, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        String sheetName = this.getSheetName(bgFormInfo, kdsSheet, bgOrgUnitMap);
        if (sheetName.length() > 31) {
            sheetName = BgFormExportUtils.getNewSheetName(kdsBook, sheetName.substring(0, 31), true);
        }
        if (sheetNames.contains(sheetName)) {
            sheetName = BgFormExportUtils.getNewSheetName(kdsBook, sheetName, true);
        }
        sheetNames.add(sheetName);
        return sheetName;
    }

    private String getSheetName(BgFormInfo bgFormInfo, Object sheet, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        String sheetName = null;
        if (this.rbSheetName.isSelected() || this.rbPostfix.isSelected()) {
            if (sheet instanceof KDSSheet) {
                sheetName = ((KDSSheet)sheet).getName().trim();
            } else if (sheet instanceof Sheet) {
                sheetName = ((Sheet)sheet).getSheetName().trim();
            }
        } else if ((this.rdTemplatePlusAfter.isSelected() || this.rdTemplate.isSelected()) && bgFormInfo != null && bgFormInfo.getBgTemplate() != null && !StringUtils.isEmpty((String)bgFormInfo.getBgTemplate().getName())) {
            sheetName = bgFormInfo.getBgTemplate().getName();
        }
        String postfix = this.getPostfix((OrgUnitInfo)bgFormInfo.getBizOrgUnit(), bgFormInfo, bgOrgUnitMap);
        if (!StringUtils.isEmpty((String)postfix)) {
            if (this.rbPostfix.isSelected()) {
                sheetName = sheetName + this.SEP_STR + postfix;
            } else if (this.rdTemplatePlusAfter.isSelected() && bgFormInfo != null && bgFormInfo.getBgTemplate() != null && !StringUtils.isEmpty((String)bgFormInfo.getBgTemplate().getName())) {
                sheetName = bgFormInfo.getBgTemplate().getName() + this.SEP_STR + postfix;
            }
        }
        return sheetName;
    }

    protected void exportMergeKDSBook(String filepath, KDSBook kdsBook, String keyName) {
        if (kdsBook == null) {
            return;
        }
        int Excel2003_MaxColCount = 256;
        boolean isOver = false;
        KDSSheet srcSheet = null;
        for (int i = 0; i < kdsBook.getSheetCount(); ++i) {
            srcSheet = kdsBook.getSheet((Object)i);
            if (srcSheet.getColumnCount() <= 256) continue;
            isOver = true;
            break;
        }
        if (isOver) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper"));
            return;
        }
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        if (this.rbDataANDExpression.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
        } else if (this.rbDataANDExcelExpression.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        } else if (this.rbData.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        }
        long ct1 = System.currentTimeMillis();
        String excelName = null;
        excelName = this.isSplitOrgExport() ? this.getExcelName(keyName) : this.getExcelName();
        em.exportToExcel(kdsBook, filepath + "//" + excelName + ".xls");
        logger.info((Object)("end exportToExcel : " + (System.currentTimeMillis() - ct1) + "ms"));
    }

    protected Object mergerBook(Map<BgFormInfo, Object> exportBookMap, List exportInfoList) throws Exception {
        if (exportBookMap == null || exportBookMap.isEmpty()) {
            return null;
        }
        Map<String, BgOrgUnitInfo> bgOrgUnitMap = this.getBgOrgUnits(exportBookMap);
        if (this.isSplitOrgExport()) {
            return this.processMergeBookWithOrg(exportBookMap, bgOrgUnitMap);
        }
        return this.processMergeBook(exportBookMap, bgOrgUnitMap);
    }

    private Map<String, Book> processMergeBookWithOrg(Map<BgFormInfo, Object> exportBookMap, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        LinkedHashMap<String, Book> mergeBookMap = new LinkedHashMap<String, Book>();
        LinkedHashMap orgExportBookMap = new LinkedHashMap();
        String keyName2 = null;
        Map formBookMap = null;
        for (BgFormInfo bgFormInfo : exportBookMap.keySet()) {
            keyName2 = this.getKeyName(bgFormInfo);
            if (!orgExportBookMap.containsKey(keyName2)) {
                orgExportBookMap.put(keyName2, new LinkedHashMap());
            }
            ((LinkedHashMap)orgExportBookMap.get(keyName2)).put(bgFormInfo, exportBookMap.get(bgFormInfo));
        }
        for (String keyName2 : orgExportBookMap.keySet()) {
            Book mergeBook;
            if (keyName2 == null || (mergeBook = this.processMergeBook(formBookMap = (Map)orgExportBookMap.get(keyName2), bgOrgUnitMap)) == null) continue;
            mergeBookMap.put(keyName2, mergeBook);
        }
        return mergeBookMap;
    }

    private String getKeyName(BgFormInfo bgFormInfo) {
        return bgFormInfo.getOrgUnit().getNumber() + "(" + bgFormInfo.getOrgUnit().getName() + ")";
    }

    private Book processMergeBook(Map<BgFormInfo, Object> exportBookMap, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        Book mergeBook = null;
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (BgFormInfo bgFormInfo : exportBookMap.keySet()) {
            String newName;
            Sheet _sheet;
            int i;
            if (!(exportBookMap.get(bgFormInfo) instanceof Book)) continue;
            Book _book = (Book)exportBookMap.get(bgFormInfo);
            if (mergeBook == null) {
                mergeBook = _book;
                for (i = 0; i < _book.getSheetCount(); ++i) {
                    _sheet = mergeBook.getSheet(i);
                    newName = this.getSheetName(bgFormInfo, mergeBook, _sheet, sheetNames, bgOrgUnitMap);
                    _sheet.setName(newName);
                }
                continue;
            }
            for (i = 0; i < _book.getSheetCount(); ++i) {
                _sheet = _book.getSheet(i);
                newName = this.getSheetName(bgFormInfo, mergeBook, _sheet, sheetNames, bgOrgUnitMap);
                _sheet.setName(newName);
                mergeBook.addSheet(_sheet);
            }
        }
        return mergeBook;
    }

    protected String getSheetName(BgFormInfo bgFormInfo, Book book, Sheet sheet, List<String> sheetNames, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        String sheetName = this.getSheetName(bgFormInfo, sheet, bgOrgUnitMap);
        if (sheetName.length() > 31) {
            sheetName = BgFormExportUtils.getNewSheetName(book, sheetName.substring(0, 31), true);
        }
        if (sheetNames.contains(sheetName)) {
            sheetName = BgFormExportUtils.getNewSheetName(book, sheetName, true);
        }
        sheetNames.add(sheetName);
        return sheetName;
    }

    protected void exportMergeBook(String filepath, Book book, String keyName) {
        if (book == null) {
            return;
        }
        long st = System.currentTimeMillis();
        logger.error((Object)("************** start exportOrgUnitFile: " + (System.currentTimeMillis() - st) + " ms"));
        BookDataWrapper bookDataWrapper = new BookDataWrapper(book);
        logger.error((Object)("************** end new BookDataWrapper: " + (System.currentTimeMillis() - st) + " ms"));
        if (this.rbDataANDExpression.isSelected()) {
            bookDataWrapper.setExportFormula(true);
            bookDataWrapper.setExportCustomerFomulas(true);
            bookDataWrapper.setShowValue(true);
        } else if (this.rbDataANDExcelExpression.isSelected()) {
            bookDataWrapper.setExportFormula(true);
            bookDataWrapper.setExportCustomerFomulas(false);
        } else if (this.rbData.isSelected()) {
            bookDataWrapper.setExportFormula(false);
            bookDataWrapper.setExportCustomerFomulas(false);
        }
        bookDataWrapper.setExportHideCols(true);
        bookDataWrapper.setExportHideRows(true);
        String excelName = null;
        excelName = this.isSplitOrgExport() ? this.getExcelName(keyName) : this.getExcelName();
        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
        logger.error((Object)("************** end new SXSSFExportWrapper: " + (System.currentTimeMillis() - st) + " ms"));
        try {
            booksc.write(filepath + "//" + excelName + ".xlsx");
        }
        catch (Exception e) {
            logger.error((Object)"exportMergeBook error", (Throwable)e);
        }
        logger.info((Object)("end booksc.write : " + (System.currentTimeMillis() - st) + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcelFile(Set<String> _viewPermissionSet, FullOrgUnitInfo orgUnitInfo, Map bgFormIdsMap, List exportInfoList, Map<BgFormInfo, Object> exportBookMap) {
        if (orgUnitInfo == null) {
            return;
        }
        String _bgFormId2 = null;
        BgFormInfo _bgFormInfo = null;
        KDSBook _kdsBook = null;
        Book _book = null;
        String[] _exportInfo = null;
        Map _tmpBgFormIdsMap = (Map)bgFormIdsMap.get(orgUnitInfo.getId().toString());
        LinkedHashMap<String, BgFormInfo> bgFormInfoMap = this.getBgFormMap(_tmpBgFormIdsMap);
        if (bgFormInfoMap.isEmpty()) {
            return;
        }
        long ct = System.currentTimeMillis();
        logger.info((Object)("start new MBGViewListFormExportProcessor : " + ct));
        MbgExportThreadProcessor threadProcessor = new MbgExportThreadProcessor();
        threadProcessor.start(bgFormInfoMap, (CoreUIObject)this, this.isMoveDimension, _tmpBgFormIdsMap);
        logger.info((Object)("end new MBGViewListFormExportProcessor : " + (System.currentTimeMillis() - ct) + "ms"));
        MBGFormExportProvider mbgFormExportProvider = new MBGFormExportProvider(bgFormInfoMap, (CoreUIObject)this, this.isMoveDimension(), this.pageViewNumbers);
        for (String _bgFormId2 : bgFormInfoMap.keySet()) {
            try {
                _bgFormInfo = bgFormInfoMap.get(_bgFormId2);
                BgFinalizedUtils.setFormFinalized(this.getUIContext(), (IObjectValue)_bgFormInfo);
                long st = System.currentTimeMillis();
                MBgTemplateHelper.startLog("******************* UI LOGGER start export:" + _bgFormId2 + "   " + _bgFormInfo.getName());
                boolean isOver = false;
                if (".xlsx".equals(this.fileFormat)) {
                    if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                        _book = BgFormExportUtils.exportFixExcelFile2007(null, _bgFormInfo, null);
                        MBgTemplateHelper.logTime("******************* UI LOGGER end exportFixExcelFile 2007(ms):" + _bgFormId2 + "   " + _bgFormInfo + "    " + (System.currentTimeMillis() - st));
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                        _book = BgFormExportUtils.exportViewListExcelFile2007(_bgFormInfo, threadProcessor);
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                        _book = BgFormExportUtils.exportMbgExcelFile2007(_bgFormInfo, mbgFormExportProvider);
                    }
                    exportBookMap.put(_bgFormInfo, _book);
                } else {
                    if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                        _kdsBook = this.exportFixExcelFile(_bgFormInfo);
                        MBgTemplateHelper.logTime("******************* UI LOGGER end exportFixExcelFile 2003(ms):" + _bgFormId2 + "   " + _bgFormInfo + "    " + (System.currentTimeMillis() - st));
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                        _kdsBook = this.exportViewListExcelFile(_bgFormInfo, threadProcessor);
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                        _kdsBook = BgFormExportUtils.exportMbgExcelFile(_bgFormInfo, mbgFormExportProvider);
                    }
                    int Excel2003_MaxColCount = 256;
                    KDSSheet srcSheet = null;
                    if (_kdsBook != null) {
                        for (int i = 0; i < _kdsBook.getSheetCount(); ++i) {
                            srcSheet = _kdsBook.getSheet((Object)i);
                            if (srcSheet.getColumnCount() <= 256) continue;
                            isOver = true;
                            break;
                        }
                        exportBookMap.put(_bgFormInfo, _kdsBook);
                    }
                }
                _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), isOver ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper") : EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                exportInfoList.add(_exportInfo);
                MBgTemplateHelper.logTime("******************* UI LOGGER end export(ms):" + _bgFormId2 + "   " + _bgFormInfo + "    " + (System.currentTimeMillis() - st));
            }
            catch (Exception ex) {
                logger.error((Object)"****exportExcelFile error :", (Throwable)ex);
                if (_bgFormInfo == null) continue;
                _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                exportInfoList.add(_exportInfo);
            }
            finally {
                _kdsBook = null;
                _book = null;
            }
        }
    }

    protected KDSBook exportFixExcelFile(BgFormInfo _bgFormInfo) throws Exception {
        return BgFormExportUtils.exportFixExcelFile(null, _bgFormInfo);
    }

    protected KDSBook exportViewListExcelFile(BgFormInfo _bgFormInfo, MBGViewListFormExportProvider viewlistExportProcessor) throws Exception {
        return BgFormExportUtils.exportViewListExcelFile(_bgFormInfo, viewlistExportProcessor);
    }

    protected KDSBook exportViewListExcelFile(BgFormInfo _bgFormInfo, MbgExportThreadProcessor threadProcessor) throws Exception {
        return BgFormExportUtils.exportViewListExcelFile(_bgFormInfo, threadProcessor);
    }

    private LinkedHashMap<String, BgFormInfo> getBgFormMap(Map _tmpBgFormIdsMap) {
        return BgFormExportUtils.getBgFormMap(null, _tmpBgFormIdsMap);
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re && this.bgFormIdsMap != null) {
            this.bgFormIdsMap.clear();
        }
        return re;
    }

    protected String getViewPermission() {
        return "mbg_form05_view";
    }

    protected String getExportPermission() {
        if (this.getUIContext().containsKey(BgFormExportUtils.exportPermission)) {
            return String.valueOf(this.getUIContext().get(BgFormExportUtils.exportPermission));
        }
        return "mbg_form36_export";
    }

    @Override
    protected void rbSheetName_itemStateChanged(ItemEvent e) throws Exception {
        if (this.rbSheetName.isSelected()) {
            this.enablePostfix(false);
        }
    }

    @Override
    protected void rbPostfix_itemStateChanged(ItemEvent e) throws Exception {
        if (this.rbPostfix.isSelected()) {
            this.enablePostfix(true);
        }
    }

    @Override
    protected void rbPostfix_actionPerformed(ActionEvent e) throws Exception {
        super.rbPostfix_actionPerformed(e);
        if (this.rbPostfix.isSelected()) {
            this.kDOrgSimpleName.setSelected(true);
        }
    }

    @Override
    protected void rdTemplate_itemStateChanged(ItemEvent e) throws Exception {
        if (this.rdTemplate.isSelected()) {
            this.enablePostfix(false);
        }
    }

    @Override
    protected void rdTemplatePlusAfter_itemStateChanged(ItemEvent e) throws Exception {
        if (this.rdTemplatePlusAfter.isSelected()) {
            this.enablePostfix(true);
        }
    }

    @Override
    protected void rdTemplatePlusAfter_actionPerformed(ActionEvent e) throws Exception {
        super.rdTemplatePlusAfter_actionPerformed(e);
        if (this.rdTemplatePlusAfter.isSelected()) {
            this.kDOrgSimpleName.setSelected(true);
        }
    }

    protected void enablePostfix(boolean isEnable) {
        this.kDOrgSimpleName.setEnabled(isEnable);
        this.kDOrgName.setEnabled(isEnable);
        this.kDOrgNumber.setEnabled(isEnable);
        this.kDFormNumber.setEnabled(isEnable);
        if (!isEnable) {
            this.kDOrgSimpleName.setSelected(false);
            this.kDOrgName.setSelected(false);
            this.kDOrgNumber.setSelected(false);
            this.kDFormNumber.setSelected(false);
        }
    }

    protected String getPostfix(OrgUnitInfo orgUnitInfo, BgFormInfo bgFormInfo, Map<String, BgOrgUnitInfo> bgOrgUnitMap) {
        BgOrgUnitInfo bgOrgUnitInfo = null;
        if (bgOrgUnitMap.containsKey(orgUnitInfo.getNumber())) {
            bgOrgUnitInfo = bgOrgUnitMap.get(orgUnitInfo.getNumber());
        }
        String postfix = "";
        if (this.rbPostfix.isSelected() || this.rdTemplatePlusAfter.isSelected()) {
            if (this.kDOrgSimpleName.isSelected()) {
                if (bgOrgUnitInfo != null && !StringUtils.isEmpty((String)bgOrgUnitInfo.getSimpleName())) {
                    postfix = postfix + bgOrgUnitInfo.getSimpleName();
                } else if (bgOrgUnitInfo != null && StringUtils.isEmpty((String)bgOrgUnitInfo.getSimpleName())) {
                    postfix = postfix + bgOrgUnitInfo.getName();
                } else if (bgOrgUnitInfo == null) {
                    postfix = postfix + orgUnitInfo.getName();
                }
            }
            if (this.kDOrgName.isSelected()) {
                postfix = StringUtils.isEmpty((String)postfix) ? postfix + (bgOrgUnitInfo != null ? bgOrgUnitInfo.getName() : orgUnitInfo.getName()) : postfix + this.SEP_STR + (bgOrgUnitInfo != null ? bgOrgUnitInfo.getName() : orgUnitInfo.getName());
            }
            if (this.kDOrgNumber.isSelected()) {
                postfix = StringUtils.isEmpty((String)postfix) ? postfix + (bgOrgUnitInfo != null ? bgOrgUnitInfo.getNumber() : orgUnitInfo.getNumber()) : postfix + this.SEP_STR + (bgOrgUnitInfo != null ? bgOrgUnitInfo.getNumber() : orgUnitInfo.getNumber());
            }
            if (this.kDFormNumber.isSelected()) {
                postfix = StringUtils.isEmpty((String)postfix) ? postfix + bgFormInfo.getNumber() : postfix + this.SEP_STR + bgFormInfo.getNumber();
            }
            if (StringUtils.isEmpty((String)postfix) && this.kDOrgSimpleName.isSelected()) {
                postfix = postfix + (bgOrgUnitInfo != null ? bgOrgUnitInfo.getName() : orgUnitInfo.getName());
            }
        }
        return postfix.trim();
    }

    protected void checkPostfix() {
        if (this.rbPostfix.isSelected() || this.rdTemplatePlusAfter.isSelected()) {
            boolean hasPostfix = true;
            if (!(this.kDOrgSimpleName.isSelected() || this.kDOrgName.isSelected() || this.kDOrgNumber.isSelected() || this.kDFormNumber.isSelected())) {
                hasPostfix = false;
            }
            if (!hasPostfix) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("needPostfix"));
                SysUtil.abort();
            }
        }
    }

    protected String getExcelName() {
        if (StringUtils.isEmpty((String)this.EXCEL_NAME)) {
            this.EXCEL_NAME = this.getMessageStr("mergeExportExcelName") + this.SEP_STR + this.getDateNumber() + this.SEP_STR + this.getRandomNumber();
        }
        return this.EXCEL_NAME;
    }

    protected String getExcelName(String prefix) {
        return prefix + "_" + this.getExcelName();
    }

    protected String getRandomNumber() {
        DecimalFormat df = new DecimalFormat("######");
        SecureRandom random = new SecureRandom();
        return df.format(random.nextInt(this.MAX_RANDOM_VALUE));
    }

    protected String getDateNumber() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return String.valueOf(calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5));
    }

    @Override
    protected void rdExprotPage_actionPerformed(ActionEvent e) throws Exception {
        super.rdExprotPage_actionPerformed(e);
        if (this.rdExprotPage.isSelected()) {
            this.setMoveDimension(true);
        }
    }

    @Override
    protected void rdNotExprotPage_actionPerformed(ActionEvent e) throws Exception {
        super.rdNotExprotPage_actionPerformed(e);
        if (this.rdNotExprotPage.isSelected()) {
            this.setMoveDimension(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("Owner") instanceof BgFormSelfDefineListUI) {
            this.rdExprotPage.setEnabled(false);
            this.rdNotExprotPage.setEnabled(false);
        }
    }

    @Override
    public IBookDimensionParse getBookDimensionParse() {
        return new BookDimensionClientParse();
    }

    @Override
    public String getOrgPermission() {
        return null;
    }
}

