/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgFormPropertyExportEnum;
import com.kingdee.eas.ma.mbg.BgFormPropertyExportInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgFormPropertyF7UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgFormPropertyF7UI
extends AbstractBgFormPropertyF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormPropertyF7UI.class);
    private boolean isCancel = true;
    public static final String BGFORMPROPERTYEXPORTINFO = "BGFORMPROPERTYEXPORTINFO";
    private static final String SELECT = "select";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NUMBER = "propertyNumber";
    private BgFormPropertyExportInfo data;

    public void setCancel(boolean cancel) {
        this.isCancel = cancel;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void reShow() throws Exception {
        this.isCancel = true;
        this.onShow();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void init() {
        this.kDTable1.checkParsed();
        this.kDTable1.getColumn(PROPERTY).getStyleAttributes().setLocked(true);
        Object _oldData = this.getUIContext().get(BGFORMPROPERTYEXPORTINFO);
        if (_oldData != null) {
            this.data = (BgFormPropertyExportInfo)_oldData;
            this.fillTable(this.data);
        }
    }

    private void fillTable(BgFormPropertyExportInfo oldData) {
        this.kDTable1.removeRows();
        for (BgFormPropertyExportInfo.Property next : oldData.getResult()) {
            IRow row = this.kDTable1.addRow();
            row.getCell(SELECT).setValue((Object)next.isSelected());
            row.getCell(PROPERTY).setValue((Object)next.getP().getAlias());
            row.getCell(PROPERTY_NUMBER).setValue((Object)next.getP().getName());
            if (!BgFormPropertyExportEnum.BG_Form_Number.equals((Object)next.getP())) continue;
            row.getCell(SELECT).setValue((Object)true);
            row.getCell(SELECT).getStyleAttributes().setLocked(true);
            row.getCell(SELECT).getStyleAttributes().setBackground(Color.lightGray);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setSelected(true);
    }

    private void setSelected(boolean selected) {
        int in = this.kDTable1.getRowCount();
        for (int i = 0; i < in; ++i) {
            if (BgFormPropertyExportEnum.BG_Form_Number.getName().equals(this.kDTable1.getRow(i).getCell(PROPERTY_NUMBER).getValue())) continue;
            this.kDTable1.getRow(i).getCell(SELECT).setValue((Object)selected);
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setSelected(false);
    }

    protected void checkSelectRow() {
        if (this.kDTable1.getSelectManager().getBlocks() == null || this.kDTable1.getSelectManager().getBlocks().isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow();
        KDTSelectBlock sb = (KDTSelectBlock)this.kDTable1.getSelectManager().getBlocks().get(0);
        int top = sb.getTop();
        int bottom = sb.getBottom();
        if (top > bottom) {
            int tmp = top;
            top = bottom;
            bottom = tmp;
        }
        if (top > 0) {
            IRow newRow = this.kDTable1.addRow(bottom + 1);
            IRow oldRow = this.kDTable1.getRow(top - 1);
            this.copyRow(newRow, oldRow);
            this.kDTable1.removeRow(top - 1);
            sb.setTop(top - 1);
            sb.setBottom(bottom - 1);
            this.kDTable1.getSelectManager().select(sb);
        }
    }

    protected void copyRow(IRow newRow, IRow oldRow) {
        newRow.getCell(SELECT).setValue(oldRow.getCell(SELECT).getValue());
        newRow.getCell(PROPERTY).setValue(oldRow.getCell(PROPERTY).getValue());
        newRow.getCell(PROPERTY_NUMBER).setValue(oldRow.getCell(PROPERTY_NUMBER).getValue());
        newRow.getCell(SELECT).getStyleAttributes().setBackground(oldRow.getStyleAttributes().getBackground());
        newRow.getCell(SELECT).getStyleAttributes().setLocked(oldRow.getStyleAttributes().isLocked());
        if (BgFormPropertyExportEnum.BG_Form_Number.getName().equals(newRow.getCell(PROPERTY_NUMBER).getValue())) {
            newRow.getCell(SELECT).getStyleAttributes().setLocked(true);
            newRow.getCell(SELECT).getStyleAttributes().setBackground(Color.lightGray);
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectRow();
        KDTSelectBlock sb = (KDTSelectBlock)this.kDTable1.getSelectManager().getBlocks().get(0);
        int top = sb.getTop();
        int bottom = sb.getBottom();
        if (top > bottom) {
            int tmp = top;
            top = bottom;
            bottom = tmp;
        }
        if (bottom < this.kDTable1.getRowCount() - 1) {
            IRow newRow = this.kDTable1.addRow(top);
            IRow oldRow = this.kDTable1.getRow(bottom + 2);
            this.copyRow(newRow, oldRow);
            this.kDTable1.removeRow(bottom + 2);
            sb.setTop(top + 1);
            sb.setBottom(bottom + 1);
            this.kDTable1.getSelectManager().select(sb);
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgFormPropertyExportInfo getData() {
        return this.data;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.destroyWindow();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.data = new BgFormPropertyExportInfo();
        this.checkSelected();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            this.data.getResult().add(i, new BgFormPropertyExportInfo.Property(BgFormPropertyExportEnum.getEnum(row.getCell(PROPERTY_NUMBER).getValue().toString()), i, (Boolean)row.getCell(SELECT).getValue()));
        }
        this.isCancel = false;
        this.destroyWindow();
    }

    private void checkSelected() {
        boolean flag = true;
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            boolean isSelected = (Boolean)this.kDTable1.getRow(i).getCell(SELECT).getValue();
            if (!isSelected) continue;
            flag = false;
        }
        if (flag) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"pleaseSelectProperty"));
            SysUtil.abort();
        }
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        BgFormPropertyExportInfo newValue = (BgFormPropertyExportInfo)dataChangeEvent.getNewValue();
        BgFormPropertyExportInfo oldValue = (BgFormPropertyExportInfo)dataChangeEvent.getNewValue();
        if (oldValue.equals(newValue)) {
            return;
        }
        this.fillTable(newValue);
    }
}

