/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgHistoryDataUI;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgHistoryDataUI
extends AbstractBgHistoryDataUI {
    private static final long serialVersionUID = -1477111444471316637L;
    private static final Logger logger = CoreUIObject.getLogger(BgHistoryDataUI.class);
    public static final String COL_periodNumber = "periodNumber";
    public static final String COL_periodType = "periodType";
    public static final String COL_currency = "currency";
    public static final String COL_budget = "budget";
    public static final String COL_actual = "actual";

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadData();
    }

    private void loadData() throws EASBizException, BOSException {
        BOSUuid orgUnitId = null;
        BOSUuid bgFormId = null;
        String formulaString = null;
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_ID) != null) {
            orgUnitId = (BOSUuid)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        }
        if (this.getUIContext().get("BGFORM_ID") != null) {
            bgFormId = (BOSUuid)this.getUIContext().get("BGFORM_ID");
        }
        if (this.getUIContext().get("FORMULA") != null) {
            formulaString = (String)this.getUIContext().get("FORMULA");
        }
        if (orgUnitId != null && bgFormId != null && formulaString != null) {
            String[] parameter = null;
            BgNDataInfo info = null;
            List formulaHint = null;
            FormulaHint formulas = null;
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                formulaHint.clear();
            }
            Map resultMap = null;
            if (parameter != null) {
                resultMap = MBGFormFacadeFactory.getRemoteInstance().getHistoryData(orgUnitId, bgFormId, parameter[0], parameter[2]);
            }
            if (resultMap == null || resultMap.isEmpty()) {
                return;
            }
            this.txtItemNumber.setText(parameter[0]);
            this.txtItemName.setText(String.valueOf(resultMap.get(DimensionConstants.DIMENSION_NAME)));
            this.txtElementName.setText(String.valueOf(resultMap.get(DimensionConstants.DEF_ELEMENT_NUMBER)));
            this.tblMain.checkParsed();
            Map data = (Map)resultMap.get(DimensionConstants.VALUE);
            Map periodMap = (Map)resultMap.get(DimensionConstants.DEF_PERIOD_NUMBER);
            Map currencyMap = (Map)resultMap.get(DimensionConstants.DEF_CURRENCY_NUMBER);
            if (data == null || data.isEmpty()) {
                return;
            }
            ArrayList datas = new ArrayList(data.values());
            Collections.sort(datas, new Comparator<BgNDataInfo>(){

                @Override
                public int compare(BgNDataInfo o1, BgNDataInfo o2) {
                    o1.splitFormula();
                    o2.splitFormula();
                    int result = o1.getBgPeriodNumber().compareTo(o2.getBgPeriodNumber());
                    if (result == 0) {
                        result = o1.getCurrencyNumber().compareTo(o2.getCurrencyNumber());
                    }
                    return result;
                }
            });
            IRow row = null;
            int i = 0;
            boolean j = false;
            int n = 0;
            n = datas.size();
            for (i = 0; i < n; ++i) {
                info = (BgNDataInfo)datas.get(i);
                if (info.getBudgetValue().compareTo(BgNConstants.ZERO) == 0 && info.getActualValue().compareTo(BgNConstants.ZERO) == 0) continue;
                BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)periodMap.get(info.getBgPeriodNumber());
                CurrencyInfo currency = (CurrencyInfo)currencyMap.get(info.getCurrencyNumber());
                row = this.tblMain.addRow();
                row.getCell(COL_periodNumber).setValue((Object)bgPeriodInfo.getName());
                row.getCell(COL_periodType).setValue((Object)bgPeriodInfo.getPeriodType());
                row.getCell(COL_currency).setValue((Object)currency);
                row.getCell(COL_budget).setValue((Object)info.getBudgetValueNoDef());
                row.getCell(COL_actual).setValue((Object)info.getBizActualNoDef());
            }
        }
    }
}

