/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormRecordEnum;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgIEException;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.IMbgPermission;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgNFormBatchImportUI;
import com.kingdee.eas.ma.mbg.client.BgBatchImportResultUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFormBatchImportResult;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgNFormBatchImportUI
extends AbstractBgNFormBatchImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgNFormBatchImportUI.class);
    private String fileFormat = ".xlsx";
    private final String successStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"true");
    private final String failStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"false");
    private final String ISROOT = "isRoot";
    private DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);
    private RptSrcTypeEnum sourceType = RptSrcTypeEnum.PT_BUDGET_REPORT;
    private BgSchemeInfo bgSchemeInfo = null;
    private IBgForm iBgForm = null;
    private IBgScheme ibgScheme = null;
    private IBgTemplate ibgTemplate = null;
    private IPermission iPermission = null;
    private IFullOrgUnit ifullOrgUnit = null;
    private IBgPeriod ibgPeriod = null;
    private ICurrency iCurrency = null;
    private IMbgPermission iMbgPermission = null;

    public RptSrcTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(RptSrcTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    protected String getImportPermission() {
        return "mbg_form35_import";
    }

    protected String getViewPermission() {
        return "mbg_form05_view";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtFilepath.setEditable(true);
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)key) : "";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilepath.getText();
        KDFileChooser fc = new BgFileUtil().getFileChooserForImp((Object)this.getUIContext());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "import"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFile());
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            FileFilter fileFilter = fc.getFileFilter();
            this.txtFilepath.setText(file.getPath());
            if (fileFilter instanceof ExcelFile) {
                this.fileFormat = ".xls";
            }
            if (fileFilter instanceof Excel2007FileFilter) {
                this.fileFormat = ".xlsx";
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
            this.setBgSchemeInfo((BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO"));
        }
        if (this.getUIContext().get("sourceType") instanceof RptSrcTypeEnum) {
            this.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType")));
        }
        this.doImport();
    }

    protected boolean isImportExpression() {
        return this.rbDataANDExpression.isSelected();
    }

    protected void doImport() throws Exception {
        this.verifyInput();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (BOSObjectType)new BgFormInfo().getBOSType(), null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (String)"mbg_bgForm_import");
                List result = null;
                try {
                    result = BgNFormBatchImportUI.this.importFile(BgNFormBatchImportUI.this.txtFilepath.getText());
                }
                catch (Exception ex) {
                    BgNFormBatchImportUI.this.handUIExceptionAndAbort(ex);
                    BgNFormBatchImportUI.this.getUIWindow().close();
                }
                LogUtil.afterLog(null, (IObjectPK)pk);
                return result;
            }

            public void afterExec(Object result) throws Exception {
                if (result != null && result instanceof List) {
                    BgNFormBatchImportUI.this.openImportResultViewUI(result);
                }
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected void openImportResultViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openImportResultModel()).create(this.getResultUI(), (Map)uiContext);
        uiWindow.show();
    }

    protected String getResultUI() {
        return BgBatchImportResultUI.class.getName();
    }

    protected String openImportResultModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void verifyInput() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectInFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List importFile(String filepath) throws EASBizException, BOSException {
        LinkedHashMap<String, BgNFormBatchImportResult> resultMap;
        block10: {
            resultMap = new LinkedHashMap<String, BgNFormBatchImportResult>();
            HashSet<String> importPermissionSet = new HashSet<String>();
            String orgUnitId = (String)this.getUIContext().get("ORGUNIT_COST");
            String orgViewId = (String)this.getUIContext().get("BGORGVIEW_ID");
            BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
            UserInfo _userInfo = SysContext.getSysContext().getCurrentUserInfo();
            TreeModel model = null;
            DefaultKingdeeTreeNode root = null;
            Set orgDataPerIds = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(this.getSourceType(), _userInfo.getId().toString(), this.getBgSchemeInfo().getId().toString());
            FullOrgUnitCollection orgColPer = BgFacadeFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(_userInfo.getId()), OrgType.CostCenter, null, this.getImportPermission());
            try {
                if (bgOrgUnitInfo != null && bgOrgUnitInfo.getId() != null) {
                    model = BgOrgUnitFactory.getRemoteInstance().getFullBgOrgModel(orgViewId, bgOrgUnitInfo.getId().toString(), false, false, true, true, false);
                    root = (DefaultKingdeeTreeNode)model.getRoot();
                    for (int i = 0; i < orgColPer.size(); ++i) {
                        importPermissionSet.add(orgColPer.get(i).getId().toString());
                    }
                    if (root != null && root.getUserObject() instanceof BgOrgUnitInfo) {
                        int rootCount = root.getChildCount();
                        DefaultKingdeeTreeNode _root = null;
                        for (int rc = 0; rc < rootCount; ++rc) {
                            _root = (DefaultKingdeeTreeNode)root.getChildAt(rc);
                            if (_root != null && _root.getUserObject() instanceof BgOrgUnitInfo) {
                                ((BgOrgUnitInfo)_root.getUserObject()).put("isRoot", Boolean.TRUE);
                            }
                            this.importOrgUnitFile(_root, filepath, importPermissionSet, resultMap, orgDataPerIds);
                        }
                    }
                    break block10;
                }
                model = BgOrgUnitFactory.getRemoteInstance().getFullOrgModel(orgUnitId, orgViewId);
                root = (DefaultKingdeeTreeNode)model.getRoot();
                for (int i = 0; i < orgColPer.size(); ++i) {
                    importPermissionSet.add(orgColPer.get(i).getId().toString());
                }
                this.importOrgUnitFile(root, filepath, importPermissionSet, resultMap, orgDataPerIds);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return new ArrayList(resultMap.values());
    }

    private void importOrgUnitFile(DefaultKingdeeTreeNode node, String filepath, Set orgRangeSet, Map<String, BgNFormBatchImportResult> resultMap, Set<String> orgDataPerIds) throws Exception {
        BgOrgUnitInfo bgOrgUnit = null;
        if (node != null && (bgOrgUnit = (BgOrgUnitInfo)node.getUserObject()) != null) {
            if (StringUtils.isEmpty((String)bgOrgUnit.getName())) {
                return;
            }
            if (orgRangeSet.contains(bgOrgUnit.getOrgUnitID())) {
                File _file = null;
                File _tmpFile2 = null;
                File[] _files = null;
                _file = new File(filepath);
                if (_file.exists() && _file.isDirectory()) {
                    _files = _file.listFiles();
                    boolean hasFileMatch = false;
                    for (File _tmpFile2 : _files) {
                        if (_tmpFile2 == null || !_tmpFile2.isDirectory() || !_tmpFile2.getName().equalsIgnoreCase(bgOrgUnit.getName().trim())) continue;
                        hasFileMatch = true;
                        break;
                    }
                    for (File _tmpFile2 : _files) {
                        if (_tmpFile2 == null || !_tmpFile2.isDirectory()) continue;
                        if (_tmpFile2.getName().equalsIgnoreCase(bgOrgUnit.getName().trim())) {
                            DefaultKingdeeTreeNode _node;
                            int i;
                            String _tmpFilepath = filepath + File.separator + bgOrgUnit.getName().trim();
                            hasFileMatch = true;
                            if (!this.checkHasOrgDataPermission(orgDataPerIds, bgOrgUnit.getOrgUnitID())) {
                                BgNFormBatchImportResult result = this.createResult(_tmpFile2);
                                result.setBgOrgName(bgOrgUnit.getNumber());
                                result.setBgOrgName(bgOrgUnit.getName());
                                result.setResult(this.failStr);
                                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"noImportOrgDataPermission", (Object[])new Object[]{bgOrgUnit.getName()}));
                                resultMap.put(bgOrgUnit.getName(), result);
                            } else {
                                this.importExcelFile(_tmpFilepath, bgOrgUnit, resultMap);
                            }
                            HashSet<String> orgNames = new HashSet<String>();
                            HashSet<String> repeatOrgNames = new HashSet<String>();
                            for (i = 0; i < node.getChildCount(); ++i) {
                                _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                                if (_node == null) continue;
                                BgOrgUnitInfo info = (BgOrgUnitInfo)_node.getUserObject();
                                if (!orgNames.isEmpty() && orgNames.contains(info.getName())) {
                                    repeatOrgNames.add(info.getName());
                                }
                                orgNames.add(info.getName());
                            }
                            for (i = 0; i < node.getChildCount(); ++i) {
                                File[] tmpFiles;
                                File tmpFile;
                                BgOrgUnitInfo info;
                                _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                                boolean isImport = true;
                                if (_node != null && repeatOrgNames.contains((info = (BgOrgUnitInfo)_node.getUserObject()).getName()) && (tmpFile = new File(_tmpFilepath)).exists() && tmpFile.isDirectory() && (tmpFiles = tmpFile.listFiles()) != null && tmpFiles.length > 0) {
                                    for (int f = 0; f < tmpFiles.length; ++f) {
                                        File fl = tmpFiles[i];
                                        if (!fl.exists() || !fl.isDirectory() || !repeatOrgNames.contains(fl.getName())) continue;
                                        BgNFormBatchImportResult result = this.createResult(null);
                                        result.setBgOrgName(info.getNumber());
                                        result.setBgOrgName(info.getName());
                                        result.setResult(this.failStr);
                                        result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"hasSameOrgUnit", (Object[])new Object[]{info.getName()}));
                                        resultMap.put(info.getName(), result);
                                        isImport = false;
                                        break;
                                    }
                                }
                                if (!isImport) continue;
                                this.importOrgUnitFile(_node, _tmpFilepath, orgRangeSet, resultMap, orgDataPerIds);
                            }
                            continue;
                        }
                        if (hasFileMatch || bgOrgUnit.get("isRoot") == null || !((Boolean)bgOrgUnit.get("isRoot")).booleanValue()) continue;
                        BgNFormBatchImportResult result = this.createResult(_tmpFile2);
                        result.setBgOrgName(bgOrgUnit.getNumber());
                        result.setBgOrgName(bgOrgUnit.getName());
                        result.setResult(this.failStr);
                        result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileError"));
                        resultMap.put(bgOrgUnit.getName(), result);
                    }
                    if (!hasFileMatch && bgOrgUnit.get("isRoot") != null && ((Boolean)bgOrgUnit.get("isRoot")).booleanValue()) {
                        BgNFormBatchImportResult result = this.createResult(_file);
                        result.setBgOrgName(bgOrgUnit.getNumber());
                        result.setBgOrgName(bgOrgUnit.getName());
                        result.setResult(this.failStr);
                        result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileError"));
                        resultMap.put(bgOrgUnit.getName(), result);
                    }
                } else if (bgOrgUnit.get("isRoot") != null && ((Boolean)bgOrgUnit.get("isRoot")).booleanValue()) {
                    BgNFormBatchImportResult result = this.createResult(_file);
                    result.setBgOrgName(bgOrgUnit.getNumber());
                    result.setBgOrgName(bgOrgUnit.getName());
                    result.setResult(this.failStr);
                    result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileError"));
                    resultMap.put(bgOrgUnit.getName(), result);
                }
            } else if (bgOrgUnit.get("isRoot") != null && ((Boolean)bgOrgUnit.get("isRoot")).booleanValue()) {
                BgNFormBatchImportResult result = this.createResult(null);
                result.setBgOrgName(bgOrgUnit.getNumber());
                result.setBgOrgName(bgOrgUnit.getName());
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"noImportPermission", (Object[])new Object[]{bgOrgUnit.getName()}));
                resultMap.put(bgOrgUnit.getName(), result);
            }
        }
    }

    protected boolean checkHasOrgDataPermission(Set<String> orgDataPerIds, String orgId) {
        if (orgDataPerIds == null || orgDataPerIds.isEmpty()) {
            return true;
        }
        return orgDataPerIds.contains(orgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importExcelFile(String filepath, BgOrgUnitInfo bgOrgUnit, Map<String, BgNFormBatchImportResult> resultMap) {
        File _file = null;
        File _tmpFile2 = null;
        File[] _files = null;
        HashMap imFileResultMap = new HashMap();
        ArrayList<String> imFileName = new ArrayList<String>();
        ArrayList<String> imFileResult = new ArrayList<String>();
        imFileResultMap.put("IMPORT_FILES_NAME", imFileName);
        imFileResultMap.put("IMPORT_FILES_RESULT", imFileResult);
        String _orgUnitId = bgOrgUnit.getOrgUnitID();
        String _succeed = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "import_succeed");
        _file = new File(filepath);
        if (_file.exists() && _file.isDirectory()) {
            for (File _tmpFile2 : _file.listFiles()) {
                if (_tmpFile2 == null || !_tmpFile2.isFile() || !this.checkFilename(_tmpFile2, this.getBgSchemeInfo())) continue;
                imFileName.add(_tmpFile2.getName());
                try {
                    this.importBudgetFile(_tmpFile2, bgOrgUnit, resultMap);
                    imFileResult.add(_succeed);
                }
                catch (Exception ex) {
                    imFileResult.add(ex.getMessage());
                    logger.error((Object)"", (Throwable)ex);
                }
            }
        }
    }

    protected BgNFormBatchImportResult createResult(File fileName) {
        BgNFormBatchImportResult result = new BgNFormBatchImportResult();
        if (fileName != null) {
            result.setFilePath(fileName.getParent());
            result.setFileName(fileName.getName());
        }
        return result;
    }

    private void importBudgetFile(File file, BgOrgUnitInfo bgOrgUnit, Map<String, BgNFormBatchImportResult> resultMap) throws Exception {
        if (file == null) {
            return;
        }
        BgNFormBatchImportResult result = this.createResult(file);
        result.setBgOrgName(bgOrgUnit.getNumber());
        result.setBgOrgName(bgOrgUnit.getName());
        resultMap.put(file.getPath(), result);
        BgFormInfo bgFormInfo = (BgFormInfo)this.parseFilename(file, bgOrgUnit, result);
        bgFormInfo = this.importFormExcelFile(file, bgFormInfo, result);
        if (bgFormInfo != null) {
            BgNFSHelper.setBudget((IObjectValue)bgFormInfo);
            this.getBgFormInterface().save((CoreBaseInfo)bgFormInfo);
            result.setBgFormName(bgFormInfo.getName());
            result.setBgFormNumber(bgFormInfo.getNumber());
            result.setResult(this.successStr);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private BgFormInfo importFormExcelFile(File file, BgFormInfo bgFormInfo, BgNFormBatchImportResult result) throws Exception {
        if (file == null || bgFormInfo == null) {
            return null;
        }
        KDSBook _kdBook = null;
        KDSSheet _kdSheet = null;
        KDSCell _kdCell = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int _kdSheetIndex = 0;
        int _kdSheetSize = 0;
        int _sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String formulaStr = null;
        String userId = null;
        String expression = null;
        String[] parameter = null;
        BigDecimal _value = null;
        BigDecimal _oldValue = null;
        BigDecimal _coefficient = null;
        BigDecimal _tmpCof = null;
        HashMap<String, BigDecimal> measureMap = new HashMap<String, BigDecimal>();
        BgMeasureUnitInfo muInfo = null;
        Date date = new Date();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        userId = user.getId().toString();
        _coefficient = bgFormInfo.getMeasureUnit().getCoefficient();
        if (bgFormInfo.getBgMeasureUnit() != null && !bgFormInfo.getBgMeasureUnit().isEmpty()) {
            Iterator iter = bgFormInfo.getBgMeasureUnit().iterator();
            while (iter.hasNext()) {
                muInfo = (BgMeasureUnitInfo)iter.next();
                measureMap.put(muInfo.getBgElement().getNumber(), muInfo.getMeasureUnit().getCoefficient());
            }
        }
        try {
            if (this.fileFormat.equals(".xls")) {
                _kdBook = POIXlsReader.parse((String)file.getPath());
            } else if (this.fileFormat.equals(".xlsx") && (_kdBook = POIXlsxReader.parse((String)file.getPath())) == null) {
                _kdBook = new Excel2007Reader().parse(file.getPath());
            }
            if (_kdBook != null) {
                _kdSheetSize = _kdBook.getSheetCount();
            }
            _book = bgFormInfo.getBook();
            _sheetSize = _book.getSheetCount();
            BgNFSHelper.disableCal(_book);
            HashSet<String> bookSheetNames = new HashSet<String>();
            for (int index = 0; index < _sheetSize; ++index) {
                bookSheetNames.add(_book.getSheetName(index));
            }
            if (_kdSheetSize != _sheetSize) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorSheetSize"));
                BgFormInfo index = null;
                _kdBook = null;
                _kdSheet = null;
                _book = null;
                _sheet = null;
                return index;
            }
            if (_kdBook != null) {
                for (_kdSheetIndex = 0; _kdSheetIndex < _kdSheetSize; ++_kdSheetIndex) {
                    _kdSheet = _kdBook.getSheet((Object)new Integer(_kdSheetIndex));
                    if (!bookSheetNames.contains(_kdSheet.getName())) {
                        result.setResult(this.failStr);
                        result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"sheetNameNotMatch", (Object[])new Object[]{_kdSheet.getName()}));
                        BgFormInfo index = null;
                        _kdBook = null;
                        _kdSheet = null;
                        _book = null;
                        _sheet = null;
                        return index;
                    }
                    _sheet = _book.getSheetByName(_kdSheet.getName());
                    if (_sheet == null) {
                        result.setResult(this.failStr);
                        result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"sheetNameNotMatch", (Object[])new Object[]{_kdSheet.getName()}));
                        BgFormInfo index = null;
                        _kdBook = null;
                        _kdSheet = null;
                        _book = null;
                        _sheet = null;
                        return index;
                    }
                    if (this.fileFormat.equals(".xls")) {
                        rowCount = _kdSheet.getRowCount();
                        colCount = _kdSheet.getColumnCount();
                    } else if (this.fileFormat.equals(".xlsx")) {
                        rowCount = _kdSheet.getExpandedRows() + 1;
                        colCount = _kdSheet.getExpandedColumns() + 1;
                    }
                    for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                            _kdCell = _kdSheet.getCell(rowIndex, colIndex, false);
                            if (_kdCell == null || _kdCell.getValue() == null || (_cell = _sheet.getCell(rowIndex, colIndex, true)).isLocked() || _cell.getMerge(true) != null && !_cell.isFirstMergedCell()) continue;
                            if (this.isImportExpression() && !StringUtils.isEmpty((String)_kdCell.getFormula())) {
                                expression = _kdCell.getFormula();
                                if (expression.charAt(0) != '=') {
                                    expression = "=" + expression;
                                }
                                BgNFSHelper.setExpression(_cell, expression);
                            }
                            _tmpCof = _coefficient;
                            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                parameter = BgNFSHelper.parseFormulaPara(null, formulaStr);
                                _oldValue = BgNFSHelper.getBudgetValue(_cell);
                                if (!measureMap.isEmpty() && measureMap.containsKey(parameter[2])) {
                                    _tmpCof = (BigDecimal)measureMap.get(parameter[2]);
                                }
                                try {
                                    if (_kdCell.getValue() != null && !StringUtils.isEmpty((String)_kdCell.getValue().toString())) {
                                        try {
                                            _value = new BigDecimal(_kdCell.getValue().toString().trim().replaceAll(",", ""));
                                        }
                                        catch (NumberFormatException e) {
                                            result.setResult(this.failStr);
                                            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"notNumber", (Object[])new Object[]{_sheet.getSheetName(), _cell.getName(false, false)}));
                                            BgFormInfo bgFormInfo2 = null;
                                            _kdBook = null;
                                            _kdSheet = null;
                                            _book = null;
                                            _sheet = null;
                                            return bgFormInfo2;
                                        }
                                        if (!BgNFSHelper.checkHasPercentage(_cell)) {
                                            _value = _value.multiply(_tmpCof);
                                        }
                                        BgNFSHelper.setValue(_cell, _value);
                                        BgNFSHelper.setBudgetValue(_cell, _value);
                                        continue;
                                    }
                                    BgNFSHelper.setValue(_cell, null);
                                    BgNFSHelper.setBudgetValue(_cell, null);
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                    BgNFSHelper.setValue(_cell, _value);
                                    BgNFSHelper.setBudgetValue(_cell, _value);
                                }
                                continue;
                            }
                            if (BgNFSHelper.checkIsNumeric(_kdCell.getValue())) {
                                if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                                    try {
                                        _value = new BigDecimal(_kdCell.getValue().toString().trim().replaceAll(",", ""));
                                        _value = _value.multiply(_tmpCof);
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    BgNFSHelper.setValue(_cell, _value);
                                    continue;
                                }
                                if (StringUtils.isEmpty((String)_kdCell.getValue().toString())) continue;
                                _cell.setValue(new Variant((Object)_kdCell.getValue().toString()));
                                continue;
                            }
                            if (!StringUtils.isEmpty((String)_kdCell.getValue().toString())) {
                                _cell.setValue(new Variant((Object)_kdCell.getValue().toString()));
                                continue;
                            }
                            BgNFSHelper.setValue(_cell, null);
                        }
                    }
                }
            }
            bgFormInfo.setBook(_book);
            _kdBook = null;
            _kdSheet = null;
            _book = null;
            _sheet = null;
        }
        catch (Throwable throwable) {
            _kdBook = null;
            _kdSheet = null;
            _book = null;
            _sheet = null;
            throw throwable;
        }
        return bgFormInfo;
    }

    private IObjectValue parseFilename(File file, BgOrgUnitInfo bgOrgUnit, BgNFormBatchImportResult result) throws Exception {
        BgSchemeInfo _bgSchemeInfo = null;
        BgFormInfo _bgFormInfo = null;
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        String userId = user.getId().toString();
        String key = null;
        String _orgUnitName = null;
        String[] parameter = null;
        if (!file.getName().endsWith(this.fileFormat)) {
            result.setResult(this.failStr);
            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileFormateError"));
            return _bgFormInfo;
        }
        parameter = this.fileFormat.equals(".xls") ? file.getName().replaceAll(".xls", "").split("_") : file.getName().replaceAll(".xlsx", "").split("_");
        if (parameter.length < 3) {
            result.setResult(this.failStr);
            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileFormateError"));
            return _bgFormInfo;
        }
        if (StringUtils.isEmpty((String)parameter[0]) || StringUtils.isEmpty((String)parameter[1]) || StringUtils.isEmpty((String)parameter[2])) {
            result.setResult(this.failStr);
            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileFormateError"));
            return _bgFormInfo;
        }
        _orgUnitName = bgOrgUnit.getName().trim();
        key = parameter[0];
        if (!key.trim().equals(_orgUnitName)) {
            result.setResult(this.failStr);
            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileNameNotMatchOrg"));
            return _bgFormInfo;
        }
        _bgSchemeInfo = this.getBgSchemeInfo(parameter[1]);
        if (_bgSchemeInfo == null) {
            result.setResult(this.failStr);
            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"fileNameNotMatchScheme"));
            return _bgFormInfo;
        }
        String bgFormNumber = parameter[2];
        if (StringUtils.isEmpty((String)bgFormNumber)) {
            // empty if block
        }
        if ((_bgFormInfo = this.existForm(bgOrgUnit.getOrgUnitID(), _bgSchemeInfo.getId().toString(), bgFormNumber)) != null) {
            result.setBgFormName(_bgFormInfo.getName());
            result.setBgFormNumber(_bgFormInfo.getNumber());
            BgTemFormTypeEnum formType = _bgFormInfo.getBgTemplate().getFormType();
            if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"noSpecialForm"));
                return null;
            }
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formType)) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"noViewForm"));
                return null;
            }
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formType)) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"noViewlistForm"));
                return null;
            }
            if (BgFormRecordEnum.RECORD.equals((Object)_bgFormInfo.getRecord())) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"cantImportRecord"));
                return null;
            }
            BgProcessEnum bgProcessType = _bgFormInfo.getProcessType();
            if (BgProcessEnum.C03.equals((Object)bgProcessType)) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"notSenddown"));
                return null;
            }
            if (_bgFormInfo.getState().getValue() != 1 && _bgFormInfo.getState().getValue() != 42) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"bgformErrorState"));
                return null;
            }
            if (_bgFormInfo.getBgTemplate().isReadonly()) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"cantImportReadOnly"));
                return null;
            }
            ArrayList<String> billIds = new ArrayList<String>();
            billIds.add(_bgFormInfo.getId().toString());
            Set<String> formIds = MBgCheckHelper.requestMutex(null, billIds, true);
            if (formIds != null && formIds.contains(_bgFormInfo.getId().toString())) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"mutexError"));
                return null;
            }
            Set bgTemplatePermission = this.getIMbgPermission().getBgTemplatePermission(this.getSourceType(), userId, this.bgSchemeInfo.getId().toString());
            if (bgTemplatePermission != null && !bgTemplatePermission.isEmpty() && !bgTemplatePermission.contains(_bgFormInfo.getBgTemplate().getId().toString())) {
                result.setResult(this.failStr);
                result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"hasNoDataPermission"));
                return null;
            }
            if (_bgFormInfo.getState().getValue() == 1 || _bgFormInfo.getState().getValue() == 42) {
                _bgFormInfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(_bgFormInfo.getId()), BgNFSHelper.getSelectors());
                if (_bgFormInfo.getState().getValue() != 42) {
                    _bgFormInfo.setState(BgFormStateEnum.Edited);
                }
            } else {
                _bgFormInfo = null;
            }
        } else {
            result.setResult(this.failStr);
            result.setDetail(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"orgNoBgFormNumber", (Object[])new Object[]{bgOrgUnit.getName(), bgFormNumber}));
            return null;
        }
        if (_bgFormInfo == null) {
            throw new BgIEException(BgIEException.ERRORBGFORM);
        }
        return _bgFormInfo;
    }

    private boolean checkFilename(File file, BgSchemeInfo bgSchemeInfo) {
        if (file == null || bgSchemeInfo == null || StringUtils.isEmpty((String)file.getName())) {
            return false;
        }
        return !file.getName().startsWith("~$");
    }

    private BgSchemeInfo getBgSchemeInfo(String bgSchemeName) throws Exception {
        BgSchemeInfo _bgSchemeInfo = null;
        if (bgSchemeName.equals(this.getBgSchemeInfo().getName())) {
            _bgSchemeInfo = this.getBgSchemeInfo();
        }
        return _bgSchemeInfo;
    }

    private SelectorItemCollection getBgFormSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.readonly");
        sic.add("processType");
        sic.add("record");
        return sic;
    }

    private BgFormInfo existForm(String orgUnitId, String bgSchemeId, String bgFormNumber) throws Exception {
        BgFormInfo _result;
        block7: {
            if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgFormNumber)) {
                return null;
            }
            HashSet<Integer> states = new HashSet<Integer>();
            states.add(1);
            states.add(42);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgFormNumber, CompareType.EQUALS));
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getBgFormSelector());
            _result = null;
            BgFormInfo _tmpFormInfo = null;
            BgFormCollection _bgFormCol = null;
            _bgFormCol = this.getBgFormInterface().getBgFormCollection(view);
            if (_bgFormCol == null || _bgFormCol.isEmpty()) break block7;
            if (_bgFormCol.size() == 1) {
                _result = _bgFormCol.get(0);
                break block7;
            }
            Iterator iter = _bgFormCol.iterator();
            while (iter.hasNext()) {
                _tmpFormInfo = (BgFormInfo)iter.next();
                if (_tmpFormInfo.getState().getValue() != 2) continue;
                _result = _tmpFormInfo;
                break;
            }
        }
        return _result;
    }

    protected IBgForm getBgFormInterface() throws Exception {
        if (this.iBgForm == null) {
            this.iBgForm = BgFormFactory.getRemoteInstance();
        }
        return this.iBgForm;
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        if (this.ibgScheme == null) {
            this.ibgScheme = BgSchemeFactory.getRemoteInstance();
        }
        return this.ibgScheme;
    }

    protected IBgTemplate getBgTemplateInterface() throws Exception {
        if (this.ibgTemplate == null) {
            this.ibgTemplate = BgTemplateFactory.getRemoteInstance();
        }
        return this.ibgTemplate;
    }

    protected IPermission getPermissionInterface() throws Exception {
        if (this.iPermission == null) {
            this.iPermission = PermissionFactory.getRemoteInstance();
        }
        return this.iPermission;
    }

    protected IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        if (this.ifullOrgUnit == null) {
            this.ifullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        return this.ifullOrgUnit;
    }

    protected IBgPeriod getBgPeriodInterface() throws Exception {
        if (this.ibgPeriod == null) {
            this.ibgPeriod = BgPeriodFactory.getRemoteInstance();
        }
        return this.ibgPeriod;
    }

    protected ICurrency getCurrencyInterface() throws Exception {
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        return this.iCurrency;
    }

    protected IMbgPermission getIMbgPermission() throws BOSException {
        if (this.iMbgPermission == null) {
            return MbgPermissionFactory.getRemoteInstance();
        }
        return this.iMbgPermission;
    }
}

