/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgNFormRollProcessUI;
import com.kingdee.eas.ma.mbg.client.notify.CellDoubleClickListener;
import com.kingdee.eas.ma.mbg.client.utils.BgNCWfHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionFillHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.roll.BgRollContext;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNFormRollProcessUI
extends AbstractBgNFormRollProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(BgNFormRollProcessUI.class);
    private Set<String> canEditNumbers;

    public Set<String> getCanEditNumbers() {
        return this.canEditNumbers;
    }

    public void setCanEditNumbers(Set<String> canEditNumbers) {
        this.canEditNumbers = canEditNumbers;
    }

    @Override
    public void init() throws Exception {
        if (this.getCanEditNumbers() == null && this.getBgFormInfo() != null) {
            this.setCanEditNumbers(BgRollContext.newInstance(null, this.getBgFormInfo()).getCanEditPeriodNumbers());
        }
        super.init();
    }

    @Override
    protected boolean isCanEditBgData(String formula, IBgNData bgData) {
        String bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1];
        if (!this.canEditNumbers.contains(bgPeriodNumber)) {
            return false;
        }
        return this.getCheckHelper().canSave(formula, this.getEditScenario(), this.getVersionNumber()) && this.isCanEditByState(bgData);
    }

    @Override
    protected boolean isCanEditByState(IBgNData bgData) {
        return bgData == null || 5 == ((BgNDataInfo)bgData).getState() || 9 == ((BgNDataInfo)bgData).getState();
    }

    @Override
    public void doubleClickCell() {
        Cell cell = this.getBook().getActiveSheet().getActiveCell();
        CellDoubleClickListener cellDoubleClickListener = new CellDoubleClickListener(this.getMainStatusBar(), cell, this.getBgFormInfo(), this.getEditScenario(), this.getCheckHelper(), this.getBgdataMap(), this.canEditNumbers);
        cellDoubleClickListener.doubleClick();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setComponentEnable();
        this.btnUpdateBgForm.setVisible(false);
        this.menuItemUpdateBgForm.setVisible(false);
        this.btnAdjustHistory.setVisible(false);
        this.menuItemAdjustHistory.setVisible(false);
    }

    private void setComponentEnable() {
        this.menuItemSavePrintSetting.setVisible(false);
    }

    @Override
    protected void fillAdjustValue(Cell cell, String formula, IBgNData data) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo;
        BgVersionInfo bgVersion;
        super.fillAdjustValue(cell, formula, data);
        if (this.getEditData() instanceof BgFormInfo && (bgVersion = (bgFormInfo = (BgFormInfo)this.getEditData()).getBgVersion()) != null && bgVersion.isIsRollVersion() && BgSHelper.EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell))) {
            BgNFSHelper.setBackGroup(cell, Styles.getNullColor());
        }
    }

    @Override
    public void afterRefer(String billId) throws Exception {
        if (!this.isHasExamineCheck()) {
            return;
        }
        boolean bre = false;
        BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo("select * where id ='" + billId + "'");
        if (BgFormHelper.checkInProInst(billId)) {
            bre = this.getFacadeInterface().submitFormWork(BOSUuid.read((String)billId));
        } else if (BgNCWfHelper.checkPostActivityPersons((CoreBaseInfo)bgFormInfo, (CoreUI)this, this.getFacadeInterface().getContext(), "com.kingdee.eas.ma.mbg.BgFormFunction", "ActionRollFormSubmit")) {
            bre = this.getFacadeInterface().submitRollWork((IObjectValue)bgFormInfo);
        }
        if (bre) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"budgetRollForm") + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"exclaim")));
            BgNFCHelper.refreshListUI((CoreUI)this);
            this.destroyWindow();
        } else {
            MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"budgetRollForm") + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"exclaim")));
        }
    }

    @Override
    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", "budgetRollForm") + " - " + MessageFormat.format(BgNFCHelper.getMessageStr(this.getOprtState()), "", "") + " - " + this.getEditData().get("name").toString();
    }

    @Override
    public void actionCreateBgExpression_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateBgExpression_actionPerformed(e);
        String orgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
        if (e.getActionCommand().equalsIgnoreCase("MbgActualS")) {
            DimensionFillHelper.createBgFormula(this, this.getBook().getActiveSheet(), (IObjectValue)this.getBgFormInfo(), "MbgActualS", false, false, orgUnitId, true, false);
        } else if (e.getActionCommand().equalsIgnoreCase("MbgAggregate")) {
            DimensionFillHelper.createBgFormula(this, this.getBook().getActiveSheet(), (IObjectValue)this.getBgFormInfo(), "MbgAggregate", false, false, orgUnitId, true, false);
        } else if (e.getActionCommand().equalsIgnoreCase("MbgFormula")) {
            DimensionFillHelper.createBgFormula(this, this.getBook().getActiveSheet(), (IObjectValue)this.getBgFormInfo(), "MbgFormula", false, false, orgUnitId, true, false);
        } else if (e.getActionCommand().equalsIgnoreCase("MbgActualSF")) {
            DimensionFillHelper.createBgFormulaFromItemFormula(this, this.getBook().getActiveSheet(), (IObjectValue)this.getBgFormInfo(), "MbgActualS", false, false, orgUnitId, true, false);
        } else if (e.getActionCommand().equalsIgnoreCase("MbgAggregateF")) {
            DimensionFillHelper.createBgFormulaFromItemFormula(this, this.getBook().getActiveSheet(), (IObjectValue)this.getBgFormInfo(), "MbgAggregate", false, false, orgUnitId, true, false);
        } else if (e.getActionCommand().equalsIgnoreCase("MbgFormulaF")) {
            DimensionFillHelper.createBgFormulaFromItemFormula(this, this.getBook().getActiveSheet(), (IObjectValue)this.getBgFormInfo(), "MbgFormula", false, false, orgUnitId, true, false);
        }
    }
}

