/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.BgNFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgTemFormatImportUI;
import com.kingdee.eas.ma.mbg.client.form.BgNFormSpecialProvider;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BudgetEditMenuManager;
import com.kingdee.eas.ma.mbg.client.utils.DimensionFillHelper;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialFormProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialTemplateProcessUI;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNFormSpecialProcessUI
extends BgNFormProcessUI
implements IBgSpecialFormProcessUI,
IBgSpecialTemplateProcessUI {
    private static final long serialVersionUID = -4592394088671043460L;
    private static final Logger logger = CoreUIObject.getLogger(BgNFormSpecialProcessUI.class);
    private boolean createNewBook = true;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.addPagePanel();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            BgFormInfo bgFormInfo = this.getBgFormInfo();
            String logName = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
            IObjectPK Loginpk = LogUtil.beginLog(null, (String)"actionEdit_actionPerformed", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"mbg_bgForm_update");
            LogUtil.afterLog(null, (IObjectPK)Loginpk);
        }
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BudgetEditMenuManager((Component)((Object)this));
    }

    @Override
    public IBookProvider getBudgetProvider() {
        return new BgNFormSpecialProvider((Component)((Object)this));
    }

    @Override
    public Book getBook() {
        Book book = null;
        if (this.createNewBook && OprtState.ADDNEW.equals(this.getOprtState())) {
            this.createNewBook = false;
            try {
                book = this.getBookProvider().loadBook();
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handleException(ex);
                SysUtil.abort();
            }
        } else {
            book = super.getBook();
        }
        return book;
    }

    public void addPagePanel() throws Exception {
        this.getUIContentPane().add(BgSpecialBudgetClientHelper.getPageDimensionPanel(this.getSpreadManager().getSpreadContainer(), (CoreUI)this, this.getBgFormInfo(), this.getSchemeHelper(), this.getOrgUnitInfo()), "Center");
    }

    @Override
    public Component getWorkTableComponent() {
        return this.getUIContentPane();
    }

    @Override
    protected SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        BgSpecialBudgetClientHelper.getSpecialItemSelector(sic);
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBgItemFill_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            uiContext.put((Object)"ORGUNITID", (Object)this.getBgFormInfo().getOrgUnit().getId().toString());
            uiContext.put((Object)"item_formula_map", (Object)this.getItemFormulMap());
            uiContext.put((Object)"this_is_from_template", (Object)Boolean.FALSE);
            uiContext.put((Object)"BGSCHEME_ID", (Object)this.getBgSchemeId());
            uiContext.put((Object)"filterValueMap", this.getFilterMap());
            uiContext.put((Object)"IS_SPECIAL_BUDGET", (Object)Boolean.TRUE);
            uiContext.put((Object)BgBaseConstants.BGPERIOD_INFO, (Object)this.getBgFormInfo().getBgPeriod());
            uiContext.put((Object)BgBaseConstants.CURRENCY_INFO, (Object)this.getBgFormInfo().getCurrency());
            try {
                uiContext.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
            }
            catch (EASBizException ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
            catch (BOSException ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormatImportUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            uiWindow.show();
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public Map<String, Set<String>> getFilterMap() throws EASBizException, BOSException {
        return BgSpecialBudgetHelper.getFilterMapByBgForm(null, this.getBgFormInfo(), this.getSchemeHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            this.getBook().getUndoManager().startGroup();
            String orgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
            try {
                DimensionFillHelper.showBgItem(this, this.getBgSchemeId(), this.getBook().getActiveSheet(), true, "", this.getBgFormInfo().getCurrency().getNumber(), this.getItemFormulMap(), null, false, false, orgUnitId, true, this.getFilterMap(), true, true);
                this.getSpreadManager().getSpreadContainer().repaint();
            }
            finally {
                this.getBook().getUndoManager().endGroup();
            }
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public void actionCreateItemFormula_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            super.actionCreateItemFormula_actionPerformed(e);
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    protected void cell_Content_Changed(SheetChangeEvent e) throws Exception {
        super.cell_Content_Changed(e);
    }

    @Override
    protected void showCell(Cell cell) throws Exception {
        super.showCell(cell);
        if (cell != null) {
            this.setOldFormula(cell, BgNFSHelper.getFormulaOfCell(cell));
        }
    }

    @Override
    protected void showAllBook() throws Exception {
        super.showAllBook();
        BgSpecialBudgetHelper.clearSrcMap();
    }

    @Override
    public void addCell(Cell cell) {
        super.addCell(cell);
    }

    @Override
    public void fillSpecialItem() {
        if (this.cells.isEmpty()) {
            return;
        }
        BgSheetRange range = new BgSheetRange(this.getBook().getActiveSheet());
        for (Cell cell : this.cells) {
            range.addCell(cell.getRow(), cell.getCol());
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(range.getRange());
        try {
            BgSpecialBudgetHelper.buildFormula((Range)ranges.get(0), BgSpecialBudgetClientHelper.getBgSpecialItemByForm(this.getBgFormInfo()));
            BgNTemplateHelper.dealWith(ranges, this.getOrgUnitInfo().getId().toString(), this.getItemFormulMap(), true, true, null, true, false, null, this.getSchemeHelper(), true, null, true, true);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    public void afterFill() {
        super.afterFill();
    }

    @Override
    public boolean isElementRequired() {
        return true;
    }

    @Override
    public boolean isScenarioRequired() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

