/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionCollection;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.client.AbstractBgNTempletExportUI;
import com.kingdee.eas.ma.mbg.client.BgExportResultUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNTemplateToHelperFile;
import com.kingdee.eas.ma.mbg.utils.BgExportUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.XmlFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgNTempletExportUI
extends AbstractBgNTempletExportUI {
    private static final long serialVersionUID = 7297653150851758057L;
    private static final Logger logger = CoreUIObject.getLogger(BgNTempletExportUI.class);
    private Map bgTemplateIdsMap = null;

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected static IBgTemplate getTempleteInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbXML.isSelected();
        this.bgTemplateIdsMap = (Map)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new BgFileUtil().getFileChooserForExp((Object)this.getUIContext());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new XmlFileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (BOSObjectType)new BgFormInfo().getBOSType(), null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "batchExport"), (String)"bgScheme_export");
                List reList = BgNTempletExportUI.this.exportFile(BgNTempletExportUI.this.txtFilepath.getText(), BgNTempletExportUI.this.bgTemplateIdsMap);
                new BgFileUtil().storeDefaultPathForEXP((Object)BgNTempletExportUI.this.txtFilepath, (Object)BgNTempletExportUI.this.getUIContext());
                LogUtil.afterLog(null, (IObjectPK)pk);
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"EXAMINE_DATA", (Object)reList);
                uiContext.put((Object)"UI_TITLE", (Object)BgNTempletExportUI.this.exportTitle());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)BgNTempletExportUI.this.getModel()).create(BgExportResultUI.class.getName(), (Map)uiContext);
                uiWindow.show();
                return reList;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected String exportTitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"title_export_bgTemplate");
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re) {
            // empty if block
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List exportFile(String filepath, Map bgTemplateIdsMap) throws Exception {
        ArrayList<String[]> _exportInfoList = new ArrayList<String[]>();
        HashMap<String, BgTemplateInfo> bgTemplateMap = new HashMap<String, BgTemplateInfo>();
        HashMap<String, BgViewDimensionInfo> dimensionMap = new HashMap<String, BgViewDimensionInfo>();
        HashSet bgTemplateIds = new HashSet();
        Iterator it = bgTemplateIdsMap.values().iterator();
        while (it.hasNext()) {
            bgTemplateIds.addAll(((Map)it.next()).keySet());
        }
        if (bgTemplateIds.isEmpty()) {
            return _exportInfoList;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getSelector());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bgTemplateIds, CompareType.INCLUDE));
        BgTemplateCollection col = BgTemplateFactory.getRemoteInstance().getBgTemplateCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            bgTemplateMap.put(col.get(i).getId().toString(), col.get(i));
        }
        evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("template.id", bgTemplateIds, CompareType.INCLUDE));
        BgViewDimensionCollection dims = BgViewDimensionFactory.getRemoteInstance().getBgViewDimensionCollection(evi);
        for (int i = 0; i < dims.size(); ++i) {
            dimensionMap.put(dims.get(i).getTemplate().getId().toString(), dims.get(i));
        }
        HashSet<BOSUuid> _orgPermissionSet = new HashSet<BOSUuid>();
        FullOrgUnitCollection _fullOrgColl = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = SysContext.getSysContext().getCurrentCostUnit();
        UserInfo _userInfo = SysContext.getSysContext().getCurrentUserInfo();
        TreeModel model = null;
        DefaultKingdeeTreeNode root = null;
        try {
            model = BgNFSHelper.getOrgTreeModel(_ccOrgUnitInfo.getId().toString(), null);
            root = (DefaultKingdeeTreeNode)this.getUIContext().get("OrgUnit");
            Set<String> subNodeIds = BgOrgTreeHelper.getAllSubNodeUserObject(root);
            _fullOrgColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(_userInfo.getId()));
            if (_ccOrgUnitInfo != null) {
                for (int i = 0; i < _fullOrgColl.size(); ++i) {
                    _orgPermissionSet.add(_fullOrgColl.get(i).getId());
                }
            }
            BgOrgUnitInfo _oui = (BgOrgUnitInfo)root.getUserObject();
            FullOrgUnitInfo _orgUnitInfo = _oui.castToFullOrgUnitInfo();
            String _tmpOrgUnitId = _orgUnitInfo.getId().toString();
            String[] _exportInfo = null;
            for (String bgTempId : bgTemplateMap.keySet()) {
                BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)bgTemplateMap.get(bgTempId);
                String bgTemplateOrgId = bgTemplateInfo.getOrgUnit().getId().toString();
                if (!bgTemplateIdsMap.containsKey(bgTemplateOrgId) || !((Map)bgTemplateIdsMap.get(bgTemplateOrgId)).containsKey(bgTempId)) continue;
                if (!((String[])((Map)bgTemplateIdsMap.get(bgTemplateOrgId)).get(bgTempId))[3].equals(bgTemplateOrgId)) {
                    _exportInfo = new String[]{_orgUnitInfo.getName(), bgTemplateInfo.getNumber() + " - " + bgTemplateInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"distributionByParent")};
                    _exportInfoList.add(_exportInfo);
                    ((Map)bgTemplateIdsMap.get(bgTemplateOrgId)).remove(bgTempId);
                    continue;
                }
                if (subNodeIds.contains(bgTemplateOrgId)) continue;
                _exportInfo = new String[]{bgTemplateInfo.getOrgUnit().getName(), bgTemplateInfo.getNumber() + " - " + bgTemplateInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"exportError_orgNotExpand")};
                _exportInfoList.add(_exportInfo);
            }
            this.exportOrgUnitFile(root, _orgPermissionSet, _exportInfoList, filepath, bgTemplateIdsMap, bgTemplateMap, dimensionMap);
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _exportInfoList;
    }

    protected void exportOrgUnitFile(DefaultKingdeeTreeNode root, Set permissionSet, List exportInfoList, String filepath, Map bgTemplateIdsMap, Map<String, BgTemplateInfo> bgTemplateMap, Map<String, BgViewDimensionInfo> dimensionMap) throws BOSException {
        block4: {
            FullOrgUnitInfo _orgUnitInfo;
            String[] _tmpbgFormInfo;
            String[] _exportInfo;
            String _tmpOrgUnitId;
            block5: {
                if (root == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
                    return;
                }
                String _tmpFilepath = null;
                _tmpOrgUnitId = null;
                String _tmpbgFormId = null;
                _exportInfo = null;
                _tmpbgFormInfo = null;
                _orgUnitInfo = null;
                DefaultKingdeeTreeNode _node = null;
                BgOrgUnitInfo _oui = (BgOrgUnitInfo)root.getUserObject();
                if (_oui == null) break block4;
                _orgUnitInfo = _oui.castToFullOrgUnitInfo();
                _tmpOrgUnitId = _orgUnitInfo.getId().toString();
                if (!permissionSet.contains(_orgUnitInfo.getId())) break block5;
                this.exportDirectory(filepath, _orgUnitInfo);
                if (bgTemplateIdsMap.containsKey(_tmpOrgUnitId)) {
                    this.exportXmlFile(_orgUnitInfo, filepath, bgTemplateIdsMap, exportInfoList, bgTemplateMap, dimensionMap);
                }
                _tmpFilepath = filepath + "/" + _orgUnitInfo.getName().replaceAll(" ", "");
                int in = root.getChildCount();
                for (int i = 0; i < in; ++i) {
                    _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    this.exportOrgUnitFile(_node, permissionSet, exportInfoList, _tmpFilepath, bgTemplateIdsMap, bgTemplateMap, dimensionMap);
                }
                break block4;
            }
            if (!bgTemplateIdsMap.containsKey(_tmpOrgUnitId)) break block4;
            Map _tmpBgFormIdsMap = (Map)bgTemplateIdsMap.get(_tmpOrgUnitId);
            for (String _tmpbgFormId : _tmpBgFormIdsMap.keySet()) {
                _tmpbgFormInfo = (String[])_tmpBgFormIdsMap.get(_tmpbgFormId);
                _exportInfo = new String[]{_orgUnitInfo.getName(), _tmpbgFormInfo[1] + " - " + _tmpbgFormInfo[2], com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorPermission")};
                exportInfoList.add(_exportInfo);
            }
        }
    }

    protected void exportDirectory(String filepath, FullOrgUnitInfo orgUnitInfo) {
        if (StringUtils.isEmpty((String)filepath) || orgUnitInfo == null) {
            return;
        }
        File _file = new File(filepath + "/" + orgUnitInfo.getName().replaceAll(" ", ""));
        if (!_file.exists()) {
            _file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportXmlFile(FullOrgUnitInfo orgUnitInfo, String filepath, Map bgTempleteIdsMap, List exportInfoList, Map<String, BgTemplateInfo> bgTemplateMap, Map<String, BgViewDimensionInfo> dimensionMap) {
        if (orgUnitInfo == null || StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String _bgTempleteId2 = null;
        StringBuffer filename = null;
        StringBuffer filename2 = null;
        BgTemplateInfo _bgTemplateInfo = null;
        Object dimension = null;
        Book _book = null;
        String[] _exportInfo = null;
        Map _tmpBgTempleteIdsMap = (Map)bgTempleteIdsMap.get(orgUnitInfo.getId().toString());
        for (String _bgTempleteId2 : _tmpBgTempleteIdsMap.keySet()) {
            try {
                _bgTemplateInfo = bgTemplateMap.get(_bgTempleteId2);
                filename = new StringBuffer();
                filename.append(orgUnitInfo.getName().trim());
                filename.append("_");
                filename.append(_bgTemplateInfo.getName().trim());
                filename.append("_");
                filename.append(_bgTemplateInfo.getNumber().trim());
                filename.append("_");
                if (_bgTemplateInfo.getBgType() != null) {
                    filename.append(_bgTemplateInfo.getBgType().getName().trim());
                    filename.append("_");
                }
                filename.append(_bgTemplateInfo.getFormType().getAlias().trim());
                _book = _bgTemplateInfo.getBook();
                BgNFSHelper.disableCal(_book);
                BgNFSHelper.disableUndo(_book);
                filename.append(".data");
                BgNTemplateToHelperFile.saveDataToFile(_bgTemplateInfo, filepath + ("/" + orgUnitInfo.getName() + "/" + BgExportUtils.convert(filename.toString(), '_')).replaceAll(" ", ""));
                filename2 = new StringBuffer(filename.substring(0, filename.lastIndexOf(".")));
                filename2.append(".xml");
                if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)_bgTemplateInfo.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgTemplateInfo.getFormType())) {
                    BookIOController ctrl = new BookIOController();
                    ctrl.setKmlUOTrans((Book.IUserObjectProvider)new UserObjectTrans());
                    ctrl.setIOMode(BookIOController.FLAG_ALL);
                    BookIOUtil.saveToFile((Book)_book, (BookIOController)ctrl, (String)(filepath + ("/" + orgUnitInfo.getName() + "/" + BgExportUtils.convert(filename2.toString(), '_')).replaceAll(" ", "")));
                } else if (BgTemFormTypeEnum.VIEWFORM.equals((Object)_bgTemplateInfo.getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)_bgTemplateInfo.getFormType())) {
                    BgNTemplateToHelperFile.saveDimension(dimensionMap.get(_bgTempleteId2), _bgTemplateInfo.getFormType(), filepath + ("/" + orgUnitInfo.getName() + "/" + BgExportUtils.convert(filename2.toString(), '_')).replaceAll(" ", ""));
                }
                _exportInfo = new String[]{orgUnitInfo.getName(), _bgTemplateInfo.getNumber() + " - " + _bgTemplateInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                exportInfoList.add(_exportInfo);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                if (_bgTemplateInfo == null) continue;
                _exportInfo = new String[]{orgUnitInfo.getName(), _bgTemplateInfo.getNumber() + " - " + _bgTemplateInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                exportInfoList.add(_exportInfo);
            }
            finally {
                _book = null;
            }
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re && this.bgTemplateIdsMap != null) {
            this.bgTemplateIdsMap.clear();
        }
        return re;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isAllowChange"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.*"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit.*"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add("*");
        sic.add(new SelectorItemInfo("styleSet.id"));
        sic.add(new SelectorItemInfo("styleSet.number"));
        sic.add("bgSpecialItems.dimensionNumber");
        sic.add("bgSpecialItems.dimensionName");
        sic.add("bgSpecialItems.memberName");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.dimRelaGroupRef.*");
        sic.add("bgSpecialItems.dimRelaGroupRef.dimRelaGroup.*");
        return sic;
    }
}

