/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.BgControlOrgEntrustCollection;
import com.kingdee.eas.ma.control.BgControlOrgEntrustFactory;
import com.kingdee.eas.ma.control.BgControlOrgEntrustInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgOrgMigrationUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgOrgMigrationUI
extends AbstractBgOrgMigrationUI {
    private static final Logger logger = CoreUIObject.getLogger(BgOrgMigrationUI.class);
    private static final String OLDLEAFORG = "oldLeafOrg";
    private static final String ADDLEAFORG = "addLeafOrg";
    private static final String MIGRATIONDATA = "migrationData";
    private static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgOrgUnitReource";
    private Map<String, List<BgOrgUnitInfo>> oldRefNewOrgUnits = null;
    private Map<String, BgOrgUnitInfo> oldOrgUnits = null;
    private Set<String> checkOrgUnitIds = null;
    private BgOrgViewInfo orgViewInfo = null;
    private boolean isCancel = true;
    private List<BgOrgUnitInfo[]> result = new ArrayList<BgOrgUnitInfo[]>();
    private Map<String, List<BgOrgUnitInfo>> parentOrgUnits = null;
    private Map<String, Boolean> bgFormResult = null;
    public Map<String, Integer> isSelectedOrg = new LinkedHashMap<String, Integer>();

    public Map<String, Boolean> getBgFormResult() {
        return this.bgFormResult;
    }

    public void setBgFormResult(Map<String, Boolean> bgFormResult) {
        this.bgFormResult = bgFormResult;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public BgOrgViewInfo getOrgViewInfo() {
        return this.orgViewInfo;
    }

    public void setOrgViewInfo(BgOrgViewInfo orgViewInfo) {
        this.orgViewInfo = orgViewInfo;
    }

    public Set<String> getCheckOrgUnitIds() {
        return this.checkOrgUnitIds;
    }

    public void setCheckOrgUnitIds(Set<String> checkOrgUnitIds) {
        this.checkOrgUnitIds = checkOrgUnitIds;
    }

    public Map<String, List<BgOrgUnitInfo>> getOldRefNewOrgUnits() {
        return this.oldRefNewOrgUnits;
    }

    public Map<String, List<BgOrgUnitInfo>> getParentOrgUnits() {
        return this.parentOrgUnits;
    }

    public void setParentOrgUnits(Map<String, List<BgOrgUnitInfo>> parentOrgUnits) {
        this.parentOrgUnits = parentOrgUnits;
    }

    public Map<String, Integer> getIsSelectedOrg() {
        return this.isSelectedOrg;
    }

    public void setIsSelectedOrg(Map<String, Integer> isSelectedOrg) {
        this.isSelectedOrg = isSelectedOrg;
    }

    public void setOldRefNewOrgUnits(Map<String, List<BgOrgUnitInfo>> oldRefNewOrgUnits) {
        this.oldRefNewOrgUnits = oldRefNewOrgUnits;
    }

    public Map<String, BgOrgUnitInfo> getOldOrgUnits() {
        return this.oldOrgUnits;
    }

    public void setOldOrgUnits(Map<String, BgOrgUnitInfo> oldOrgUnits) {
        this.oldOrgUnits = oldOrgUnits;
    }

    public List<BgOrgUnitInfo[]> getResult() {
        return this.result;
    }

    public void setResult(List<BgOrgUnitInfo[]> result) {
        this.result = result;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.init();
        this.initTable();
    }

    private void init() throws BOSException {
        ArrayList<BgOrgUnitInfo> allOrgUnits = new ArrayList<BgOrgUnitInfo>();
        List<BgOrgUnitInfo> bgOrgUnits = null;
        for (Map.Entry<String, List<BgOrgUnitInfo>> entry : this.oldRefNewOrgUnits.entrySet()) {
            bgOrgUnits = entry.getValue();
            allOrgUnits.addAll(bgOrgUnits);
        }
        this.bgFormResult = BgOrgUnitFacadeFactory.getRemoteInstance().checkBgFormOrgUnits(allOrgUnits, this.orgViewInfo.getId().toString());
    }

    private void initTable() throws Exception {
        this.tblMigration.checkParsed();
        this.tblMigration.getColumn(OLDLEAFORG).getStyleAttributes().setLocked(true);
        this.tblMigration.getColumn(ADDLEAFORG).getStyleAttributes().setLocked(true);
        String bgOrgUnitId = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        List<BgOrgUnitInfo> bgOrgUnits = null;
        IRow row = null;
        ICell cell = null;
        for (Map.Entry<String, List<BgOrgUnitInfo>> entry : this.oldRefNewOrgUnits.entrySet()) {
            bgOrgUnitId = entry.getKey();
            bgOrgUnitInfo = this.oldOrgUnits.get(bgOrgUnitId);
            bgOrgUnits = entry.getValue();
            int index = 0;
            for (BgOrgUnitInfo info : bgOrgUnits) {
                row = this.tblMigration.addRow();
                cell = row.getCell(OLDLEAFORG);
                cell.setValue((Object)bgOrgUnitInfo.getName());
                cell.setUserObject((Object)bgOrgUnitInfo);
                cell = row.getCell(ADDLEAFORG);
                cell.setValue((Object)info.getName());
                cell.setUserObject((Object)info);
                row.getCell(MIGRATIONDATA).setValue((Object)Boolean.FALSE);
                if (bgOrgUnits.size() == 1 && this.checkHasDataOrgUnit(info, false) && !this.bgFormResult.containsKey(info.getOrgUnitID())) {
                    row.getCell(MIGRATIONDATA).setValue((Object)Boolean.TRUE);
                    this.isSelectedOrg.put(bgOrgUnitInfo.getOrgUnitID(), row.getRowIndex());
                }
                ++index;
            }
            this.tblMigration.getMergeManager().mergeBlock(this.tblMigration.getRowCount() - index, 0, this.tblMigration.getRowCount() - 1, 0);
        }
        this.tblMigration.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                BgOrgUnitInfo oldLeafOrgUnitInfo = (BgOrgUnitInfo)BgOrgMigrationUI.this.tblMigration.getCell(rowIndex, BgOrgMigrationUI.OLDLEAFORG).getUserObject();
                if (colIndex == 2) {
                    if (!((Boolean)e.getOldValue()).booleanValue()) {
                        if (BgOrgMigrationUI.this.isSelectedOrg.keySet().contains(oldLeafOrgUnitInfo.getOrgUnitID())) {
                            Integer index = BgOrgMigrationUI.this.isSelectedOrg.get(oldLeafOrgUnitInfo.getOrgUnitID());
                            BgOrgMigrationUI.this.tblMigration.getCell(index.intValue(), BgOrgMigrationUI.MIGRATIONDATA).setValue((Object)Boolean.FALSE);
                            BgOrgMigrationUI.this.isSelectedOrg.remove(oldLeafOrgUnitInfo.getOrgUnitID());
                        }
                        BgOrgMigrationUI.this.isSelectedOrg.put(oldLeafOrgUnitInfo.getOrgUnitID(), rowIndex);
                    } else if (BgOrgMigrationUI.this.isSelectedOrg.containsKey(oldLeafOrgUnitInfo.getOrgUnitID())) {
                        BgOrgMigrationUI.this.isSelectedOrg.remove(oldLeafOrgUnitInfo.getOrgUnitID());
                    }
                }
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editStarting(KDTEditEvent e) {
                try {
                    if (!((Boolean)e.getOldValue()).booleanValue()) {
                        int rowIndex = e.getRowIndex();
                        int colIndex = e.getColIndex();
                        if (colIndex == 2) {
                            BgOrgUnitInfo oldLeafOrgUnitInfo = (BgOrgUnitInfo)BgOrgMigrationUI.this.tblMigration.getCell(rowIndex, BgOrgMigrationUI.OLDLEAFORG).getUserObject();
                            BgOrgUnitInfo newLeafOrgUnitInfo = (BgOrgUnitInfo)BgOrgMigrationUI.this.tblMigration.getCell(rowIndex, BgOrgMigrationUI.ADDLEAFORG).getUserObject();
                            if (BgOrgMigrationUI.this.checkHasDataOrgUnit(newLeafOrgUnitInfo, true)) {
                                if (BgOrgMigrationUI.this.bgFormResult.containsKey(newLeafOrgUnitInfo.getOrgUnitID()) && ((Boolean)BgOrgMigrationUI.this.bgFormResult.get(newLeafOrgUnitInfo.getOrgUnitID())).booleanValue()) {
                                    MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)BgOrgMigrationUI.RESOURCE, (String)"existBgFormMigration"));
                                    e.setCancel(true);
                                } else {
                                    BgOrgMigrationUI.this.tblMigration.getCell(rowIndex, BgOrgMigrationUI.MIGRATIONDATA).setValue((Object)Boolean.TRUE);
                                }
                            } else {
                                e.setCancel(true);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"error:", (Throwable)ex);
                }
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    protected boolean checkBgControlOrgEntrust(BgOrgUnitInfo oldLeafOrgUnitInfo, BgOrgUnitInfo newLeafOrgUnitInfo, boolean isShowMessage) throws BOSException {
        if (oldLeafOrgUnitInfo == null || newLeafOrgUnitInfo == null) {
            return true;
        }
        HashSet<String> orgUnitRefTypes = new HashSet<String>();
        HashSet<String> bgEntrustOrgUnitRefTypes = new HashSet<String>();
        BgControlOrgEntrustCollection bgOrgUnitColl = BgControlOrgEntrustFactory.getRemoteInstance().getBgControlOrgEntrustCollection("select * where bgOrgUnit.id = '" + newLeafOrgUnitInfo.getOrgUnitID() + "'");
        BgControlOrgEntrustInfo info = null;
        String typeId = null;
        String orgUnitId = null;
        Object bgEntrustOrgUnitId = null;
        if (bgOrgUnitColl == null || bgOrgUnitColl.isEmpty()) {
            return true;
        }
        int in = bgOrgUnitColl.size();
        for (int i = 0; i < in; ++i) {
            info = bgOrgUnitColl.get(i);
            typeId = info.getBgIndexSort() == null ? " " : info.getId().toString();
            orgUnitId = info.getBgOrgUnit().getId().toString();
            orgUnitRefTypes.add(typeId + "!" + orgUnitId);
        }
        BgControlOrgEntrustCollection bgEntrustOrgUnitColl = BgControlOrgEntrustFactory.getRemoteInstance().getBgControlOrgEntrustCollection("select * where bgEntrustOrgUnit.id = '" + oldLeafOrgUnitInfo.getOrgUnitID() + "'");
        if (bgEntrustOrgUnitColl == null || bgEntrustOrgUnitColl.isEmpty()) {
            return true;
        }
        int in2 = bgEntrustOrgUnitColl.size();
        for (int i = 0; i < in2; ++i) {
            info = bgEntrustOrgUnitColl.get(i);
            typeId = info.getBgIndexSort() == null ? " " : info.getId().toString();
            bgEntrustOrgUnitRefTypes.add(typeId + "!" + newLeafOrgUnitInfo.getOrgUnitID());
        }
        for (String bgEntrustOrgUnitRefType : bgEntrustOrgUnitRefTypes) {
            if (!orgUnitRefTypes.contains(bgEntrustOrgUnitRefType)) continue;
            if (isShowMessage) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"existBgControlOrgEntrustMigration"));
            }
            return false;
        }
        return true;
    }

    protected boolean checkHasDataOrgUnit(BgOrgUnitInfo newLeafOrgUnitInfo, boolean isShowMessage) {
        if (newLeafOrgUnitInfo == null) {
            return true;
        }
        if (this.checkOrgUnitIds.contains(newLeafOrgUnitInfo.getOrgUnitID())) {
            if (isShowMessage) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"existDataMigration"));
            }
            return false;
        }
        return true;
    }

    private void initContext() {
        this.oldRefNewOrgUnits = (Map)this.getUIContext().get("oldRefNewOrgUnits");
        this.oldOrgUnits = (Map)this.getUIContext().get("oldOrgUnits");
        this.checkOrgUnitIds = (Set)this.getUIContext().get("hasDataOrgUnitIds");
        this.orgViewInfo = (BgOrgViewInfo)this.getUIContext().get("BGORGVIEW_INFO");
        this.parentOrgUnits = (Map)this.getUIContext().get("parentOrgUnits");
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object row = null;
        Integer index2 = null;
        BgOrgUnitInfo[] orgRef = null;
        List<BgOrgUnitInfo> bgOrgUnits = null;
        String orgUnitId = null;
        BgOrgUnitInfo info = null;
        StringBuffer message = new StringBuffer();
        Iterator<List<BgOrgUnitInfo>> iter = this.parentOrgUnits.values().iterator();
        while (iter.hasNext()) {
            int count = 0;
            bgOrgUnits = iter.next();
            for (BgOrgUnitInfo bgOrgunitInfo : bgOrgUnits) {
                if (this.checkOrgUnitIds != null && this.checkOrgUnitIds.contains(bgOrgunitInfo.getOrgUnitID())) {
                    ++count;
                }
                if (count <= true) continue;
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"cantMigrationOrgsData"));
                return;
            }
        }
        HashSet<String> nums = new HashSet<String>();
        int in = this.tblMigration.getRowCount();
        for (int i = 0; i < in; ++i) {
            info = (BgOrgUnitInfo)this.tblMigration.getCell(i, ADDLEAFORG).getUserObject();
            if (nums.contains(info.getNumber())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"cantMigrationOrgsData"));
                return;
            }
            nums.add(info.getNumber());
        }
        for (Map.Entry<String, BgOrgUnitInfo> entry : this.oldOrgUnits.entrySet()) {
            orgUnitId = entry.getKey();
            info = entry.getValue();
            if (this.isSelectedOrg.keySet().contains(orgUnitId)) continue;
            message.append(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"notSelectOrgMigration", (Object[])new String[]{info.getName()}) + "\r\n");
        }
        if (message.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RESOURCE, (String)"orgMigrationMessage"), (String)message.toString(), (int)1);
            return;
        }
        for (Integer index2 : this.isSelectedOrg.values()) {
            orgRef = new BgOrgUnitInfo[]{(BgOrgUnitInfo)this.tblMigration.getCell(index2.intValue(), OLDLEAFORG).getUserObject(), (BgOrgUnitInfo)this.tblMigration.getCell(index2.intValue(), ADDLEAFORG).getUserObject()};
            this.result.add(orgRef);
        }
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }
}

